

#include <linux/errno.h>
#include <linux/tty.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/signal.h>
/*#include <linux/string.h>*/
#include <linux/errno.h>
#include <linux/ctype.h>
#include <linux/ptrace.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/stat.h>
#include <linux/string.h>
#include <linux/kdev_t.h>
#include <asm/segment.h>
#include <asm/pgtable.h>
#include <asm/io.h>
#include <stdarg.h>
#include <linux/proc_fs.h>
#include "log.h"



#define MODULE
#include <linux/module.h>

#include "include/syscallmgr.h"
#include "audit.h"
#include "log.h"

struct redirect_db {
  void *resident;
  void *transient; 
  char is_pointer;
  char savearea[5];
};

extern int printk( const char* fmt, ...);
extern int sys_execve(), _TRANSIENT_sys_execve();
extern int getname();
/*extern int console_loglevel;*/

static struct redirect_db redirect_list[]= {
	{ sys_execve, _TRANSIENT_sys_execve }
};

static int __NR_sys_audit_log=-1;
static int __NR_sys_aprintf=-1;


static char buf[1024];
static char log_buf[LBL];
static unsigned long audit_size=0;
static unsigned long audit_start=0;
static unsigned long logged=0;
static struct wait_queue * audit_wait = NULL;

int aprintf(const char *fmt,...) {
	va_list args;
	int i;
	char *p, *buf_end;
	long flags;
	
	save_flags(flags);
	cli();
	va_start(args,fmt);
	i=vsprintf(buf,fmt,args);
	buf_end=buf+i;
	va_end(args);
//	buf_end=buf_end+1;
	
	p=buf;
	
	for (; p<buf_end;p++) {
		log_buf[(audit_start+audit_size) & (LBL-1)]=*p;
		if (audit_size<LBL) 
			audit_size++;
		else {
			audit_start++;
			audit_start &= LBL-1;
		}
		logged++;
		if (*p=='\n') break;
	}
	restore_flags(flags);
	sti();
	wake_up_interruptible(&audit_wait);
	return i;
}

asmlinkage int sys_aprintf(char *s,int len) {
	char buf[1020];
	int err;
	
	if (len<0) return -EINVAL;
	
	if ((err=verify_area(VERIFY_READ,s,len))) return(err);
		
	memcpy_fromfs(buf,s,len);
	
	return aprintf("%s",buf);
}

















/* FRAGMENT OF CODE TAKEN DIRECTLY FROM EMUMOD - THANKS TO HANS LERMEN */

struct jmpop {
  unsigned char opcode;
  int displacement __attribute__ ((packed));
};


static void redirect_resident_routine(void *resident_addr, void *transient_addr, char *savearea)
{
  enum { JMP_OPCODE=0x0e9 };
  struct jmpop  *raddr = resident_addr;
  int flags, displ;
  
  displ=((int)transient_addr) - ((int)resident_addr+sizeof(struct jmpop));
  save_flags(flags);
  cli();
  memcpy(savearea,resident_addr,sizeof(struct jmpop));
  raddr->opcode = JMP_OPCODE;
  raddr->displacement = displ;  
  restore_flags(flags);
}

static void restore_redirect(void *resident_addr,  char *savearea)
{
  int flags;
  
  save_flags(flags);
  cli();
  memcpy(resident_addr,savearea,5);
  restore_flags(flags);
}


static void redirect_all() {
  int num=sizeof(redirect_list) / sizeof(struct redirect_db);
  struct redirect_db *p;
  int flags,i;
  
  save_flags(flags);
  for (i=0, p=redirect_list; i<num; i++, p++) {
    if (p->is_pointer) {
      *((long *)(p->savearea)) = *((long *)(p->resident));
      *((long *)(p->resident)) = (long)p->transient;
    }
    else redirect_resident_routine(p->resident, p->transient, p->savearea);
  }
  restore_flags(flags);
}

static void restore_redirect_all() {
  int num=sizeof(redirect_list) / sizeof(struct redirect_db);
  struct redirect_db *p;
  int flags,i;
  
  save_flags(flags);
  for (i=0, p=&redirect_list[num-1]; i<num; i++, p--) {
    if (p->is_pointer) {
      *((long *)(p->resident)) = *((long *)(p->savearea));
    }
    else restore_redirect(p->resident, p->savearea);
  }
  restore_flags(flags);
}

/* CODE THIEFT BLOCK 1 ENDS HERE */

#define STAR    0
#define NOTSTAR 1
#define RESET   2

int strmask(char *str, char *mask)
/*
    Tests string 'str' against mask string 'mask'
    Returns TRUE if the string matches the mask.

    The mask can contain '?' and '*' wild card characters.
    '?' matches any single character.
    '*' matches any number of any characters.

    For example:
                    strmask("Hello", "Hello");  ---> TRUE
                    strmask("Hello", "Jello");  ---> FALSE
                    strmask("Hello", "H*o");    ---> TRUE
                    strmask("Hello", "H*g");    ---> FALSE
                    strmask("Hello", "?ello");  ---> TRUE
                    strmask("Hello", "H????");  ---> TRUE
                    strmask("H", "H????");      ---> FALSE
*/
{
    char *sp, *mp, *reset_string, *reset_mask, *sn;
    int state;

    sp = str;
    mp = mask;

    while (1) {
        switch (*mp) {
        case '\0':
            return(*sp ? 0:1);
        case '?':
            sp++;
            mp++;
            break;
        default:
            if (*mp == *sp) {
                sp++;
                mp++;
                break;
            }
            else {
                return(0);
            }
        case '*':
            if (*(mp + 1) == '\0') {
                return(1);
            }
            if ((sn = strchr(sp, *(mp + 1))) == NULL) {
                return(0);
            }

            /* save place -- match rest of string */
            /* if fail, reset to here */
            reset_mask = mp;
            reset_string = sn + 1;

            mp = mp + 2;
            sp = sn + 1;
            state = NOTSTAR;
            while (state == NOTSTAR) {
                switch (*mp) {
                case '\0':
                    if (*sp == '\0') {
                        return(0);
                    }
                    else {
                        state = RESET;
                    }
                    break;
                case '?':
                    sp++;
                    mp++;
                    break;
                default:
                    if (*mp == *sp) {
                        sp++;
                        mp++;
                    }
                    else {
                        state = RESET;
                    }
                    break;
                case '*':
                    state = STAR;
                    break;
                }
            }
            /* we've reach a new star or should reset to last star */
            if (state == RESET) {
                sp = reset_string;
                mp = reset_mask;
            }
            break;
        }
    }
}


static int printthem(char **argv) {
        int i = 0;
        int j = 0;
        int rc = 0;
/*      int koko = 0;*/
        char korkor[100];
        char *tmp;
        
        do {	
	        if (((tmp=get_user(argv+(i++)))==NULL) || (j>98)) {
	        	korkor[--j]='\0';
/*	        	rc=matchit(korkor);*/
	        	
	        	/* UGLY BLOODY FUCKING TRICK ON FOLLOWING LINE */
/*	        	koko = console_loglevel; console_loglevel=6;*/
/*	        	if (rc & ACT_LOG) {*/
	        		aprintf("A %d (%d,%d)",current->pid,current->uid,current->gid); 
	        		if (rc & ACT_DENY) {
	        			aprintf("denied ");
	        		}
	        		if (current->tty!=NULL) {
	        			aprintf(" [%d:%d]",MAJOR(current->tty->device),MINOR(current->tty->device));
	        		} else {
	        			aprintf(" [0:0]");
	        		}
	        		aprintf("P exec : %s\n",korkor);
/*	        	}*/
	        	/* END OF U.B.F.T ON FOLLOWING LINE */
/*	        	console_loglevel=koko;*/
	        	
	        	return(0);
	        }
	        while (((korkor[j]=get_user(tmp++))!=0) && (j<99)) 
			j++;
		korkor[j++]=' ';
	        
	} while (tmp!=NULL);
	return(0);
}


asmlinkage int _TRANSIENT_sys_execve(struct pt_regs regs)
{
	int error;
	char *filename;
	
	error = getname((char *) regs.ebx, &filename);
	if (error)
		return error; 
	error = printthem((char **)regs.ecx);
	if (error)
		return error;
	error = do_execve(filename, (char **) regs.ecx, (char **) regs.edx, &regs);
	putname(filename);
	return error;
}

/* CODE THIEFT BLOCK 2 STOPS HERE */

/* Copyright infrigement notice : */
/* HEAVILY cheated code from linux/kernel/printk.c that is (C) by Linus. */

asmlinkage int sys_audit_log(int type, char *buf, int len) {
	unsigned long i;
	char c;
	int error=0;
	
	if (!suser()) {
		return -EPERM;
	}
	
	switch (type) {
		case LOG_CLEAR:
				logged=0;
				return 0;
		case LOG_READ:
				if (!buf || len<0) return -EINVAL;
				if (!len) return 0;
				if ((error=verify_area(VERIFY_WRITE,buf,len))) return error;
				cli();
				while (!audit_size) {
					if (current->signal & ~current->blocked) {
						sti();
						return -ERESTARTSYS;
					}
					interruptible_sleep_on(&audit_wait);
				}
				
				i=0;
				c='a';
				while (audit_size && i < len-1) {
					c=*((char *)log_buf+audit_start);
					audit_start++;
					audit_size--;
					audit_start &= LBL-1;
					sti();
					put_user(c,buf);
					*buf++;
					i++;
					cli();
					if (c=='\n') {
						sti();put_user('\0',buf);cli();
						break;
					}
				}
				sti();
				return i;
		default:
				return -EINVAL;
	}
	return 0; /* shut up, gcc! */
}

extern struct proc_dir_entry proc_root;


static int audit_open(struct inode * inode, struct file * file)
{
	MOD_INC_USE_COUNT;
        return 0;
        /*sys_audit_log(LOG_READ,NULL,0);*/
}
        
static void audit_release(struct inode * inode, struct file * file)
{
	MOD_DEC_USE_COUNT;
/*(void) sys_audit_log(0,NULL,0);*/
}
                
static int audit_read(struct inode * inode, struct file * file,char * buf, int count)
{
      return sys_audit_log(LOG_READ,buf,count);
}
static int audit_select(struct inode *inode, struct file *file, int sel_type, select_table * wait)
{
        if (sel_type != SEL_IN)
	        return 0;
        if (audit_size)
                return 1;
        select_wait(&audit_wait, wait);
        return 0;
}
                                                                


static struct file_operations proc_audit_operations = {
		NULL,		/* lseek */
		audit_read,	/* read */
		NULL,		/* write */
		NULL,		/* readdir */
		audit_select,	/* select */
		NULL,		/* ioctl */
		NULL,		/* mmap */
		NULL,	/* open */
		NULL,	/* close */
		NULL		/* fsync */
};

static struct inode_operations proc_audit_inode_operations = {
		&proc_audit_operations,	
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL
};

static struct proc_dir_entry proc_audit={
			0,5,"audit",S_IFREG|S_IRUSR,1,0,0,
			0,&proc_audit_inode_operations,NULL,
			};

int init_module(void) {
  kernel_version[0] = kernel_version[0];

  printk(AUDIT": registering syscall sys_audit_log()\n");
  __NR_sys_audit_log=register_syscall(0, sys_audit_log,SYS_AUDIT_LOG_ID);
  if (__NR_sys_audit_log>0) {
    printk(AUDIT": NR_sys_audit_log=%d\n",__NR_sys_audit_log);
  }
  else {
    printk(AUDIT": init_module failed\n");
    return -1;
  }
  
  printk(AUDIT": registering syscall sys_aprintf()\n");
  __NR_sys_aprintf=register_syscall(0,sys_aprintf,SYS_APRINTF_ID);
  if (__NR_sys_aprintf>0) {
    printk(AUDIT": NR_sys_aprintf=%d\n",__NR_sys_aprintf);
  }
  else {
    printk(AUDIT": init_module failed\n");
    return -1;
  }
  
 
  printk(AUDIT": redirecting execve\n");
  redirect_all();
  printk(AUDIT": registering proc entries\n");
  proc_register_dynamic(&proc_root,&(struct proc_dir_entry)proc_audit);
  printk(AUDIT": Done!\n");
  
  
  return(0);
  
}

void cleanup_module(void) {

  if (MOD_IN_USE) printk(AUDIT": device busy, remove delayed\n");
  else printk(AUDIT": cleanup module called\n");
  restore_redirect_all();
  unregister_syscall(__NR_sys_aprintf);
  unregister_syscall(__NR_sys_audit_log);
  proc_unregister(&proc_root,proc_audit.low_ino);
  
  
}