/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2024 Intel Corporation
 */

#ifndef __SKL_UNIVERSAL_PLANE_REGS_H__
#define __SKL_UNIVERSAL_PLANE_REGS_H__

#include "intel_display_reg_defs.h"

#define _SKL_PLANE(pipe, plane, reg_1_a, reg_1_b, reg_2_a, reg_2_b) \
	_PLANE((plane), _PIPE((pipe), (reg_1_a), (reg_1_b)), _PIPE((pipe), (reg_2_a), (reg_2_b)))
#define _SKL_PLANE_DW(pipe, plane, dw, reg_1_a, reg_1_b, reg_2_a, reg_2_b) \
	(_SKL_PLANE((pipe), (plane), (reg_1_a), (reg_1_b), (reg_2_a), (reg_2_b)) + (dw) * 4)
#define _MMIO_SKL_PLANE(pipe, plane, reg_1_a, reg_1_b, reg_2_a, reg_2_b) \
	_MMIO(_SKL_PLANE((pipe), (plane), (reg_1_a), (reg_1_b), (reg_2_a), (reg_2_b)))
#define _MMIO_SKL_PLANE_DW(pipe, plane, dw, reg_1_a, reg_1_b, reg_2_a, reg_2_b) \
	_MMIO(_SKL_PLANE_DW((pipe), (plane), (dw), (reg_1_a), (reg_1_b), (reg_2_a), (reg_2_b)))

#define _SEL_FETCH(pipe, plane, reg_1_a, reg_1_b, reg_2_a, reg_2_b, reg_5_a, reg_5_b, reg_6_a, reg_6_b) \
	_PICK_EVEN_2RANGES((plane), PLANE_5, \
			   _PIPE((pipe), (reg_1_a), (reg_1_b)), \
			   _PIPE((pipe), (reg_2_a), (reg_2_b)), \
			   _PIPE((pipe), (reg_5_a), (reg_5_b)), \
			   _PIPE((pipe), (reg_6_a), (reg_6_b)))
#define _MMIO_SEL_FETCH(pipe, plane, reg_1_a, reg_1_b, reg_2_a, reg_2_b, reg_5_a, reg_5_b, reg_6_a, reg_6_b) \
	_MMIO(_SEL_FETCH((pipe), (plane), \
			 (reg_1_a), (reg_1_b), (reg_2_a), (reg_2_b), \
			 (reg_5_a), (reg_5_b), (reg_6_a), (reg_6_b)))

#define _PLANE_CTL_1_A				0x70180
#define _PLANE_CTL_2_A				0x70280
#define _PLANE_CTL_1_B				0x71180
#define _PLANE_CTL_2_B				0x71280
#define PLANE_CTL(pipe, plane)		_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_CTL_1_A, _PLANE_CTL_1_B, \
							_PLANE_CTL_2_A, _PLANE_CTL_2_B)
#define   PLANE_CTL_ENABLE			REG_BIT(31)
#define   PLANE_CTL_ARB_SLOTS_MASK		REG_GENMASK(30, 28) /* icl+ */
#define   PLANE_CTL_ARB_SLOTS(x)		REG_FIELD_PREP(PLANE_CTL_ARB_SLOTS_MASK, (x)) /* icl+ */
#define   PLANE_CTL_PIPE_GAMMA_ENABLE		REG_BIT(30) /* Pre-GLK */
#define   PLANE_CTL_YUV_RANGE_CORRECTION_DISABLE	REG_BIT(28)
/*
 * ICL+ uses the same PLANE_CTL_FORMAT bits, but the field definition
 * expanded to include bit 23 as well. However, the shift-24 based values
 * correctly map to the same formats in ICL, as long as bit 23 is set to 0
 */
#define   PLANE_CTL_FORMAT_MASK_SKL		REG_GENMASK(27, 24) /* pre-icl */
#define   PLANE_CTL_FORMAT_MASK_ICL		REG_GENMASK(27, 23) /* icl+ */
#define   PLANE_CTL_FORMAT_YUV422		REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_SKL, 0)
#define   PLANE_CTL_FORMAT_NV12			REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_SKL, 1)
#define   PLANE_CTL_FORMAT_XRGB_2101010		REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_SKL, 2)
#define   PLANE_CTL_FORMAT_P010			REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_SKL, 3)
#define   PLANE_CTL_FORMAT_XRGB_8888		REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_SKL, 4)
#define   PLANE_CTL_FORMAT_P012			REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_SKL, 5)
#define   PLANE_CTL_FORMAT_XRGB_16161616F	REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_SKL, 6)
#define   PLANE_CTL_FORMAT_P016			REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_SKL, 7)
#define   PLANE_CTL_FORMAT_XYUV			REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_SKL, 8)
#define   PLANE_CTL_FORMAT_INDEXED		REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_SKL, 12)
#define   PLANE_CTL_FORMAT_RGB_565		REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_SKL, 14)
#define   PLANE_CTL_FORMAT_Y210			REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_ICL, 1)
#define   PLANE_CTL_FORMAT_Y212			REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_ICL, 3)
#define   PLANE_CTL_FORMAT_Y216			REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_ICL, 5)
#define   PLANE_CTL_FORMAT_Y410			REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_ICL, 7)
#define   PLANE_CTL_FORMAT_Y412			REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_ICL, 9)
#define   PLANE_CTL_FORMAT_Y416			REG_FIELD_PREP(PLANE_CTL_FORMAT_MASK_ICL, 11)
#define   PLANE_CTL_PIPE_CSC_ENABLE		REG_BIT(23) /* Pre-GLK */
#define   PLANE_CTL_KEY_ENABLE_MASK		REG_GENMASK(22, 21)
#define   PLANE_CTL_KEY_ENABLE_SOURCE		REG_FIELD_PREP(PLANE_CTL_KEY_ENABLE_MASK, 1)
#define   PLANE_CTL_KEY_ENABLE_DESTINATION	REG_FIELD_PREP(PLANE_CTL_KEY_ENABLE_MASK, 2)
#define   PLANE_CTL_ORDER_RGBX			REG_BIT(20)
#define   PLANE_CTL_YUV420_Y_PLANE		REG_BIT(19)
#define   PLANE_CTL_YUV_TO_RGB_CSC_FORMAT_BT709	REG_BIT(18)
#define   PLANE_CTL_YUV422_ORDER_MASK		REG_GENMASK(17, 16)
#define   PLANE_CTL_YUV422_ORDER_YUYV		REG_FIELD_PREP(PLANE_CTL_YUV422_ORDER_MASK, 0)
#define   PLANE_CTL_YUV422_ORDER_UYVY		REG_FIELD_PREP(PLANE_CTL_YUV422_ORDER_MASK, 1)
#define   PLANE_CTL_YUV422_ORDER_YVYU		REG_FIELD_PREP(PLANE_CTL_YUV422_ORDER_MASK, 2)
#define   PLANE_CTL_YUV422_ORDER_VYUY		REG_FIELD_PREP(PLANE_CTL_YUV422_ORDER_MASK, 3)
#define   PLANE_CTL_RENDER_DECOMPRESSION_ENABLE	REG_BIT(15)
#define   PLANE_CTL_TRICKLE_FEED_DISABLE	REG_BIT(14)
#define   PLANE_CTL_CLEAR_COLOR_DISABLE		REG_BIT(13) /* TGL+ */
#define   PLANE_CTL_PLANE_GAMMA_DISABLE		REG_BIT(13) /* Pre-GLK */
#define   PLANE_CTL_TILED_MASK			REG_GENMASK(12, 10)
#define   PLANE_CTL_TILED_LINEAR		REG_FIELD_PREP(PLANE_CTL_TILED_MASK, 0)
#define   PLANE_CTL_TILED_X			REG_FIELD_PREP(PLANE_CTL_TILED_MASK, 1)
#define   PLANE_CTL_TILED_Y			REG_FIELD_PREP(PLANE_CTL_TILED_MASK, 4)
#define   PLANE_CTL_TILED_YF			REG_FIELD_PREP(PLANE_CTL_TILED_MASK, 5)
#define   PLANE_CTL_TILED_4                     REG_FIELD_PREP(PLANE_CTL_TILED_MASK, 5)
#define   PLANE_CTL_ASYNC_FLIP			REG_BIT(9)
#define   PLANE_CTL_FLIP_HORIZONTAL		REG_BIT(8)
#define   PLANE_CTL_MEDIA_DECOMPRESSION_ENABLE	REG_BIT(4) /* TGL+ */
#define   PLANE_CTL_ALPHA_MASK			REG_GENMASK(5, 4) /* Pre-GLK */
#define   PLANE_CTL_ALPHA_DISABLE		REG_FIELD_PREP(PLANE_CTL_ALPHA_MASK, 0)
#define   PLANE_CTL_ALPHA_SW_PREMULTIPLY	REG_FIELD_PREP(PLANE_CTL_ALPHA_MASK, 2)
#define   PLANE_CTL_ALPHA_HW_PREMULTIPLY	REG_FIELD_PREP(PLANE_CTL_ALPHA_MASK, 3)
#define   PLANE_CTL_ROTATE_MASK			REG_GENMASK(1, 0)
#define   PLANE_CTL_ROTATE_0			REG_FIELD_PREP(PLANE_CTL_ROTATE_MASK, 0)
#define   PLANE_CTL_ROTATE_90			REG_FIELD_PREP(PLANE_CTL_ROTATE_MASK, 1)
#define   PLANE_CTL_ROTATE_180			REG_FIELD_PREP(PLANE_CTL_ROTATE_MASK, 2)
#define   PLANE_CTL_ROTATE_270			REG_FIELD_PREP(PLANE_CTL_ROTATE_MASK, 3)

#define _PLANE_STRIDE_1_A			0x70188
#define _PLANE_STRIDE_2_A			0x70288
#define _PLANE_STRIDE_1_B			0x71188
#define _PLANE_STRIDE_2_B			0x71288
#define PLANE_STRIDE(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_STRIDE_1_A, _PLANE_STRIDE_1_B, \
							_PLANE_STRIDE_2_A, _PLANE_STRIDE_2_B)
#define   PLANE_STRIDE__MASK			REG_GENMASK(11, 0)
#define   PLANE_STRIDE_(stride)			REG_FIELD_PREP(PLANE_STRIDE__MASK, (stride))

#define _PLANE_POS_1_A				0x7018c
#define _PLANE_POS_2_A				0x7028c
#define _PLANE_POS_1_B				0x7118c
#define _PLANE_POS_2_B				0x7128c
#define PLANE_POS(pipe, plane)		_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_POS_1_A, _PLANE_POS_1_B, \
							_PLANE_POS_2_A, _PLANE_POS_2_B)
#define   PLANE_POS_Y_MASK			REG_GENMASK(31, 16)
#define   PLANE_POS_Y(y)			REG_FIELD_PREP(PLANE_POS_Y_MASK, (y))
#define   PLANE_POS_X_MASK			REG_GENMASK(15, 0)
#define   PLANE_POS_X(x)			REG_FIELD_PREP(PLANE_POS_X_MASK, (x))

#define _PLANE_SIZE_1_A				0x70190
#define _PLANE_SIZE_2_A				0x70290
#define _PLANE_SIZE_1_B				0x71190
#define _PLANE_SIZE_2_B				0x71290
#define PLANE_SIZE(pipe, plane)		_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_SIZE_1_A, _PLANE_SIZE_1_B, \
							_PLANE_SIZE_2_A, _PLANE_SIZE_2_B)
#define   PLANE_HEIGHT_MASK			REG_GENMASK(31, 16)
#define   PLANE_HEIGHT(h)			REG_FIELD_PREP(PLANE_HEIGHT_MASK, (h))
#define   PLANE_WIDTH_MASK			REG_GENMASK(15, 0)
#define   PLANE_WIDTH(w)			REG_FIELD_PREP(PLANE_WIDTH_MASK, (w))

#define _PLANE_KEYVAL_1_A			0x70194
#define _PLANE_KEYVAL_2_A			0x70294
#define _PLANE_KEYVAL_1_B			0x71194
#define _PLANE_KEYVAL_2_B			0x71294
#define PLANE_KEYVAL(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane),\
							_PLANE_KEYVAL_1_A, _PLANE_KEYVAL_1_B, \
							_PLANE_KEYVAL_2_A, _PLANE_KEYVAL_2_B)

#define _PLANE_KEYMSK_1_A			0x70198
#define _PLANE_KEYMSK_2_A			0x70298
#define _PLANE_KEYMSK_1_B			0x71198
#define _PLANE_KEYMSK_2_B			0x71298
#define PLANE_KEYMSK(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_KEYMSK_1_A, _PLANE_KEYMSK_1_B, \
							_PLANE_KEYMSK_2_A, _PLANE_KEYMSK_2_B)
#define   PLANE_KEYMSK_ALPHA_ENABLE		REG_BIT(31)

#define _PLANE_SURF_1_A				0x7019c
#define _PLANE_SURF_2_A				0x7029c
#define _PLANE_SURF_1_B				0x7119c
#define _PLANE_SURF_2_B				0x7129c
#define PLANE_SURF(pipe, plane)		_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_SURF_1_A, _PLANE_SURF_1_B, \
							_PLANE_SURF_2_A, _PLANE_SURF_2_B)
#define   PLANE_SURF_ADDR_MASK			REG_GENMASK(31, 12)
#define   PLANE_SURF_DECRYPT			REG_BIT(2)
#define   PLANE_SURF_ASYNC_UPDATE		REG_BIT(0)

#define _PLANE_KEYMAX_1_A			0x701a0
#define _PLANE_KEYMAX_2_A			0x702a0
#define _PLANE_KEYMAX_1_B			0x711a0
#define _PLANE_KEYMAX_2_B			0x712a0
#define PLANE_KEYMAX(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_KEYMAX_1_A, _PLANE_KEYMAX_1_B, \
							_PLANE_KEYMAX_2_A, _PLANE_KEYMAX_2_B)
#define   PLANE_KEYMAX_ALPHA_MASK		REG_GENMASK(31, 24)
#define   PLANE_KEYMAX_ALPHA(a)			REG_FIELD_PREP(PLANE_KEYMAX_ALPHA_MASK, (a))

#define _PLANE_OFFSET_1_A			0x701a4
#define _PLANE_OFFSET_2_A			0x702a4
#define _PLANE_OFFSET_1_B			0x711a4
#define _PLANE_OFFSET_2_B			0x712a4
#define PLANE_OFFSET(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_OFFSET_1_A, _PLANE_OFFSET_1_B, \
							_PLANE_OFFSET_2_A, _PLANE_OFFSET_2_B)
#define   PLANE_OFFSET_Y_MASK			REG_GENMASK(31, 16)
#define   PLANE_OFFSET_Y(y)			REG_FIELD_PREP(PLANE_OFFSET_Y_MASK, (y))
#define   PLANE_OFFSET_X_MASK			REG_GENMASK(15, 0)
#define   PLANE_OFFSET_X(x)			REG_FIELD_PREP(PLANE_OFFSET_X_MASK, (x))

#define _PLANE_SURFLIVE_1_A			0x701ac
#define _PLANE_SURFLIVE_2_A			0x702ac
#define _PLANE_SURFLIVE_1_B			0x711ac
#define _PLANE_SURFLIVE_2_B			0x712ac
#define PLANE_SURFLIVE(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_SURFLIVE_1_A, _PLANE_SURFLIVE_1_B, \
							_PLANE_SURFLIVE_2_A, _PLANE_SURFLIVE_2_B)

#define _PLANE_CC_VAL_1_A			0x701b4
#define _PLANE_CC_VAL_2_A			0x702b4
#define _PLANE_CC_VAL_1_B			0x711b4
#define _PLANE_CC_VAL_2_B			0x712b4
#define PLANE_CC_VAL(pipe, plane, dw)	_MMIO_SKL_PLANE_DW((pipe), (plane), (dw), \
							   _PLANE_CC_VAL_1_A, _PLANE_CC_VAL_1_B, \
							   _PLANE_CC_VAL_2_A, _PLANE_CC_VAL_2_B)

#define _PLANE_AUX_DIST_1_A			0x701c0
#define _PLANE_AUX_DIST_2_A			0x702c0
#define _PLANE_AUX_DIST_1_B			0x711c0
#define _PLANE_AUX_DIST_2_B			0x712c0
#define PLANE_AUX_DIST(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_AUX_DIST_1_A, _PLANE_AUX_DIST_1_B, \
							_PLANE_AUX_DIST_2_A, _PLANE_AUX_DIST_2_B)
#define   PLANE_AUX_DISTANCE_MASK		REG_GENMASK(31, 12)
#define   PLANE_AUX_STRIDE_MASK			REG_GENMASK(11, 0)
#define   PLANE_AUX_STRIDE(stride)		REG_FIELD_PREP(PLANE_AUX_STRIDE_MASK, (stride))

#define _PLANE_AUX_OFFSET_1_A			0x701c4
#define _PLANE_AUX_OFFSET_2_A			0x702c4
#define _PLANE_AUX_OFFSET_1_B			0x711c4
#define _PLANE_AUX_OFFSET_2_B			0x712c4
#define PLANE_AUX_OFFSET(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_AUX_OFFSET_1_A, _PLANE_AUX_OFFSET_1_B, \
							_PLANE_AUX_OFFSET_2_A, _PLANE_AUX_OFFSET_2_B)

#define _PLANE_CUS_CTL_1_A			0x701c8
#define _PLANE_CUS_CTL_2_A			0x702c8
#define _PLANE_CUS_CTL_1_B			0x711c8
#define _PLANE_CUS_CTL_2_B			0x712c8
#define PLANE_CUS_CTL(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_CUS_CTL_1_A, _PLANE_CUS_CTL_1_B, \
							_PLANE_CUS_CTL_2_A, _PLANE_CUS_CTL_2_B)
#define   PLANE_CUS_ENABLE			REG_BIT(31)
#define   PLANE_CUS_Y_PLANE_MASK		REG_BIT(30)
#define   PLANE_CUS_Y_PLANE_4_RKL		REG_FIELD_PREP(PLANE_CUS_Y_PLANE_MASK, 0)
#define   PLANE_CUS_Y_PLANE_5_RKL		REG_FIELD_PREP(PLANE_CUS_Y_PLANE_MASK, 1)
#define   PLANE_CUS_Y_PLANE_6_ICL		REG_FIELD_PREP(PLANE_CUS_Y_PLANE_MASK, 0)
#define   PLANE_CUS_Y_PLANE_7_ICL		REG_FIELD_PREP(PLANE_CUS_Y_PLANE_MASK, 1)
#define   PLANE_CUS_HPHASE_SIGN_NEGATIVE	REG_BIT(19)
#define   PLANE_CUS_HPHASE_MASK			REG_GENMASK(17, 16)
#define   PLANE_CUS_HPHASE_0			REG_FIELD_PREP(PLANE_CUS_HPHASE_MASK, 0)
#define   PLANE_CUS_HPHASE_0_25			REG_FIELD_PREP(PLANE_CUS_HPHASE_MASK, 1)
#define   PLANE_CUS_HPHASE_0_5			REG_FIELD_PREP(PLANE_CUS_HPHASE_MASK, 2)
#define   PLANE_CUS_VPHASE_SIGN_NEGATIVE	REG_BIT(15)
#define   PLANE_CUS_VPHASE_MASK			REG_GENMASK(13, 12)
#define   PLANE_CUS_VPHASE_0			REG_FIELD_PREP(PLANE_CUS_VPHASE_MASK, 0)
#define   PLANE_CUS_VPHASE_0_25			REG_FIELD_PREP(PLANE_CUS_VPHASE_MASK, 1)
#define   PLANE_CUS_VPHASE_0_5			REG_FIELD_PREP(PLANE_CUS_VPHASE_MASK, 2)

#define _PLANE_COLOR_CTL_1_A			0x701cc /* GLK+ */
#define _PLANE_COLOR_CTL_2_A			0x702cc
#define _PLANE_COLOR_CTL_1_B			0x711cc
#define _PLANE_COLOR_CTL_2_B			0x712cc
#define PLANE_COLOR_CTL(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_COLOR_CTL_1_A, _PLANE_COLOR_CTL_1_B, \
							_PLANE_COLOR_CTL_2_A, _PLANE_COLOR_CTL_2_B)
#define   PLANE_COLOR_PIPE_GAMMA_ENABLE			REG_BIT(30) /* Pre-ICL */
#define   PLANE_COLOR_YUV_RANGE_CORRECTION_DISABLE	REG_BIT(28)
#define   PLANE_COLOR_PIPE_CSC_ENABLE			REG_BIT(23) /* Pre-ICL */
#define   PLANE_COLOR_PLANE_CSC_ENABLE			REG_BIT(21) /* ICL+ */
#define   PLANE_COLOR_INPUT_CSC_ENABLE			REG_BIT(20) /* ICL+ */
#define   PLANE_COLOR_CSC_MODE_MASK			REG_GENMASK(19, 17)
#define   PLANE_COLOR_CSC_MODE_BYPASS			REG_FIELD_PREP(PLANE_COLOR_CSC_MODE_MASK, 0)
#define   PLANE_COLOR_CSC_MODE_YUV601_TO_RGB601		REG_FIELD_PREP(PLANE_COLOR_CSC_MODE_MASK, 1)
#define   PLANE_COLOR_CSC_MODE_YUV709_TO_RGB709		REG_FIELD_PREP(PLANE_COLOR_CSC_MODE_MASK, 2)
#define   PLANE_COLOR_CSC_MODE_YUV2020_TO_RGB2020	REG_FIELD_PREP(PLANE_COLOR_CSC_MODE_MASK, 3)
#define   PLANE_COLOR_CSC_MODE_RGB709_TO_RGB2020	REG_FIELD_PREP(PLANE_COLOR_CSC_MODE_MASK, 4)
#define   PLANE_COLOR_PLANE_GAMMA_DISABLE		REG_BIT(13)
#define   PLANE_COLOR_ALPHA_MASK			REG_GENMASK(5, 4)
#define   PLANE_COLOR_ALPHA_DISABLE			REG_FIELD_PREP(PLANE_COLOR_ALPHA_MASK, 0)
#define   PLANE_COLOR_ALPHA_SW_PREMULTIPLY		REG_FIELD_PREP(PLANE_COLOR_ALPHA_MASK, 2)
#define   PLANE_COLOR_ALPHA_HW_PREMULTIPLY		REG_FIELD_PREP(PLANE_COLOR_ALPHA_MASK, 3)

#define _PLANE_INPUT_CSC_RY_GY_1_A		0x701e0
#define _PLANE_INPUT_CSC_RY_GY_2_A		0x702e0
#define _PLANE_INPUT_CSC_RY_GY_1_B		0x711e0
#define _PLANE_INPUT_CSC_RY_GY_2_B		0x712e0
#define PLANE_INPUT_CSC_COEFF(pipe, plane, index)	_MMIO_SKL_PLANE_DW((pipe), (plane), (index), \
									   _PLANE_INPUT_CSC_RY_GY_1_A, _PLANE_INPUT_CSC_RY_GY_1_B, \
									   _PLANE_INPUT_CSC_RY_GY_2_A, _PLANE_INPUT_CSC_RY_GY_2_B)

#define _PLANE_INPUT_CSC_PREOFF_HI_1_A		0x701f8
#define _PLANE_INPUT_CSC_PREOFF_HI_2_A		0x702f8
#define _PLANE_INPUT_CSC_PREOFF_HI_1_B		0x711f8
#define _PLANE_INPUT_CSC_PREOFF_HI_2_B		0x712f8
#define PLANE_INPUT_CSC_PREOFF(pipe, plane, index)	_MMIO_SKL_PLANE_DW((pipe), (plane), (index), \
									   _PLANE_INPUT_CSC_PREOFF_HI_1_A, _PLANE_INPUT_CSC_PREOFF_HI_1_B, \
									   _PLANE_INPUT_CSC_PREOFF_HI_2_A, _PLANE_INPUT_CSC_PREOFF_HI_2_B)

#define _PLANE_INPUT_CSC_POSTOFF_HI_1_A		0x70204
#define _PLANE_INPUT_CSC_POSTOFF_HI_2_A		0x70304
#define _PLANE_INPUT_CSC_POSTOFF_HI_1_B		0x71204
#define _PLANE_INPUT_CSC_POSTOFF_HI_2_B		0x71304
#define PLANE_INPUT_CSC_POSTOFF(pipe, plane, index)	_MMIO_SKL_PLANE_DW((pipe), (plane), (index), \
									   _PLANE_INPUT_CSC_POSTOFF_HI_1_A, _PLANE_INPUT_CSC_POSTOFF_HI_1_B, \
									   _PLANE_INPUT_CSC_POSTOFF_HI_2_A, _PLANE_INPUT_CSC_POSTOFF_HI_2_B)

#define _PLANE_CSC_RY_GY_1_A			0x70210
#define _PLANE_CSC_RY_GY_2_A			0x70310
#define _PLANE_CSC_RY_GY_1_B			0x71210
#define _PLANE_CSC_RY_GY_2_B			0x71310
#define PLANE_CSC_COEFF(pipe, plane, index)	_MMIO_SKL_PLANE_DW((pipe), (plane), (index), \
								   _PLANE_CSC_RY_GY_1_A, _PLANE_CSC_RY_GY_1_B, \
								   _PLANE_CSC_RY_GY_2_A, _PLANE_CSC_RY_GY_2_B)

#define _PLANE_CSC_PREOFF_HI_1_A		0x70228
#define _PLANE_CSC_PREOFF_HI_2_A		0x70328
#define _PLANE_CSC_PREOFF_HI_1_B		0x71228
#define _PLANE_CSC_PREOFF_HI_2_B		0x71328
#define PLANE_CSC_PREOFF(pipe, plane, index)	_MMIO_SKL_PLANE_DW((pipe), (plane), (index), \
								   _PLANE_CSC_PREOFF_HI_1_A, _PLANE_CSC_PREOFF_HI_1_B, \
								   _PLANE_CSC_PREOFF_HI_2_A, _PLANE_CSC_PREOFF_HI_2_B)

#define _PLANE_CSC_POSTOFF_HI_1_A		0x70234
#define _PLANE_CSC_POSTOFF_HI_2_A		0x70334
#define _PLANE_CSC_POSTOFF_HI_1_B		0x71234
#define _PLANE_CSC_POSTOFF_HI_2_B		0x71334
#define PLANE_CSC_POSTOFF(pipe, plane, index)	_MMIO_SKL_PLANE_DW((pipe), (plane), (index), \
								   _PLANE_CSC_POSTOFF_HI_1_A, _PLANE_CSC_POSTOFF_HI_1_B, \
								   _PLANE_CSC_POSTOFF_HI_2_A, _PLANE_CSC_POSTOFF_HI_2_B)
#define _PLANE_WM_1_A_0				0x70240
#define _PLANE_WM_1_B_0				0x71240
#define _PLANE_WM_2_A_0				0x70340
#define _PLANE_WM_2_B_0				0x71340
#define PLANE_WM(pipe, plane, level)	_MMIO_SKL_PLANE_DW((pipe), (plane), (level), \
							   _PLANE_WM_1_A_0, _PLANE_WM_1_B_0, \
							   _PLANE_WM_2_A_0, _PLANE_WM_2_B_0)
#define   PLANE_WM_EN				REG_BIT(31)
#define   PLANE_WM_IGNORE_LINES			REG_BIT(30)
#define   PLANE_WM_LINES_MASK			REG_GENMASK(26, 14)
#define   PLANE_WM_BLOCKS_MASK			REG_GENMASK(11, 0)

#define _PLANE_WM_SAGV_1_A			0x70258
#define _PLANE_WM_SAGV_1_B			0x71258
#define _PLANE_WM_SAGV_2_A			0x70358
#define _PLANE_WM_SAGV_2_B			0x71358
#define PLANE_WM_SAGV(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_WM_SAGV_1_A, _PLANE_WM_SAGV_1_B, \
							_PLANE_WM_SAGV_2_A, _PLANE_WM_SAGV_2_B)

#define _PLANE_WM_SAGV_TRANS_1_A		0x7025c
#define _PLANE_WM_SAGV_TRANS_1_B		0x7125c
#define _PLANE_WM_SAGV_TRANS_2_A		0x7035c
#define _PLANE_WM_SAGV_TRANS_2_B		0x7135c
#define PLANE_WM_SAGV_TRANS(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
								_PLANE_WM_SAGV_TRANS_1_A, _PLANE_WM_SAGV_TRANS_1_B, \
								_PLANE_WM_SAGV_TRANS_2_A, _PLANE_WM_SAGV_TRANS_2_B)

#define _PLANE_WM_TRANS_1_A			0x70268
#define _PLANE_WM_TRANS_1_B			0x71268
#define _PLANE_WM_TRANS_2_A			0x70368
#define _PLANE_WM_TRANS_2_B			0x71368
#define PLANE_WM_TRANS(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_WM_TRANS_1_A, _PLANE_WM_TRANS_1_B, \
							_PLANE_WM_TRANS_2_A, _PLANE_WM_TRANS_2_B)

#define _PLANE_CHICKEN_1_A			0x7026c /* tgl+ */
#define _PLANE_CHICKEN_2_A			0x7036c
#define _PLANE_CHICKEN_1_B			0x7126c
#define _PLANE_CHICKEN_2_B			0x7136c
#define PLANE_CHICKEN(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_CHICKEN_1_A, _PLANE_CHICKEN_1_B, \
							_PLANE_CHICKEN_2_A, _PLANE_CHICKEN_2_B)
#define   PLANE_CHICKEN_DISABLE_DPT		REG_BIT(19) /* mtl+ */

#define _PLANE_NV12_BUF_CFG_1_A			0x70278
#define _PLANE_NV12_BUF_CFG_2_A			0x70378
#define _PLANE_NV12_BUF_CFG_1_B			0x71278
#define _PLANE_NV12_BUF_CFG_2_B			0x71378
#define PLANE_NV12_BUF_CFG(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_NV12_BUF_CFG_1_A, _PLANE_NV12_BUF_CFG_1_B, \
							_PLANE_NV12_BUF_CFG_2_A, _PLANE_NV12_BUF_CFG_2_B)

#define _PLANE_BUF_CFG_1_A			0x7027c
#define _PLANE_BUF_CFG_2_A			0x7037c
#define _PLANE_BUF_CFG_1_B			0x7127c
#define _PLANE_BUF_CFG_2_B			0x7137c
#define PLANE_BUF_CFG(pipe, plane)	_MMIO_SKL_PLANE((pipe), (plane), \
							_PLANE_BUF_CFG_1_A, _PLANE_BUF_CFG_1_B, \
							_PLANE_BUF_CFG_2_A, _PLANE_BUF_CFG_2_B)
/* skl+: 10 bits, icl+ 11 bits, adlp+ 12 bits */
#define   PLANE_BUF_END_MASK			REG_GENMASK(27, 16)
#define   PLANE_BUF_END(end)			REG_FIELD_PREP(PLANE_BUF_END_MASK, (end))
#define   PLANE_BUF_START_MASK			REG_GENMASK(11, 0)
#define   PLANE_BUF_START(start)		REG_FIELD_PREP(PLANE_BUF_START_MASK, (start))

/* tgl+ */
#define _SEL_FETCH_PLANE_CTL_1_A		0x70890
#define _SEL_FETCH_PLANE_CTL_2_A		0x708b0
#define _SEL_FETCH_PLANE_CTL_5_A		0x70920
#define _SEL_FETCH_PLANE_CTL_6_A		0x70940
#define _SEL_FETCH_PLANE_CTL_1_B		0x71890
#define _SEL_FETCH_PLANE_CTL_2_B		0x718b0
#define _SEL_FETCH_PLANE_CTL_5_B		0x71920
#define _SEL_FETCH_PLANE_CTL_6_B		0x71940
#define SEL_FETCH_PLANE_CTL(pipe, plane)	_MMIO_SEL_FETCH((pipe), (plane),\
								_SEL_FETCH_PLANE_CTL_1_A, _SEL_FETCH_PLANE_CTL_1_B, \
								_SEL_FETCH_PLANE_CTL_2_A, _SEL_FETCH_PLANE_CTL_2_B, \
								_SEL_FETCH_PLANE_CTL_5_A, _SEL_FETCH_PLANE_CTL_5_B, \
								_SEL_FETCH_PLANE_CTL_6_A, _SEL_FETCH_PLANE_CTL_6_B)
#define   SEL_FETCH_PLANE_CTL_ENABLE		REG_BIT(31)

/* tgl+ */
#define _SEL_FETCH_PLANE_POS_1_A		0x70894
#define _SEL_FETCH_PLANE_POS_2_A		0x708b4
#define _SEL_FETCH_PLANE_POS_5_A		0x70924
#define _SEL_FETCH_PLANE_POS_6_A		0x70944
#define _SEL_FETCH_PLANE_POS_1_B		0x71894
#define _SEL_FETCH_PLANE_POS_2_B		0x718b4
#define _SEL_FETCH_PLANE_POS_5_B		0x71924
#define _SEL_FETCH_PLANE_POS_6_B		0x71944
#define SEL_FETCH_PLANE_POS(pipe, plane)	_MMIO_SEL_FETCH((pipe), (plane),\
								_SEL_FETCH_PLANE_POS_1_A, _SEL_FETCH_PLANE_POS_1_B, \
								_SEL_FETCH_PLANE_POS_2_A, _SEL_FETCH_PLANE_POS_2_B, \
								_SEL_FETCH_PLANE_POS_5_A, _SEL_FETCH_PLANE_POS_5_B, \
								_SEL_FETCH_PLANE_POS_6_A, _SEL_FETCH_PLANE_POS_6_B)

/* tgl+ */
#define _SEL_FETCH_PLANE_SIZE_1_A		0x70898
#define _SEL_FETCH_PLANE_SIZE_2_A		0x708b8
#define _SEL_FETCH_PLANE_SIZE_5_A		0x70928
#define _SEL_FETCH_PLANE_SIZE_6_A		0x70948
#define _SEL_FETCH_PLANE_SIZE_1_B		0x71898
#define _SEL_FETCH_PLANE_SIZE_2_B		0x718b8
#define _SEL_FETCH_PLANE_SIZE_5_B		0x71928
#define _SEL_FETCH_PLANE_SIZE_6_B		0x71948
#define SEL_FETCH_PLANE_SIZE(pipe, plane)	_MMIO_SEL_FETCH((pipe), (plane),\
								_SEL_FETCH_PLANE_SIZE_1_A, _SEL_FETCH_PLANE_SIZE_1_B, \
								_SEL_FETCH_PLANE_SIZE_2_A, _SEL_FETCH_PLANE_SIZE_2_B, \
								_SEL_FETCH_PLANE_SIZE_5_A, _SEL_FETCH_PLANE_SIZE_5_B, \
								_SEL_FETCH_PLANE_SIZE_6_A, _SEL_FETCH_PLANE_SIZE_6_B)

/* tgl+ */
#define _SEL_FETCH_PLANE_OFFSET_1_A		0x7089c
#define _SEL_FETCH_PLANE_OFFSET_2_A		0x708bc
#define _SEL_FETCH_PLANE_OFFSET_5_A		0x7092c
#define _SEL_FETCH_PLANE_OFFSET_6_A		0x7094c
#define _SEL_FETCH_PLANE_OFFSET_1_B		0x7189c
#define _SEL_FETCH_PLANE_OFFSET_2_B		0x718bc
#define _SEL_FETCH_PLANE_OFFSET_5_B		0x7192c
#define _SEL_FETCH_PLANE_OFFSET_6_B		0x7194c
#define SEL_FETCH_PLANE_OFFSET(pipe, plane)	_MMIO_SEL_FETCH((pipe), (plane),\
								_SEL_FETCH_PLANE_OFFSET_1_A, _SEL_FETCH_PLANE_OFFSET_1_B, \
								_SEL_FETCH_PLANE_OFFSET_2_A, _SEL_FETCH_PLANE_OFFSET_2_B, \
								_SEL_FETCH_PLANE_OFFSET_5_A, _SEL_FETCH_PLANE_OFFSET_5_B, \
								_SEL_FETCH_PLANE_OFFSET_6_A, _SEL_FETCH_PLANE_OFFSET_6_B)

#endif /* __SKL_UNIVERSAL_PLANE_REGS_H__ */
