/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * LLC station component (SAP and connection resource manager) 
 */


#ifndef LLC_MAIN_H
#define LLC_MAIN_H


/* Station component; one per adapter */
typedef struct
{
   us8                 state;			/* state of station */
   mph_t               mp_handle;       	/* memory pool handle of station */
   us8                 xid_r_count;		/* XID response PDU counter */
   void *              ack_timer;
   us8                 ack_timer_running;	/* YES or NO */
   us8                 retry_count;
   us8                 maximum_retry;
   us8                 mac_type;		/* T-R, eth, 802.3 PCNetwk */
#if 1
   us8                 mac_sa [6];		/* MAC source address */
#else
   /* Constant in 'lan_hdrs.h' */
   us8                 mac_sa [MAC_ADDR_LEN];	/* MAC source address */
#endif
   dll_t               sap_list;		/* list of related SAPs */
   dll_t               avail_events;		/* events available for queuing */
   dll_t               event_q;			/* events entering state mach. */
   dll_t               mac_pdu_q;		/* PDUs ready to send to MAC */
} station_t;


#ifdef LLC_MAIN_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_MAIN_C */


EXTRN us16         llc_init (void);
EXTRN us16         llc_exit (void);
EXTRN us16         llc_sap_get (sap_t ** sap);
EXTRN us16         llc_sap_save (sap_t * sap);
EXTRN us16         llc_rtn_sap (sap_t * sap);
EXTRN us16         llc_sap_find (us8 lsap, sap_t ** sap);
EXTRN us16         llc_check_init (void);
EXTRN us16         llc_connection_get (connection_t ** connection);
EXTRN us16         llc_connection_rtn (connection_t * connection);
EXTRN us16         llc_connection_reset (connection_t * connection);
EXTRN us16         llc_service_io (station_t * station);
EXTRN us16         station_get (station_t ** station);
EXTRN us16         station_get_event (station_t * station, void ** event);
EXTRN us16         station_send_event (station_t * station, void * event);
EXTRN us16         station_send_pdu (station_t * station,
                                                 frame_t * pdu_frame);


#undef EXTRN
#endif  /* LLC_MAIN_H */


