#!perl
use strict;
use warnings;

use Test::More;

BEGIN {
    use_ok('Time::Moment');
}

{
    my $tm = Time::Moment->from_string('2012-12-24T12:30:45.123456789Z');
    my @tests = (
        [  9, '2012-12-24T12:30:45.123456789Z' ],
        [  8, '2012-12-24T12:30:45.123456780Z' ],
        [  7, '2012-12-24T12:30:45.123456700Z' ],
        [  6, '2012-12-24T12:30:45.123456Z'    ],
        [  5, '2012-12-24T12:30:45.123450Z'    ],
        [  4, '2012-12-24T12:30:45.123400Z'    ],
        [  3, '2012-12-24T12:30:45.123Z'       ],
        [  2, '2012-12-24T12:30:45.120Z'       ],
        [  1, '2012-12-24T12:30:45.100Z'       ],
        [  0, '2012-12-24T12:30:45Z'           ],
        [ -1, '2012-12-24T12:30:00Z'           ],
        [ -2, '2012-12-24T12:00:00Z'           ],
        [ -3, '2012-12-24T00:00:00Z'           ],
    );

    for my $test (@tests) {
        my ($precision, $string) = @$test;
        my $got = $tm->with_precision($precision);
        is($got->to_string, $string, "->with_precision($precision)");
        is($got->precision, $precision, "$got->precision");
    }
}

{
    my $tm = Time::Moment->from_string('2012-12-24T12:30:45.123456789+14:30');
    my @tests = (
        [  9, '2012-12-24T12:30:45.123456789+14:30' ],
        [  8, '2012-12-24T12:30:45.123456780+14:30' ],
        [  7, '2012-12-24T12:30:45.123456700+14:30' ],
        [  6, '2012-12-24T12:30:45.123456+14:30'    ],
        [  5, '2012-12-24T12:30:45.123450+14:30'    ],
        [  4, '2012-12-24T12:30:45.123400+14:30'    ],
        [  3, '2012-12-24T12:30:45.123+14:30'       ],
        [  2, '2012-12-24T12:30:45.120+14:30'       ],
        [  1, '2012-12-24T12:30:45.100+14:30'       ],
        [  0, '2012-12-24T12:30:45+14:30'           ],
        [ -1, '2012-12-24T12:30:00+14:30'           ],
        [ -2, '2012-12-24T12:00:00+14:30'           ],
        [ -3, '2012-12-24T00:00:00+14:30'           ],
    );

    for my $test (@tests) {
        my ($precision, $string) = @$test;
        my $got = $tm->with_precision($precision);
        is($got->to_string, $string, "->with_precision($precision)");
        is($got->precision, $precision, "$got->precision");
    }
}

{
    my $tm = Time::Moment->from_string('2012-12-24T12:30:45.123456789-14:30');
    my @tests = (
        [  9, '2012-12-24T12:30:45.123456789-14:30' ],
        [  8, '2012-12-24T12:30:45.123456780-14:30' ],
        [  7, '2012-12-24T12:30:45.123456700-14:30' ],
        [  6, '2012-12-24T12:30:45.123456-14:30'    ],
        [  5, '2012-12-24T12:30:45.123450-14:30'    ],
        [  4, '2012-12-24T12:30:45.123400-14:30'    ],
        [  3, '2012-12-24T12:30:45.123-14:30'       ],
        [  2, '2012-12-24T12:30:45.120-14:30'       ],
        [  1, '2012-12-24T12:30:45.100-14:30'       ],
        [  0, '2012-12-24T12:30:45-14:30'           ],
        [ -1, '2012-12-24T12:30:00-14:30'           ],
        [ -2, '2012-12-24T12:00:00-14:30'           ],
        [ -3, '2012-12-24T00:00:00-14:30'           ],
    );

    for my $test (@tests) {
        my ($precision, $string) = @$test;
        my $got = $tm->with_precision($precision);
        is($got->to_string, $string, "->with_precision($precision)");
        is($got->precision, $precision, "$got->precision");
    }
}

done_testing();

