#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

ALLMÄN FÖRKLARING OM DE MÄNSKLIGA RÄTTIGHETERNA
INLEDNING
Enär erkännandet av det inneboende värdet hos alla medlemmar av människosläktet och av deras lika och oförytterliga rättigheter är grundvalen för frihet, rättvisa och fred i världen,

enär ringaktning och förakt för de mänskliga rättigheterna lett till barbariska gärningar, som upprört mänsklighetens samvete, och enär skapandet av en värld, där människorna åtnjuta yttrandefrihet, trosfrihet samt frihet från fruktan och nöd, kungjorts som folkens högsta strävan,

enär det är väsentligt för att icke människan skall tvingas att som en sista utväg tillgripa uppror mot tyranni och förtryck, att de mänskliga rättigheterna skyddas genom lagens överhöghet,

enär det är väsentligt att främja utvecklandet av vänskapliga förbindelser mellan nationerna,

enär Förenta Nationernas folk i stadgan ånyo uttryckt sin tro på de grundläggande mänskliga rättigheterna, den enskilda människans värdighet och värde samt männens och kvinnornas lika rättigheter, ävensom beslutat främja socialt framåtskridande och bättre levnadsvillkor under större frihet,

enär medlemsstaterna åtagit sig att i samverkan med Förenta Nationerna säkerställa allmän och effektiv respekt för de mänskliga rättigheterna och de grundläggande friheterna,

enär en gemensam uppfattning av dessa fri- och rättigheters innebörd är av största betydelse för uppfyllandet av detta åtagande,

kungör

GENERALFÖRSAMLINGEN

denna ALLMÄNNA FÖRKLARING OM DE MÄNSKLIGA RÄTTIGHETERNA såsom en gemensam riktlinje för alla folk och alla nationer, på det att varje individ och varje samhällsorgan må med denna förklaring i åtanke ständigt sträva efter att genom undervisning och uppfostran befordra respekten för dessa fri- och rättigheter samt genom framstegsfrämjande inhemska och internationella åtgärder säkerställa deras allmänna och verksamma erkännande och tilllämpning såväl bland folken i medlemsstaterna som bland folken i områden under deras överhöghet.

Artikel 1.
Alla människor äro födda fria och lika i värde och rättigheter. De äro utrustade med förnuft och samvete och böra handla gentemot varandra i en anda av broderskap.

Artikel 2.
Envar är berättigad till alla de fri- och rättigheter, som uttalas i denna förklaring, utan åtskillnad av något slag, såsom ras, hudfärg, kön, språk, religion, politisk eller annan uppfattning, nationellt eller socialt ursprung, egendom, börd eller ställning i övrigt.

Ingen åtskillnad må vidare göras på grund av den politiska, juridiska eller internationella ställning, som intages av det land eller område, till vilket en person hör, vare sig detta land eller område är oberoende, står under förvaltarskap, är icke-självstyrande eller är underkastat någon annan begränsning av sin suveränitet.

Artikel 3.
Envar har rätt till liv, frihet och personlig säkerhet.

Artikel 4.
Ingen må hållas i slaveri eller träldom; slaveri och slavhandel i alla dess former äro förbjudna.

Artikel 5.
Ingen må utsättas för tortyr eller grym, omänsklig eller förnedrande behandling eller bestraffning.

Artikel 6.
Envar har rätt att allestädes erkännas som person i lagens mening.

Artikel 7.
Alla äro lika inför lagen och äro utan åtskillnad berättigade till lika skydd från lagens sida. Alla äro berättigade till lika skydd mot varje åtskillnad i strid med denna förklaring och mot varje framkallande av sådan åtskillnad.

Artikel 8.
Envar har rätt till verksam hjälp från sitt lands behöriga domstolar mot handlingar, som kränka de grundläggande rättigheter, vilka tillkomma honom genom lag eller författning.

Artikel 9.
Ingen må godtyckligt anhållas, fängslas eller landsförvisas.

Artikel 10.
Envar är under full likställdhet berättigad till rättvis och offentlig rannsakning inför oavhängig och opartisk domstol vid fastställandet av såväl hans rättigheter och skyldigheter som varje anklagelse mot honom för brott.

Artikel 11.
Envar, som blivit anklagad för straffbar gärning, har rätt att betraktas som oskyldig, till dess hans skuld blivit lagligen fastställd vid offentlig rättegång, under vilken han åtnjutit alla för sitt försvar nödiga garantier.
Ingen må dömas för handling eller underlåtenhet, som vid tidpunkten för dess begående icke var straffbar enligt inhemsk eller internationell rätt. Ej heller må högre straff utmätas än vad som var tillämpligt vid tidpunkten för den straffbara gärningens begående.
Artikel 12.
Ingen må utsättas för godtyckliga ingripanden i fråga om privatliv, familj, hem eller korrespondens, ej heller angrepp på heder och anseende. Envar har rätt till lagens skydd mot sådana ingripanden eller angrepp.

Artikel 13.
Envar har rätt att inom varje stats gränser fritt förflytta sig och välja sin vistelseort.
Envar har rätt att lämna varje land, inbegripet sitt eget, och att återvända till sitt eget land.
Artikel 14.
Envar har rätt att i andra länder söka och åtnjuta fristad från förföljelse.
Denna rätt må icke åberopas vid laga åtgärder, reellt grundade på icke-politiska brott eller på handlingar, som strida mot Förenta Nationernas ändamål och grundsatser.
Artikel 15.
Envar har rätt till en nationalitet.
Ingen må godtyckligt berövas sin nationalitet eller förmenas rätten att ändra nationalitet.
Artikel 16.
Fullvuxna män och kvinnor har rätt att utan någon inskränkning på grund av sin ras, nationalitet eller religion ingå äktenskap och bilda familj. De äga lika rättigheter vid giftermål, under äktenskap och vid äktenskaps upplösning.
Äktenskap må ingås endast med de blivande makarnas fria och fullständiga samtycke.
Familjen är den naturliga och grundläggande enheten i samhället och äger rätt till skydd från samhället och staten.
Artikel 17.
Envar har rätt att äga egendom såväl ensam som i förening med andra.
Ingen må godtyckligt berövas sin egendom.
Artikel 18.
Envar har rätt till tankefrihet, samvetsfrihet och religionsfrihet. Denna rätt innefattar frihet att byta religion eller tro och att ensam eller i gemenskap med andra offentligt eller enskilt utöva sin religion eller tro genom undervisning, andaktsövningar, gudstjänst och iakttagande av religiösa sedvänjor.

Artikel 19.
Envar har rätt till åsiktsfrihet och yttrandefrihet. Denna rätt innefattar frihet för envar att utan ingripanden hysa åsikter och frihet att söka, mottaga och sprida upplysningar och tankar genom varje slags uttrycksmedel och utan hänsyn till gränser.

Artikel 20.
Envar har rätt till frihet i fråga om fredliga möten och sammanslutningar.
Ingen må tvingas att tillhöra en sammanslutning.
Artikel 21.
Envar har rätt att taga del i sitt lands styrelse direkt eller genom fritt valda ombud.
Envar har rätt till lika tillträde till allmän tjänst i sitt land.
Folkets vilja skall utgöra grundvalen för statsmakternas myndighet. Denna vilja skall uttryckas i periodiska och verkliga val, vilka skola äga rum med tillämpning av allmän och lika rösträtt samt hemlig röstning eller likvärdiga fria röstningsförfaranden.
Artikel 22.
Envar äger i sin egenskap av samhällsmedlem rätt till social trygghet och är berättigad till att de ekonomiska, sociala och kulturella rättigheter, som äro oundgängliga för hans värdighet och för en fri utveckling av hans personlighet, förverkligas genom nationella åtgärder och mellanfolkligt samarbete med hänsyn tagen till varje stats organisation och resurser.

Artikel 23.
Envar har rätt till arbete, till fritt val av sysselsättning, till rättvisa och tillfredsställande arbetsförhållanden och till skydd mot arbetslöshet.
Envar har utan åtskillnad rätt till lika lön för lika arbete.
Envar, som arbetar, har rätt till rättvis och tillfredsställande ersättning, som tillförsäkrar honom själv och hans familj en människovärdig tillvaro och som, där så är nödvändigt, kompletteras med andra medel för socialt skydd.
Envar har rätt att bilda och ansluta sig till fackföreningar till skydd för sina intressen.
Artikel 24.
Envar har rätt till vila och fritid, innefattande rimlig begränsning av arbetstiden och regelbunden semester med bibehållen lön.

Artikel 25.
Envar har rätt till en levnadsstandard, som är tillräcklig för hans egen och hans familjs hälsa och välbefinnande, däri inbegripet föda, kläder, bostad, hälsovård och nödvändiga sociala förmåner, vidare rätt till trygghet i händelse av arbetslöshet, sjukdom, invaliditet, makes död, ålderdom eller annan förlust av försörjning under omständigheter, över vilka han icke kunnat råda.
Mödrar och barn äro berättigade till särskild omvårdnad och hjälp. Alla barn, vare sig födda inom eller utom äktenskap, skola åtnjuta samma sociala skydd.
Artikel 26.
Envar har rätt till undervisning. Undervisningen skall vara kostnadsfri, åtminstone på de elementära och grundläggande stadierna. Den elementära undervisningen skall vara obligatorisk. Yrkesundervisning och teknisk undervisning skall vara allmänt tillgänglig. Den högre undervisningen skall stå öppen i lika mån för alla på grundval av deras duglighet.
Undervisningen skall syfta till personlighetens fulla utveckling och till att stärka respekten för människans grundläggande fri- och rättigheter. Undervisningen skall främja förståelse, tolerans och vänskap mellan alla nationer, rasgrupper och religiösa grupper samt befordra Förenta Nationernas verksamhet för fredens bevarande.
Rätten att välja den undervisning, som skall ges åt barnen, tillkommer i främsta rummet deras föräldrar.
Artikel 27.
Envar har rätt att fritt taga del i samhällets kulturella liv, att njuta av konsten samt att bli delaktig av vetenskapens framsteg och dess förmåner.
Envar har rätt till skydd för de moraliska och materiella intressen, som härröra från varje vetenskapligt, litterärt eller konstnärligt verk, till vilket han är upphovsman.
Artikel 28.
Envar har rätt till en social och internationell ordning, i vilken de fri- och rättigheter, som uttalas i denna förklaring, till fullo kunna förverkligas.

Artikel 29.
Envar har plikter mot samhället, i vilket den fria och fullständiga utvecklingen av hans personlighet ensamt är möjlig.
Vid utövandet av sina fri- och rättigheter må envar underkastas endast sådana inskränkningar, som blivit fastställda i lag i uteslutande syfte att trygga tillbörlig hänsyn till och respekt för andras fri- och rättigheter samt för att tillgodose det demokratiska samhällets rättmätiga krav på moral, allmän ordning och allmän välfärd.
Dessa fri- och rättigheter må i intet fall utövas i strid med Förenta Nationernas ändamål och grundsatser.
Artikel 30.
Intet i denna förklaring må tolkas såsom innebärande rättighet för någon stat, grupp eller person att ägna sig åt verksamhet eller utföra handling, som syftar till att omintetgöra någon av häri uttalade fri- och rättigheter.

TEXT

is(Text::Guess::Language->guess($text),'sv','is sv');

done_testing;
