#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

Mannréttindayfirlýsing Sameinuðo Þjóðanna.
Inngangsorð
Það ber að viðurkenna, að hver maður sé jafnborinn til virðingar og réttinda, er eigi verði af honum tekin, og er þetta undirstaða frelsis, réttlætis og friðar i heiminum.

Hafi mannréttindi verið fyrir borð borin og lítilsvirt, hefur slíkt haft í för með sér siðlausar athafnir, er ofboðið hafa samvizku mannkynsins, enda hefur því verið yfir lýst, að æðsta markmið almennings um heim allan sé að skapa veröld, þar sem menn fái notið málfrelsis , trúfrelsis og óttaleysis um einkalíf afkomu.

Mannréttindi á að vernda með lögum. Að öðrum kosti hljóta menn að grípa til þess örþrifaráðs að rísa upp gegn kúgun og ofbeldi.

Það er mikilsvert að efla vinsamleg samskipti þjóða í milli.

Í stofnskrá sinni hafa Sameinuðu þjóðdirnar lýst yfir trú sinni á grundvallaratriði mannréttinda, á göfgi og gildi mannsins og jafnrétti karla og kvernna, enda munu þær beita sér fyrir félagslegum framförum og betri lífsafkomu með auknu frelsi manna.

Aðildarríkin hafa bundizt samtökum um að efla almenna virðingu fyrir og gæzlu hinna mikilsverðustu mannréttinda í samráði við Sameinuðu þjóðirnar.

Til þess að slík samtök megi sem best takast, er það ákaflega mikilvægt, að almennur skilningur verði vakinn á eðli slíkra réttinda og frjálsræðis.

Fyrir því hefur allsherjarþing Sameinuðu þjóðanna fallizt á mannréttindayfirlýsingu þá, sem hér með er birt öllum þjóðum og ríkjum til fyrirmyndar. Skulu einstaklingar og yfirvöld jafnan hafa yfirlýsingu þessa í huga og kappkosta með fræðslu og uppeldi að efla virðingu fyrir réttindum Þeim og frjálstræÞi, sem hér er að stefnt. Ber og hverjum einum að stuðla Þeim framförum, innan ríkis og ríkja í milli, er að markmiðum yfirlýsingarinnar stefna, tryggja almenna og virka viðurkenningu á grundvallaratriðum hennar og sjá um, að Þau verði í heiðri höfó, bæði meðal Þjóða aðildarríkjanna sjálfra og meðal Þjóða á landsvæðum Þeim, er hlita lögsögu aðildarríkja.

1. grein.
Hver maður er borinn frjáls og jafn öðrum að virðingu og réttindum. Menn eru gæddir vitsmunum og samvizku, og ber þeim að breyta bróðurlega hverjum við annan.

2. grein.
Hver maður skal eiga kröfu á réttindum þeim og því frjálsræði, sem fólgin eru í yfirlýsingu þessari, og skal þar engan greinarmun gera vegna kynþáttar, litarháttar, kynferðis, tungu, trúar, stjórnmálaskoðana eða annarra skoðana, þjóðernis, uppruna, eigna, ætternis eða annarra aðstæðna.
Eigi má heldur gera greinarmun á mönnum fyrir sakir stjórnskipulags lands þeirra eða landsvæðis, þjóðréttarstöðu þess eða lögsögu yfir því, hvort sem landið er sjálfstætt ríki, umráðasvæði, sjálfstjórnarlaust eða á annan hátt háð takmörkunum á fullveldi sínu.

3. grein.
Allir menn eiga rétt til lífs, frelsis og mannhelgi.

4. grein.
Engan mann skal hneppa í þrældóm né nauðungarvinnu. Þrælahald og þrælaverzlun, hverju nafni sem nefnist, skulu bönnuð.

5. grein.
Enginn maður skal sæta pyndingum, grimmilegri, ómannlegri eða vanvirðandi meðferð eða refsingu.

6. grein.
Allir menn skulu, hvar í heimi sem er, eiga kröfu á að vera viðurkenndir aðilar að lögum.

7. grein.
Allir menn skulu jafnir fyrir lögunum og eiga rétt á jafnri vernd þeirra, án manngreinarálits. Ber öllum mönnum réttur til verndar gegn hvers konar misrétti, sem í bága brýtur við yfirlýsingu þessa, svo og gagnvart hvers konar áróðri til þess að skapa slíkt misrétti.

8. grein.
Nú sætir einhver maður meðferð, er brýtur í bága við grundvallarréttindi þau, sem tryggð eru í stjórnarskrá og lögum, og skal hann þá eiga athvarf hjá dómstólum landsins til þess að fa hlut sinn réttan.

9. grein.
Ekki má eftir geðþótta taka menn fasta, hneppa þá i fangelsi eða varðhald né gera útlæga.

10. grein.
Nú leikur vafi á um réttindi þegns og skyldur, eða hann er borinn sökum um glæpsamlegt athæfi, og skal hann þá njóta fulls jafnréttis við aðra menn um réttláta opinbera rannsókn fÞrir óháðum og óhlutdrægum dómstóli.

11. grein.
Hvern þann mann, sem borinn er sökum fyrir refsivert athæfi, skal telja saklausan, unz sök hans her sönnuð lögfullri sönnun fÞrir opinberum dómstóli, enda hafi tryggilega verið búið um vörn sakbornings.
Engan skal telja sekan til refsingar, nema verknaður sá eða aðgerðaleysi, sem hann er borinn, varði refsingu að landslögum eða þjóðarétti á þeim tíma, er máli skiptir. Eigi má heldur dæma hann til þyngri refsingar en þeirrar, sem að lögum var leyfð, þegar verknaðurinn var framinn.
12. grein.
Eigi má eftir geðþótta raska heimilisfriði nokkurs manns, hnýsast í einkamál hans eða bréf, vanvirða hann eða spilla mannorði hans. Ber hverjum manni lagavernd gagnvart slíkum afskiptum eða árásum.

13. grein.
Frjálsir skulu menn vera ferða sinna og dvalar innan landamæra hvers ríkis.
Rétt skal mönnum vera að fara af landi burt, hvort sem er af sínu landi eða öðru, og eiga afturkvæmt til heimalands síns.
14. grein.
Rétt skal mönnum vera að leita og njóta griðlands erlendis gegn ofsóknum.
Enginn má þó skírskota til slíkra réttinda, sem lögsóttur er með réttu fyrir ópólitísk afbrot eða atferli, er brýtur í bága við markmið og grundvallarreglur Sameinuðu þjóðanna.
15. grein.
Allir menn hafa rétt til ríkisfangs.
Engan mann má eftir geðþótta svipta ríkisfangi né rétti til þess að skipta um ríkisfang.
16. grein.
Konum og körlum, sem hafa aldur til þess að lögum, skal heimilt að stofna til hjúskapar og fjölskyldu, án tillits til kynþáttar, þjóðernis eða trúarbragða. Þau skulu njóta jafnréttis um stofnun og slit hjúskapar, svo og í hjónabandinu.
Eigi má hjúskap binda, nema bæði hjónæfni samþykki fúsum vilja.
Fjölskyldan er í eðli sínu frumeining þjóðfélagsins, og ber þjóðfélagi og ríki að vernda hana.
17. grein.
Hverjum manni skal heimilt að eiga eignir, einum sér eða í félagi við aðra.
Engan má eftir geðþótta svipta eign sinni.
18. grein.
Allir menn skulu frjálsir hugsana sinna, sanfæringar og trúar. Í þessu felst frjálsræði til að skipta um trú eða játningu og enn fremur til að láta í ljós trú sína eða játningu, einir sér eða í félagi við aðra, opinberlega eða einslega, með kennslu, tilbeiðslu, guðsþjónustum og helgihaldi.

19. grein.
Hver maður skal frjáls skoðana sinna og að því að láta þær í ljós. Felur slíkt frjálsræði í sér réttindi til þess að leita, taka við og dreifa vitneskju og hugmyndum með hverjum hætti sem vera skal og án tillits til landamæra.

20. grein.
Hverjum manni skal frjálst að eiga þátt í friðsamlegum fundahöldum og félagsskap.
Engan mann má neyða til að vera í félagi.
21. grein.
Hverjum manni er heimilt að taka þátt í stjórn lands síns, beinlínis eða með því að kjósa til þess fulltrúa frjálsum kosningum.
Hver maður á jafnan rétt til þess að gegna opinberum störfum í landi sínu.
Vilji þjóðarinnar skal vera grundvöllur að valdi ríkisstjórnar. Skal hann látinn í ljós með reglubundnum, óháðum og almennum kosningum, enda sé kosningarréttur jafn og leynileg atkvæðagreiðsla viðhöfð eða jafngildi hennar að frjálsræði.
22. grein.
Hver þjóðfélagsþegn skal fyrir atbeina hins opinbera eða alþjóðasamtaka og í samræmi við skipulag og efnahag hvers ríkis eiga kröfu á félagslegu öryggi og þeim efnahagslegum, félagslegum og menningarlegum réttindum, sem honum eru nauðsynleg til þess að virðing hans og þroski fái notið sin.

23. grein.
Hver maður á rétt á atvinnu að frjálsu vali, á réttlátum og hagkvænum vinnuskilyrðum og á vernd gegn atvinnuleysi.
Hverjum manni ber sama greiðsla fyrir sama verk, án manngreinarálits.
Allir menn, sem vinnu stunda, skulu bera úr býtum réttlátt og hagstætt endurgjald, er tryggi þeim og fjölskyldum þeirra mannsæm lífskjör. Þeim ber og önnur félagsleg vernd, ef þörf krefur.
Hver maður má stofna til stéttarsamtaka og ganga í þau til verndar hagsmunum sínum.
24. grein.
Hverjum manni ber réttur til hvíldar og tómstunda, og telst þar til hæfileg takmörkun vinnutíma og reglubundið orlof að óskertum launum.

25. grein.
Hver maður á kröfu til lífskjara, sem nauðsynleg eru til verndar heilsu og vellíðan hans sjálfs og fjölskyldu hans. Telst þar til matur, klæðnaður, húsnæði, læknishjálp og nauðsynleg félagshjálp, svo og réttindi til öryggis gegn atvinnuleysi, veikindum, örorku, fyrirvinnumissi, elli eða öðrum áföllum, sem skorti valda og hann getur ekki við gert.
Mæðrum og börnum ber sérstök vernd og aðstoð. Öll börn, skilgetin sem óskilgetin, skulu njóta sömu félagsverndar.
26. grein.
Hver maður á rétt til menntunar. Skal hún veitt ókeypis, að minnsta kosti barnafræðsla og undirstöðummentu. Börn skulu vera skólaskyld. Iðnaðar- og verknám skal öllum standa til boða og æðri menntu vera öllum jafnfrjáls, þeim er hæfileika hafa til að njóta hennar.
Menntun skal beina í þá átt að þroska persónuleika einstaklinganna og innræta þeim virðingu fyrir mannréttindum og mannhelgi. Hún skal miða að því að efla skilning, umburðarlyndi og vináttu meðal allra þjóða, kynþátta og trúarflokka og að efla starf Sameinuðu þjóðanna í þágu friðarins.
Foreldrar skulu fremur öðrum ráða, hverrar menntunar börn þeirra skuli njóta.
27. grein
Hverjum manni ber réttur til þess að taka frjálsan þátt í menningarlífi þjóðfélagsins, njóta lista, eiga þátt í framförum á sviði vísinda og verða aðnjótandi þeirra gæða, er af þeim leiðir.
Hver maður skal njóta lögverndar þeirra hagsmuna, í andlegum og efnalegum skilningi, er leiðir af vísindaverki, ritverki eða listaverki, sem hann er höfundur að, hverju nafni sem nefnist.
28. grein
Hverjum manni ber réttur til þess þjóðfélags- og milliþjóðaskipulags, er virði og framkvæmi að fullu mannréttindi þau, sem í yfirlýsingu þessari eru upp talin.

29. grein.
Hver maður hefur skyldur við þióðfélagið, enda getur það eitt tryggt fullan og frjálsan persónuþroska einstaklingsins.
Þjóðfélagsþegnar skulu um réttindi og frjálsræði háðir þeim takmörkunum einum, sem settar eru með lögum i því skyni að tryggja viðurkenningu á og virðingu fyrir frelsi og réttindum annarra og til þess að fullnægja réttlátum kröfum um siðgæði, reglu og velferð almennings í lýðfrjálsu þjóðfélagi.
Þessi mannréttindi má aldrei framkvæma svo, að í bága fari við markmið og grundvallarreglur Sameinuðu þjóðanna.
30. grein.
Ekkert atriði þessarar yfirlýsingar má túlka á þann veg, að nokkru ríki, flokki manna eða einstaklingi sé heimilt að aðhafast nokkuð það, er stefni að því að gera að engu nokkur þeirra mannréttinda, sem hér hafa verið upp talin.

TEXT

is(Text::Guess::Language->guess($text),'is','is is');

done_testing;
