#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

Az Emberi Jogok Egyetemes Nyilatkozata
Bevezető
Tekintettel arra, hogy az emberiség családja minden egyes tagja méltóságának, valamint egyenlő és elidegeníthetetlen jogainak elismerése alkotja a szabadság, az igazság és a béke alapját a világon,

Tekintettel arra, hogy az emberi jogok el nem ismerése és semmibevevése az emberiség lelkiismeretét fellázító barbár cselekményekhez vezetett, és hogy az ember legfőbb vágya egy olyan világ eljövetele, amelyben az elnyomástól, valamint a nyomortól megszabadult emberi lények szava és meggyőződése szabad lesz,

Tekintettel annak fontosságára, hogy az emberi jogokat a jog uralma védelmezze, nehogy az ember végső szükségében a zsarnokság és az elnyomás elleni lázadásra kényszerüljön,

Tekintettel arra, hogy igen lényeges a nemzetek közötti baráti kapcsolatok kifejeződésének előmozdítása,

Tekintettel arra, hogy az Alapokmányban az Egyesült Nemzetek népei újból hitet tettek az alapvető emberi jogok, az emberi személyiség méltósága és értéke, a férfiak és nők egyenjogúsága mellett, valamint kinyilvánították azt az elhatározásukat, hogy elősegítik a szociális haladást és nagyobb szabadság mellett jobb életfeltételeket valósítanak meg,

Tekintettel arra, hogy a tagállamok kötelezték magukat arra, hogy az Egyesült Nemzetek Szervezetével együttműködve biztosítják az emberi jogok és alapvető szabadságok általános és tényleges tiszteletbentartását,

Tekintettel arra, hogy a jogok és szabadságok mibenléte tekintetében közös felfogás kialakításának a legnagyobb jelentősége van az említett kötelezettség maradéktalan teljesítésének szempontjából

a közgyűlés kinyilvánítja
az emberi jogok egyetemleges nyilatkozatát

mint azt a közös eszményt, amelynek elérésére minden népnek és minden nemzetnek törekednie kell abból a célból, hogy minden személy és a társadalom minden szerve, állandóan szem előtt tartva a jelen Nyilatkozatot, oktatás és nevelés útján előmozdítsa e jogok és szabadságok tiszteletbentartásának kifejlesztését, valamint azoknak fokozatosan megvalósuló hazai és nemzetközi jogszabályok útján történő általános és tényleges alkalmazását és elismerését mind a tagállamok népei között, mind pedig a joghatóságuk alatt álló területek népei között.

1. cikk
Minden. emberi lény szabadon születik és egyenlő méltósága és joga van. Az emberek, ésszel és lelkiismerettel bírván, egymással szemben testvéri szellemben kell hogy viseltessenek.

2. cikk
Mindenki, bármely megkülönböztetésre, nevezetesen fajra, színre, nemre, nyelvre, vallásra, politikai vagy bármely más véleményre, nemzeti vagy társadalmi eredetre, vagyonra, születésre, vagy bármely más körülményre való tekintet nélkül hivatkozhat a jelen Nyilatkozatban kinyilvánított összes jogokra és szabadságokra.

Ezenfelül nem lehet semmiféle megkülönböztetést tenni annak az országnak, vagy területnek politikai, jogi vagy nemzetközi helyzete alapján sem, amelynek a személy állampolgára, aszerint, hogy az illető ország vagy terület független, gyámság alatt áll, nem autonóm vagy szuverenitása bármely vonatkozásban korlátozott.

3. cikk
Minden személynek joga van az élethez, a szabadsághoz és a személyi biztonsághoz.

4. cikk
Senkit sem lehet rabszolgaságban, vagy szolgaságban tartani, a rabszolgaság és a rabszolgakereskedés minden alakja tilos.

5. cikk
Senkit sem lehet kínvallatásnak, avagy kegyetlen, embertelen vagy lealacsonyító büntetésnek vagy bánásmódnak alávetni.

6. cikk
Mindenkinek joga van ahhoz, hogy jogalanyiságát bárhol elismerjék.

7. cikk
A törvény előtt mindenki egyenlő és minden megkülönböztetés nélkül joga van a törvény egyenlő védelméhez. Mindenkinek joga van egyenlő védelemhez a jelen Nyilatkozatot sértő minden megkülönböztetéssel és minden ilyen megkülönböztetésre irányuló felbujtással szemben.

8. cikk
Minden személynek joga van az alkotmányban vagy a törvényben részére biztosított alapvető jogokat sértő eljárások ellen a hazai bíróságokhoz tényleges jogorvoslatért folyamodni.

9. cikk
Senkit sem lehet önkényesen letartóztatni, őrizetbe venni vagy száműzni.

10. cikk
Minden személynek teljesen egyenlő joga van arra, hogy ügyét független és pártatlan bíróság méltányosan és nyilvánosan tárgyalja, s ez határozzon egyrészt jogai és kőtelezettségei felől, másrészt minden ellene emelt bűnügyi vád megalapozottsága felől.

11. cikk
Minden büntetendő cselekménnyel vádolt személyt ártatlannak kell vélelmezni mindaddig, amíg bűnősségét nyilvánosan lefolytatott perben, a védelméhez szükséges valamennyi biztosíték mellett, törvényesen megállapítják.
Senkit sem szabad elítélni oly cselekményért vagy mulasztásért, amely elkövetése pillanatában a hazai jog vagy a nemzetközi jog szerint nem volt büntetendő cselekmény. Ugyancsak nem szabad súlyosabb büntetést kiszabni, mint amely a büntetendő cselekmény elkövetése pillanatában volt alkalmazható.
12. cikk
Senkinek magánéletébe, családi ügyeibe, lakóhelye megválasztásába vagy levelezésébe nem szabad önkényesen beavatkozni, sem pedig becsületében vagy jó hírnevében megsérteni. Minden személynek joga van az ilyen beavatkozásokkal vagy sértésekkel szemben a törvény védelméhez.

13. cikk
Az államon belül minden személynek joga van szabadon mozogni és lakóhelyét szabadon megválasztani.
Minden személynek joga van minden országot, ideértve saját hazáját is, elhagyni, valamint saját hazájába visszatérni.
14. cikk
Minden személynek joga van az üldözés elől más országban menedéket keresni és a más ország nyújtotta menedéket élvezni.
Erre a jogra nem lehet hivatkozni közönséges bűncselekmény miatti. kellőképpen megalapozott üldözés, sem pedig az Egyesült Nemzetek céljaival és elveivel ellentétes tevékenység esetében.
15. cikk
Minden személynek joga van valamely állampolgársághoz.
Senkit sem lehet sem állampolgárságától, sem állampolgársága megváltoztatásának jogától önkényesen megfosztani.
16. cikk
Mind a férfinak, mind a nőnek a házasságra érett kor elérésétől kezdve joga van fajon, nemzetiségen vagy valláson alapuló korlátozás nélkül házasságot kötni és családot alapítani. A házasság tekintetében a férfinak és a nőnek mind a házasság tartama alatt, mind a házasság felbontása tekintetében egyenlő jogai vannak.
Házasságot csak a jövendő házastársak szabad és teljes beleegyezésével lehet kötni.
A család a társadalom természetes és alapvető alkotó eleme és joga van a társadalom, valamint az állam védelmére.
17. cikk
Minden személynek, mind egyénileg, mind másokkal együttesen joga van a tulajdonhoz.
Senkit sem lehet tulajdonától önkényesen megfosztani.
18. cikk
Minden személynek joga van a gondolat, a lelkiismeret és a vallás szabadságához, ez a jog magában foglalja a vallás és a meggyőződés megváltoztatásának szabadságát, valamint a vallásnak vagy a meggyőződésnek mind egyénileg, mind együttesen, mind a nyilvánosság előtt, mind a magánéletben oktatás, gyakorlás és szertartások végzése útján való kifejezésre juttatásának jogát.

19. cikk
Minden személynek joga van a vélemény és a kifejezés szabadságához, amely magában foglalja azt a jogot, hogy véleménye miatt ne szenvedjen zaklatást és hogy határokra való tekintet nélkül kutathasson, átvihessen és terjeszthessen híreket és eszméket bármilyen kifejezési módon.

20. cikk
Minden személynek joga van békés célú gyülekezési és egyesülési szabadsághoz.
Senkit sem lehet valamely egyesületbe való belépésre kőtelezni.
21. cikk
Minden személynek joga van a hazája közügyeinek igazgatásában akár közvetlenül, akár szabadon választott képviselői útján való részvételhez.
Minden személynek egyenlő feltételek mellett joga van saját hazájában közszolgálati állásokra való alkalmazásához.
A közhatalom tekintélyének alapja a nép akarata; ez az akarat egyenlő szavazati jog és titkos szavazás vagy a szavazás szabadságát ezzel egyenértékűen biztosító eljárás alapján időszakonként tartandó tisztességes választáson kell hogy kifejezésre jusson.
22. cikk
Minden személynek mint a társadalom tagjának joga van a szociális biztonsághoz; minden személynek ugyancsak igénye van arra, hogy -az államok erőfeszítései és a nemzetközi együttműködés eredményeképpen és számot vetve az egyes országok szervezetével és gazdasági erőforrásaival- a méltóságához és személyiségének szabadon való kifejlődéséhez szükséges gazdasági, szociális és kulturális jogait kielégíthesse.

23. cikk
Minden személynek joga van a munkához, a munka szabad megválasztásához, a méltányos és kielégítő munkafeltételekhez és a munkanélküliség elleni védelemhez.
Az egyenlő munkáért mindenkinek, bármilyen megkülönböztetés nélkül egyenlő bérhez van joga.
Mindenkinek, aki dolgozik, olyan méltányos és kielégítő fizetéshez van joga, amely számára és családja számára az emberi méltóságnak megfelelő létet biztosít és amelyet megfelelő esetben a szociális védelem összes egyéb eszközei egészítenek ki.
Minden személynek joga van a pihenéshez, a szabad időhöz, nevezetesen a munka időtartamának ésszerű korlátozásához, valamint az időszakonkénti fizetett szabadsághoz.
24. cikk
Minden személynek joga van a pihenésre és szabadidőre, beleértve a munkaidő ésszerű korlátozását és az időszakos fizetett szabadságot.

25. cikk
Minden személynek joga van saját maga és családja egészségének és jólétének biztosítására alkalmas életszínvonalhoz, nevezetesen élelemhez, ruházathoz, lakáshoz, orvosi gondozáshoz, valamint a szükséges szociális szolgáltatásokhoz, joga van a munkanélküliség, betegség, rokkantság, özvegység, öregség esetére szóló, valamint mindazon más esetekre szóló biztosításhoz, amikor létfenntartási eszközeit akaratától független körülmények miatt elveszíti.
Az anyaság és a gyermekkor különleges segítséghez és támogatáshoz adnak jogot. Minden gyermek, akár házasságból, akár házasságon kívül született, ugyanabban a szociális védelemben részesül.
26. cikk
Minden személynek joga van a neveléshez. A nevelésnek, legalábbis az elemi és alapvető oktatást illetően, ingyenesnek kell lennie. Az elemi oktatás kötelező. A technikai és szakoktatást általánossá kell tenni; a felsőbb tanulmányokra való felvételnek mindenki előtt -érdeméhez képest- egyenlő feltételek mellett nyitva kell állnia.
A nevelésnek az emberi személyiség teljes kibontakoztatására, valamint az emberi jogok és alapvető szabadságok tiszteletbentartásának megerősítésére kell irányulnia. A nevelésnek elő kell segítenie a nemzetek, valamint az összes faji és vallási csoportok közötti megértést, türelmet és barátságot, valamint az Egyesült Nemzetek által a béke fenntartásának érdekében kifejtett tevékenység kifejlődését.
A szülőket elsőbbségi jog illeti meg a gyermekeiknek adandó nevelés megválasztásában.
27. cikk
Minden személynek joga van a közösség kulturális életében való szabad részvételhez, a művészetek élvezéséhez, valamint a tudomány haladásában és az abból származó jótéteményekben való részvételhez.
Mindenkinek joga van minden általa alkotott tudományos, irodalmi és művészeti termékkel kapcsolatos erkölcsi és anyagi érdekeinek védelméhez.
28. cikk
Minden személynek joga van ahhoz, hogy mind a társadalmi, mind a nemzetközi viszonyok tekintetében olyan rendszer uralkodjék, amelyben a jelen Nyilatkozatban kinyilvánított jogok és szabadságok teljes hatállyal érvényesülhessenek.

29. cikk
A személynek kőtelességei vannak a közösséggel szemben, amelynek keretében egyedül lehetséges a személyiség szabad és teljes kifejlődése.
Jogainak gyakorlása és szabadságainak élvezete tekintetében senki sincs alávetve más korlátozásnak, mint amelyet a törvény kizárólag mások jogai és szabadságai elismerésének és tiszteletbentartásának biztosítása érdekében, valamint a demokratikus társadalom erkölcse, közrendje és általános jóléte jogos követelményeinek kielégítése érdekében megállapít.
Ezeket a jogokat és szabadságokat semmi esetre sem lehet az Egyesült Nemzetek céljaival és elveivel ellentétesen gyakorolni.
30. cikk
A jelen Nyilatkozat egyetlen rendelkezése sem értelmezhető úgy, hogy az valamely állam, valamely csoport, vagy valamely egyén részére bármilyen jogot adna arra, hogy az itt kinyilvánított jogok és szabadságok megsemmisítésére irányuló tevékenységet fejtsen ki, vagy ilyen cselekményt elkövessen.

TEXT

is(Text::Guess::Language->guess($text),'hu','is hu');

done_testing;
