/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;
import org.apache.fontbox.afm.FontMetric;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorAFM;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;

public abstract class PDSimpleFont
extends PDFont {
    private final HashMap<Integer, Float> mFontSizes = new HashMap(128);
    private float avgFontWidth = 0.0f;
    private PDFontDescriptor fontDescriptor = null;

    public PDSimpleFont() {
    }

    public PDSimpleFont(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public void drawString(String string, Graphics g, float fontSize, AffineTransform at, float x, float y) throws IOException {
        System.err.println("Not yet implemented:" + this.getClass().getName());
    }

    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        float retval = 0.0f;
        int code = this.getCodeFromArray(c, offset, length);
        FontMetric metric = this.getAFM();
        if (metric != null) {
            Encoding encoding = this.getEncoding();
            COSName characterName = encoding.getName(code);
            retval = metric.getCharacterHeight(characterName.getName());
        } else {
            PDFontDescriptor desc = this.getFontDescriptor();
            if (desc != null) {
                float xHeight = desc.getXHeight();
                float capHeight = desc.getCapHeight();
                retval = xHeight != 0.0f && capHeight != 0.0f ? (xHeight + capHeight) / 2.0f : (xHeight != 0.0f ? xHeight : (capHeight != 0.0f ? capHeight : 0.0f));
                if (retval == 0.0f) {
                    retval = desc.getAscent();
                }
            }
        }
        return retval;
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        int code = this.getCodeFromArray(c, offset, length);
        Float fontWidth = this.mFontSizes.get(code);
        if (fontWidth == null) {
            COSInteger firstChar = (COSInteger)this.font.getDictionaryObject(COSName.FIRST_CHAR);
            COSInteger lastChar = (COSInteger)this.font.getDictionaryObject(COSName.LAST_CHAR);
            if (firstChar != null && lastChar != null) {
                long first = firstChar.intValue();
                long last = lastChar.intValue();
                if ((long)code >= first && (long)code <= last && this.font.getDictionaryObject(COSName.WIDTHS) != null) {
                    COSArray widthArray = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS);
                    COSNumber fontWidthObject = (COSNumber)widthArray.getObject((int)((long)code - first));
                    fontWidth = Float.valueOf(fontWidthObject.floatValue());
                } else {
                    fontWidth = Float.valueOf(this.getFontWidthFromAFMFile(code));
                }
            } else {
                fontWidth = Float.valueOf(this.getFontWidthFromAFMFile(code));
            }
            this.mFontSizes.put(code, fontWidth);
        }
        return fontWidth.floatValue();
    }

    public float getAverageFontWidth() throws IOException {
        float average = 0.0f;
        if (this.avgFontWidth != 0.0f) {
            average = this.avgFontWidth;
        } else {
            float totalWidth = 0.0f;
            float characterCount = 0.0f;
            COSArray widths = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS);
            if (widths != null) {
                for (int i = 0; i < widths.size(); ++i) {
                    COSNumber fontWidth = (COSNumber)widths.getObject(i);
                    if (!(fontWidth.floatValue() > 0.0f)) continue;
                    totalWidth += fontWidth.floatValue();
                    characterCount += 1.0f;
                }
            }
            average = totalWidth > 0.0f ? totalWidth / characterCount : this.getAverageFontWidthFromAFMFile();
            this.avgFontWidth = average;
        }
        return average;
    }

    public PDFontDescriptor getFontDescriptor() throws IOException {
        if (this.fontDescriptor == null) {
            COSDictionary fd = (COSDictionary)this.font.getDictionaryObject(COSName.FONT_DESC);
            if (fd == null) {
                FontMetric afm = this.getAFM();
                if (afm != null) {
                    this.fontDescriptor = new PDFontDescriptorAFM(afm);
                }
            } else {
                this.fontDescriptor = new PDFontDescriptorDictionary(fd);
            }
        }
        return this.fontDescriptor;
    }

    public void setFontDescriptor(PDFontDescriptorDictionary fontDescriptor) {
        COSDictionary dic = null;
        if (fontDescriptor != null) {
            dic = fontDescriptor.getCOSDictionary();
        }
        this.font.setItem(COSName.FONT_DESC, (COSBase)dic);
        this.fontDescriptor = fontDescriptor;
    }

    public PDStream getToUnicode() throws IOException {
        return PDStream.createFromCOS(this.font.getDictionaryObject("ToUnicode"));
    }

    public void setToUnicode(PDStream unicode) {
        this.font.setItem("ToUnicode", (COSObjectable)unicode);
    }

    public PDRectangle getFontBoundingBox() throws IOException {
        return this.getFontDescriptor().getFontBoundingBox();
    }

    protected void writeFont(Graphics2D g2d, AffineTransform at, Font awtFont, float fontSize, float x, float y, String string) {
        if (!at.isIdentity()) {
            try {
                AffineTransform atInv = at.createInverse();
                g2d.setFont(awtFont.deriveFont(fontSize));
                g2d.transform(at);
                Point2D.Float newXy = new Point2D.Float(x, y);
                atInv.transform(new Point2D.Float(x, y), newXy);
                g2d.drawString(string, (float)newXy.getX(), (float)newXy.getY());
                g2d.transform(atInv);
            }
            catch (NoninvertibleTransformException e) {
                System.err.println("Error in " + this.getClass().getName() + ".writeFont:" + e);
            }
        } else {
            g2d.setFont(awtFont.deriveFont(at).deriveFont(fontSize));
            g2d.drawString(string, x, y);
        }
    }
}

