# Generated by default/object.tt
package Paws::Rekognition::ValidationData;
  use Moose;
  has Assets => (is => 'ro', isa => 'ArrayRef[Paws::Rekognition::Asset]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Rekognition::ValidationData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Rekognition::ValidationData object:

  $service_obj->Method(Att1 => { Assets => $value, ..., Assets => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Rekognition::ValidationData object:

  $result = $service_obj->Method(...);
  $result->Att1->Assets

=head1 DESCRIPTION

Contains the Amazon S3 bucket location of the validation data for a
model training job.

The validation data includes error information for individual JSON
lines in the dataset. For more information, see Debugging a Failed
Model Training in the Amazon Rekognition Custom Labels Developer Guide.

You get the C<ValidationData> object for the training dataset
(TrainingDataResult) and the test dataset (TestingDataResult) by
calling DescribeProjectVersions.

The assets array contains a single Asset object. The
GroundTruthManifest field of the Asset object contains the S3 bucket
location of the validation data.

=head1 ATTRIBUTES


=head2 Assets => ArrayRef[L<Paws::Rekognition::Asset>]

The assets that comprise the validation data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Rekognition>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

