#!/usr/bin/perl

use strict;
use FindBin;
use Config;
use inc::Module::Install;

chdir $FindBin::Bin;

name            ('Perl6-Pugs');
version_from    ('lib/Perl6/Pugs.pm');
abstract_from   ('lib/Perl6/Pugs.pm');
author          ('Autrijus Tang <autrijus@autrijus.org>');
license         ('perl');
install_script  ("pugs$Config{_exe}");
build_requires  ('Test::More');

(`ghc --version` =~ /Glasgow/) or die << '.';
*** Cannot find a runnable 'ghc' from path.
*** Please install GHC from http://haskell.org/ghc/.
.

clean_files(glob("src/*.hi"), glob("src/*.o*"), glob("pugs*"), "config.h");

my $has_readline = 1;
$has_readline = 0 if $^O eq 'MSWin32';

if ($^O =~ /darwin/i and not -e "/usr/local/include/readline/readline.h") {
    warn << '.';
*** /usr/local/include/readline/readline.h not found.
*** Readline support disabled.  If you want readling support,
    please install Readline from the URL below and try again:
    http://p4.elixus.org/snap/pugs/macosx-readline-5.0.005.pkg.tar.gz
.
    $has_readline = 0;
}


open IN, '< lib/Perl6/Pugs.pm' or die $!;
open FH, '> config.h' or die $!;

while (<IN>) {
    /version (\S+) .*\breleased (.*)\./ or next;
    print FH << ".";

#ifdef VERSION
#undef VERSION
#endif
#define VERSION "$1"

#ifdef DATE
#undef DATE
#endif
#define DATE "$2"

.
    last;
}

if ($has_readline) {
    print FH "#define READLINE 1\n";
}
else {
    print FH "#undef READLINE\n";
}
close FH;

postamble(<< ".");
pugs$Config{_exe}: @{[glob("src/*.hs")]}
	ghc --make -o pugs -O src/Main.hs -isrc

tags ::
	hasktags -c src
.

WriteAll( sign => 1 );
