use utf8;
package App::Yath::Schema::SQLite::Run;
our $VERSION = '2.000003'; # TRIAL

package
    App::Yath::Schema::Result::Run;

# Created by DBIx::Class::Schema::Loader
# DO NOT MODIFY ANY PART OF THIS FILE

use strict;
use warnings;

use parent 'App::Yath::Schema::ResultBase';
__PACKAGE__->load_components(
  "InflateColumn::DateTime",
  "InflateColumn::Serializer",
  "InflateColumn::Serializer::JSON",
);
__PACKAGE__->table("runs");
__PACKAGE__->add_columns(
  "run_uuid",
  { data_type => "uuid", is_nullable => 0 },
  "run_id",
  { data_type => "integer", is_auto_increment => 1, is_nullable => 0 },
  "user_id",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 0 },
  "project_id",
  { data_type => "integer", is_foreign_key => 1, is_nullable => 0 },
  "log_file_id",
  {
    data_type      => "integer",
    default_value  => \"null",
    is_foreign_key => 1,
    is_nullable    => 1,
  },
  "passed",
  { data_type => "integer", default_value => \"null", is_nullable => 1 },
  "failed",
  { data_type => "integer", default_value => \"null", is_nullable => 1 },
  "to_retry",
  { data_type => "integer", default_value => \"null", is_nullable => 1 },
  "retried",
  { data_type => "integer", default_value => \"null", is_nullable => 1 },
  "concurrency_j",
  { data_type => "integer", default_value => \"null", is_nullable => 1 },
  "concurrency_x",
  { data_type => "integer", default_value => \"null", is_nullable => 1 },
  "added",
  {
    data_type => "datetime",
    default_value => \"now",
    is_nullable => 0,
    size => 6,
  },
  "status",
  { data_type => "text", default_value => "pending", is_nullable => 0 },
  "mode",
  { data_type => "text", default_value => "qvfd", is_nullable => 0 },
  "canon",
  { data_type => "bool", is_nullable => 0 },
  "pinned",
  { data_type => "bool", default_value => \"FALSE", is_nullable => 0 },
  "has_coverage",
  { data_type => "bool", default_value => \"null", is_nullable => 1 },
  "has_resources",
  { data_type => "bool", default_value => \"null", is_nullable => 1 },
  "parameters",
  { data_type => "json", default_value => \"null", is_nullable => 1 },
  "worker_id",
  { data_type => "text", default_value => \"null", is_nullable => 1 },
  "error",
  { data_type => "text", default_value => \"null", is_nullable => 1 },
  "duration",
  {
    data_type => "numeric",
    default_value => \"null",
    is_nullable => 1,
    size => [14, 4],
  },
);
__PACKAGE__->set_primary_key("run_id");
__PACKAGE__->add_unique_constraint("run_uuid_unique", ["run_uuid"]);
__PACKAGE__->has_many(
  "coverage",
  "App::Yath::Schema::Result::Coverage",
  { "foreign.run_id" => "self.run_id" },
  { cascade_copy => 0, cascade_delete => 1 },
);
__PACKAGE__->has_many(
  "jobs",
  "App::Yath::Schema::Result::Job",
  { "foreign.run_id" => "self.run_id" },
  { cascade_copy => 0, cascade_delete => 1 },
);
__PACKAGE__->belongs_to(
  "log_file",
  "App::Yath::Schema::Result::LogFile",
  { log_file_id => "log_file_id" },
  {
    is_deferrable => 0,
    join_type     => "LEFT",
    on_delete     => "SET NULL",
    on_update     => "NO ACTION",
  },
);
__PACKAGE__->belongs_to(
  "project",
  "App::Yath::Schema::Result::Project",
  { project_id => "project_id" },
  { is_deferrable => 0, on_delete => "CASCADE", on_update => "NO ACTION" },
);
__PACKAGE__->has_many(
  "reports",
  "App::Yath::Schema::Result::Reporting",
  { "foreign.run_id" => "self.run_id" },
  { cascade_copy => 0, cascade_delete => 1 },
);
__PACKAGE__->has_many(
  "resources",
  "App::Yath::Schema::Result::Resource",
  { "foreign.run_id" => "self.run_id" },
  { cascade_copy => 0, cascade_delete => 1 },
);
__PACKAGE__->has_many(
  "run_fields",
  "App::Yath::Schema::Result::RunField",
  { "foreign.run_id" => "self.run_id" },
  { cascade_copy => 0, cascade_delete => 1 },
);
__PACKAGE__->has_many(
  "sweeps",
  "App::Yath::Schema::Result::Sweep",
  { "foreign.run_id" => "self.run_id" },
  { cascade_copy => 0, cascade_delete => 1 },
);
__PACKAGE__->belongs_to(
  "user",
  "App::Yath::Schema::Result::User",
  { user_id => "user_id" },
  { is_deferrable => 0, on_delete => "CASCADE", on_update => "NO ACTION" },
);


# Created by DBIx::Class::Schema::Loader v0.07052 @ 2024-08-01 07:24:11
# DO NOT MODIFY ANY PART OF THIS FILE

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Yath::Schema::SQLite::Run - Autogenerated result class for Run in SQLite.

=head1 SEE ALSO

L<App::Yath::Schema::Overlay::Run> - Where methods that are not
auto-generated are defined.

=head1 SOURCE

The source code repository for Test2-Harness can be found at
L<http://github.com/Test-More/Test2-Harness/>.

=head1 MAINTAINERS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 AUTHORS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 COPYRIGHT

Copyright Chad Granum E<lt>exodist7@gmail.comE<gt>.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

See L<http://dev.perl.org/licenses/>

=cut
