use strict;
use warnings;

use HTML::LinkExtor ();
use Test::More tests => 3;

my $HTML = <<HTML;
<head>
<base href="http://www.sn.no/">
</head>
<body>

This is <A HREF="link.html">link</a> and an <img SRC="img.jpg"
alt="Image">.
HTML


# Try the callback interface
my $links = "";
my $p = HTML::LinkExtor->new(sub {
    my($tag, %links) = @_;
    #diag "$tag @{[%links]}";
    $links .= "$tag @{[%links]}\n";
});

$p->parse($HTML); $p->eof;

ok($links =~ m|^base href http://www\.sn\.no/$|m);
ok($links =~ m|^a href link\.html$|m);

# Used to be problems when using the links method on a document with
# no links it it.  This is a test to prove that it works.
$p = new HTML::LinkExtor;
$p->parse("this is a document with no links"); $p->eof;
my @links = $p->links;
is(@links, 0);
