### base class for a message for the (AI) parser

sub new {
  my ($class, $type, $message, $data) = @_;
  
  ### 1. message is e.g. "load", "dither", "select" etc, see HelpSystem.pm
  ### type is the same
  ### 2. contents is a *Carry.pm

  ### NOTE : I do not use a dynamic_cast in perl so there is a type per message
  $self = { message => $message, typestring => $type, contents => ParserAIMessageCarry->new($data), };

  bless $self, $class;
}

sub getTypeString {
  my $self = shift;

  return $self->{typestring};
}

sub getCarry {
  my $self = shift;

  return $self->{contents};
}

1;
