/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.geom.Line2D;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverLineEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverLineEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, EpsGraphics epsGraphics) {
        ULine uLine = (ULine)uShape;
        double d3 = d + uLine.getDX();
        double d4 = d2 + uLine.getDY();
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null) {
            Line2D.Double double_ = uClip.getClippedLine(new Line2D.Double(d, d2, d3, d4));
            if (double_ == null) {
                return;
            }
            d = double_.x1;
            d2 = double_.y1;
            d3 = double_.x2;
            d4 = double_.y2;
        }
        epsGraphics.setStrokeColor(colorMapper.getMappedColor(uParam.getColor()));
        epsGraphics.setStrokeWidth("" + uParam.getStroke().getThickness(), uParam.getStroke().getDashVisible(), uParam.getStroke().getDashSpace());
        epsGraphics.epsLine(d, d2, d3, d4);
    }
}

