# Generated by default/object.tt
package Paws::IoT::AuditMitigationActionsTaskMetadata;
  use Moose;
  has StartTime => (is => 'ro', isa => 'Str', request_name => 'startTime', traits => ['NameInRequest']);
  has TaskId => (is => 'ro', isa => 'Str', request_name => 'taskId', traits => ['NameInRequest']);
  has TaskStatus => (is => 'ro', isa => 'Str', request_name => 'taskStatus', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::AuditMitigationActionsTaskMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::AuditMitigationActionsTaskMetadata object:

  $service_obj->Method(Att1 => { StartTime => $value, ..., TaskStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::AuditMitigationActionsTaskMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->StartTime

=head1 DESCRIPTION

Information about an audit mitigation actions task that is returned by
C<ListAuditMitigationActionsTasks>.

=head1 ATTRIBUTES


=head2 StartTime => Str

The time at which the audit mitigation actions task was started.


=head2 TaskId => Str

The unique identifier for the task.


=head2 TaskStatus => Str

The current state of the audit mitigation actions task.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

