package Sourcecode::Spellchecker;
use strict;
use warnings;
use IO::File;

our $VERSION = 0.02;

# Attribution: This data is primarily from Wikipedia's
# "List of commonly mispelled words" although I have manually
# trimmed it down by removing words that are very unlikely to
# occur in source code.
# See http://en.wikipedia.org/wiki/Wikipedia:Lists_of_common_misspellings
my %spellings = (
    'abbout'              => 'about',
    'aberation'           => 'aberration',
    'abigious'            => 'ambiguous',
    'abilties'            => 'abilities',
    'abilty'              => 'ability',
    'abitrate'            => 'arbitrate',
    'abotu'               => 'about',
    'abov'                => 'above',
    'abreviate'           => 'abbreviate',
    'abreviated'          => 'abbreviated',
    'abreviation'         => 'abbreviation',
    'abritrary'           => 'arbitrary',
    'abscence'            => 'absence',
    'absense'             => 'absence',
    'absolut'             => 'absolute',
    'absolutly'           => 'absolutely',
    'absorbsion'          => 'absorption',
    'absorbtion'          => 'absorption',
    'abudance'            => 'abundance',
    'abundacies'          => 'abundances',
    'abundancies'         => 'abundances',
    'abundunt'            => 'abundant',
    'abutts'              => 'abuts',
    'acadamy'             => 'academy',
    'acadmic'             => 'academic',
    'accademic'           => 'academic',
    'accademy'            => 'academy',
    'acccused'            => 'accused',
    'accelleration'       => 'acceleration',
    'accension'           => 'accession, ascension',
    'acceptence'          => 'acceptance',
    'acceptible'          => 'acceptable',
    'accesing'            => 'accessing',
    'accesnt'             => 'accent',
    'accesories'          => 'accessories',
    'accessable'          => 'accessible',
    'accidant'            => 'accident',
    'accidentaly'         => 'accidentally',
    'accidently'          => 'accidentally',
    'accidentually'       => 'accidentally',
    'acclimitization'     => 'acclimatization',
    'accomadate'          => 'accommodate',
    'accomadated'         => 'accommodated',
    'accomadates'         => 'accommodates',
    'accomadating'        => 'accommodating',
    'accomadation'        => 'accommodation',
    'accomadations'       => 'accommodations',
    'accomdate'           => 'accommodate',
    'accomodate'          => 'accommodate',
    'accomodated'         => 'accommodated',
    'accomodates'         => 'accommodates',
    'accomodating'        => 'accommodating',
    'accomodation'        => 'accommodation',
    'accomodations'       => 'accommodations',
    'accompanyed'         => 'accompanied',
    'accordian'           => 'accordion',
    'accoring'            => 'according',
    'accoustic'           => 'acoustic',
    'accout'              => 'account',
    'accrediation'        => 'accreditation',
    'accredidation'       => 'accreditation',
    'accross'             => 'across',
    'acedemic'            => 'academic',
    'acessable'           => 'accessible',
    'acess'               => 'access',
    'acheive'             => 'achieve',
    'acheived'            => 'achieved',
    'acheivement'         => 'achievement',
    'acheivements'        => 'achievements',
    'acheives'            => 'achieves',
    'acheiving'           => 'achieving',
    'acheivment'          => 'achievement',
    'acheivments'         => 'achievements',
    'achievment'          => 'achievement',
    'achievments'         => 'achievements',
    'achive'              => 'achieve, archive',
    'achived'             => 'achieved, archived',
    'achivement'          => 'achievement',
    'achivements'         => 'achievements',
    'acknowldeged'        => 'acknowledged',
    'acknowledgeing'      => 'acknowledging',
    'ackward'             => 'awkward, backward',
    'acommodate'          => 'accommodate',
    'acomplish'           => 'accomplish',
    'acomplished'         => 'accomplished',
    'acomplishment'       => 'accomplishment',
    'acomplishments'      => 'accomplishments',
    'acording'            => 'according',
    'acordingly'          => 'accordingly',
    'acquaintence'        => 'acquaintance',
    'acquaintences'       => 'acquaintances',
    'acquiantence'        => 'acquaintance',
    'acquiantences'       => 'acquaintances',
    'acquited'            => 'acquitted',
    'activites'           => 'activities',
    'activly'             => 'actively',
    'actualy'             => 'actually',
    'acumulating'         => 'accumulating',
    'acuracy'             => 'accuracy',
    'acused'              => 'accused',
    'acustom'             => 'accustom',
    'acustommed'          => 'accustomed',
    'adavanced'           => 'advanced',
    'adbandon'            => 'abandon',
    'addional'            => 'additional',
    'addionally'          => 'additionally',
    'additinally'         => 'additionally',
    'additionaly'         => 'additionally',
    'additonal'           => 'additional',
    'additonally'         => 'additionally',
    'addmission'          => 'admission',
    'addopt'              => 'adopt',
    'addopted'            => 'adopted',
    'addoptive'           => 'adoptive',
    'addresable'          => 'addressable',
    'addres'              => 'address, adders',
    'addresed'            => 'addressed',
    'addresing'           => 'addressing',
    'addressess'          => 'addresses',
    'addtion'             => 'addition',
    'addtional'           => 'additional',
    'adecuate'            => 'adequate',
    'adequit'             => 'adequate',
    'adhearing'           => 'adhering',
    'adherance'           => 'adherence',
    'admendment'          => 'amendment',
    'admininistrative'    => 'administrative',
    'adminstered'         => 'administered',
    'adminstrate'         => 'administrate',
    'adminstration'       => 'administration',
    'adminstrative'       => 'administrative',
    'adminstrator'        => 'administrator',
    'admissability'       => 'admissibility',
    'admissable'          => 'admissible',
    'admited'             => 'admitted',
    'admitedly'           => 'admittedly',
    'adn'                 => 'and',
    'adolecent'           => 'adolescent',
    'adquire'             => 'acquire',
    'adquired'            => 'acquired',
    'adquires'            => 'acquires',
    'adquiring'           => 'acquiring',
    'adresable'           => 'addressable',
    'adres'               => 'address',
    'adresing'            => 'addressing',
    'adressable'          => 'addressable',
    'adress'              => 'address',
    'adressed'            => 'addressed',
    'adresses'            => 'addresses',
    'adressing'           => 'addressing, dressing',
    'adventrous'          => 'adventurous',
    'advertisment'        => 'advertisement',
    'advertisments'       => 'advertisements',
    'advesary'            => 'adversary',
    'adviced'             => 'advised',
    'aeriel'              => 'aerial',
    'aeriels'             => 'aerials',
    'afecting'            => 'affecting',
    'affilate'            => 'affiliate',
    'affilliate'          => 'affiliate',
    'affort'              => 'afford, effort',
    'aforememtioned'      => 'aforementioned',
    'againnst'            => 'against',
    'agains'              => 'against',
    'agaisnt'             => 'against',
    'aganist'             => 'against',
    'aggaravates'         => 'aggravates',
    'aggreed'             => 'agreed',
    'aggreement'          => 'agreement',
    'aggregious'          => 'egregious',
    'aggresive'           => 'aggressive',
    'agian'               => 'again',
    'agianst'             => 'against',
    'agina'               => 'again, angina',
    'agin'                => 'again',
    'aginst'              => 'against',
    'agravate'            => 'aggravate',
    'agre'                => 'agree',
    'agred'               => 'agreed',
    'agreeement'          => 'agreement',
    'agreemnt'            => 'agreement',
    'agregate'            => 'aggregate',
    'agregates'           => 'aggregates',
    'agreing'             => 'agreeing',
    'agression'           => 'aggression',
    'agressive'           => 'aggressive',
    'agressively'         => 'aggressively',
    'agressor'            => 'aggressor',
    'ahev'                => 'have',
    'ahppen'              => 'happen',
    'ahve'                => 'have',
    'aicraft'             => 'aircraft',
    'aiport'              => 'airport',
    'airbourne'           => 'airborne',
    'aircaft'             => 'aircraft',
    'aircrafts'           => 'aircraft',
    'airporta'            => 'airports',
    'airrcraft'           => 'aircraft',
    'aisian'              => 'asian',
    'albiet'              => 'albeit',
    'albumns'             => 'albums',
    'alchohol'            => 'alcohol',
    'alchoholic'          => 'alcoholic',
    'alchol'              => 'alcohol',
    'alcholic'            => 'alcoholic',
    'alcohal'             => 'alcohol',
    'alcoholical'         => 'alcoholic',
    'aledge'              => 'allege',
    'aledged'             => 'alleged',
    'aledges'             => 'alleges',
    'alege'               => 'allege',
    'aleged'              => 'alleged',
    'alegience'           => 'allegiance',
    'alegorical'          => 'allegorical',
    'algebraical'         => 'algebraic',
    'algorhitms'          => 'algorithms',
    'algorith'            => 'algorithm',
    'algorithmical'       => 'algorithmically',
    'algoritm'            => 'algorithm',
    'algoritms'           => 'algorithms',
    'alientating'         => 'alienating',
    'alledge'             => 'allege',
    'alledged'            => 'alleged',
    'alledgedly'          => 'allegedly',
    'alledges'            => 'alleges',
    'allegedely'          => 'allegedly',
    'allegedy'            => 'allegedly',
    'allegely'            => 'allegedly',
    'allegence'           => 'allegiance',
    'allegience'          => 'allegiance',
    'allign'              => 'align',
    'alligned'            => 'aligned',
    'alliviate'           => 'alleviate',
    'allpication'         => 'application',
    'allready'            => 'already',
    'allthough'           => 'although',
    'alltogether'         => 'altogether',
    'almsot'              => 'almost',
    'alochol'             => 'alcohol',
    'alomst'              => 'almost',
    'alotted'             => 'allotted',
    'alowed'              => 'allowed',
    'alowing'             => 'allowing',
    'alows'               => 'allows',
    'alreayd'             => 'already',
    'alse'                => 'else',
    'alsot'               => 'also',
    'alternitives'        => 'alternatives',
    'altho'               => 'although',
    'althought'           => 'although',
    'altough'             => 'although',
    'alusion'             => 'allusion, illusion',
    'alwasy'              => 'always',
    'alwyas'              => 'always',
    'amalgomated'         => 'amalgamated',
    'amatuer'             => 'amateur',
    'amature'             => 'armature, amateur',
    'ambigious'           => 'ambiguous',
    'amendmant'           => 'amendment',
    'amercia'             => 'America',
    'amke'                => 'make',
    'amking'              => 'making',
    'ammend'              => 'amend',
    'ammended'            => 'amended',
    'ammendment'          => 'amendment',
    'ammendments'         => 'amendments',
    'ammount'             => 'amount',
    'ammused'             => 'amused',
    'amoung'              => 'among',
    'amoungst'            => 'amongst',
    'amout'               => 'amount',
    'amung'               => 'among',
    'amunition'           => 'ammunition',
    'analagous'           => 'analogous',
    'analitic'            => 'analytic',
    'analogeous'          => 'analogous',
    'analysator'          => 'analyzer',
    'anarchim'            => 'anarchism',
    'anarchistm'          => 'anarchism',
    'anbd'                => 'and',
    'ancestory'           => 'ancestry',
    'ancilliary'          => 'ancillary',
    'andd'                => 'and',
    'ang'                 => 'and',
    'anihilation'         => 'annihilation',
    'aniversary'          => 'anniversary',
    'annouced'            => 'announced',
    'annoucement'         => 'announcement',
    'annualy'             => 'annually',
    'annuled'             => 'annulled',
    'anohter'             => 'another',
    'anomolies'           => 'anomalies',
    'anomolous'           => 'anomalous',
    'anomoly'             => 'anomaly',
    'anonimity'           => 'anonymity',
    'anounced'            => 'announced',
    'anouncement'         => 'announcement',
    'ansestors'           => 'ancestors',
    'antartic'            => 'antarctic',
    'anual'               => 'annual',
    'anulled'             => 'annulled',
    'anwsered'            => 'answered',
    'anyhwere'            => 'anywhere',
    'anytying'            => 'anything',
    'aparent'             => 'apparent',
    'aparment'            => 'apartment',
    'apenines'            => 'apennines, Apennines',
    'aplication'          => 'application',
    'aplied'              => 'applied',
    'apolegetics'         => 'apologetics',
    'apon'                => 'upon, apron',
    'apparant'            => 'apparent',
    'apparantly'          => 'apparently',
    'appart'              => 'apart',
    'appartment'          => 'apartment',
    'appartments'         => 'apartments',
    'appealling'          => 'appealing, appalling',
    'appeareance'         => 'appearance',
    'appearence'          => 'appearance',
    'appearences'         => 'appearances',
    'apperance'           => 'appearance',
    'apperances'          => 'appearances',
    'appereance'          => 'appearance',
    'appereances'         => 'appearances',
    'applicaiton'         => 'application',
    'applicaitons'        => 'applications',
    'appologies'          => 'apologies',
    'appology'            => 'apology',
    'apprearance'         => 'appearance',
    'apprieciate'         => 'appreciate',
    'approachs'           => 'approaches',
    'appropiate'          => 'appropriate',
    'appropraite'         => 'appropriate',
    'appropriatly'        => 'appropriately',
    'appropropiate'       => 'appropriate',
    'approproximate'      => 'approximate',
    'approxamately'       => 'approximately',
    'approxiately'        => 'approximately',
    'approximitely'       => 'approximately',
    'aprehensive'         => 'apprehensive',
    'apropriate'          => 'appropriate',
    'aproval'             => 'approval',
    'aproximate'          => 'approximate',
    'aproximately'        => 'approximately',
    'aquaintance'         => 'acquaintance',
    'aquainted'           => 'acquainted',
    'aquiantance'         => 'acquaintance',
    'aquire'              => 'acquire',
    'aquired'             => 'acquired',
    'aquiring'            => 'acquiring',
    'aquisition'          => 'acquisition',
    'aquitted'            => 'acquitted',
    'aranged'             => 'arranged',
    'arangement'          => 'arrangement',
    'arbitarily'          => 'arbitrarily',
    'arbitary'            => 'arbitrary',
    'archetect'           => 'architect',
    'archetects'          => 'architects',
    'archetectural'       => 'architectural',
    'archetecturally'     => 'architecturally',
    'archetecture'        => 'architecture',
    'archiac'             => 'archaic',
    'archictect'          => 'architect',
    'archimedian'         => 'archimedean',
    'architecht'          => 'architect',
    'architechturally'    => 'architecturally',
    'architechture'       => 'architecture',
    'architechtures'      => 'architectures',
    'architectual'        => 'architectural',
    'archtypes'           => 'archetypes',
    'aready'              => 'already',
    'areodynamics'        => 'aerodynamics',
    'argubly'             => 'arguably',
    'arguement'           => 'argument',
    'arguements'          => 'arguments',
    'arised'              => 'arose',
    'aritmetic'           => 'arithmetic',
    'arival'              => 'arrival',
    'armamant'            => 'armament',
    'armistace'           => 'armistice',
    'arogant'             => 'arrogant',
    'arogent'             => 'arrogant',
    'aroud'               => 'around',
    'arraival'            => 'arrival',
    'arrangment'          => 'arrangement',
    'arrangments'         => 'arrangements',
    'arrengement'         => 'arrangement',
    'arrengements'        => 'arrangements',
    'arround'             => 'around',
    'artcile'             => 'article',
    'artical'             => 'article',
    'artice'              => 'article',
    'articel'             => 'article',
    'artifical'           => 'artificial',
    'artifically'         => 'artificially',
    'arund'               => 'around',
    'asign'               => 'assign',
    'aslo'                => 'also',
    'asociated'           => 'associated',
    'asorbed'             => 'absorbed',
    'assemple'            => 'assemble',
    'assertation'         => 'assertion',
    'asside'              => 'aside',
    'assigment'           => 'assignment',
    'assigments'          => 'assignments',
    'assistent'           => 'assistant',
    'assitant'            => 'assistant',
    'assit'               => 'assist',
    'assocation'          => 'association',
    'assoicate'           => 'associate',
    'assoicated'          => 'associated',
    'assoicates'          => 'associates',
    'assosication'        => 'assassination',
    'asssassans'          => 'assassins',
    'assualt'             => 'assault',
    'assualted'           => 'assaulted',
    'assymetrical'        => 'asymmetrical',
    'assymetric'          => 'asymmetric',
    'asteriod'            => 'asteroid',
    'asthetic'            => 'aesthetic',
    'asthetical'          => 'aesthetical',
    'asthetically'        => 'aesthetically',
    'asume'               => 'assume',
    'asuming'             => 'assuming',
    'atain'               => 'attain',
    'atempting'           => 'attempting',
    'atomatically'        => 'automatically',
    'atorney'             => 'attorney',
    'atribute'            => 'attribute',
    'atributed'           => 'attributed',
    'atributes'           => 'attributes',
    'attaindre'           => 'attainder, attained',
    'attemp'              => 'attempt',
    'attemped'            => 'attempted',
    'attemps'             => 'attempts',
    'attemt'              => 'attempt',
    'attemted'            => 'attempted',
    'attemting'           => 'attempting',
    'attemts'             => 'attempts',
    'attendence'          => 'attendance',
    'attendent'           => 'attendant',
    'attendents'          => 'attendants',
    'attened'             => 'attended',
    'attension'           => 'attention',
    'attitide'            => 'attitude',
    'attributred'         => 'attributed',
    'attrocities'         => 'atrocities',
    'attruibutes'         => 'attributes',
    'audeince'            => 'audience',
    'auromated'           => 'automated',
    'austrailia'          => 'Australia',
    'austrailian'         => 'Australian',
    'authentification'    => 'authentication',
    'auther'              => 'author',
    'authobiographic'     => 'autobiographic',
    'authobiography'      => 'autobiography',
    'authorative'         => 'authoritative',
    'authorites'          => 'authorities',
    'authorithy'          => 'authority',
    'authoritiers'        => 'authorities',
    'authoritive'         => 'authoritative',
    'authrorities'        => 'authorities',
    'autochtonous'        => 'autochthonous',
    'autoctonous'         => 'autochthonous',
    'automaticaly'        => 'automatically',
    'automaticly'         => 'automatically',
    'automatize'          => 'automate',
    'automatized'         => 'automated',
    'automatizes'         => 'automates',
    'automibile'          => 'automobile',
    'automonomous'        => 'autonomous',
    'autonymous'          => 'autonomous',
    'autor'               => 'author',
    'autority'            => 'authority',
    'auxilary'            => 'auxiliary',
    'auxillaries'         => 'auxiliaries',
    'auxillary'           => 'auxiliary',
    'auxilliaries'        => 'auxiliaries',
    'auxilliary'          => 'auxiliary',
    'avaiable'            => 'available',
    'availabe'            => 'available',
    'availabled'          => 'available',
    'availablity'         => 'availability',
    'availaible'          => 'available',
    'availale'            => 'available',
    'availavility'        => 'availability',
    'availble'            => 'available',
    'availiable'          => 'available',
    'availible'           => 'available',
    'avalable'            => 'available',
    'avalance'            => 'avalanche',
    'avaliable'           => 'available',
    'avation'             => 'aviation',
    'averageed'           => 'averaged',
    'avilable'            => 'available',
    'awared'              => 'awarded',
    'awya'                => 'away',
    'baceause'            => 'because',
    'backgorund'          => 'background',
    'backgroud'           => 'background',
    'backrounds'          => 'backgrounds',
    'bahavior'            => 'behavior',
    'bakc'                => 'back',
    'baloons'             => 'balloons',
    'banannas'            => 'bananas',
    'bandwith'            => 'bandwidth',
    'bankrupcy'           => 'bankruptcy',
    'banruptcy'           => 'bankruptcy',
    'baout'               => 'about, bout',
    'basicaly'            => 'basically',
    'basicly'             => 'basically',
    'batery'              => 'battery',
    'bcak'                => 'back',
    'beacuse'             => 'because',
    'beatiful'            => 'beautiful',
    'beaurocracy'         => 'bureaucracy',
    'beaurocratic'        => 'bureaucratic',
    'beautyfull'          => 'beautiful',
    'becamae'             => 'became',
    'becames'             => 'becomes, became',
    'becasue'             => 'because',
    'beccause'            => 'because',
    'becomeing'           => 'becoming',
    'becomming'           => 'becoming',
    'becouse'             => 'because',
    'becuase'             => 'because',
    'bedore'              => 'before',
    'beeing'              => 'being',
    'befoer'              => 'before',
    'beggin'              => 'begin, begging',
    'begginer'            => 'beginner',
    'begginers'           => 'beginners',
    'beggining'           => 'beginning',
    'begginings'          => 'beginnings',
    'beggins'             => 'begins',
    'begining'            => 'beginning',
    'beginnig'            => 'beginning',
    'behavour'            => 'behavior, behaviour',
    'beleif'              => 'belief',
    'beleive'             => 'believe',
    'beleived'            => 'believed',
    'beleives'            => 'believes',
    'beleiving'           => 'believing',
    'belive'              => 'believe',
    'belived'             => 'believed, beloved',
    'belives'             => 'believes, beliefs',
    'beneficary'          => 'beneficiary',
    'beng'                => 'being',
    'benificial'          => 'beneficial',
    'benifit'             => 'benefit',
    'benifits'            => 'benefits',
    'bernouilli'          => 'Bernoulli',
    'beteen'              => 'between',
    'betwen'              => 'between',
    'beween'              => 'between',
    'bewteen'             => 'between',
    'bilateraly'          => 'bilaterally',
    'billingualism'       => 'bilingualism',
    'binominal'           => 'binomial',
    'bizzare'             => 'bizarre',
    'blaim'               => 'blame',
    'blaimed'             => 'blamed',
    'blessure'            => 'blessing',
    'boaut'               => 'bout, boat, about',
    'bodydbuilder'        => 'bodybuilder',
    'bombardement'        => 'bombardment',
    'bombarment'          => 'bombardment',
    'bondary'             => 'boundary',
    'borke'               => 'broke',
    'boundry'             => 'boundary',
    'bouyancy'            => 'buoyancy',
    'bouyant'             => 'buoyant',
    'boyant'              => 'buoyant',
    'breakthough'         => 'breakthrough',
    'breakthroughts'      => 'breakthroughs',
    'breif'               => 'brief',
    'breifly'             => 'briefly',
    'brethen'             => 'brethren',
    'briliant'            => 'brilliant',
    'brillant'            => 'brilliant',
    'brimestone'          => 'brimstone',
    'broacasted'          => 'broadcast',
    'broadacasting'       => 'broadcasting',
    'broady'              => 'broadly',
    'buisness'            => 'business',
    'buisnessman'         => 'businessman',
    'buoancy'             => 'buoyancy',
    'buring'              => 'burying, burning, burin, during',
    'burried'             => 'buried',
    'busines'             => 'business',
    'busineses'           => 'business, businesses',
    'busness'             => 'business',
    'bussiness'           => 'business',
    'caculater'           => 'calculator',
    'cacuses'             => 'caucuses',
    'cahracters'          => 'characters',
    'calaber'             => 'caliber',
    'calander'            => 'calendar, calender, colander',
    'calculater'          => 'calculator',
    'calculs'             => 'calculus',
    'calender'            => 'calendar',
    'calenders'           => 'calendars',
    'caligraphy'          => 'calligraphy',
    'caluclate'           => 'calculate',
    'caluclated'          => 'calculated',
    'caluculate'          => 'calculate',
    'caluculated'         => 'calculated',
    'calulate'            => 'calculate',
    'calulated'           => 'calculated',
    'calulater'           => 'calculator',
    'camoflage'           => 'camouflage',
    'campain'             => 'campaign',
    'campains'            => 'campaigns',
    'cancelation'         => 'cancellation',
    'candadate'           => 'candidate',
    'candiate'            => 'candidate',
    'candidiate'          => 'candidate',
    'cannister'           => 'canister',
    'cannisters'          => 'canisters',
    'cannnot'             => 'cannot',
    'cannonical'          => 'canonical',
    'cannotation'         => 'connotation',
    'cannotations'        => 'connotations',
    'caost'               => 'coast',
    'capabilites'         => 'capabilities',
    'capatibilities'      => 'capabilities',
    'caperbility'         => 'capability',
    'capible'             => 'capable',
    'captial'             => 'capital',
    'captued'             => 'captured',
    'capturd'             => 'captured',
    'carachter'           => 'character',
    'caracterized'        => 'characterized',
    'carefull'            => 'careful',
    'careing'             => 'caring',
    'cariage'             => 'carriage',
    'carniverous'         => 'carnivorous',
    'carreer'             => 'career',
    'carrers'             => 'careers',
    'cartdridge'          => 'cartridge',
    'carthographer'       => 'cartographer',
    'casette'             => 'cassette',
    'casue'               => 'cause',
    'casued'              => 'caused',
    'casues'              => 'causes',
    'casuing'             => 'causing',
    'casulaties'          => 'casualties',
    'casulaty'            => 'casualty',
    'catagories'          => 'categories',
    'catagorized'         => 'categorized',
    'catagory'            => 'category',
    'catapillar'          => 'caterpillar',
    'catapillars'         => 'caterpillars',
    'catapiller'          => 'caterpillar',
    'catapillers'         => 'caterpillars',
    'catepillar'          => 'caterpillar',
    'catepillars'         => 'caterpillars',
    'catergorize'         => 'categorize',
    'catergorized'        => 'categorized',
    'caterpilar'          => 'caterpillar',
    'caterpilars'         => 'caterpillars',
    'caterpiller'         => 'caterpillar',
    'caterpillers'        => 'caterpillars',
    'cathlic'             => 'catholic',
    'catholocism'         => 'catholicism',
    'catterpilar'         => 'caterpillar',
    'catterpilars'        => 'caterpillars',
    'catterpillar'        => 'caterpillar',
    'catterpillars'       => 'caterpillars',
    'cattleship'          => 'battleship',
    'causalities'         => 'casualties',
    'ceasar'              => 'Caesar',
    'celcius'             => 'Celsius',
    'cellpading'          => 'cellpadding',
    'cementary'           => 'cemetery',
    'cemetarey'           => 'cemetery',
    'cemetaries'          => 'cemeteries',
    'cemetary'            => 'cemetery',
    'cencus'              => 'census',
    'censur'              => 'censor, censure',
    'cententenial'        => 'centennial',
    'centruies'           => 'centuries',
    'centruy'             => 'century',
    'centuties'           => 'centuries',
    'centuty'             => 'century',
    'ceratin'             => 'certain, keratin',
    'cerimonial'          => 'ceremonial',
    'cerimonies'          => 'ceremonies',
    'cerimonious'         => 'ceremonious',
    'cerimony'            => 'ceremony',
    'ceromony'            => 'ceremony',
    'certainity'          => 'certainty',
    'certian'             => 'certain',
    'cervial'             => 'cervical, servile, serval',
    'chalenging'          => 'challenging',
    'challange'           => 'challenge',
    'challanged'          => 'challenged',
    'challanges'          => 'challenges',
    'challege'            => 'challenge',
    'changable'           => 'changeable',
    'charachter'          => 'character',
    'charachters'         => 'characters',
    'charactersistic'     => 'characteristic',
    'charactor'           => 'character',
    'charactors'          => 'characters',
    'charasmatic'         => 'charismatic',
    'charaterized'        => 'characterized',
    'charcter'            => 'character',
    'chariman'            => 'chairman',
    'charistics'          => 'characteristics',
    'chasr'               => 'chaser, chase',
    'cheif'               => 'chief',
    'cheifs'              => 'chiefs',
    'chemcial'            => 'chemical',
    'chemcially'          => 'chemically',
    'chemestry'           => 'chemistry',
    'chemicaly'           => 'chemically',
    'childbird'           => 'childbirth',
    'childen'             => 'children',
    'childs'              => 'children',
    'chnages'             => 'changes',
    'choosen'             => 'chosen',
    'chracter'            => 'character',
    'chuch'               => 'church',
    'churchs'             => 'churches',
    'circulaton'          => 'circulation',
    'circut'              => 'circuit',
    'ciricuit'            => 'circuit',
    'ciriculum'           => 'curriculum',
    'civillian'           => 'civilian',
    'claer'               => 'clear',
    'claerer'             => 'clearer',
    'claerly'             => 'clearly',
    'claimes'             => 'claims',
    'clas'                => 'class',
    'clasical'            => 'classical',
    'clasically'          => 'classically',
    'clasic'              => 'classic',
    'cleareance'          => 'clearance',
    'clera'               => 'clear, sclera',
    'clincial'            => 'clinical',
    'clinicaly'           => 'clinically',
    'cmo'                 => 'com',
    'cmoputer'            => 'computer',
    'coctail'             => 'cocktail',
    'coform'              => 'conform',
    'cognizent'           => 'cognizant',
    'coincedentally'      => 'coincidentally',
    'colaborations'       => 'collaborations',
    'colateral'           => 'collateral',
    'colelctive'          => 'collective',
    'collaberative'       => 'collaborative',
    'collecton'           => 'collection',
    'collegue'            => 'colleague',
    'collegues'           => 'colleagues',
    'collonade'           => 'colonnade',
    'collonies'           => 'colonies',
    'collony'             => 'colony',
    'collosal'            => 'colossal',
    'colonizators'        => 'colonizers',
    'colorfull'           => 'colorful',
    'comand'              => 'command',
    'comander'            => 'commander, commandeer',
    'comando'             => 'commando',
    'comandos'            => 'commandos',
    'comany'              => 'company',
    'comapany'            => 'company',
    'comback'             => 'comeback',
    'combanations'        => 'combinations',
    'combinatins'         => 'combinations',
    'combusion'           => 'combustion',
    'comdemnation'        => 'condemnation',
    'comemmorates'        => 'commemorates',
    'comemoretion'        => 'commemoration',
    'comision'            => 'commission',
    'comisioned'          => 'commissioned',
    'comisioner'          => 'commissioner',
    'comisioning'         => 'commissioning',
    'comisions'           => 'commissions',
    'comission'           => 'commission',
    'comissioned'         => 'commissioned',
    'comissioner'         => 'commissioner',
    'comissioning'        => 'commissioning',
    'comissions'          => 'commissions',
    'comit'               => 'commit',
    'comited'             => 'committed',
    'comiting'            => 'committing',
    'comitted'            => 'committed',
    'comittee'            => 'committee',
    'comitting'           => 'committing',
    'commandoes'          => 'commandos',
    'commedic'            => 'comedic',
    'commemerative'       => 'commemorative',
    'commemmorate'        => 'commemorate',
    'commemmorating'      => 'commemorating',
    'commerical'          => 'commercial',
    'commerically'        => 'commercially',
    'commericial'         => 'commercial',
    'commericially'       => 'commercially',
    'commerorative'       => 'commemorative',
    'comming'             => 'coming',
    'comminication'       => 'communication',
    'comminucation'       => 'communication',
    'commision'           => 'commission',
    'commisioned'         => 'commissioned',
    'commisioner'         => 'commissioner',
    'commisioning'        => 'commissioning',
    'commisions'          => 'commissions',
    'commited'            => 'committed',
    'commitee'            => 'committee',
    'commiting'           => 'committing',
    'committ'             => 'commit',
    'committe'            => 'committee',
    'committment'         => 'commitment',
    'committments'        => 'commitments',
    'commmemorated'       => 'commemorated',
    'commoditiy'          => 'commodity',
    'commongly'           => 'commonly',
    'commonweath'         => 'commonwealth',
    'commuications'       => 'communications',
    'commuinications'     => 'communications',
    'communciation'       => 'communication',
    'communiation'        => 'communication',
    'communites'          => 'communities',
    'compability'         => 'compatibility',
    'comparision'         => 'comparison',
    'comparisions'        => 'comparisons',
    'comparitive'         => 'comparative',
    'comparitively'       => 'comparatively',
    'compatabilities'     => 'compatibilities',
    'compatability'       => 'compatibility',
    'compatable'          => 'compatible',
    'compatablities'      => 'compatibilities',
    'compatablity'        => 'compatibility',
    'compatiable'         => 'compatible',
    'compatibiliy'        => 'compatibility',
    'compatibilty'        => 'compatibility',
    'compatiblities'      => 'compatibilities',
    'compatiblity'        => 'compatibility',
    'compeitions'         => 'competitions',
    'compensantion'       => 'compensation',
    'competance'          => 'competence',
    'competant'           => 'competent',
    'competative'         => 'competitive',
    'competion'           => 'competition, completion',
    'competitiion'        => 'competition',
    'competive'           => 'competitive',
    'competiveness'       => 'competitiveness',
    'comphrehensive'      => 'comprehensive',
    'compitent'           => 'competent',
    'compleatly'          => 'completely',
    'completedthe'        => 'completed the',
    'completelyl'         => 'completely',
    'completetion'        => 'completion',
    'complient'           => 'compliant',
    'complier'            => 'compiler',
    'componant'           => 'component',
    'comprable'           => 'comparable',
    'compres'             => 'compress',
    'compresion'          => 'compression',
    'comprimise'          => 'compromise',
    'compulsary'          => 'compulsory',
    'compulsery'          => 'compulsory',
    'computarized'        => 'computerized',
    'concensus'           => 'consensus',
    'concider'            => 'consider',
    'concidered'          => 'considered',
    'concidering'         => 'considering',
    'conciders'           => 'considers',
    'concieted'           => 'conceited',
    'concieved'           => 'conceived',
    'concious'            => 'conscious',
    'conciously'          => 'consciously',
    'conciousness'        => 'consciousness',
    'condamned'           => 'condemned',
    'condemmed'           => 'condemned',
    'condidtion'          => 'condition',
    'condidtions'         => 'conditions',
    'conditionsof'        => 'conditions of',
    'conected'            => 'connected',
    'conection'           => 'connection',
    'conesencus'          => 'consensus',
    'confidental'         => 'confidential',
    'confidentally'       => 'confidentially',
    'confids'             => 'confides',
    'configuratoin'       => 'configuration',
    'configureable'       => 'configurable',
    'confortable'         => 'comfortable',
    'congradulations'     => 'congratulations',
    'congresional'        => 'congressional',
    'conived'             => 'connived',
    'conjecutre'          => 'conjecture',
    'conjuction'          => 'conjunction',
    'connectinos'         => 'connections',
    'conotations'         => 'connotations',
    'conquerd'            => 'conquered',
    'conquerer'           => 'conqueror',
    'conquerers'          => 'conquerors',
    'conqured'            => 'conquered',
    'conscent'            => 'consent',
    'consciouness'        => 'consciousness',
    'consdider'           => 'consider',
    'consdidered'         => 'considered',
    'consdiered'          => 'considered',
    'consectutive'        => 'consecutive',
    'consenquently'       => 'consequently',
    'consentrate'         => 'concentrate',
    'consentrated'        => 'concentrated',
    'consentrates'        => 'concentrates',
    'consept'             => 'concept',
    'consequentually'     => 'consequently',
    'consequeseces'       => 'consequences',
    'consern'             => 'concern',
    'conserned'           => 'concerned',
    'conserning'          => 'concerning',
    'conservitive'        => 'conservative',
    'consiciousness'      => 'consciousness',
    'consicousness'       => 'consciousness',
    'considerd'           => 'considered',
    'consideres'          => 'considered',
    'consious'            => 'conscious',
    'consistancy'         => 'consistency',
    'consistant'          => 'consistent',
    'consistantly'        => 'consistently',
    'consituencies'       => 'constituencies',
    'consituency'         => 'constituency',
    'consituted'          => 'constituted',
    'consitutional'       => 'constitutional',
    'consitution'         => 'constitution',
    'consolodate'         => 'consolidate',
    'consolodated'        => 'consolidated',
    'consonent'           => 'consonant',
    'consonents'          => 'consonants',
    'consorcium'          => 'consortium',
    'conspiracys'         => 'conspiracies',
    'conspiriator'        => 'conspirator',
    'constaints'          => 'constraints',
    'constanly'           => 'constantly',
    'constatn'            => 'constant',
    'constinually'        => 'continually',
    'constituant'         => 'constituent',
    'constituants'        => 'constituents',
    'constituional'       => 'constitutional',
    'constituion'         => 'constitution',
    'consttruction'       => 'construction',
    'constuction'         => 'construction',
    'consulant'           => 'consultant',
    'contaiminate'        => 'contaminate',
    'containes'           => 'contains',
    'containts'           => 'contains',
    'contamporaries'      => 'contemporaries',
    'contamporary'        => 'contemporary',
    'contempoary'         => 'contemporary',
    'contemporaneus'      => 'contemporaneous',
    'contempory'          => 'contemporary',
    'contence'            => 'contents',
    'contendor'           => 'contender',
    'contibute'           => 'contribute',
    'contibuted'          => 'contributed',
    'contibutes'          => 'contributes',
    'contigent'           => 'contingent',
    'contined'            => 'continued',
    'continous'           => 'continuous',
    'continously'         => 'continuously',
    'continueing'         => 'continuing',
    'contraints'          => 'constraints',
    'contravercial'       => 'controversial',
    'contraversy'         => 'controversy',
    'contributer'         => 'contributor',
    'contributers'        => 'contributors',
    'contritutions'       => 'contributions',
    'controled'           => 'controlled',
    'controling'          => 'controlling',
    'controll'            => 'control',
    'controlls'           => 'controls',
    'controvercial'       => 'controversial',
    'controvercy'         => 'controversy',
    'controveries'        => 'controversies',
    'controversal'        => 'controversial',
    'controversey'        => 'controversy',
    'controvertial'       => 'controversial',
    'controvery'          => 'controversy',
    'contruction'         => 'construction',
    'contstruction'       => 'construction',
    'conveinent'          => 'convenient',
    'convential'          => 'conventional',
    'convertables'        => 'convertibles',
    'convertion'          => 'conversion',
    'convertor'           => 'converter',
    'conviced'            => 'convinced',
    'convienient'         => 'convenient',
    'convinient'          => 'convenient',
    'coordiantion'        => 'coordination',
    'coorperation'        => 'cooperation, corporation',
    'coorperations'       => 'corporations',
    'copmetitors'         => 'competitors',
    'coputer'             => 'computer',
    'copywrite'           => 'copyright',
    'corected'            => 'corrected',
    'cornmitted'          => 'committed',
    'corosion'            => 'corrosion',
    'corparate'           => 'corporate',
    'corperations'        => 'corporations',
    'correcters'          => 'correctors',
    'correponding'        => 'corresponding',
    'correponds'          => 'corresponds',
    'correposding'        => 'corresponding',
    'correspondant'       => 'correspondent',
    'correspondants'      => 'correspondents',
    'corridoors'          => 'corridors',
    'corrispondant'       => 'correspondent',
    'corrispondants'      => 'correspondents',
    'corrispond'          => 'correspond',
    'corrisponded'        => 'corresponded',
    'corrisponding'       => 'corresponding',
    'corrisponds'         => 'corresponds',
    'costitution'         => 'constitution',
    'coucil'              => 'council',
    'coudl'               => 'could, cloud',
    'councellor'          => 'councillor, counselor, councilor',
    'councellors'         => 'councillors, counselors, councilors',
    'counries'            => 'countries',
    'countains'           => 'contains',
    'countires'           => 'countries',
    'coururier'           => 'courier, couturier',
    'coverted'            => 'converted, covered, coveted',
    'cpoy'                => 'coy, copy',
    'creaeted'            => 'created',
    'critereon'           => 'criterion',
    'criterias'           => 'criteria',
    'criticists'          => 'critics',
    'critising'           => 'criticising, criticizing',
    'critisising'         => 'criticising',
    'critisism'           => 'criticism',
    'critisisms'          => 'criticisms',
    'critisize'           => 'criticise, criticize',
    'critisized'          => 'criticised, criticized',
    'critisizes'          => 'criticises, criticizes',
    'critisizing'         => 'criticising, criticizing',
    'critized'            => 'criticized',
    'critizing'           => 'criticizing',
    'crockodiles'         => 'crocodiles',
    'crowm'               => 'crown',
    'crtical'             => 'critical',
    'crticised'           => 'criticised',
    'crusies'             => 'cruises',
    'cryptocraphic'       => 'cryptographic',
    'crystalisation'      => 'crystallisation',
    'culiminating'        => 'culminating',
    'cumulatative'        => 'cumulative',
    'curch'               => 'church',
    'curcuit'             => 'circuit',
    'curently'            => 'currently',
    'currenly'            => 'currently',
    'curriculem'          => 'curriculum',
    'cxan'                => 'cyan',
    'cyclinder'           => 'cylinder',
    'daed'                => 'dead',
    'dael'                => 'deal, dial, dahl',
    'damenor'             => 'demeanor',
    'dammage'             => 'damage',
    'daugher'             => 'daughter',
    'deafult'             => 'default',
    'deamon'              => 'daemon',
    'debateable'          => 'debatable',
    'decendant'           => 'descendant',
    'decendants'          => 'descendants',
    'decendent'           => 'descendant',
    'decendents'          => 'descendants',
    'decideable'          => 'decidable',
    'decidely'            => 'decidedly',
    'decieved'            => 'deceived',
    'decison'             => 'decision',
    'decomissioned'       => 'decommissioned',
    'decomposit'          => 'decompose',
    'decomposited'        => 'decomposed',
    'decompositing'       => 'decomposing',
    'decomposits'         => 'decomposes',
    'decompres'           => 'decompress',
    'decress'             => 'decrees',
    'decribed'            => 'described',
    'decribe'             => 'describe',
    'decribes'            => 'describes',
    'decribing'           => 'describing',
    'dectect'             => 'detect',
    'defendent'           => 'defendant',
    'defendents'          => 'defendants',
    'deffensively'        => 'defensively',
    'deffined'            => 'defined',
    'deffine'             => 'define',
    'definance'           => 'defiance',
    'definate'            => 'definite',
    'definately'          => 'definitely',
    'definatly'           => 'definitely',
    'definetly'           => 'definitely',
    'definining'          => 'defining',
    'definit'             => 'definite',
    'definitly'           => 'definitely',
    'definiton'           => 'definition',
    'defintion'           => 'definition',
    'degrate'             => 'degrade',
    'delagates'           => 'delegates',
    'delapidated'         => 'dilapidated',
    'delemiter'           => 'delimiter',
    'delevopment'         => 'development',
    'deliberatly'         => 'deliberately',
    'demenor'             => 'demeanor',
    'demographical'       => 'demographic',
    'demolision'          => 'demolition',
    'demorcracy'          => 'democracy',
    'demostration'        => 'demonstration',
    'denegrating'         => 'denigrating',
    'densly'              => 'densely',
    'deparmental'         => 'departmental',
    'deparment'           => 'department',
    'deparments'          => 'departments',
    'dependance'          => 'dependence',
    'dependancies'        => 'dependencies',
    'dependancy'          => 'dependency',
    'dependant'           => 'dependent',
    'deram'               => 'dram, dream',
    'deriviated'          => 'derived',
    'derivitive'          => 'derivative',
    'derogitory'          => 'derogatory',
    'descendands'         => 'descendants',
    'descibed'            => 'described',
    'descision'           => 'decision',
    'descisions'          => 'decisions',
    'descriibes'          => 'describes',
    'descripters'         => 'descriptors',
    'descripton'          => 'description',
    'desctruction'        => 'destruction',
    'descuss'             => 'discuss',
    'desgined'            => 'designed',
    'deside'              => 'decide',
    'desigining'          => 'designing',
    'desinations'         => 'destinations',
    'desintegrated'       => 'disintegrated',
    'desintegration'      => 'disintegration',
    'desireable'          => 'desirable',
    'desitned'            => 'destined',
    'desktiop'            => 'desktop',
    'desorder'            => 'disorder',
    'desoriented'         => 'disoriented',
    'desparate'           => 'desperate, disparate',
    'despict'             => 'depict',
    'despiration'         => 'desperation',
    'dessicated'          => 'desiccated',
    'dessigned'           => 'designed',
    'destablized'         => 'destabilized',
    'destory'             => 'destroy',
    'detabase'            => 'database',
    'detailled'           => 'detailed',
    'detatched'           => 'detached',
    'deteoriated'         => 'deteriorated',
    'deteriate'           => 'deteriorate',
    'deterioriating'      => 'deteriorating',
    'determinining'       => 'determining',
    'detremental'         => 'detrimental',
    'devasted'            => 'devastated',
    'develope'            => 'develop',
    'developement'        => 'development',
    'developped'          => 'developed',
    'develpment'          => 'development',
    'deveolpment'         => 'development',
    'devestated'          => 'devastated',
    'devestating'         => 'devastating',
    'devided'             => 'divided',
    'devide'              => 'divide',
    'devistating'         => 'devastating',
    'devolopement'        => 'development',
    'diablical'           => 'diabolical',
    'diamons'             => 'diamonds',
    'diaster'             => 'disaster',
    'dichtomy'            => 'dichotomy',
    'diconnects'          => 'disconnects',
    'dicover'             => 'discover',
    'dicovered'           => 'discovered',
    'dicovering'          => 'discovering',
    'dicovers'            => 'discovers',
    'dicovery'            => 'discovery',
    'dictionnary'         => 'dictionary',
    'dicussed'            => 'discussed',
    'diferent'            => 'different',
    'diferrent'           => 'different',
    'differentiatiations' => 'differentiations',
    'differnt'            => 'different',
    'difficulity'         => 'difficulty',
    'diffrent'            => 'different',
    'dificulties'         => 'difficulties',
    'dificulty'           => 'difficulty',
    'dimenions'           => 'dimensions',
    'dimentional'         => 'dimensional',
    'dimention'           => 'dimension',
    'dimentions'          => 'dimensions',
    'dimesnional'         => 'dimensional',
    'diminuitive'         => 'diminutive',
    'dimunitive'          => 'diminutive',
    'diplay'              => 'display',
    'diplomancy'          => 'diplomacy',
    'dirived'             => 'derived',
    'disagreeed'          => 'disagreed',
    'disapeared'          => 'disappeared',
    'disapointing'        => 'disappointing',
    'disappearred'        => 'disappeared',
    'disaproval'          => 'disapproval',
    'disasterous'         => 'disastrous',
    'disatisfaction'      => 'dissatisfaction',
    'disatisfied'         => 'dissatisfied',
    'disatrous'           => 'disastrous',
    'discontentment'      => 'discontent',
    'discontiguous'       => 'noncontiguous',
    'discribed'           => 'described',
    'discribe'            => 'describe',
    'discribes'           => 'describes',
    'discribing'          => 'describing',
    'disctinction'        => 'distinction',
    'disctinctive'        => 'distinctive',
    'disemination'        => 'dissemination',
    'disenchanged'        => 'disenchanted',
    'disiplined'          => 'disciplined',
    'disobediance'        => 'disobedience',
    'disobediant'         => 'disobedient',
    'disolved'            => 'dissolved',
    'disover'             => 'discover',
    'dispair'             => 'despair',
    'disparingly'         => 'disparagingly',
    'dispenced'           => 'dispensed',
    'dispence'            => 'dispense',
    'dispencing'          => 'dispensing',
    'dispertion'          => 'dispersion',
    'dispicable'          => 'despicable',
    'dispite'             => 'despite',
    'dispostion'          => 'disposition',
    'disproportiate'      => 'disproportionate',
    'disricts'            => 'districts',
    'dissagreement'       => 'disagreement',
    'dissapearance'       => 'disappearance',
    'dissapear'           => 'disappear',
    'dissapeared'         => 'disappeared',
    'dissapearing'        => 'disappearing',
    'dissapears'          => 'disappears',
    'dissappear'          => 'disappear',
    'dissappears'         => 'disappears',
    'dissappointed'       => 'disappointed',
    'dissarray'           => 'disarray',
    'dissobediance'       => 'disobedience',
    'dissobediant'        => 'disobedient',
    'dissobedience'       => 'disobedience',
    'dissobedient'        => 'disobedient',
    'distiction'          => 'distinction',
    'distingish'          => 'distinguish',
    'distingished'        => 'distinguished',
    'distingishes'        => 'distinguishes',
    'distingishing'       => 'distinguishing',
    'distingquished'      => 'distinguished',
    'distrubution'        => 'distribution',
    'distruction'         => 'destruction',
    'distructive'         => 'destructive',
    'ditributed'          => 'distributed',
    'diversed'            => 'diverse, diverged',
    'divice'              => 'device',
    'divison'             => 'division',
    'divisons'            => 'divisions',
    'doccument'           => 'document',
    'doccumented'         => 'documented',
    'doccuments'          => 'documents',
    'docrines'            => 'doctrines',
    'doctines'            => 'doctrines',
    'docuentation'        => 'documentation',
    'documantation'       => 'documentation',
    'documenatry'         => 'documentary',
    'documentaion'        => 'documentation',
    'doens'               => 'does',
    'doign'               => 'doing',
    'dominaton'           => 'domination',
    'dominent'            => 'dominant',
    'dominiant'           => 'dominant',
    'donig'               => 'doing',
    'dowloads'            => 'downloads',
    'downlad'             => 'download',
    'downlads'            => 'downloads',
    'dramtic'             => 'dramatic',
    'dreasm'              => 'dreams',
    'driectly'            => 'directly',
    'drnik'               => 'drink',
    'druming'             => 'drumming',
    'drummless'           => 'drumless',
    'dum'                 => 'dumb',
    'dupicate'            => 'duplicate',
    'durig'               => 'during',
    'durring'             => 'during',
    'duting'              => 'during',
    'eahc'                => 'each',
    'ealier'              => 'earlier',
    'earlies'             => 'earliest',
    'earnt'               => 'earned',
    'easilly'             => 'easily',
    'ecclectic'           => 'eclectic',
    'eceonomy'            => 'economy',
    'ecidious'            => 'deciduous',
    'eclispe'             => 'eclipse',
    'ecomonic'            => 'economic',
    'ecspecially'         => 'especially',
    'edditable'           => 'editable',
    'editting'            => 'editing',
    'eearly'              => 'early',
    'efel'                => 'evil',
    'effeciency'          => 'efficiency',
    'effecient'           => 'efficient',
    'effeciently'         => 'efficiently',
    'efficency'           => 'efficiency',
    'efficent'            => 'efficient',
    'efficently'          => 'efficiently',
    'efford'              => 'effort, afford',
    'effords'             => 'efforts, affords',
    'effulence'           => 'effluence',
    'eigth'               => 'eighth, eight',
    'eiter'               => 'either',
    'elction'             => 'election',
    'electic'             => 'eclectic, electric',
    'electon'             => 'election, electron',
    'electrial'           => 'electrical',
    'electricly'          => 'electrically',
    'electricty'          => 'electricity',
    'elementay'           => 'elementary',
    'eleminated'          => 'eliminated',
    'eleminating'         => 'eliminating',
    'eletricity'          => 'electricity',
    'eletronic'           => 'electronic',
    'elicided'            => 'elicited',
    'eligable'            => 'eligible',
    'elimentary'          => 'elementary',
    'ellected'            => 'elected',
    'elphant'             => 'elephant',
    'embarassed'          => 'embarrassed',
    'embarass'            => 'embarrass',
    'embarassing'         => 'embarrassing',
    'embarassment'        => 'embarrassment',
    'embargos'            => 'embargoes',
    'embarrased'          => 'embarrassed',
    'embarras'            => 'embarrass',
    'embarrasing'         => 'embarrassing',
    'embarrasment'        => 'embarrassment',
    'emblamatic'          => 'emblematic',
    'eminated'            => 'emanated',
    'eminate'             => 'emanate',
    'emision'             => 'emission',
    'emited'              => 'emitted',
    'emiting'             => 'emitting',
    'emition'             => 'emission, emotion',
    'emmediately'         => 'immediately',
    'emmigrated'          => 'emigrated, immigrated',
    'emminent'            => 'eminent, imminent',
    'emminently'          => 'eminently',
    'emmisaries'          => 'emissaries',
    'emmisarries'         => 'emissaries',
    'emmisarry'           => 'emissary',
    'emmisary'            => 'emissary',
    'emmision'            => 'emission',
    'emmisions'           => 'emissions',
    'emmited'             => 'emitted',
    'emmiting'            => 'emitting',
    'emmitted'            => 'emitted',
    'emmitting'           => 'emitting',
    'emperical'           => 'empirical',
    'emphaised'           => 'emphasised',
    'emphsis'             => 'emphasis',
    'empirial'            => 'empirical, imperial',
    'emprisoned'          => 'imprisoned',
    'enameld'             => 'enameled',
    'enchanced'           => 'enhanced',
    'enchancement'        => 'enhancement',
    'encorporating'       => 'incorporating',
    'encouraing'          => 'encouraging',
    'encryptiion'         => 'encryption',
    'encylopedia'         => 'encyclopedia',
    'endevors'            => 'endeavors',
    'endevour'            => 'endeavour',
    'endianess'           => 'endianness',
    'endig'               => 'ending',
    'endolithes'          => 'endoliths',
    'enduce'              => 'induce',
    'ened'                => 'need',
    'enflamed'            => 'inflamed',
    'enforceing'          => 'enforcing',
    'engagment'           => 'engagement',
    'engeneer'            => 'engineer',
    'engeneering'         => 'engineering',
    'engieneer'           => 'engineer',
    'engieneers'          => 'engineers',
    'enhaced'             => 'enhanced',
    'enlargment'          => 'enlargement',
    'enlargments'         => 'enlargements',
    'enlightnment'        => 'enlightenment',
    'enlish'              => 'English, enlist',
    'enocded'             => 'encoded',
    'enourmous'           => 'enormous',
    'enourmously'         => 'enormously',
    'ensconsed'           => 'ensconced',
    'entaglements'        => 'entanglements',
    'enteratinment'       => 'entertainment',
    'enterily'            => 'entirely',
    'enthusiatic'         => 'enthusiastic',
    'entitity'            => 'entity',
    'entitlied'           => 'entitled',
    'entrepeneur'         => 'entrepreneur',
    'entrepeneurs'        => 'entrepreneurs',
    'enviormental'        => 'environmental',
    'enviormentally'      => 'environmentally',
    'enviorment'          => 'environment',
    'enviorments'         => 'environments',
    'enviornmental'       => 'environmental',
    'enviornmentalist'    => 'environmentalist',
    'enviornmentally'     => 'environmentally',
    'enviornment'         => 'environment',
    'enviornments'        => 'environments',
    'enviroiment'         => 'environment',
    'enviromental'        => 'environmental',
    'enviromentalist'     => 'environmentalist',
    'enviromentally'      => 'environmentally',
    'enviroment'          => 'environment',
    'enviroments'         => 'environments',
    'environement'        => 'environment',
    'environent'          => 'environment',
    'envolutionary'       => 'evolutionary',
    'envrionments'        => 'environments',
    'enxt'                => 'next',
    'epidsodes'           => 'episodes',
    'epsiode'             => 'episode',
    'equialent'           => 'equivalent',
    'equilibium'          => 'equilibrium',
    'equilibrum'          => 'equilibrium',
    'equiped'             => 'equipped',
    'equippment'          => 'equipment',
    'equitorial'          => 'equatorial',
    'equivelant'          => 'equivalent',
    'equivelent'          => 'equivalent',
    'equivilant'          => 'equivalent',
    'equivilent'          => 'equivalent',
    'equivlalent'         => 'equivalent',
    'erally'              => 'orally, really',
    'eratically'          => 'erratically',
    'eratic'              => 'erratic',
    'eraticly'            => 'erratically',
    'erested'             => 'arrested, erected',
    'errupted'            => 'erupted',
    'esential'            => 'essential',
    'esitmated'           => 'estimated',
    'esle'                => 'else',
    'especialy'           => 'especially',
    'essencial'           => 'essential',
    'essense'             => 'essence',
    'essentail'           => 'essential',
    'essentialy'          => 'essentially',
    'essentual'           => 'essential',
    'essesital'           => 'essential',
    'estabishes'          => 'establishes',
    'establising'         => 'establishing',
    'ethnocentricm'       => 'ethnocentrism',
    'ethose'              => 'those, ethos',
    'europian'            => 'European',
    'europians'           => 'Europeans',
    'eurpean'             => 'European',
    'eurpoean'            => 'European',
    'evenhtually'         => 'eventually',
    'eventally'           => 'eventually',
    'eventhough'          => 'even though',
    'eventially'          => 'eventually',
    'eventualy'           => 'eventually',
    'everthing'           => 'everything',
    'everytime'           => 'every time',
    'everyting'           => 'everything',
    'eveyr'               => 'every',
    'evidentally'         => 'evidently',
    'exagerated'          => 'exaggerated',
    'exagerate'           => 'exaggerate',
    'exagerates'          => 'exaggerates',
    'exagerating'         => 'exaggerating',
    'exagerrated'         => 'exaggerated',
    'exagerrate'          => 'exaggerate',
    'exagerrates'         => 'exaggerates',
    'exagerrating'        => 'exaggerating',
    'examinated'          => 'examined',
    'exampt'              => 'exempt',
    'exapansion'          => 'expansion',
    'excact'              => 'exact',
    'excange'             => 'exchange',
    'excecutable'         => 'executable',
    'excecuted'           => 'executed',
    'excecute'            => 'execute',
    'excecutes'           => 'executes',
    'excecuting'          => 'executing',
    'excecution'          => 'execution',
    'excedded'            => 'exceeded',
    'exceded'             => 'exceeded',
    'excelent'            => 'excellent',
    'excellance'          => 'excellence',
    'excellant'           => 'excellent',
    'excell'              => 'excel',
    'excells'             => 'excels',
    'excercise'           => 'exercise',
    'exchanching'         => 'exchanging',
    'excisted'            => 'existed',
    'exculsivly'          => 'exclusively',
    'execising'           => 'exercising',
    'exection'            => 'execution',
    'exectued'            => 'executed',
    'exeedingly'          => 'exceedingly',
    'exelent'             => 'excellent',
    'exellent'            => 'excellent',
    'exemple'             => 'example',
    'exept'               => 'except',
    'exeptional'          => 'exceptional',
    'exerbated'           => 'exacerbated',
    'exerbate'            => 'exacerbate',
    'exerciese'           => 'exercises',
    'exerpt'              => 'excerpt',
    'exerpts'             => 'excerpts',
    'exersize'            => 'exercise',
    'exerternal'          => 'external',
    'exhalted'            => 'exalted',
    'exhibtion'           => 'exhibition',
    'exibition'           => 'exhibition',
    'exibitions'          => 'exhibitions',
    'exicting'            => 'exciting',
    'exinct'              => 'extinct',
    'existance'           => 'existence',
    'existant'            => 'existent',
    'existince'           => 'existence',
    'exlcude'             => 'exclude',
    'exliled'             => 'exiled',
    'exludes'             => 'excludes',
    'exmaple'             => 'example',
    'expalin'             => 'explain',
    'expatriot'           => 'expatriate',
    'expeced'             => 'expected',
    'expecially'          => 'especially',
    'expeditonary'        => 'expeditionary',
    'expeiments'          => 'experiments',
    'expell'              => 'expel',
    'expells'             => 'expels',
    'experianced'         => 'experienced',
    'experiance'          => 'experience',
    'expiditions'         => 'expeditions',
    'expierence'          => 'experience',
    'explaination'        => 'explanation',
    'explaning'           => 'explaining',
    'explicitely'         => 'explicitly',
    'explictly'           => 'explicitly',
    'exploititive'        => 'exploitative',
    'explotation'         => 'exploitation',
    'expresion'           => 'expression',
    'exprimental'         => 'experimental',
    'expropiated'         => 'expropriated',
    'expropiation'        => 'expropriation',
    'exressed'            => 'expressed',
    'extemely'            => 'extremely',
    'extention'           => 'extension',
    'extentions'          => 'extensions',
    'extered'             => 'exerted',
    'extermist'           => 'extremist',
    'extint'              => 'extinct, extant',
    'extradiction'        => 'extradition',
    'extraterrestial'     => 'extraterrestrial',
    'extraterrestials'    => 'extraterrestrials',
    'extravagent'         => 'extravagant',
    'extrememly'          => 'extremely',
    'extremeophile'       => 'extremophile',
    'extremly'            => 'extremely',
    'extrordinarily'      => 'extraordinarily',
    'extrordinary'        => 'extraordinary',
    'eyars'               => 'years, eyas',
    'eyar'                => 'year, eyas',
    'eyasr'               => 'years, eyas',
    'faciliated'          => 'facilitated',
    'faciliate'           => 'facilitate',
    'faciliates'          => 'facilitates',
    'facilites'           => 'facilities',
    'facillitate'         => 'facilitate',
    'facinated'           => 'fascinated',
    'facist'              => 'fascist',
    'failuer'             => 'failure',
    'familar'             => 'familiar',
    'familes'             => 'families',
    'familliar'           => 'familiar',
    'famoust'             => 'famous',
    'fanatism'            => 'fanaticism',
    'farenheit'           => 'Fahrenheit',
    'fatc'                => 'fact',
    'fatser'              => 'faster',
    'faught'              => 'fought',
    'favoutrable'         => 'favourable',
    'feasable'            => 'feasible',
    'febuary'             => 'February',
    'feburary'            => 'February',
    'fedreally'           => 'federally',
    'feromone'            => 'pheromone',
    'fertily'             => 'fertility',
    'fetaures'            => 'features',
    'fianite'             => 'finite',
    'fianlly'             => 'finally',
    'ficticious'          => 'fictitious',
    'fictious'            => 'fictitious',
    'fidn'                => 'find',
    'fiel'                => 'feel, field, file, phial',
    'fiels'               => 'feels, fields, files, phials',
    'fiercly'             => 'fiercely',
    'fightings'           => 'fighting',
    'filiament'           => 'filament',
    'fimilies'            => 'families',
    'finacial'            => 'financial',
    'finaly'              => 'finally',
    'financialy'          => 'financially',
    'firends'             => 'friends',
    'firts'               => 'flirts, first',
    'fisionable'          => 'fissionable',
    'flamable'            => 'flammable',
    'flawess'             => 'flawless',
    'fleed'               => 'fled, freed',
    'florescent'          => 'fluorescent',
    'flourescent'         => 'fluorescent',
    'flourine'            => 'fluorine',
    'flourishment'        => 'flourishing',
    'fluorish'            => 'flourish',
    'follwoing'           => 'following',
    'folowing'            => 'following',
    'fomed'               => 'formed',
    'fomr'                => 'from, form',
    'fonetic'             => 'phonetic',
    'fontrier'            => 'fontier',
    'foootball'           => 'football',
    'forbad'              => 'forbade',
    'forbiden'            => 'forbidden',
    'foreward'            => 'foreword',
    'forfiet'             => 'forfeit',
    'forhead'             => 'forehead',
    'foriegn'             => 'foreign',
    'formallized'         => 'formalized',
    'formallize'          => 'formalize',
    'formaly'             => 'formally, formerly',
    'formelly'            => 'formerly',
    'formidible'          => 'formidable',
    'formost'             => 'foremost',
    'forsaw'              => 'foresaw',
    'forseeable'          => 'foreseeable',
    'forse'               => 'force',
    'fortan'              => 'fortran',
    'fortelling'          => 'foretelling',
    'forunner'            => 'forerunner',
    'forwardig'           => 'forwarding',
    'foucs'               => 'focus',
    'foudn'               => 'found',
    'fougth'              => 'fought',
    'foundaries'          => 'foundries',
    'foundary'            => 'foundry',
    'fourties'            => 'forties',
    'fourty'              => 'forty',
    'fouth'               => 'fourth',
    'foward'              => 'forward',
    'framwork'            => 'framework',
    'freind'              => 'friend',
    'freindly'            => 'friendly',
    'frequentily'         => 'frequently',
    'fromed'              => 'formed',
    'frome'               => 'from',
    'froniter'            => 'frontier',
    'fucntion'            => 'function',
    'fucntioning'         => 'functioning',
    'fuction'             => 'function',
    'fuctions'            => 'functions',
    'fufilled'            => 'fulfilled',
    'fufill'              => 'fulfill',
    'fulfiled'            => 'fulfilled',
    'fullfilled'          => 'fulfilled',
    'fullfill'            => 'fulfill',
    'functionaly'         => 'functionally',
    'functionnality'      => 'functionality',
    'functonality'        => 'functionality',
    'fundametal'          => 'fundamental',
    'fundametals'         => 'fundamentals',
    'funguses'            => 'fungi',
    'funtion'             => 'function',
    'furuther'            => 'further',
    'futher'              => 'further',
    'futhermore'          => 'furthermore',
    'gae'                 => 'game, Gael, gale',
    'galatic'             => 'galactic',
    'gallaxies'           => 'galaxies',
    'galvinized'          => 'galvanized',
    'ganerate'            => 'generate',
    'ganes'               => 'games',
    'garanteed'           => 'guaranteed',
    'garantee'            => 'guarantee',
    'garantees'           => 'guarantees',
    'gauarana'            => 'guaraná',
    'gauranteed'          => 'guaranteed',
    'gaurantee'           => 'guarantee',
    'gaurantees'          => 'guarantees',
    'gaurd'               => 'guard, gourd',
    'gaurenteed'          => 'guaranteed',
    'gaurentee'           => 'guarantee',
    'gaurentees'          => 'guarantees',
    'geneological'        => 'genealogical',
    'geneologies'         => 'genealogies',
    'geneology'           => 'genealogy',
    'generaly'            => 'generally',
    'generatting'         => 'generating',
    'generiously'         => 'generously',
    'geographicial'       => 'geographical',
    'geometrician'        => 'geometer',
    'geometricians'       => 'geometers',
    'gerat'               => 'great',
    'glight'              => 'flight',
    'gnawwed'             => 'gnawed',
    'gogin'               => 'going',
    'goign'               => 'going',
    'gonig'               => 'going',
    'gouvener'            => 'governor',
    'govement'            => 'government',
    'govenment'           => 'government',
    'govenrment'          => 'government',
    'goverance'           => 'governance',
    'govermental'         => 'governmental',
    'goverment'           => 'government',
    'governer'            => 'governor',
    'governmnet'          => 'government',
    'govormental'         => 'governmental',
    'govorment'           => 'government',
    'govornment'          => 'government',
    'gracefull'           => 'graceful',
    'graet'               => 'great',
    'grafitti'            => 'graffiti',
    'grahical'            => 'graphical',
    'grahpical'           => 'graphical',
    'gramatically'        => 'grammatically',
    'grammaticaly'        => 'grammatically',
    'grammer'             => 'grammar',
    'grapic'              => 'graphic',
    'grat'                => 'great',
    'gratuitious'         => 'gratuitous',
    'greatful'            => 'grateful',
    'greatfully'          => 'gratefully',
    'greif'               => 'grief',
    'gridles'             => 'griddles',
    'gropu'               => 'group',
    'grwo'                => 'grow',
    'guage'               => 'gauge',
    'guarenteed'          => 'guaranteed',
    'guarentee'           => 'guarantee',
    'guarentees'          => 'guarantees',
    'guidence'            => 'guidance',
    'gunanine'            => 'guanine',
    'guranteed'           => 'guaranteed',
    'gurantee'            => 'guarantee',
    'gurantees'           => 'guarantees',
    'guttaral'            => 'guttural',
    'gutteral'            => 'guttural',
    'habaeus'             => 'habeas',
    'haev'                => 'have, heave',
    'halarious'           => 'hilarious',
    'halfs'               => 'halves',
    'halp'                => 'help',
    'hapened'             => 'happened',
    'hapen'               => 'happen',
    'hapening'            => 'happening',
    'happended'           => 'happened',
    'happend'             => 'happened',
    'happenned'           => 'happened',
    'harased'             => 'harassed',
    'harases'             => 'harasses',
    'harasment'           => 'harassment',
    'harasments'          => 'harassments',
    'harassement'         => 'harassment',
    'harrased'            => 'harassed',
    'harrases'            => 'harasses',
    'harras'              => 'harass',
    'harrasing'           => 'harassing',
    'harrasment'          => 'harassment',
    'harrasments'         => 'harassments',
    'harrassed'           => 'harassed',
    'harrasses'           => 'harassed',
    'harrassing'          => 'harassing',
    'harrassment'         => 'harassment',
    'harrassments'        => 'harassments',
    'haviest'             => 'heaviest',
    'headquarer'          => 'headquarter',
    'headquatered'        => 'headquartered',
    'headquater'          => 'headquarter',
    'headquaters'         => 'headquarters',
    'healthercare'        => 'healthcare',
    'heared'              => 'heard',
    'heathy'              => 'healthy',
    'heigher'             => 'higher',
    'heirarchically'      => 'hierarchically',
    'heirarchy'           => 'hierarchy',
    'heiroglyphics'       => 'hieroglyphics',
    'helment'             => 'helmet',
    'helpfull'            => 'helpful',
    'helpped'             => 'helped',
    'herad'               => 'heard',
    'heridity'            => 'heredity',
    'heroe'               => 'hero',
    'heros'               => 'heroes',
    'hertiage'            => 'heritage',
    'hertzs'              => 'hertz',
    'hesistant'           => 'hesitant',
    'heterogenous'        => 'heterogeneous',
    'hieght'              => 'height',
    'hierachical'         => 'hierarchical',
    'hierachies'          => 'hierarchies',
    'hierachy'            => 'hierarchy',
    'hierarchie'          => 'hierarchy',
    'hierarcical'         => 'hierarchical',
    'hierarcy'            => 'hierarchy',
    'hieroglph'           => 'hieroglyph',
    'hieroglphs'          => 'hieroglyphs',
    'higer'               => 'higher',
    'higest'              => 'highest',
    'higway'              => 'highway',
    'hillarious'          => 'hilarious',
    'himselv'             => 'himself',
    'hinderance'          => 'hindrance',
    'hinderence'          => 'hindrance',
    'hindrence'           => 'hindrance',
    'hismelf'             => 'himself',
    'historicians'        => 'historians',
    'holf'                => 'hold',
    'holliday'            => 'holiday',
    'homogeneized'        => 'homogenized',
    'homogeneize'         => 'homogenize',
    'honory'              => 'honorary',
    'horrifing'           => 'horrifying',
    'hosited'             => 'hoisted',
    'hospitible'          => 'hospitable',
    'hounour'             => 'honour',
    'housr'               => 'hours, house',
    'howver'              => 'however',
    'hsitorians'          => 'historians',
    'hstory'              => 'history',
    'hten'                => 'then, hen, the',
    'htere'               => 'there, here',
    'htey'                => 'they',
    'htikn'               => 'think',
    'hting'               => 'thing',
    'htink'               => 'think',
    'htis'                => 'this',
    'humer'               => 'humor, humour',
    'humerous'            => 'humorous',
    'huminoid'            => 'humanoid',
    'humoural'            => 'humoral',
    'humurous'            => 'humorous',
    'husban'              => 'husband',
    'hvae'                => 'have',
    'hvaing'              => 'having',
    'hvea'                => 'have, heave',
    'hwihc'               => 'which',
    'hwile'               => 'while',
    'hwole'               => 'whole',
    'hydogen'             => 'hydrogen',
    'hydropile'           => 'hydrophile',
    'hydropilic'          => 'hydrophilic',
    'hydropobe'           => 'hydrophobe',
    'hydropobic'          => 'hydrophobic',
    'hygeine'             => 'hygiene',
    'hypocracy'           => 'hypocrisy',
    'hypocrasy'           => 'hypocrisy',
    'hypocricy'           => 'hypocrisy',
    'hypocrit'            => 'hypocrite',
    'hypocrits'           => 'hypocrites',
    'iconclastic'         => 'iconoclastic',
    'idaeidae'            => 'idea',
    'idaes'               => 'ideas',
    'idealogies'          => 'ideologies',
    'idealogy'            => 'ideology',
    'identicial'          => 'identical',
    'identifers'          => 'identifiers',
    'ideosyncratic'       => 'idiosyncratic',
    'idesa'               => 'ideas, ides',
    'idiosyncracy'        => 'idiosyncrasy',
    'illegimacy'          => 'illegitimacy',
    'illegitmate'         => 'illegitimate',
    'illess'              => 'illness',
    'illiegal'            => 'illegal',
    'illution'            => 'illusion',
    'ilness'              => 'illness',
    'ilogical'            => 'illogical',
    'imagenary'           => 'imaginary',
    'imaginery'           => 'imaginary, imagery',
    'imagin'              => 'imagine',
    'imanent'             => 'eminent, imminent',
    'imcomplete'          => 'incomplete',
    'imediately'          => 'immediately',
    'imense'              => 'immense',
    'imigrant'            => 'emigrant, immigrant',
    'imigrated'           => 'emigrated, immigrated',
    'imigration'          => 'emigration, immigration',
    'iminent'             => 'eminent, imminent, immanent',
    'immeadiately'        => 'immediately',
    'immediatley'         => 'immediately',
    'immediatly'          => 'immediately',
    'immidately'          => 'immediately',
    'immidiately'         => 'immediately',
    'immitated'           => 'imitated',
    'immitate'            => 'imitate',
    'immitating'          => 'imitating',
    'immitator'           => 'imitator',
    'impecabbly'          => 'impeccably',
    'impedence'           => 'impedance',
    'implamenting'        => 'implementing',
    'implemantation'      => 'implementation',
    'implemention'        => 'implementation',
    'implimented'         => 'implemented',
    'impliment'           => 'implement',
    'imploys'             => 'employs',
    'importamt'           => 'important',
    'impressario'         => 'impresario',
    'imprioned'           => 'imprisoned',
    'imprisonned'         => 'imprisoned',
    'improvision'         => 'improvisation',
    'improvments'         => 'improvements',
    'inablility'          => 'inability',
    'inaccessable'        => 'inaccessible',
    'inadiquate'          => 'inadequate',
    'inadquate'           => 'inadequate',
    'inadvertant'         => 'inadvertent',
    'inadvertantly'       => 'inadvertently',
    'inagurated'          => 'inaugurated',
    'inaguration'         => 'inauguration',
    'inappropiate'        => 'inappropriate',
    'inaugures'           => 'inaugurates',
    'inbalanced'          => 'imbalanced',
    'inbalance'           => 'imbalance',
    'inbetween'           => 'between',
    'incarcirated'        => 'incarcerated',
    'incidentially'       => 'incidentally',
    'incidently'          => 'incidentally',
    'inclreased'          => 'increased',
    'includ'              => 'include',
    'includng'            => 'including',
    'incomming'           => 'incoming',
    'incompatabilities'   => 'incompatibilities',
    'incompatability'     => 'incompatibility',
    'incompatable'        => 'incompatible',
    'incompatablities'    => 'incompatibilities',
    'incompatablity'      => 'incompatibility',
    'incompatiblities'    => 'incompatibilities',
    'incompatiblity'      => 'incompatibility',
    'incompetance'        => 'incompetence',
    'incompetant'         => 'incompetent',
    'incomptable'         => 'incompatible',
    'incomptetent'        => 'incompetent',
    'inconsistant'        => 'inconsistent',
    'incoroporated'       => 'incorporated',
    'incorperation'       => 'incorporation',
    'incorportaed'        => 'incorporated',
    'incorprates'         => 'incorporates',
    'incorruptable'       => 'incorruptible',
    'incramentally'       => 'incrementally',
    'increadible'         => 'incredible',
    'incredable'          => 'incredible',
    'inctroduced'         => 'introduced',
    'inctroduce'          => 'introduce',
    'incuding'            => 'including',
    'indefinately'        => 'indefinitely',
    'indefineable'        => 'undefinable',
    'indefinitly'         => 'indefinitely',
    'indendation'         => 'indentation',
    'indended'            => 'intended',
    'indentical'          => 'identical',
    'indepedantly'        => 'independently',
    'indepedence'         => 'independence',
    'independance'        => 'independence',
    'independant'         => 'independent',
    'independantly'       => 'independently',
    'independece'         => 'independence',
    'independendet'       => 'independent',
    'indespensable'       => 'indispensable',
    'indespensible'       => 'indispensable',
    'indictement'         => 'indictment',
    'indipendence'        => 'independence',
    'indipendent'         => 'independent',
    'indipendently'       => 'independently',
    'indispensible'       => 'indispensable',
    'indisputible'        => 'indisputable',
    'indisputibly'        => 'indisputably',
    'indite'              => 'indict',
    'individualy'         => 'individually',
    'indpendent'          => 'independent',
    'indpendently'        => 'independently',
    'indulgue'            => 'indulge',
    'indutrial'           => 'industrial',
    'indviduals'          => 'individuals',
    'inefficienty'        => 'inefficiently',
    'inevatible'          => 'inevitable',
    'inevitible'          => 'inevitable',
    'inevititably'        => 'inevitably',
    'infalability'        => 'infallibility',
    'infallable'          => 'infallible',
    'infectuous'          => 'infectious',
    'infered'             => 'inferred',
    'infilitrated'        => 'infiltrated',
    'infilitrate'         => 'infiltrate',
    'infilitration'       => 'infiltration',
    'infinit'             => 'infinite',
    'inflamation'         => 'inflammation',
    'influencial'         => 'influential',
    'influented'          => 'influenced',
    'infomation'          => 'information',
    'informatiom'         => 'information',
    'informations'        => 'information',
    'informtion'          => 'information',
    'infrantryman'        => 'infantryman',
    'infrigement'         => 'infringement',
    'infromation'         => 'information',
    'ingenius'            => 'ingenious',
    'ingreediants'        => 'ingredients',
    'inhabitans'          => 'inhabitants',
    'inherantly'          => 'inherently',
    'inheritage'          => 'heritage, inheritance',
    'inheritence'         => 'inheritance',
    'inital'              => 'initial',
    'initalize'           => 'initialize',
    'initally'            => 'initially',
    'initation'           => 'initiation',
    'initators'           => 'initiators',
    'initiaitive'         => 'initiative',
    'initializiation'     => 'initialization',
    'inlcuding'           => 'including',
    'inmigrant'           => 'immigrant',
    'inmigrants'          => 'immigrants',
    'inocence'            => 'innocence',
    'inofficial'          => 'unofficial',
    'inot'                => 'into',
    'inpeach'             => 'impeach',
    'inpolite'            => 'impolite',
    'inprisonment'        => 'imprisonment',
    'inproving'           => 'improving',
    'insectiverous'       => 'insectivorous',
    'insensative'         => 'insensitive',
    'inseperable'         => 'inseparable',
    'insistance'          => 'insistence',
    'insitution'          => 'institution',
    'insitutions'         => 'institutions',
    'instade'             => 'instead',
    'instatance'          => 'instance',
    'institue'            => 'institute',
    'instuction'          => 'instruction',
    'instuments'          => 'instruments',
    'instutionalized'     => 'institutionalized',
    'instutions'          => 'intuitions',
    'insurence'           => 'insurance',
    'integreated'         => 'integrated',
    'integrety'           => 'integrity',
    'integrey'            => 'integrity',
    'intelectual'         => 'intellectual',
    'inteligence'         => 'intelligence',
    'inteligent'          => 'intelligent',
    'intenational'        => 'international',
    'intendet'            => 'intended',
    'intented'            => 'intended, indented',
    'intepretation'       => 'interpretation',
    'intepretator'        => 'interpretor',
    'interational'        => 'international',
    'interbread'          => 'interbreed, interbred',
    'interchangable'      => 'interchangeable',
    'interchangably'      => 'interchangeably',
    'intercontinetal'     => 'intercontinental',
    'intered'             => 'interred, interned',
    'interelated'         => 'interrelated',
    'interferance'        => 'interference',
    'interfereing'        => 'interfering',
    'intergrated'         => 'integrated',
    'intergration'        => 'integration',
    'interm'              => 'interim',
    'intermittant'        => 'intermittent',
    'internation'         => 'international',
    'interpet'            => 'interpret',
    'interrim'            => 'interim',
    'interrugum'          => 'interregnum',
    'intertaining'        => 'entertaining',
    'interupted'          => 'interrupted',
    'interupt'            => 'interrupt',
    'intervines'          => 'intervenes',
    'intevene'            => 'intervene',
    'intial'              => 'initial',
    'intially'            => 'initially',
    'intrduced'           => 'introduced',
    'intrest'             => 'interest',
    'introdued'           => 'introduced',
    'intruduced'          => 'introduced',
    'intrumental'         => 'instrumental',
    'intrument'           => 'instrument',
    'intruments'          => 'instruments',
    'intrusted'           => 'entrusted',
    'intutive'            => 'intuitive',
    'intutively'          => 'intuitively',
    'inudstry'            => 'industry',
    'inumerable'          => 'enumerable, innumerable',
    'inventer'            => 'inventor',
    'invertibrates'       => 'invertebrates',
    'investingate'        => 'investigate',
    'involvment'          => 'involvement',
    'irelevent'           => 'irrelevant',
    'iresistable'         => 'irresistible',
    'iresistably'         => 'irresistibly',
    'iresistible'         => 'irresistible',
    'iresistibly'         => 'irresistibly',
    'iritable'            => 'irritable',
    'iritated'            => 'irritated',
    'ironicly'            => 'ironically',
    'irregardless'        => 'regardless',
    'irrelevent'          => 'irrelevant',
    'irreplacable'        => 'irreplaceable',
    'irresistable'        => 'irresistible',
    'irresistably'        => 'irresistibly',
    'issueing'            => 'issuing',
    'itnroduced'          => 'introduced',
    'iunior'              => 'junior',
    'iwll'                => 'will',
    'iwth'                => 'with',
    'janurary'            => 'January',
    'januray'             => 'January',
    'japanes'             => 'Japanese',
    'jaques'              => 'jacques',
    'jave'                => 'java',
    'jeapardy'            => 'jeopardy',
    'jewllery'            => 'jewellery',
    'jorunal'             => 'journal',
    'jouney'              => 'journey',
    'journied'            => 'journeyed',
    'journies'            => 'journeys',
    'jstu'                => 'just',
    'jsut'                => 'just',
    'judical'             => 'judicial',
    'judisuary'           => 'judiciary',
    'juducial'            => 'judicial',
    'juristiction'        => 'jurisdiction',
    'juristictions'       => 'jurisdictions',
    'kindergarden'        => 'kindergarten',
    'klenex'              => 'kleenex',
    'knifes'              => 'knives',
    'knive'               => 'knife',
    'knowlegeable'        => 'knowledgeable',
    'knowlege'            => 'knowledge',
    'knwo'                => 'know',
    'knwos'               => 'knows',
    'konw'                => 'know',
    'konws'               => 'knows',
    'kwno'                => 'know',
    'labatory'            => 'lavatory, laboratory',
    'labled'              => 'labelled, labeled',
    'labratory'           => 'laboratory',
    'laguage'             => 'language',
    'laguages'            => 'languages',
    'langage'             => 'language',
    'langauage'           => 'language',
    'langugage'           => 'language',
    'larg'                => 'large',
    'largst'              => 'largest',
    'larrry'              => 'larry',
    'lastr'               => 'last',
    'lattitude'           => 'latitude',
    'lauch'               => 'launch',
    'launchs'             => 'launch, launches',
    'launhed'             => 'launched',
    'lavae'               => 'larvae',
    'layed'               => 'laid',
    'lazyness'            => 'laziness',
    'leage'               => 'league',
    'leanr'               => 'lean, learn, leaner',
    'leathal'             => 'lethal',
    'lefted'              => 'left',
    'legitamate'          => 'legitimate',
    'legitmate'           => 'legitimate',
    'leibnitz'            => 'leibniz',
    'lenght'              => 'length',
    'leran'               => 'learn',
    'lerans'              => 'learns',
    'lesstiff'            => 'lesstif',
    'levetated'           => 'levitated',
    'levetate'            => 'levitate',
    'levetates'           => 'levitates',
    'levetating'          => 'levitating',
    'levle'               => 'level',
    'liasion'             => 'liaison',
    'liason'              => 'liaison',
    'liasons'             => 'liaisons',
    'libaries'            => 'libraries',
    'libary'              => 'library',
    'libell'              => 'libel',
    'libguistic'          => 'linguistic',
    'libguistics'         => 'linguistics',
    'lible'               => 'libel, liable',
    'libraris'            => 'libraries',
    'licenceing'          => 'licencing',
    'lieing'              => 'lying',
    'liekd'               => 'liked',
    'liek'                => 'like',
    'liesure'             => 'leisure',
    'lieuenant'           => 'lieutenant',
    'lieved'              => 'lived',
    'liftime'             => 'lifetime',
    'likelyhood'          => 'likelihood',
    'liquify'             => 'liquefy',
    'liscense'            => 'license, licence',
    'lisence'             => 'license, licence',
    'lisense'             => 'license, licence',
    'listners'            => 'listeners',
    'litature'            => 'literature',
    'literaly'            => 'literally',
    'literture'           => 'literature',
    'littel'              => 'little',
    'litterally'          => 'literally',
    'liuke'               => 'like',
    'livley'              => 'lively',
    'lmits'               => 'limits',
    'loev'                => 'love',
    'loggging'            => 'logging',
    'loggin'              => 'login',
    'logile'              => 'logfile',
    'lonelyness'          => 'loneliness',
    'longitudonal'        => 'longitudinal',
    'lonley'              => 'lonely',
    'lonly'               => 'lonely, only',
    'loosing'             => 'losing',
    'lotharingen'         => 'lothringen',
    'lsat'                => 'last',
    'lukid'               => 'likud',
    'lveo'                => 'love',
    'lvoe'                => 'love',
    'machinary'           => 'machinery',
    'maching'             => 'machine, marching, matching',
    'mackeral'            => 'mackerel',
    'magasine'            => 'magazine',
    'magincian'           => 'magician',
    'magnificient'        => 'magnificent',
    'mailny'              => 'mainly',
    'maintainance'        => 'maintenance',
    'maintainence'        => 'maintenance',
    'maintance'           => 'maintenance',
    'maintenence'         => 'maintenance',
    'maintinaing'         => 'maintaining',
    'maintioned'          => 'mentioned',
    'majoroty'            => 'majority',
    'maked'               => 'marked, made',
    'makeing'             => 'making',
    'makse'               => 'makes',
    'mamalian'            => 'mammalian',
    'mamal'               => 'mammal',
    'managable'           => 'manageable',
    'managment'           => 'management',
    'maneouvred'          => 'manoeuvred',
    'maneouvre'           => 'manoeuvre',
    'maneouvres'          => 'manoeuvres',
    'maneouvring'         => 'manoeuvring',
    'manisfestations'     => 'manifestations',
    'manoeuverability'    => 'maneuverability',
    'manoeuvering'        => 'maneuvering',
    'manouverability'   => 'maneuverability, manoeuvrability, manoeuverability',
    'manouverable'      => 'maneuverable, manoeuvrable',
    'manouver'          => 'maneuver, manoeuvre',
    'manouvers'         => 'maneuvers, manoeuvres',
    'mantained'         => 'maintained',
    'manuever'          => 'maneuver, manoeuvre',
    'manuevers'         => 'maneuvers, manoeuvres',
    'manufacturedd'     => 'manufactured',
    'manufatured'       => 'manufactured',
    'manufature'        => 'manufacture',
    'manufaturing'      => 'manufacturing',
    'manuver'           => 'maneuver',
    'mariage'           => 'marriage',
    'marjority'         => 'majority',
    'markes'            => 'marks',
    'marketting'        => 'marketing',
    'marrage'           => 'marriage',
    'marraige'          => 'marriage',
    'marryied'          => 'married',
    'masterbation'      => 'masturbation',
    'mataphysical'      => 'metaphysical',
    'materalists'       => 'materialist',
    'mathamatics'       => 'mathematics',
    'mathematican'      => 'mathematician',
    'mathematicas'      => 'mathematics',
    'matheticians'      => 'mathematicians',
    'mathimatical'      => 'mathematical',
    'mathimatic'        => 'mathematic',
    'mathimatics'       => 'mathematics',
    'mathmatically'     => 'mathematically',
    'mathmatician'      => 'mathematician',
    'mathmaticians'     => 'mathematicians',
    'mchanics'          => 'mechanics',
    'meaninng'          => 'meaning',
    'mear'              => 'wear, mere',
    'mechandise'        => 'merchandise',
    'medacine'          => 'medicine',
    'medeival'          => 'medieval',
    'medevial'          => 'medieval',
    'mediciney'         => 'mediciny',
    'medievel'          => 'medieval',
    'memeber'           => 'member',
    'menally'           => 'mentally',
    'ment'              => 'meant',
    'messanger'         => 'messenger',
    'messenging'        => 'messaging',
    'messsages'         => 'messages',
    'metalic'           => 'metallic',
    'metalurgical'      => 'metallurgical',
    'metalurgic'        => 'metallurgic',
    'metalurgy'         => 'metallurgy',
    'metamorphysis'     => 'metamorphosis',
    'metaphoricial'     => 'metaphorical',
    'meterologist'      => 'meteorologist',
    'meterology'        => 'meteorology',
    'methaphor'         => 'metaphor',
    'methaphors'        => 'metaphors',
    'micoscopy'         => 'microscopy',
    'microprocesspr'    => 'microprocessor',
    'milennia'          => 'millennia',
    'milennium'         => 'millennium',
    'miliary'           => 'military',
    'milion'            => 'million',
    'miliraty'          => 'military',
    'millenialism'      => 'millennialism',
    'millenial'         => 'millennial',
    'millenia'          => 'millennia',
    'millenium'         => 'millennium',
    'millepede'         => 'millipede',
    'millioniare'       => 'millionaire',
    'milliseonds'       => 'milliseconds',
    'millitary'         => 'military',
    'millon'            => 'million',
    'miltary'           => 'military',
    'minature'          => 'miniature',
    'minerial'          => 'mineral',
    'miniscule'         => 'minuscule',
    'ministery'         => 'ministry',
    'minstries'         => 'ministries',
    'minstry'           => 'ministry',
    'minumum'           => 'minimum',
    'mirrorred'         => 'mirrored',
    'miscelaneous'      => 'miscellaneous',
    'miscellanious'     => 'miscellaneous',
    'miscellanous'      => 'miscellaneous',
    'miscelleneous'     => 'miscellaneous',
    'mischeivous'       => 'mischievous',
    'mischevious'       => 'mischievous',
    'mischievious'      => 'mischievous',
    'misdameanor'       => 'misdemeanor',
    'misdameanors'      => 'misdemeanors',
    'misdemenor'        => 'misdemeanor',
    'misdemenors'       => 'misdemeanors',
    'misformed'         => 'malformed',
    'misfourtunes'      => 'misfortunes',
    'misile'            => 'missile',
    'mispelled'         => 'misspelled',
    'mispelling'        => 'misspelling',
    'mispell'           => 'misspell',
    'missle'            => 'missile',
    'missonary'         => 'missionary',
    'misterious'        => 'mysterious',
    'mistery'           => 'mystery',
    'misteryous'        => 'mysterious',
    'mkae'              => 'make',
    'mkaes'             => 'makes',
    'mkaing'            => 'making',
    'mkea'              => 'make',
    'mmnemonic'         => 'mnemonic',
    'moderm'            => 'modem',
    'modle'             => 'model',
    'modulues'          => 'modules',
    'moent'             => 'moment',
    'moeny'             => 'money',
    'moil'              => 'soil',
    'moleclues'         => 'molecules',
    'momento'           => 'memento',
    'monestaries'       => 'monasteries',
    'monestary'         => 'monastery, monetary',
    'monickers'         => 'monikers',
    'monochorome'       => 'monochrome',
    'monochromo'        => 'monochrome',
    'monocrome'         => 'monochrome',
    'monolite'          => 'monolithic',
    'montains'          => 'mountains',
    'montanous'         => 'mountainous',
    'monts'             => 'months',
    'montypic'          => 'monotypic',
    'morgage'           => 'mortgage',
    'mortage'           => 'mortgage',
    'mosture'           => 'moisture',
    'motiviated'        => 'motivated',
    'mounth'            => 'month',
    'movei'             => 'movie',
    'movment'           => 'movement',
    'mroe'              => 'more',
    'mucuous'           => 'mucous',
    'mudering'          => 'murdering',
    'muder'             => 'murder',
    'mulitplied'        => 'multiplied',
    'multicultralism'   => 'multiculturalism',
    'multidimensionnal' => 'multidimensional',
    'multipled'         => 'multiplied',
    'multiplers'        => 'multipliers',
    'munbers'           => 'numbers',
    'muncipalities'     => 'municipalities',
    'muncipality'       => 'municipality',
    'munnicipality'     => 'municipality',
    'muscels'           => 'mussels, muscles',
    'muscial'           => 'musical',
    'muscician'         => 'musician',
    'muscicians'        => 'musicians',
    'mutiliated'        => 'mutilated',
    'mutiple'           => 'multiple',
    'myraid'            => 'myriad',
    'mysef'             => 'myself',
    'mysterous'         => 'mysterious',
    'naieve'            => 'naive',
    'nam'               => 'name',
    'nams'              => 'names',
    'naturaly'          => 'naturally',
    'naturely'          => 'naturally',
    'naturually'        => 'naturally',
    'naturual'          => 'natural',
    'navagating'        => 'navigating',
    'nead'              => 'need',
    'neccesarily'       => 'necessarily',
    'neccesary'         => 'necessary',
    'neccessarily'      => 'necessarily',
    'neccessary'        => 'necessary',
    'neccessities'      => 'necessities',
    'necesarily'        => 'necessarily',
    'necesary'          => 'necessary',
    'necessiate'        => 'necessitate',
    'neglible'          => 'negligible',
    'negligable'        => 'negligible',
    'negociate'         => 'negotiate',
    'negociation'       => 'negotiation',
    'negociations'      => 'negotiations',
    'negotation'        => 'negotiation',
    'neice'             => 'niece, nice',
    'neigborhood'       => 'neighborhood',
    'neigbourhood'      => 'neighbourhood',
    'neigbouring'       => 'neighbouring, neighboring',
    'neigbour'          => 'neighbour, neighbor',
    'neigbours'         => 'neighbours, neighbors',
    'nescessary'        => 'necessary',
    'nessasarily'       => 'necessarily',
    'nessecary'         => 'necessary',
    'nessessary'        => 'necessary',
    'nestin'            => 'nesting',
    'neverthless'       => 'nevertheless',
    'newletters'        => 'newsletters',
    'nickle'            => 'nickel',
    'nightfa;;'         => 'nightfall',
    'nightime'          => 'nighttime',
    'nineth'            => 'ninth',
    'ninteenth'         => 'nineteenth',
    'ninty'             => 'ninety',
    'nkow'              => 'know',
    'nkwo'              => 'know',
    'nmae'              => 'name',
    'nonsence'          => 'nonsense',
    'nontheless'        => 'nonetheless',
    'norhern'           => 'northern',
    'northen'           => 'northern',
    'northereastern'    => 'northeastern',
    'notabley'          => 'notably',
    'noteable'          => 'notable',
    'noteably'          => 'notably',
    'noteriety'         => 'notoriety',
    'nothern'           => 'northern',
    'noth'              => 'north',
    'noticable'         => 'noticeable',
    'noticably'         => 'noticeably',
    'notications'       => 'notifications',
    'noticeing'         => 'noticing',
    'noticible'         => 'noticeable',
    'notwhithstanding'  => 'notwithstanding',
    'noveau'            => 'nouveau',
    'novermber'         => 'November',
    'nowdays'           => 'nowadays',
    'nowe'              => 'now',
    'nto'               => 'not',
    'nucular'           => 'nuclear',
    'nuculear'          => 'nuclear',
    'nuisanse'          => 'nuisance',
    'numberous'         => 'numerous',
    'nusance'           => 'nuisance',
    'nutritent'         => 'nutrient',
    'nutritents'        => 'nutrients',
    'nuturing'          => 'nurturing',
    'obediance'         => 'obedience',
    'obediant'          => 'obedient',
    'obession'          => 'obsession',
    'obssessed'         => 'obsessed',
    'obstacal'          => 'obstacle',
    'obstancles'        => 'obstacles',
    'obstruced'         => 'obstructed',
    'ocasionally'       => 'occasionally',
    'ocasional'         => 'occasional',
    'ocasionaly'        => 'occasionally',
    'ocasioned'         => 'occasioned',
    'ocasion'           => 'occasion',
    'ocasions'          => 'occasions',
    'ocassionally'      => 'occasionally',
    'ocassional'        => 'occasional',
    'ocassionaly'       => 'occasionally',
    'ocassioned'        => 'occasioned',
    'ocassion'          => 'occasion',
    'ocassions'         => 'occasions',
    'occaison'          => 'occasion',
    'occassionally'     => 'occasionally',
    'occassional'       => 'occasional',
    'occassionaly'      => 'occasionally',
    'occassioned'       => 'occasioned',
    'occassion'         => 'occasion',
    'occassions'        => 'occasions',
    'occationally'      => 'occasionally',
    'occour'            => 'occur',
    'occurance'         => 'occurrence',
    'occurances'        => 'occurrences',
    'occured'           => 'occurred',
    'occurence'         => 'occurrence',
    'occurences'        => 'occurrences',
    'occuring'          => 'occurring',
    'occurrance'        => 'occurrence',
    'occurrances'       => 'occurrences',
    'occurr'            => 'occur',
    'octohedral'        => 'octahedral',
    'octohedra'         => 'octahedra',
    'octohedron'        => 'octahedron',
    'ocuntries'         => 'countries',
    'ocuntry'           => 'country',
    'ocurrance'         => 'occurrence',
    'ocurred'           => 'occurred',
    'ocurrence'         => 'occurrence',
    'ocurr'             => 'occur',
    'offcers'           => 'officers',
    'offcially'         => 'officially',
    'offereings'        => 'offerings',
    'offically'         => 'officially',
    'offical'           => 'official',
    'officals'          => 'officials',
    'officaly'          => 'officially',
    'officialy'         => 'officially',
    'offred'            => 'offered',
    'oftenly'           => 'often',
    'oging'             => 'going, ogling',
    'omision'           => 'omission',
    'omited'            => 'omitted',
    'omiting'           => 'omitting',
    'omitt'             => 'omit',
    'omlette'           => 'omelette',
    'ommision'          => 'omission',
    'ommited'           => 'omitted',
    'ommiting'          => 'omitting',
    'ommitted'          => 'omitted',
    'ommitting'         => 'omitting',
    'omre'              => 'more',
    'onyl'              => 'only',
    'openess'           => 'openness',
    'oponent'           => 'opponent',
    'oportunity'        => 'opportunity',
    'opose'             => 'oppose',
    'oposite'           => 'opposite',
    'oposition'         => 'opposition',
    'oppenly'           => 'openly',
    'oppinion'          => 'opinion',
    'opponant'          => 'opponent',
    'oppononent'        => 'opponent',
    'oppositition'      => 'opposition',
    'oppossed'          => 'opposed',
    'opprotunity'       => 'opportunity',
    'opression'         => 'oppression',
    'opressive'         => 'oppressive',
    'optionnal'         => 'optional',
    'optmizations'      => 'optimizations',
    'optomism'          => 'optimism',
    'orded'             => 'ordered',
    'organim'           => 'organism',
    'organistion'       => 'organisation',
    'organiztion'       => 'organization',
    'orginally'         => 'originally',
    'orginal'           => 'original',
    'orginize'          => 'organise',
    'orgin'             => 'origin, organ',
    'oridinarily'       => 'ordinarily',
    'orientatied'       => 'orientated',
    'orientied'         => 'oriented',
    'origanaly'         => 'originally',
    'originall'         => 'original, originally',
    'originaly'         => 'originally',
    'originially'       => 'originally',
    'originnally'       => 'originally',
    'origional'         => 'original',
    'orignally'         => 'originally',
    'orignially'        => 'originally',
    'otehr'             => 'other',
    'oublisher'         => 'publisher',
    'oustanding'        => 'outstanding',
    'overaall'          => 'overall',
    'overriden'         => 'overridden',
    'overshaddowed'     => 'overshadowed',
    'overthere'         => 'over there',
    'overwelming'       => 'overwhelming',
    'overwheliming'     => 'overwhelming',
    'owrk'              => 'work',
    'owudl'             => 'would',
    'oxigen'            => 'oxygen',
    'oximoron'          => 'oxymoron',
    'pacakge'           => 'package',
    'pachage'           => 'package',
    'packacge'          => 'package',
    'packege'           => 'package',
    'packge'            => 'package',
    'paide'             => 'paid',
    'paitience'         => 'patience',
    'pakage'            => 'package',
    'palce'             => 'place, palace',
    'paliamentarian'    => 'parliamentarian',
    'pallete'           => 'palette',
    'pallette'          => 'palette',
    'pamflet'           => 'pamphlet',
    'pamplet'           => 'pamphlet',
    'paralell'          => 'parallel',
    'paralelly'         => 'parallelly',
    'paralel'           => 'parallel',
    'paralely'          => 'parallelly',
    'parallely'         => 'parallelly',
    'paramameters'      => 'parameters',
    'paramater'         => 'parameter',
    'parametes'         => 'parameters',
    'paramter'          => 'parameter',
    'paramters'         => 'parameters',
    'paranthesis'       => 'parenthesis',
    'paraphenalia'      => 'paraphernalia',
    'parellels'         => 'parallels',
    'parituclar'        => 'particular',
    'parliment'         => 'parliament',
    'parrakeets'        => 'parakeets',
    'parralel'          => 'parallel',
    'parrallell'        => 'parallel',
    'parrallelly'       => 'parallelly',
    'parrallel'         => 'parallel',
    'parrallely'        => 'parallelly',
    'partialy'          => 'partially',
    'particually'       => 'particularly',
    'particualr'        => 'particular',
    'particuarly'       => 'particularly',
    'particularily'     => 'particularly',
    'particulary'       => 'particularly',
    'pary'              => 'party',
    'pased'             => 'passed',
    'pasengers'         => 'passengers',
    'passerbys'         => 'passersby',
    'pasttime'          => 'pastime',
    'pastural'          => 'pastoral',
    'paticular'         => 'particular',
    'pattented'         => 'patented',
    'pavillion'         => 'pavilion',
    'payed'             => 'paid',
    'pblisher'          => 'publisher',
    'pbulisher'         => 'publisher',
    'peageant'          => 'pageant',
    'peculure'          => 'peculiar',
    'pedestrain'        => 'pedestrian',
    'peformed'          => 'performed',
    'peice'             => 'piece',
    'penatly'           => 'penalty',
    'penerator'         => 'penetrator',
    'penisula'          => 'peninsula',
    'penisular'         => 'peninsular',
    'penninsula'        => 'peninsula',
    'penninsular'       => 'peninsular',
    'pennisula'         => 'peninsula',
    'pensinula'         => 'peninsula',
    'peom'              => 'poem',
    'peoms'             => 'poems',
    'peopel'            => 'people',
    'peotry'            => 'poetry',
    'peprocessor'       => 'preprocessor',
    'perade'            => 'parade',
    'percepted'         => 'perceived',
    'percieved'         => 'perceived',
    'percieve'          => 'perceive',
    'perenially'        => 'perennially',
    'perfomance'        => 'performance',
    'perfomers'         => 'performers',
    'perfoming'         => 'performing',
    'performence'       => 'performance',
    'performes'         => 'performed, performs',
    'perhasp'           => 'perhaps',
    'perheaps'          => 'perhaps',
    'perhpas'           => 'perhaps',
    'peripathetic'      => 'peripatetic',
    'peristent'         => 'persistent',
    'perjery'           => 'perjury',
    'perjorative'       => 'pejorative',
    'permanant'         => 'permanent',
    'permenantly'       => 'permanently',
    'permenant'         => 'permanent',
    'permissable'       => 'permissible',
    'permissons'        => 'permissions',
    'perogative'        => 'prerogative',
    'peronal'           => 'personal',
    'perosnality'       => 'personality',
    'perphas'           => 'perhaps',
    'perpindicular'     => 'perpendicular',
    'perseverence'      => 'perseverance',
    'persistance'       => 'persistence',
    'persistant'        => 'persistent',
    'personell'         => 'personnel',
    'personel'          => 'personnel, personal',
    'personnell'        => 'personnel',
    'persuded'          => 'persuaded',
    'persued'           => 'pursued',
    'persue'            => 'pursue',
    'persuing'          => 'pursuing',
    'persuit'           => 'pursuit',
    'persuits'          => 'pursuits',
    'pertubation'       => 'perturbation',
    'pertubations'      => 'perturbations',
    'petetion'          => 'petition',
    'phenomenom'        => 'phenomenon',
    'phenomenonal'      => 'phenomenal',
    'phenomenonly'      => 'phenomenally',
    'phenomonenon'      => 'phenomenon',
    'phenomonon'        => 'phenomenon',
    'phenonmena'        => 'phenomena',
    'philisopher'       => 'philosopher',
    'philisophical'     => 'philosophical',
    'philisophy'        => 'philosophy',
    'phillosophically'  => 'philosophically',
    'philospher'        => 'philosopher',
    'philosphies'       => 'philosophies',
    'philosphy'         => 'philosophy',
    'phongraph'         => 'phonograph',
    'phylosophical'     => 'philosophical',
    'physicaly'         => 'physically',
    'piblisher'         => 'publisher',
    'pich'              => 'pitch',
    'pilgrimmage'       => 'pilgrimage',
    'pilgrimmages'      => 'pilgrimages',
    'pinapple'          => 'pineapple',
    'pinnaple'          => 'pineapple',
    'pinoneered'        => 'pioneered',
    'plagarism'         => 'plagiarism',
    'planation'         => 'plantation',
    'planed'            => 'planned',
    'plantiff'          => 'plaintiff',
    'plateu'            => 'plateau',
    'plattform'         => 'platform',
    'plausable'         => 'plausible',
    'playright'         => 'playwright',
    'playwrite'         => 'playwright',
    'playwrites'        => 'playwrights',
    'pleaes'            => 'please',
    'pleasent'          => 'pleasant',
    'plesant'           => 'pleasant',
    'ploting'           => 'plotting',
    'poeoples'          => 'peoples',
    'poety'             => 'poetry',
    'poisin'            => 'poison',
    'polical'           => 'political',
    'polinator'         => 'pollinator',
    'polinators'        => 'pollinators',
    'politican'         => 'politician',
    'politicans'        => 'politicians',
    'poltical'          => 'political',
    'poluted'           => 'polluted',
    'polute'            => 'pollute',
    'polutes'           => 'pollutes',
    'poluting'          => 'polluting',
    'polution'          => 'pollution',
    'pomotion'          => 'promotion',
    'poportional'       => 'proportional',
    'popoulation'       => 'population',
    'popularaty'        => 'popularity',
    'populare'          => 'popular',
    'populer'           => 'popular',
    'portait'           => 'portrait',
    'portayed'          => 'portrayed',
    'portraing'         => 'portraying',
    'portuguease'       => 'portuguese',
    'portugues'         => 'Portuguese',
    'posessed'          => 'possessed',
    'posesses'          => 'possesses',
    'posessing'         => 'possessing',
    'posession'         => 'possession',
    'posessions'        => 'possessions',
    'posess'            => 'possess',
    'posible'           => 'possible',
    'posion'            => 'poison',
    'positon'           => 'position, positron',
    'possable'          => 'possible',
    'possably'          => 'possibly',
    'posseses'          => 'possesses',
    'possesing'         => 'possessing',
    'possesion'         => 'possession',
    'possessess'        => 'possesses',
    'possibile'         => 'possible',
    'possibilty'        => 'possibility',
    'possiblility'      => 'possibility',
    'possiblilty'       => 'possibility',
    'possiblities'      => 'possibilities',
    'possiblity'        => 'possibility',
    'possition'         => 'position',
    'posthomous'        => 'posthumous',
    'postion'           => 'position',
    'postive'           => 'positive',
    'potatos'           => 'potatoes',
    'potrait'           => 'portrait',
    'potrayed'          => 'portrayed',
    'poulations'        => 'populations',
    'poverful'          => 'powerful',
    'poweful'           => 'powerful',
    'powerfull'         => 'powerful',
    'ppublisher'        => 'publisher',
    'practially'        => 'practically',
    'practial'          => 'practical',
    'practicaly'        => 'practically',
    'practicioner'      => 'practitioner',
    'practicioners'     => 'practitioners',
    'practicly'         => 'practically',
    'practioner'        => 'practitioner',
    'practioners'       => 'practitioners',
    'prairy'            => 'prairie',
    'prarie'            => 'prairie',
    'praries'           => 'prairies',
    'pratice'           => 'practice',
    'preample'          => 'preamble',
    'precedessor'       => 'predecessor',
    'preceeded'         => 'preceded',
    'preceeding'        => 'preceding',
    'preceed'           => 'precede',
    'preceeds'          => 'precedes',
    'precendence'       => 'precedence',
    'precentage'        => 'percentage',
    'precice'           => 'precise',
    'precisly'          => 'precisely',
    'precission'        => 'precision',
    'precurser'         => 'precursor',
    'predecesors'       => 'predecessors',
    'predicatble'       => 'predictable',
    'predicitons'       => 'predictions',
    'predomiantly'      => 'predominately',
    'prefered'          => 'preferred',
    'prefering'         => 'preferring',
    'preferrably'       => 'preferably',
    'prefferably'       => 'preferably',
    'pregancies'        => 'pregnancies',
    'preiod'            => 'period',
    'preliferation'     => 'proliferation',
    'premeired'         => 'premiered',
    'premeire'          => 'premiere',
    'premillenial'      => 'premillennial',
    'preminence'        => 'preeminence',
    'premission'        => 'permission',
    'preocupation'      => 'preoccupation',
    'prepaired'         => 'prepared',
    'prepair'           => 'prepare',
    'prepartion'        => 'preparation',
    'prepatory'         => 'preparatory',
    'preperation'       => 'preparation',
    'preperations'      => 'preparations',
    'preriod'           => 'period',
    'presedential'      => 'presidential',
    'presense'          => 'presence',
    'presidenital'      => 'presidential',
    'presidental'       => 'presidential',
    'presitgious'       => 'prestigious',
    'prespective'       => 'perspective',
    'prestigeous'       => 'prestigious',
    'prestigous'        => 'prestigious',
    'presumabely'       => 'presumably',
    'presumibly'        => 'presumably',
    'pretection'        => 'protection',
    'prevelant'         => 'prevalent',
    'preverse'          => 'perverse',
    'previvous'         => 'previous',
    'pricipal'          => 'principal',
    'priciple'          => 'principle',
    'priestood'         => 'priesthood',
    'primarly'          => 'primarily',
    'primatively'       => 'primitively',
    'primative'         => 'primitive',
    'primatives'        => 'primitives',
    'primordal'         => 'primordial',
    'principaly'        => 'principality',
    'principial'        => 'principal',
    'principlaity'      => 'principality',
    'principly'         => 'principally',
    'princliple'        => 'principle',
    'prinicipal'        => 'principal',
    'priorty'           => 'priority',
    'privalege'         => 'privilege',
    'privaleges'        => 'privileges',
    'priveledges'       => 'privileges',
    'priveleged'        => 'privileged',
    'privelege'         => 'privilege',
    'priveleges'        => 'privileges',
    'priveliged'        => 'privileged',
    'privelige'         => 'privilege',
    'priveliges'        => 'privileges',
    'privelleges'       => 'privileges',
    'privilage'         => 'privilege',
    'priviledge'        => 'privilege',
    'priviledges'       => 'privileges',
    'privledge'         => 'privilege',
    'privte'            => 'private',
    'probabilaty'       => 'probability',
    'probablistic'      => 'probabilistic',
    'probablly'         => 'probably',
    'probalibity'       => 'probability',
    'probaly'           => 'probably',
    'probelm'           => 'problem',
    'procceed'          => 'proceed',
    'proccesors'        => 'processors',
    'proccessing'       => 'processing',
    'proccess'          => 'process',
    'proceded'          => 'proceeded, preceded',
    'procede'           => 'proceed, precede',
    'procedes'          => 'proceeds, precedes',
    'procedger'         => 'procedure',
    'proceding'         => 'proceeding, preceding',
    'procedings'        => 'proceedings',
    'proceedure'        => 'procedure',
    'proces'            => 'process',
    'processer'         => 'processor',
    'processessing'     => 'processing',
    'processpr'         => 'processor',
    'processsing'       => 'processing',
    'proclaimation'     => 'proclamation',
    'proclamed'         => 'proclaimed',
    'proclaming'        => 'proclaiming',
    'proclomation'      => 'proclamation',
    'profesion'         => 'profusion, profession',
    'profesor'          => 'professor',
    'professer'         => 'professor',
    'proffesed'         => 'professed',
    'proffesional'      => 'professional',
    'proffesion'        => 'profession',
    'proffesor'         => 'professor',
    'profilic'          => 'prolific',
    'progams'           => 'programs',
    'progessed'         => 'progressed',
    'programable'       => 'programmable',
    'programers'        => 'programmers',
    'programm'          => 'program',
    'programms'         => 'programs',
    'progrom'           => 'program',
    'progroms'          => 'programs',
    'prohabition'       => 'prohibition',
    'prologomena'       => 'prolegomena',
    'prominance'        => 'prominence',
    'prominantly'       => 'prominently',
    'prominant'         => 'prominent',
    'prominately'       => 'prominently, predominately',
    'promiscous'        => 'promiscuous',
    'promotted'         => 'promoted',
    'promps'            => 'prompts',
    'pronnounced'       => 'pronounced',
    'pronomial'         => 'pronominal',
    'prononciation'     => 'pronunciation',
    'pronouced'         => 'pronounced',
    'pronouce'          => 'pronounce',
    'pronounched'       => 'pronounced',
    'pronounciation'    => 'pronunciation',
    'pronunce'          => 'pronounce',
    'prooved'           => 'proved',
    'proove'            => 'prove',
    'propery'           => 'property',
    'prophacy'          => 'prophecy',
    'propietary'        => 'proprietary',
    'propmted'          => 'prompted',
    'propoganda'        => 'propaganda',
    'propogate'         => 'propagate',
    'propogates'        => 'propagates',
    'propogation'       => 'propagation',
    'propostion'        => 'proposition',
    'propotions'        => 'proportions',
    'propperly'         => 'properly',
    'propper'           => 'proper',
    'proprietory'       => 'proprietary',
    'proseletyzing'     => 'proselytizing',
    'prosess'           => 'process',
    'protable'          => 'portable',
    'protaganist'       => 'protagonist',
    'protaganists'      => 'protagonists',
    'protcol'           => 'protocol',
    'protecion'         => 'protection',
    'protocal'          => 'protocol',
    'protocoll'         => 'protocol',
    'protoganist'       => 'protagonist',
    'protrayed'         => 'portrayed',
    'protruberance'     => 'protuberance',
    'protruberances'    => 'protuberances',
    'prouncements'      => 'pronouncements',
    'provacative'       => 'provocative',
    'provded'           => 'provided',
    'provicial'         => 'provincial',
    'provinicial'       => 'provincial',
    'provisiosn'        => 'provision',
    'provisonal'        => 'provisional',
    'proximty'          => 'proximity',
    'pseudononymous'    => 'pseudonymous',
    'pseudonyn'         => 'pseudonym',
    'psuedo'            => 'pseudo',
    'psychadelic'       => 'psychedelic',
    'psycology'         => 'psychology',
    'psyhic'            => 'psychic',
    'pubilsher'         => 'publisher',
    'pubisher'          => 'publisher',
    'publiaher'         => 'publisher',
    'publically'        => 'publicly',
    'publicaly'         => 'publicly',
    'publicher'         => 'publisher',
    'publihser'         => 'publisher',
    'publisehr'         => 'publisher',
    'publiser'          => 'publisher',
    'publisger'         => 'publisher',
    'publisheed'        => 'published',
    'publisherr'        => 'publisher',
    'publishher'        => 'publisher',
    'publishor'         => 'publisher',
    'publishre'         => 'publisher',
    'publissher'        => 'publisher',
    'publlisher'        => 'publisher',
    'publsiher'         => 'publisher',
    'publusher'         => 'publisher',
    'puchasing'         => 'purchasing',
    'pulisher'          => 'publisher',
    'pumkin'            => 'pumpkin',
    'puplisher'         => 'publisher',
    'puritannical'      => 'puritanical',
    'purposedly'        => 'purposely',
    'purpotedly'        => 'purportedly',
    'pursuaded'         => 'persuaded',
    'pursuade'          => 'persuade',
    'pursuades'         => 'persuades',
    'pususading'        => 'persuading',
    'puting'            => 'putting',
    'pwoer'             => 'power',
    'pyscic'            => 'psychic',
    'qtuie'             => 'quite, quiet',
    'quantaty'          => 'quantity',
    'quantitiy'         => 'quantity',
    'quarantaine'       => 'quarantine',
    'quering'           => 'querying',
    'questonable'       => 'questionable',
    'quicklyu'          => 'quickly',
    'quinessential'     => 'quintessential',
    'quitted'           => 'quit',
    'quizes'            => 'quizzes',
    'qutie'             => 'quite, quiet',
    'rabinnical'        => 'rabbinical',
    'racaus'            => 'raucous',
    'radiactive'        => 'radioactive',
    'radify'            => 'ratify',
    'raelly'            => 'really',
    'rarified'          => 'rarefied',
    'reaccurring'       => 'recurring',
    'reacing'           => 'reaching',
    'reacll'            => 'recall',
    'readmition'        => 'readmission',
    'realitvely'        => 'relatively',
    'realsitic'         => 'realistic',
    'realtions'         => 'relations',
    'realyl'            => 'really',
    'realy'             => 'really',
    'reasearch'         => 'research',
    'rebiulding'        => 'rebuilding',
    'rebllions'         => 'rebellions',
    'rebounce'          => 'rebound',
    'reccomendations'   => 'recommendations',
    'reccomended'       => 'recommended',
    'reccomending'      => 'recommending',
    'reccomend'         => 'recommend',
    'reccommended'      => 'recommended',
    'reccommending'     => 'recommending',
    'reccommend'        => 'recommend',
    'reccuring'         => 'recurring',
    'receeded'          => 'receded',
    'receeding'         => 'receding',
    'recepient'         => 'recipient',
    'recepients'        => 'recipients',
    'receving'          => 'receiving',
    'rechargable'       => 'rechargeable',
    'reched'            => 'reached',
    'recided'           => 'resided',
    'recident'          => 'resident',
    'recidents'         => 'residents',
    'recide'            => 'reside',
    'reciding'          => 'residing',
    'reciepents'        => 'recipients',
    'reciept'           => 'receipt',
    'recieved'          => 'received',
    'recieve'           => 'receive',
    'reciever'          => 'receiver',
    'recievers'         => 'receivers',
    'recieves'          => 'receives',
    'recieving'         => 'receiving',
    'recipiant'         => 'recipient',
    'recipiants'        => 'recipients',
    'recived'           => 'received',
    'recivership'       => 'receivership',
    'recogise'          => 'recognise',
    'recogize'          => 'recognize',
    'recogniced'        => 'recognised',
    'recognizeable'     => 'recognizable',
    'recomended'        => 'recommended',
    'recomending'       => 'recommending',
    'recomend'          => 'recommend',
    'recomends'         => 'recommends',
    'recommanded'       => 'recommended',
    'recommedations'    => 'recommendations',
    'recompence'        => 'recompense',
    'reconaissance'     => 'reconnaissance',
    'reconcilation'     => 'reconciliation',
    'reconized'         => 'recognized',
    'reconnaisance'     => 'reconnaissance',
    'reconnaissence'    => 'reconnaissance',
    'recontructed'      => 'reconstructed',
    'recquired'         => 'required',
    'recrational'       => 'recreational',
    'recrod'            => 'record',
    'recuiting'         => 'recruiting',
    'recuring'          => 'recurring',
    'recurrance'        => 'recurrence',
    'rediculous'        => 'ridiculous',
    'redircet'          => 'redirect',
    'redirectrion'      => 'redirection',
    'reedeming'         => 'redeeming',
    'reenforced'        => 'reinforced',
    'refect'            => 'reflect',
    'refedendum'        => 'referendum',
    'refence'           => 'reference',
    'referal'           => 'referral',
    'referece'          => 'reference',
    'refereces'         => 'references',
    'refered'           => 'referred',
    'referemce'         => 'reference',
    'referemces'        => 'references',
    'referencs'         => 'references',
    'refereneced'       => 'referenced',
    'referenece'        => 'reference',
    'refereneces'       => 'references',
    'referiang'         => 'referring',
    'refering'          => 'referring',
    'refernce'          => 'references',
    'refernces'         => 'references',
    'referrence'        => 'reference',
    'referrences'       => 'references',
    'referrs'           => 'refers',
    'reffered'          => 'referred',
    'refference'        => 'reference',
    'reffering'         => 'referring',
    'refrence'          => 'reference',
    'refrences'         => 'references',
    'refrers'           => 'refers',
    'refridgeration'    => 'refrigeration',
    'refridgerator'     => 'refrigerator',
    'refromist'         => 'reformist',
    'refusla'           => 'refusal',
    'regardes'          => 'regards',
    'registerd'         => 'registered',
    'registraration'    => 'registration',
    'regluar'           => 'regular',
    'reguarly'          => 'regularly',
    'regulaion'         => 'regulation',
    'regulamentations'  => 'regulations',
    'regulaotrs'        => 'regulators',
    'regularily'        => 'regularly',
    'rehersal'          => 'rehearsal',
    'reicarnation'      => 'reincarnation',
    'reigining'         => 'reigning',
    'reknowned'         => 'renowned',
    'reknown'           => 'renown',
    'relaly'            => 'really',
    'rela'              => 'real',
    'relatiopnship'     => 'relationship',
    'relativly'         => 'relatively',
    'relected'          => 'reelected',
    'releived'          => 'relieved',
    'releive'           => 'relieve',
    'releiver'          => 'reliever',
    'releses'           => 'releases',
    'relevence'         => 'relevance',
    'relevent'          => 'relevant',
    'reliablity'        => 'reliability',
    'relient'           => 'reliant',
    'religeous'         => 'religious',
    'religously'        => 'religiously',
    'religous'          => 'religious',
    'relinqushment'     => 'relinquishment',
    'relitavely'        => 'relatively',
    'relized'           => 'realised, realized',
    'relpacement'       => 'replacement',
    'remaing'           => 'remaining',
    'remeber'           => 'remember',
    'rememberable'      => 'memorable',
    'rememberance'      => 'remembrance',
    'remembrence'       => 'remembrance',
    'remenant'          => 'remnant',
    'remenicent'        => 'reminiscent',
    'reminent'          => 'remnant',
    'reminescent'       => 'reminiscent',
    'reminscent'        => 'reminiscent',
    'reminsicent'       => 'reminiscent',
    'remoote'           => 'remote',
    'removeable'        => 'removable',
    'rendevous'         => 'rendezvous',
    'rendezous'         => 'rendezvous',
    'renedered'         => 'rende',
    'renewl'            => 'renewal',
    'rennovated'        => 'renovated',
    'rennovate'         => 'renovate',
    'rennovating'       => 'renovating',
    'rennovation'       => 'renovation',
    'rentors'           => 'renters',
    'reoccurrence'      => 'recurrence',
    'reorganision'      => 'reorganisation',
    'repatition'        => 'repetition, repartition',
    'repblican'         => 'republican',
    'repblicans'        => 'republicans',
    'repblic'           => 'republic',
    'repblics'          => 'republics',
    'repectively'       => 'respectively',
    'repeition'         => 'repetition',
    'repentence'        => 'repentance',
    'repentent'         => 'repentant',
    'repeteadly'        => 'repeatedly',
    'repetion'          => 'repetition',
    'repid'             => 'rapid',
    'replacments'       => 'replacements',
    'reponse'           => 'response',
    'reponsible'        => 'responsible',
    'reportadly'        => 'reportedly',
    'represantative'    => 'representative',
    'representive'      => 'representative',
    'representives'     => 'representatives',
    'reproducable'      => 'reproducible',
    'reprtoire'         => 'repertoire',
    'repsectively'      => 'respectively',
    'reptition'         => 'repetition',
    'repubican'         => 'republican',
    'repubicans'        => 'republicans',
    'repubic'           => 'republic',
    'repubics'          => 'republics',
    'republian'         => 'republican',
    'republians'        => 'republicans',
    'republi'           => 'republic',
    'republis'          => 'republics',
    'repulican'         => 'republican',
    'repulicans'        => 'republicans',
    'repulic'           => 'republic',
    'repulics'          => 'republics',
    'requiere'          => 'require',
    'requirment'        => 'requirement',
    'requred'           => 'required',
    'resaurant'         => 'restaurant',
    'resembelance'      => 'resemblance',
    'resembes'          => 'resembles',
    'resemblence'       => 'resemblance',
    'resevoir'          => 'reservoir',
    'residental'        => 'residential',
    'resignement'       => 'resignment',
    'resistable'        => 'resistible',
    'resistence'        => 'resistance',
    'resistent'         => 'resistant',
    'resizeable'        => 'resizable',
    'respectivly'       => 'respectively',
    'responce'          => 'response',
    'responibilities'   => 'responsibilities',
    'responisble'       => 'responsible',
    'responnsibilty'    => 'responsibility',
    'responsability'    => 'responsibility',
    'responsibile'      => 'responsible',
    'responsibilites'   => 'responsibilities',
    'responsiblities'   => 'responsibilities',
    'responsiblity'     => 'responsibility',
    'ressemblance'      => 'resemblance',
    'ressembled'        => 'resembled',
    'ressemblence'      => 'resemblance',
    'ressemble'         => 'resemble',
    'ressembling'       => 'resembling',
    'ressize'           => 'resize',
    'ressource'         => 'resource',
    'resssurecting'     => 'resurrecting',
    'ressurected'       => 'resurrected',
    'ressurection'      => 'resurrection',
    'ressurect'         => 'resurrect',
    'ressurrection'     => 'resurrection',
    'restarant'         => 'restaurant',
    'restarants'        => 'restaurants',
    'restaraunteur'     => 'restaurateur',
    'restaraunteurs'    => 'restaurateurs',
    'restaraunt'        => 'restaurant',
    'restaraunts'       => 'restaurants',
    'restauranteurs'    => 'restaurateurs',
    'restauration'      => 'restoration',
    'restauraunt'       => 'restaurant',
    'resteraunt'        => 'restaurant',
    'resteraunts'       => 'restaurants',
    'resticted'         => 'restricted',
    'restraunt'         => 'restraint, restaurant',
    'resturant'         => 'restaurant',
    'resturants'        => 'restaurants',
    'resturaunt'        => 'restaurant',
    'resturaunts'       => 'restaurants',
    'resurecting'       => 'resurrecting',
    'retalitated'       => 'retaliated',
    'retalitation'      => 'retaliation',
    'retransmited'      => 'retransmitted',
    'retreive'          => 'retrieve',
    'returnd'           => 'returned',
    'revaluated'        => 'reevaluated',
    'reveiw'            => 'review',
    'reveral'           => 'reversal',
    'reversable'        => 'reversible',
    'revolutionar'      => 'revolutionary',
    'rewitten'          => 'rewritten',
    'rewriet'           => 'rewrite',
    'rference'          => 'reference',
    'rferences'         => 'references',
    'rhymme'            => 'rhyme',
    'rhythem'           => 'rhythm',
    'rhythim'           => 'rhythm',
    'rhytmic'           => 'rhythmic',
    'rigeur'            => 'rigueur, rigour, rigor',
    'rigourous'         => 'rigorous',
    'rininging'         => 'ringing',
    'rised'             => 'rose',
    'rocord'            => 'record',
    'roomate'           => 'roommate',
    'rougly'            => 'roughly',
    'rucuperate'        => 'recuperate',
    'rudimentatry'      => 'rudimentary',
    'rulle'             => 'rule',
    'runing'            => 'running',
    'runnning'          => 'running',
    'runnung'           => 'running',
    'russina'           => 'Russian',
    'russion'           => 'Russian',
    'rwite'             => 'write',
    'rythem'            => 'rhythm',
    'rythim'            => 'rhythm',
    'rythmic'           => 'rhythmic',
    'rythm'             => 'rhythm',
    'rythyms'           => 'rhythms',
    'sacrafice'         => 'sacrifice',
    'sacreligious'      => 'sacrilegious',
    'sacrifical'        => 'sacrificial',
    'safly'             => 'safely',
    'saftey'            => 'safety',
    'safty'             => 'safety',
    'salery'            => 'salary',
    'sanctionning'      => 'sanctioning',
    'sandwhich'         => 'sandwich',
    'santioned'         => 'sanctioned',
    'sasy'              => 'says, sassy',
    'satelite'          => 'satellite',
    'satelites'         => 'satellites',
    'saterday'          => 'Saturday',
    'saterdays'         => 'Saturdays',
    'satisfactority'    => 'satisfactorily',
    'satrically'        => 'satirically',
    'satrical'          => 'satirical',
    'satric'            => 'satiric',
    'sattelite'         => 'satellite',
    'sattelites'        => 'satellites',
    'saught'            => 'sought',
    'savable'           => 'saveable',
    'saveing'           => 'saving',
    'saxaphone'         => 'saxophone',
    'scaleable'         => 'scalable',
    'scandanavia'       => 'Scandinavia',
    'scaricity'         => 'scarcity',
    'scavanged'         => 'scavenged',
    'schedual'          => 'schedule',
    'scholarhip'        => 'scholarship',
    'scholarstic'       => 'scholastic, scholarly',
    'scientfic'         => 'scientific',
    'scientifc'         => 'scientific',
    'scientis'          => 'scientist',
    'scince'            => 'science',
    'scinece'           => 'science',
    'scirpt'            => 'script',
    'scoll'             => 'scroll',
    'screenwrighter'    => 'screenwriter',
    'scrutinity'        => 'scrutiny',
    'scuptures'         => 'sculptures',
    'seached'           => 'searched',
    'seaches'           => 'searches',
    'seach'             => 'search',
    'searchs'           => 'searches',
    'secceeded'         => 'seceded, succeeded',
    'seceeded'          => 'succeeded, seceded',
    'seceed'            => 'succeed, secede',
    'secratary'         => 'secretary',
    'secretery'         => 'secretary',
    'secund'            => 'second',
    'sedereal'          => 'sidereal',
    'seeked'            => 'sought',
    'segementation'     => 'segmentation',
    'seige'             => 'siege',
    'seing'             => 'seeing',
    'seinor'            => 'senior',
    'seldomly'          => 'seldom',
    'senarios'          => 'scenarios',
    'sence'             => 'sense, since',
    'senstive'          => 'sensitive',
    'sensure'           => 'censure',
    'separatly'         => 'separately',
    'sepcify'           => 'specify',
    'seperated'         => 'separated',
    'seperately'        => 'separately',
    'seperate'          => 'separate',
    'seperates'         => 'separates',
    'seperating'        => 'separating',
    'seperation'        => 'separation',
    'seperatism'        => 'separatism',
    'seperatist'        => 'separatist',
    'seperatly'         => 'separately',
    'seperator'         => 'separator',
    'sequencial'        => 'sequential',
    'sergent'           => 'sergeant',
    'serveral'          => 'several',
    'settelement'       => 'settlement',
    'settlment'         => 'settlement',
    'setts'             => 'sets',
    'severeal'          => 'several',
    'severley'          => 'severely',
    'severly'           => 'severely',
    'sevice'            => 'service',
    'shaddow'           => 'shadow',
    'sheat'             => 'sheath, sheet, cheat',
    'sheild'            => 'shield',
    'sherif'            => 'sheriff',
    'shineing'          => 'shining',
    'shiped'            => 'shipped',
    'shiping'           => 'shipping',
    'shopkeeepers'      => 'shopkeepers',
    'shorly'            => 'shortly',
    'shortwhile'        => 'short while',
    'shoudl'            => 'should',
    'shrinked'          => 'shrunk',
    'sicne'             => 'since',
    'siezed'            => 'seized, sized',
    'sieze'             => 'seize, size',
    'siezing'           => 'seizing, sizing',
    'siezure'           => 'seizure',
    'siezures'          => 'seizures',
    'siginificant'      => 'significant',
    'signficant'        => 'significant',
    'signficiant'       => 'significant',
    'signfies'          => 'signifies',
    'signifantly'       => 'significantly',
    'significently'     => 'significantly',
    'signifigantly'     => 'significantly',
    'signifigant'       => 'significant',
    'signitories'       => 'signatories',
    'signitory'         => 'signatory',
    'similarily'        => 'similarly',
    'similiarity'       => 'similarity',
    'similiarly'        => 'similarly',
    'similiar'          => 'similar',
    'simliar'           => 'similar',
    'simmilar'          => 'similar',
    'simpley'           => 'simply',
    'simplier'          => 'simpler',
    'simultanously'     => 'simultaneously',
    'simultanous'       => 'simultaneous',
    'sincerley'         => 'sincerely',
    'singsog'           => 'singsong',
    'sinse'             => 'sines, since',
    'skateing'          => 'skating',
    'slaugterhouses'    => 'slaughterhouses',
    'slighly'           => 'slightly',
    'slippy'            => 'slippery',
    'slowy'             => 'slowly',
    'smae'              => 'same',
    'smoe'              => 'some',
    'sneeks'            => 'sneaks',
    'snese'             => 'sneeze',
    'socalism'          => 'socialism',
    'socities'          => 'societies',
    'soem'              => 'some',
    'sofware'           => 'software',
    'sohw'              => 'show',
    'soilders'          => 'soldiers',
    'solatary'          => 'solitary',
    'soley'             => 'solely',
    'soliders'          => 'soldiers',
    'soliliquy'         => 'soliloquy',
    'soluable'          => 'soluble',
    'somene'            => 'someone',
    'somtimes'          => 'sometimes',
    'somwhere'          => 'somewhere',
    'sophicated'        => 'sophisticated',
    'sophmore'          => 'sophomore',
    'sorceror'          => 'sorcerer',
    'sorrounding'       => 'surrounding',
    'sotry'             => 'story',
    'sotyr'             => 'satyr, story',
    'soudn'             => 'sound',
    'soudns'            => 'sounds',
    'sould'             => 'could, should, sold, soul',
    'sountrack'         => 'soundtrack',
    'sourthern'         => 'southern',
    'sourth'            => 'south',
    'souvenier'         => 'souvenir',
    'souveniers'        => 'souvenirs',
    'soveits'           => 'soviets',
    'sovereignity'      => 'sovereignty',
    'soverignity'       => 'sovereignty',
    'soverign'          => 'sovereign',
    'soverignty'        => 'sovereignty',
    'spainish'          => 'Spanish',
    'speach'            => 'speech',
    'specfic'           => 'specific',
    'speciallized'      => 'specialised, specialized',
    'speciefied'        => 'specified',
    'specifed'          => 'specified',
    'specificaton'      => 'specification',
    'specifing'         => 'specifying',
    'specifiying'       => 'specifying',
    'specif'            => 'specific, specify',
    'speciman'          => 'specimen',
    'spectauclar'       => 'spectacular',
    'spectaulars'       => 'spectaculars',
    'spects'            => 'aspects, expects',
    'spectum'           => 'spectrum',
    'speficied'         => 'specified',
    'speices'           => 'species',
    'speling'           => 'spelling',
    'spendour'          => 'splendour',
    'splitted'          => 'split',
    'spoace'            => 'space',
    'sponsered'         => 'sponsored',
    'sponser'           => 'sponsor',
    'spontanous'        => 'spontaneous',
    'sponzored'         => 'sponsored',
    'spoonfulls'        => 'spoonfuls',
    'sppeches'          => 'speeches',
    'spreaded'          => 'spread',
    'sprech'            => 'speech',
    'spred'             => 'spread',
    'spriritual'        => 'spiritual',
    'spritual'          => 'spiritual',
    'sqaure'            => 'square',
    'stablility'        => 'stability',
    'staically'         => 'statically',
    'stainlees'         => 'stainless',
    'staion'            => 'station',
    'standars'          => 'standards',
    'standart'          => 'standard',
    'stange'            => 'strange',
    'startegic'         => 'strategic',
    'startegies'        => 'strategies',
    'startegy'          => 'strategy',
    'stateman'          => 'statesman',
    'statememts'        => 'statements',
    'staticly'          => 'statically',
    'statment'          => 'statement',
    'steriods'          => 'steroids',
    'sterotypes'        => 'stereotypes',
    'stilus'            => 'stylus',
    'stingent'          => 'stringent',
    'stiring'           => 'stirring',
    'stirrs'            => 'stirs',
    'stlye'             => 'style',
    'stomache'          => 'stomach',
    'stong'             => 'strong',
    'stopry'            => 'story',
    'storeis'           => 'stories',
    'storise'           => 'stories',
    'stornegst'         => 'strongest',
    'stoyr'             => 'story',
    'stpo'              => 'stop',
    'stradegies'        => 'strategies',
    'stradegy'          => 'strategy',
    'stratagically'     => 'strategically',
    'strat'             => 'start, strata',
    'streemlining'      => 'streamlining',
    'stregth'           => 'strength',
    'strenghened'       => 'strengthened',
    'strenghening'      => 'strengthening',
    'strenghen'         => 'strengthen',
    'strenghtened'      => 'strengthened',
    'strenghtening'     => 'strengthening',
    'strenghten'        => 'strengthen',
    'strenght'          => 'strength',
    'strengtened'       => 'strengthened',
    'strenous'          => 'strenuous',
    'strictist'         => 'strictest',
    'strikely'          => 'strikingly',
    'strnad'            => 'strand',
    'stroy'             => 'story, destroy',
    'structual'         => 'structural',
    'stubborness'       => 'stubbornness',
    'stuctured'         => 'structured',
    'stucture'          => 'structure',
    'studdy'            => 'study',
    'studing'           => 'studying',
    'stuggling'         => 'struggling',
    'sturcture'         => 'structure',
    'subcatagories'     => 'subcategories',
    'subcatagory'       => 'subcategory',
    'subconsiously'     => 'subconsciously',
    'subdirectoires'    => 'subdirectories',
    'subjudgation'      => 'subjugation',
    'suble'             => 'subtle',
    'submachne'         => 'submachine',
    'subpecies'         => 'subspecies',
    'subsidary'         => 'subsidiary',
    'subsiduary'        => 'subsidiary',
    'subsquently'       => 'subsequently',
    'subsquent'         => 'subsequent',
    'substace'          => 'substance',
    'substancial'       => 'substantial',
    'substatial'        => 'substantial',
    'substituded'       => 'substituted',
    'substracted'       => 'subtracted',
    'substracting'      => 'subtracting',
    'substraction'      => 'subtraction',
    'substracts'        => 'subtracts',
    'substract'         => 'subtract',
    'subtances'         => 'substances',
    'subterranian'      => 'subterranean',
    'suburburban'       => 'suburban',
    'succceeded'        => 'succeeded',
    'succcesses'        => 'successes',
    'succedded'         => 'succeeded',
    'succeded'          => 'succeeded',
    'succeds'           => 'succeeds',
    'succesfully'       => 'successfully',
    'succesful'         => 'successful',
    'succesfuly'        => 'successfully',
    'succesion'         => 'succession',
    'succesive'         => 'successive',
    'successfull'       => 'successful',
    'successully'       => 'successfully',
    'succsessfull'      => 'successful',
    'succsess'          => 'success',
    'suceeded'          => 'succeeded',
    'suceeding'         => 'succeeding',
    'suceeds'           => 'succeeds',
    'suceed'            => 'succeed',
    'sucesfully'        => 'successfully',
    'sucesful'          => 'successful',
    'sucesfuly'         => 'successfully',
    'sucesion'          => 'succession',
    'sucesses'          => 'successes',
    'sucessfull'        => 'successful',
    'sucessfully'       => 'successfully',
    'sucessful'         => 'successful',
    'sucessfuly'        => 'successfully',
    'sucession'         => 'succession',
    'sucessive'         => 'successive',
    'sucessor'          => 'successor',
    'sucessot'          => 'successor',
    'sucess'            => 'success',
    'sucide'            => 'suicide',
    'sucidial'          => 'suicidal',
    'sufficently'       => 'sufficiently',
    'sufficent'         => 'sufficient',
    'sumary'            => 'summary',
    'sunglases'         => 'sunglasses',
    'suop'              => 'soup',
    'superceeded'       => 'superseded',
    'superflous'        => 'superfluous',
    'superintendant'    => 'superintendent',
    'superseeded'       => 'superseded',
    'suphisticated'     => 'sophisticated',
    'suplied'           => 'supplied',
    'suplimented'       => 'supplemented',
    'suport'            => 'support',
    'suposedly'         => 'supposedly',
    'suposed'           => 'supposed',
    'suposes'           => 'supposes',
    'supose'            => 'suppose',
    'suposing'          => 'supposing',
    'supplamented'      => 'supplemented',
    'suppliementing'    => 'supplementing',
    'suppoed'           => 'supposed',
    'suppored'          => 'supported',
    'supportin'         => 'supporting',
    'supposingly'       => 'supposedly',
    'suppoted'          => 'supported',
    'suppported'        => 'supported',
    'suppport'          => 'support',
    'suppy'             => 'supply',
    'supressed'         => 'suppressed',
    'supresses'         => 'suppresses',
    'supressing'        => 'suppressing',
    'supress'           => 'suppress',
    'suprised'          => 'surprised',
    'suprise'           => 'surprise',
    'suprisingly'       => 'surprisingly',
    'suprising'         => 'surprising',
    'suprized'          => 'surprised',
    'suprize'           => 'surprise',
    'suprizingly'       => 'surprisingly',
    'suprizing'         => 'surprising',
    'surfce'            => 'surface',
    'surley'            => 'surly, surely',
    'surounded'         => 'surrounded',
    'suroundings'       => 'surroundings',
    'surounding'        => 'surrounding',
    'surounds'          => 'surrounds',
    'suround'           => 'surround',
    'surplanted'        => 'supplanted',
    'surpressed'        => 'suppressed',
    'surpress'          => 'suppress',
    'surprized'         => 'surprised',
    'surprize'          => 'surprise',
    'surprizingly'      => 'surprisingly',
    'surprizing'        => 'surprising',
    'surrended'         => 'surrounded, surrendered',
    'surrepetitiously'  => 'surreptitiously',
    'surrepetitious'    => 'surreptitious',
    'surreptiously'     => 'surreptitiously',
    'surreptious'       => 'surreptitious',
    'surronded'         => 'surrounded',
    'surrouded'         => 'surrounded',
    'surrouding'        => 'surrounding',
    'surrundering'      => 'surrendering',
    'surveilence'       => 'surveillance',
    'surveill'          => 'surveil',
    'surveyer'          => 'surveyor',
    'survivers'         => 'survivors',
    'surviver'          => 'survivor',
    'survivied'         => 'survived',
    'suseptable'        => 'susceptible',
    'suseptible'        => 'susceptible',
    'suspention'        => 'suspension',
    'suspicously'       => 'suspiciously',
    'swaers'            => 'swears',
    'swaer'             => 'swear',
    'swepth'            => 'swept',
    'swiming'           => 'swimming',
    'syas'              => 'says',
    'symetrically'      => 'symmetrically',
    'symetrical'        => 'symmetrical',
    'symetry'           => 'symmetry',
    'symettric'         => 'symmetric',
    'symmetral'         => 'symmetric',
    'symmetricaly'      => 'symmetrically',
    'synagouge'         => 'synagogue',
    'synax'             => 'syntax',
    'synchonized'       => 'synchronized',
    'syncronization'    => 'synchronization',
    'syncronize'        => 'synchronize',
    'syncronizing'      => 'synchronizing',
    'syncronus'         => 'synchronous',
    'synonomous'        => 'synonymous',
    'synonymns'         => 'synonyms',
    'synphony'          => 'symphony',
    'syphyllis'         => 'syphilis',
    'sypmtoms'          => 'symptoms',
    'syrap'             => 'syrup',
    'sysmatically'      => 'systematically',
    'syste'             => 'system',
    'sytem'             => 'system',
    'sythesis'          => 'synthesis',
    'sytle'             => 'style',
    'tabacco'           => 'tobacco',
    'tahn'              => 'than',
    'taht'              => 'that',
    'talekd'            => 'talked',
    'targetted'         => 'targeted',
    'targetting'        => 'targeting',
    'tast'              => 'taste',
    'tath'              => 'that',
    'taxanomy'          => 'taxonomy',
    'teached'           => 'taught',
    'techicians'        => 'technicians',
    'techician'         => 'technician',
    'techiniques'       => 'techniques',
    'technitian'        => 'technician',
    'technnology'       => 'technology',
    'technolgy'         => 'technology',
    'teh'               => 'the',
    'tehy'              => 'they',
    'telelevision'      => 'television',
    'televsion'         => 'television',
    'telphony'          => 'telephony',
    'temerature'        => 'temperature',
    'tempaltes'         => 'templates',
    'tempalte'          => 'template',
    'temparate'         => 'temperate',
    'temperarily'       => 'temporarily',
    'temperment'        => 'temperament',
    'tempertaure'       => 'temperature',
    'temperture'        => 'temperature',
    'temprary'          => 'temporary',
    'tenacles'          => 'tentacles',
    'tenacle'           => 'tentacle',
    'tendacy'           => 'tendency',
    'tendancies'        => 'tendencies',
    'tendancy'          => 'tendency',
    'tepmorarily'       => 'temporarily',
    'terrestial'        => 'terrestrial',
    'terriories'        => 'territories',
    'terriory'          => 'territory',
    'territorist'       => 'terrorist',
    'territoy'          => 'territory',
    'terroist'          => 'terrorist',
    'testiclular'       => 'testicular',
    'tghe'              => 'the',
    'theather'          => 'theater',
    'theese'            => 'these',
    'theif'             => 'thief',
    'theives'           => 'thieves',
    'themselfs'         => 'themselves',
    'themslves'         => 'themselves',
    'therafter'         => 'thereafter',
    'therby'            => 'thereby',
    'theri'             => 'their',
    'ther'              => 'there, their, the',
    'thgat'             => 'that',
    'thge'              => 'the',
    'thier'             => 'their',
    'thigns'            => 'things',
    'thign'             => 'thing',
    'thigsn'            => 'things',
    'thikning'          => 'thinking, thickening',
    'thikns'            => 'thinks',
    'thikn'             => 'think',
    'thiunk'            => 'think',
    'thna'              => 'than',
    'thne'              => 'then',
    'thnigs'            => 'things',
    'thnig'             => 'thing',
    'thn'               => 'then',
    'thoughout'         => 'throughout',
    'threatend'         => 'threatened',
    'threatning'        => 'threatening',
    'threee'            => 'three',
    'threshhold'        => 'threshold',
    'thrid'             => 'third',
    'throrough'         => 'thorough',
    'throughly'         => 'thoroughly',
    'throught'          => 'through',
    'througout'         => 'throughout',
    'thru'              => 'through',
    'thsi'              => 'this',
    'thsoe'             => 'those',
    'thta'              => 'that',
    'thyat'             => 'that',
    'tiem'              => 'time, Tim',
    'tihkn'             => 'think',
    'tihs'              => 'this',
    'timne'             => 'time',
    'tiome'             => 'time',
    'tje'               => 'the',
    'tjhe'              => 'the',
    'tkaes'             => 'takes',
    'tkae'              => 'take',
    'tkaing'            => 'taking',
    'tlaking'           => 'talking',
    'tobbaco'           => 'tobacco',
    'todya'             => 'today',
    'toghether'         => 'together',
    'toke'              => 'took',
    'tolerence'         => 'tolerance',
    'tomatos'           => 'tomatoes',
    'tommorow'          => 'tomorrow',
    'tommorrow'         => 'tomorrow',
    'tongiht'           => 'tonight',
    'toriodal'          => 'toroidal',
    'tormenters'        => 'tormentors',
    'tornadoe'          => 'tornado',
    'torpeados'         => 'torpedoes',
    'torpedos'          => 'torpedoes',
    'toubles'           => 'troubles',
    'tounge'            => 'tongue',
    'tourch'            => 'torch, touch',
    'towords'           => 'towards',
    'towrad'            => 'toward',
    'tradionally'       => 'traditionally',
    'traditionaly'      => 'traditionally',
    'traditionnal'      => 'traditional',
    'traditition'       => 'tradition',
    'tradtionally'      => 'traditionally',
    'trafficed'         => 'trafficked',
    'trafficing'        => 'trafficking',
    'trafic'            => 'traffic',
    'trancendent'       => 'transcendent',
    'trancending'       => 'transcending',
    'tranformed'        => 'transformed',
    'tranform'          => 'transform',
    'transcendance'     => 'transcendence',
    'transcendant'      => 'transcendent',
    'transcendentational' => 'transcendental',
    'transcripting'       => 'transcribing, transcription',
    'transending'         => 'transcending',
    'transesxuals'        => 'transsexuals',
    'transfered'          => 'transferred',
    'transfering'         => 'transferring',
    'transformaton'       => 'transformation',
    'transistion'         => 'transition',
    'translaters'         => 'translators',
    'translater'          => 'translator',
    'transmissable'       => 'transmissible',
    'transporation'       => 'transportation',
    'trasmission'         => 'transmission',
    'tremelos'            => 'tremolos',
    'tremelo'             => 'tremolo',
    'treshold'            => 'threshold',
    'trigerring'          => 'triggering',
    'triguered'           => 'triggered',
    'triology'            => 'trilogy',
    'troling'             => 'trolling',
    'troups'              => 'troupes, troops',
    'troup'               => 'troupe',
    'truely'              => 'truly',
    'trustworthyness'     => 'trustworthiness',
    'turnk'               => 'turnkey, trunk',
    'tust'                => 'trust',
    'twelth'              => 'twelfth',
    'twon'                => 'town',
    'twpo'                => 'two',
    'tyhat'               => 'that',
    'tyhe'                => 'they',
    'typcial'             => 'typical',
    'typicaly'            => 'typically',
    'tyranies'            => 'tyrannies',
    'tyrany'              => 'tyranny',
    'tyrranies'           => 'tyrannies',
    'tyrrany'             => 'tyranny',
    'ubiquitious'         => 'ubiquitous',
    'ublisher'            => 'publisher',
    'uise'                => 'use',
    'ultimely'            => 'ultimately',
    'unacompanied'        => 'unaccompanied',
    'unahppy'             => 'unhappy',
    'unanymous'           => 'unanimous',
    'unathorised'         => 'unauthorised',
    'unavailible'         => 'unavailable',
    'unballance'          => 'unbalance',
    'unbeknowst'          => 'unbeknownst',
    'unbeleivable'        => 'unbelievable',
    'uncertainity'        => 'uncertainty',
    'unchallengable'      => 'unchallengeable',
    'unchangable'         => 'unchangeable',
    'uncompetive'         => 'uncompetitive',
    'unconciousness'      => 'unconsciousness',
    'unconcious'          => 'unconscious',
    'unconfortability'    => 'discomfort',
    'uncontitutional'     => 'unconstitutional',
    'unconvential'        => 'unconventional',
    'undecideable'        => 'undecidable',
    'understoon'          => 'understood',
    'undesireable'        => 'undesirable',
    'undetecable'         => 'undetectable',
    'undoubtely'          => 'undoubtedly',
    'undreground'         => 'underground',
    'uneccesary'          => 'unnecessary',
    'unecessary'          => 'unnecessary',
    'unequalities'        => 'inequalities',
    'unexecpted'          => 'unexpected',
    'unforetunately'      => 'unfortunately',
    'unforgetable'        => 'unforgettable',
    'unforgiveable'       => 'unforgivable',
    'unfortunatelly'      => 'unfortunately',
    'unfortunatley'       => 'unfortunately',
    'unfortunatly'        => 'unfortunately',
    'unfourtunately'      => 'unfortunately',
    'unihabited'          => 'uninhabited',
    'unilateraly'         => 'unilaterally',
    'unilatreally'        => 'unilaterally',
    'unilatreal'          => 'unilateral',
    'uninterruped'        => 'uninterrupted',
    'uninterupted'        => 'uninterrupted',
    'univeral'            => 'universal',
    'univeristies'        => 'universities',
    'univeristy'          => 'university',
    'univerity'           => 'university',
    'universtiy'          => 'university',
    'univesities'         => 'universities',
    'univesity'           => 'university',
    'unknonw'             => 'unknown',
    'unkown'              => 'unknown',
    'unlikey'             => 'unlikely',
    'unmanouverable'      => 'unmaneuverable, unmanoeuvrable',
    'unmistakeably'       => 'unmistakably',
    'unneccesarily'       => 'unnecessarily',
    'unneccesary'         => 'unnecessary',
    'unneccessarily'      => 'unnecessarily',
    'unneccessary'        => 'unnecessary',
    'unnecesarily'        => 'unnecessarily',
    'unnecesary'          => 'unnecessary',
    'unoffical'           => 'unofficial',
    'unoperational'       => 'nonoperational',
    'unoticeable'         => 'unnoticeable',
    'unplease'            => 'displease',
    'unplesant'           => 'unpleasant',
    'unprecendented'      => 'unprecedented',
    'unprecidented'       => 'unprecedented',
    'unrepentent'         => 'unrepentant',
    'unrepetant'          => 'unrepentant',
    'unrepetent'          => 'unrepentant',
    'unsed'               => 'used, unused, unsaid',
    'unsubstanciated'     => 'unsubstantiated',
    'unsuccesfully'       => 'unsuccessfully',
    'unsuccesful'         => 'unsuccessful',
    'unsuccessfull'       => 'unsuccessful',
    'unsucesful'          => 'unsuccessful',
    'unsucesfuly'         => 'unsuccessfully',
    'unsucessfull'        => 'unsuccessful',
    'unsucessfully'       => 'unsuccessfully',
    'unsucessful'         => 'unsuccessful',
    'unsuprised'          => 'unsurprised',
    'unsuprisingly'       => 'unsurprisingly',
    'unsuprising'         => 'unsurprising',
    'unsuprized'          => 'unsurprised',
    'unsuprizingly'       => 'unsurprisingly',
    'unsuprizing'         => 'unsurprising',
    'unsurprized'         => 'unsurprised',
    'unsurprizingly'      => 'unsurprisingly',
    'unsurprizing'        => 'unsurprising',
    'untill'              => 'until',
    'untranslateable'     => 'untranslatable',
    'unuseable'           => 'unusable',
    'unuseful'            => 'useless',
    'unusuable'           => 'unusable',
    'unviersity'          => 'university',
    'unwarrented'         => 'unwarranted',
    'unweildly'           => 'unwieldy',
    'unwieldly'           => 'unwieldy',
    'upcomming'           => 'upcoming',
    'upgradded'           => 'upgraded',
    'usally'              => 'usually',
    'useage'              => 'usage',
    'usefull'             => 'useful',
    'usefuly'             => 'usefully',
    'useing'              => 'using',
    'usera'               => 'users',
    'usetnet'             => 'Usenet',
    'usualy'              => 'usually',
    'ususally'            => 'usually',
    'utilites'            => 'utilities',
    'utillities'          => 'utilities',
    'utilties'            => 'utilities',
    'utiltity'            => 'utility',
    'utitlty'             => 'utility',
    'vaccume'             => 'vacuum',
    'vaccum'              => 'vacuum',
    'vacinity'            => 'vicinity',
    'vaieties'            => 'varieties',
    'vailidty'            => 'validity',
    'valuble'             => 'valuable',
    'valueable'           => 'valuable',
    'varations'           => 'variations',
    'variantions'         => 'variations',
    'varient'             => 'variant',
    'variey'              => 'variety',
    'varing'              => 'varying',
    'varities'            => 'varieties',
    'varity'              => 'variety',
    'vegatarian'          => 'vegetarian',
    'vegitables'          => 'vegetables',
    'vegitable'           => 'vegetable',
    'vegtable'            => 'vegetable',
    'vehicule'            => 'vehicle',
    'vell'                => 'well',
    'venemous'            => 'venomous',
    'vengance'            => 'vengeance',
    'vengence'            => 'vengeance',
    'verbse'              => 'verbose',
    'verfication'         => 'verification',
    'verisons'            => 'versions',
    'verison'             => 'version',
    'vermillion'          => 'vermilion',
    'versitilaty'         => 'versatility',
    'versitlity'          => 'versatility',
    'verson'              => 'version',
    'vetween'             => 'between',
    'veyr'                => 'very',
    'vigeur'              => 'vigueur, vigour, vigor',
    'vigilence'           => 'vigilance',
    'vigourous'           => 'vigorous',
    'villian'             => 'villain',
    'villification'       => 'vilification',
    'villify'             => 'vilify',
    'villin'              => 'villi, villain, villein',
    'vincinity'           => 'vicinity',
    'violentce'           => 'violence',
    'virtualy'            => 'virtually',
    'virutally'           => 'virtually',
    'virutal'             => 'virtual',
    'visable'             => 'visible',
    'visably'             => 'visibly',
    'visting'             => 'visiting',
    'vistors'             => 'visitors',
    'vitories'            => 'victories',
    'vitual'              => 'virtual',
    'volcanoe'            => 'volcano',
    'voleyball'           => 'volleyball',
    'volontary'           => 'voluntary',
    'volonteered'         => 'volunteered',
    'volonteering'        => 'volunteering',
    'volonteers'          => 'volunteers',
    'volonteer'           => 'volunteer',
    'volounteered'        => 'volunteered',
    'volounteering'       => 'volunteering',
    'volounteers'         => 'volunteers',
    'volounteer'          => 'volunteer',
    'volumne'             => 'volume',
    'vreity'              => 'variety',
    'vrey'                => 'very',
    'vriety'              => 'variety',
    'vulnerablility'      => 'vulnerability',
    'vyer'                => 'very',
    'vyre'                => 'very',
    'waht'                => 'what',
    'wanna'               => 'want to',
    'warantee'            => 'warranty',
    'wardobe'             => 'wardrobe',
    'warrent'             => 'warrant',
    'warrriors'           => 'warriors',
    'wass'                => 'was',
    'watn'                => 'want',
    'weaponary'           => 'weaponry',
    'weas'                => 'was',
    'wehn'                => 'when',
    'weilded'             => 'wielded',
    'weild'               => 'wield, wild',
    'wendsay'             => 'Wednesday',
    'wensday'             => 'Wednesday',
    'wereabouts'          => 'whereabouts',
    'whants'              => 'wants',
    'whant'               => 'want',
    'whataver'            => 'whatever',
    'whcih'               => 'which',
    'wheras'              => 'whereas',
    'wherease'            => 'whereas',
    'whereever'           => 'wherever',
    'wheter'              => 'whether',
    'whic'                => 'which',
    'whihc'               => 'which',
    'whith'               => 'with',
    'whlch'               => 'which',
    'whn'                 => 'when',
    'wholey'              => 'wholly',
    'wholy'               => 'wholly, holy',
    'whta'                => 'what',
    'whther'              => 'whether',
    'wich'                => 'which, witch',
    'widesread'           => 'widespread',
    'wief'                => 'wife',
    'wierd'               => 'weird',
    'wiew'                => 'view',
    'wiht'                => 'with',
    'wih'                 => 'with',
    'wille'               => 'will',
    'willingless'         => 'willingness',
    'willk'               => 'will',
    'wirting'             => 'writing',
    'withdrawl'           => 'withdrawal, withdraw',
    'witheld'             => 'withheld',
    'withh'               => 'with',
    'withing'             => 'within',
    'withold'             => 'withhold',
    'witht'               => 'with',
    'witn'                => 'with',
    'wiull'               => 'will',
    'wnated'              => 'wanted',
    'wnats'               => 'wants',
    'wnat'                => 'want',
    'wohle'               => 'whole',
    'wokring'             => 'working',
    'wokr'                => 'work',
    'wonderfull'          => 'wonderful',
    'wordlwide'           => 'worldwide',
    'workststion'         => 'workstation',
    'worls'               => 'world',
    'worstened'           => 'worsened',
    'woudl'               => 'would',
    'wresters'            => 'wrestlers',
    'wriet'               => 'write',
    'writen'              => 'written',
    'wroet'               => 'wrote',
    'wroking'             => 'working',
    'wrok'                => 'work',
    'wtih'                => 'with',
    'wupport'             => 'support',
    'yaching'             => 'yachting',
    'yaerly'              => 'yearly',
    'yaers'               => 'years',
    'yaer'                => 'year',
    'yatch'               => 'yacht',
    'yearm'               => 'year',
    'yeasr'               => 'years',
    'yeilding'            => 'yielding',
    'yeild'               => 'yield',
    'yeras'               => 'years',
    'yera'                => 'year',
    'yersa'               => 'years',
    'yotube'              => 'youtube',
    'youself'             => 'yourself',
    'yrea'                => 'year',
    'ytou'                => 'you',
    'yuo'                 => 'you',
    'yur'                 => 'your',
    'zeebra'              => 'zebra'
);

sub new {
    my ($class, $additionalSpellings) = @_;

    # If a custom dictionary was specified, merge it with the default dictionary
    my $dictionary = \%spellings;
    if (defined $additionalSpellings) {
        %{$dictionary} = %spellings;
        while ( my ($misspelling, $correction) =
            each %{$additionalSpellings} )
        {
            $dictionary->{$misspelling} = $correction;
        }
    }

    my $misspellingPattern = join '|', (keys %spellings);

    return bless {
        'spellings'      => $dictionary,
        'anyMisspelling' => qr/$misspellingPattern/
    }, $class;
}

# Look for common mispellings in comments and names
sub _spellcheckLine {
    my ($self, $line) = @_;
    my $lowerCaseLine = lc $line;

    # Disqualify lines that don't contain any misspelling, without
    # regard for case, because they certainly won't contain a misspelling
    # when we perform the slower search with regard for case.
    return if $lowerCaseLine !~ $self->{anyMisspelling};

    foreach my $key (keys %{ $self->{spellings} }) {
        next if $lowerCaseLine !~ /$key/;

        my ($before, $match, $after) = $line =~ /(.?)($key)(.?)/i;
        if (defined $match && $match =~ /^(?:[A-Z]+|(?:[A-Z]?[a-z]+))$/) {

            # Only report issues where the characters on either side of the
            # match are either non-alphabetic or represent a change in case
            # from left to right of lower case to upper-case. This matches
            # what we see in most variable names (i.e. you see 'numFrames'
            # but not 'NUMfRAMES').
            my $boundaryBefore =
                !$before
              || $before =~ /[^a-z]/i
              || ($before =~ /[a-z]/ && $match =~ /^[A-Z]/);
            next if !$boundaryBefore;

            my $boundaryAfter =
                !$after
              || $after =~ /[^a-z]/i
              || ($match =~ /[a-z]$/ && $after =~ /[A-Z]$/);
            next if !$boundaryAfter;

            return ($key, $self->{spellings}->{$key})
              if ($boundaryBefore && $boundaryAfter);
        }
    }

    return;
}

sub spellcheck {
    my ($self, $file) = @_;
    my $fileHandle = IO::File->new($file, 'r')
      or die("Cannot open $file for spellchecking");

    my $lineNum = 0;
    my @results = ();
    while (my $line = $fileHandle->getline) {
        $lineNum++;

        # Don't process empty lines further
        chomp $line;
        next if !length($line);

        my ($misspelling, $correction) = $self->_spellcheckLine($line);
        if (defined $misspelling && defined $misspelling) {
            push @results,
              {
                'line'        => $lineNum,
                'misspelling' => $misspelling,
                'correction'  => $correction
              };
        }
    }

    return @results;
}

1;
__END__

=head1 NAME

Sourcecode::Spellchecker - Detects common misspellings in source code and suggests corrections.

=head1 SYNOPSIS

  use Sourcecode::Spellchecker

  my $checker = new Sourcecode::Spellchecker;
  
  my $sourceFileName = 'MySourceFile.cpp';
  my @results = $checker->spellcheck($sourceFileName);
  if (@results) {
    foreach my $result (@results) {
      print "$sourceFileName:$result->{line}: "
        "'$result->{misspelling}' should be '$result->{correction}'\n";
      }
  }
  else {
    print "No spelling mistakes found.\n";
  }

=head1 DESCRIPTION

This module scans a source file for common misspellings - including in comments, string literals, and identifier names - and suggests corrections.

For example, this module will find 'strat' (a misspelling of 'start') in the following lines:

  my $strat;
  const unsigned long STRAT_TIME = 0;
  int stratTime;
  Dim TimeToStrat As Integer
  const char* szMsg = "It is time to strat.";
  // This is a comment indicating when we will strat

However, it will purposefully not find misspellings in the following lines because 'strat' is embedded in another word or split in two by a change in case:

  std::string s = other.strAt(2);
  Strategy strategy = Strategy.RunFast;
 
=head1 CONSTRUCTOR

=head2 new

  use Sourcecode::Spellchecker;
  my $checker = new Sourcecode::Spellchecker({
       'hootdoog' => 'hotdog',
       'hambergr' => 'hamburger'
  });

Optionally takes a reference to a hash containing additional misspelling-spelling pairs to search for. If no argument is supplied, the default list of misspellings is used.

Returns a newly created C<Sourcecode::Spellchecker> object.

=head1 METHODS

=head2 spellcheck($filename)

Returns a list of misspellings of the form:

  (
    {line => 1, misspelling => 'sofware', correction => 'software'},
    {line => 7, misspelling => 'speach', correction => 'speech'}
  )

=head1 SEE ALSO

C<spellcheck_source.pl> - Checks a source file for common misspellings.

The list of common misspellings and corrections used by this module is
primarily from Wikipedia's "List of commonly mispelled words" page
at L<http://en.wikipedia.org/wiki/Wikipedia:Lists_of_common_misspellings>.

=head1 AUTHOR

Zachary Blair, E<lt>zblair@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2013 by Zachary Blair

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.8 or,
at your option, any later version of Perl 5 you may have available.

=cut
