/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.error;

import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.jdbc.EmbedSQLException;

public class StandardException
extends Exception {
    public static final int REPORT_DEFAULT = 0;
    public static final int REPORT_NEVER = 1;
    public static final int REPORT_ALWAYS = 2;
    private Throwable nestedException;
    private transient Object[] arguments;
    private int severity;
    private String textMessage;
    private String sqlState;
    private transient int report;

    protected StandardException(String string) {
        this(string, null, null);
    }

    protected StandardException(String string, Object[] objectArray) {
        this(string, null, objectArray);
    }

    protected StandardException(String string, Throwable throwable, Object[] objectArray) {
        super(string);
        this.severity = StandardException.getSeverityFromIdentifier(string);
        this.sqlState = StandardException.getSQLStateFromIdentifier(string);
        this.nestedException = throwable;
        this.arguments = objectArray;
    }

    private StandardException(String string, String string2) {
        this(string);
        this.textMessage = string2;
    }

    private final void setArguments(Object[] objectArray) {
        this.arguments = objectArray;
    }

    public final Object[] getArguments() {
        return this.arguments;
    }

    public final void setNestedException(Throwable throwable) {
        this.nestedException = throwable;
    }

    public final Throwable getNestedException() {
        return this.nestedException;
    }

    public final int report() {
        return this.report;
    }

    public final void setReport(int n) {
        this.report = n;
    }

    public final void setSeverity(int n) {
        this.severity = n;
    }

    public final int getSeverity() {
        return this.severity;
    }

    public final int getErrorCode() {
        return this.severity;
    }

    public final String getSQLState() {
        return this.sqlState;
    }

    public static String getSQLStateFromIdentifier(String string) {
        if (string.length() == 5) {
            return string;
        }
        return string.substring(0, 5);
    }

    public static int getSeverityFromIdentifier(String string) {
        int n = 0;
        block0 : switch (string.length()) {
            case 5: {
                block3 : switch (string.charAt(0)) {
                    case '0': {
                        switch (string.charAt(1)) {
                            case '1': {
                                n = 10000;
                                break;
                            }
                            case '7': 
                            case 'A': {
                                n = 20000;
                                break;
                            }
                            case '8': {
                                n = 40000;
                            }
                        }
                        break;
                    }
                    case '2': 
                    case '3': {
                        n = 20000;
                        break;
                    }
                    case '4': {
                        switch (string.charAt(1)) {
                            case '0': {
                                n = 30000;
                                break block3;
                            }
                            case '2': {
                                n = 20000;
                            }
                        }
                    }
                }
                break;
            }
            default: {
                switch (string.charAt(6)) {
                    case 'M': {
                        n = 50000;
                        break block0;
                    }
                    case 'D': {
                        n = 45000;
                        break block0;
                    }
                    case 'C': {
                        n = 40000;
                        break block0;
                    }
                    case 'T': {
                        n = 30000;
                        break block0;
                    }
                    case 'S': {
                        n = 20000;
                        break block0;
                    }
                    case 'U': {
                        n = 0;
                    }
                }
            }
        }
        return n;
    }

    public static StandardException normalClose() {
        StandardException standardException = StandardException.newException("XXXXX.C.6");
        standardException.report = 1;
        return standardException;
    }

    public static StandardException errorClose(Throwable throwable) {
        StandardException standardException = StandardException.newException("08003", throwable);
        standardException.report = 1;
        return standardException;
    }

    public static StandardException newException(String string) {
        return new StandardException(string);
    }

    public static StandardException newException(String string, Throwable throwable) {
        return new StandardException(string, throwable, null);
    }

    public static StandardException newException(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return new StandardException(string, objectArray);
    }

    public static StandardException newException(String string, Throwable throwable, Object object) {
        Object[] objectArray = new Object[]{object};
        return new StandardException(string, throwable, objectArray);
    }

    public static StandardException newException(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return new StandardException(string, objectArray);
    }

    public static StandardException newException(String string, Throwable throwable, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return new StandardException(string, throwable, objectArray);
    }

    public static StandardException newException(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return new StandardException(string, objectArray);
    }

    public static StandardException newException(String string, Throwable throwable, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return new StandardException(string, throwable, objectArray);
    }

    public static StandardException newException(String string, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return new StandardException(string, objectArray);
    }

    public static StandardException newException(String string, Throwable throwable, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return new StandardException(string, throwable, objectArray);
    }

    public static StandardException newException(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5};
        return new StandardException(string, objectArray);
    }

    public static StandardException newException(String string, Throwable throwable, Object object, Object object2, Object object3, Object object4, Object object5) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5};
        return new StandardException(string, throwable, objectArray);
    }

    public static StandardException newException(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6};
        return new StandardException(string, objectArray);
    }

    public static StandardException newException(String string, Throwable throwable, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6};
        return new StandardException(string, throwable, objectArray);
    }

    public static StandardException newException(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7};
        return new StandardException(string, objectArray);
    }

    public static StandardException newException(String string, Throwable throwable, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7};
        return new StandardException(string, throwable, objectArray);
    }

    public static StandardException newException(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8};
        return new StandardException(string, objectArray);
    }

    public static StandardException newException(String string, Throwable throwable, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8};
        return new StandardException(string, throwable, objectArray);
    }

    public static StandardException newPreLocalizedException(String string, Throwable throwable, String string2) {
        StandardException standardException = new StandardException(string, string2);
        if (throwable != null) {
            standardException.nestedException = throwable;
        }
        return standardException;
    }

    public static StandardException unexpectedUserException(Throwable throwable) {
        Object object;
        Object object2;
        if (throwable instanceof SQLException && !(throwable instanceof EmbedSQLException) && (object2 = ((SQLException)(object = (SQLException)throwable)).getSQLState()) != null && ((String)object2).length() == 5 && ((String)object2).startsWith("38") && !((String)object2).equals("38000")) {
            StandardException standardException = new StandardException((String)object2, ((Throwable)object).getMessage());
            if (((SQLException)object).getNextException() != null) {
                standardException.setNestedException(((SQLException)object).getNextException());
            }
            return standardException;
        }
        if (throwable instanceof EmbedSQLException && ((EmbedSQLException)(object = (EmbedSQLException)throwable)).isSimpleWrapper() && (object2 = ((EmbedSQLException)object).getJavaException()) instanceof StandardException) {
            return (StandardException)object2;
        }
        if (throwable instanceof StandardException) {
            return (StandardException)throwable;
        }
        boolean bl = false;
        if (throwable instanceof EmbedSQLException) {
            object = ((EmbedSQLException)throwable).toString();
            bl = true;
        } else {
            object = throwable.getMessage();
        }
        object = object == null ? "" : ((String)object).trim();
        if (((String)object).length() == 0) {
            object = throwable.getClass().getName();
        } else if (!bl) {
            object = throwable.getClass().getName() + ": " + (String)object;
        }
        StandardException standardException = StandardException.newException("38000", throwable, object);
        return standardException;
    }

    public static StandardException plainWrapException(Throwable throwable) {
        Object object;
        Object object2;
        if (throwable instanceof StandardException) {
            return (StandardException)throwable;
        }
        if (throwable instanceof SQLException && (object2 = ((SQLException)(object = (SQLException)throwable)).getSQLState()) != null) {
            StandardException standardException = new StandardException((String)object2, "(" + ((SQLException)object).getErrorCode() + ") " + ((Throwable)object).getMessage());
            if ((object = ((SQLException)object).getNextException()) != null) {
                standardException.setNestedException(StandardException.plainWrapException((Throwable)object));
            }
            return standardException;
        }
        object = throwable.getMessage();
        object = object == null ? "" : ((String)object).trim();
        object2 = StandardException.newException("XJ001.U", throwable, object, (Object)throwable.getClass().getName());
        return object2;
    }

    public static StandardException closeException() {
        StandardException standardException = StandardException.newException("close.C.1");
        standardException.setReport(1);
        return standardException;
    }

    public String getMessage() {
        if (this.textMessage == null) {
            this.textMessage = MessageService.getCompleteMessage(this.getMessageId(), this.getArguments());
        }
        return this.textMessage;
    }

    public final String getMessageId() {
        return super.getMessage();
    }

    public String getErrorProperty(String string) {
        return StandardException.getErrorProperty(this.getMessageId(), string);
    }

    public String toString() {
        String string = this.getMessage();
        return "ERROR " + this.getSQLState() + ": " + string;
    }

    private static String getErrorProperty(String string, String string2) {
        return MessageService.getProperty(string, string2);
    }

    public static StandardException interrupt(InterruptedException interruptedException) {
        StandardException standardException = StandardException.newException("08000", interruptedException);
        return standardException;
    }

    public static SQLWarning newWarning(String string) {
        return StandardException.newWarningCommon(string, null);
    }

    public static SQLWarning newWarning(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return StandardException.newWarningCommon(string, objectArray);
    }

    public static SQLWarning newWarning(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return StandardException.newWarningCommon(string, objectArray);
    }

    private static SQLWarning newWarningCommon(String string, Object[] objectArray) {
        String string2 = MessageService.getCompleteMessage(string, objectArray);
        String string3 = StandardException.getSQLStateFromIdentifier(string);
        SQLWarning sQLWarning = new SQLWarning(string2, string3, 10000);
        return sQLWarning;
    }
}

