######################################################################
#
# t/4252_utf8_by_sjis_z_12of12.t
#
# Copyright (c) 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

sub BEGIN {
    eval q<
        use FindBin;
        use lib "$FindBin::Bin/..";
    >;
}
require 'lib/jacode.pl';

# avoid "Allocation too large"
@todo = (
("\xFA\x9C",'utf8','sjis','z',"\xEF\xA8\x90"),
("\xFA\x9D",'utf8','sjis','z',"\xE5\xA2\x9E"),
("\xFA\x9E",'utf8','sjis','z',"\xE5\xA2\xB2"),
("\xFA\x9F",'utf8','sjis','z',"\xE5\xA4\x8B"),
("\xFA\xA0",'utf8','sjis','z',"\xE5\xA5\x93"),
("\xFA\xA1",'utf8','sjis','z',"\xE5\xA5\x9B"),
("\xFA\xA2",'utf8','sjis','z',"\xE5\xA5\x9D"),
("\xFA\xA3",'utf8','sjis','z',"\xE5\xA5\xA3"),
("\xFA\xA4",'utf8','sjis','z',"\xE5\xA6\xA4"),
("\xFA\xA5",'utf8','sjis','z',"\xE5\xA6\xBA"),
("\xFA\xA6",'utf8','sjis','z',"\xE5\xAD\x96"),
("\xFA\xA7",'utf8','sjis','z',"\xE5\xAF\x80"),
("\xFA\xA8",'utf8','sjis','z',"\xE7\x94\xAF"),
("\xFA\xA9",'utf8','sjis','z',"\xE5\xAF\x98"),
("\xFA\xAA",'utf8','sjis','z',"\xE5\xAF\xAC"),
("\xFA\xAB",'utf8','sjis','z',"\xE5\xB0\x9E"),
("\xFA\xAC",'utf8','sjis','z',"\xE5\xB2\xA6"),
("\xFA\xAD",'utf8','sjis','z',"\xE5\xB2\xBA"),
("\xFA\xAE",'utf8','sjis','z',"\xE5\xB3\xB5"),
("\xFA\xAF",'utf8','sjis','z',"\xE5\xB4\xA7"),
("\xFA\xB0",'utf8','sjis','z',"\xE5\xB5\x93"),
("\xFA\xB1",'utf8','sjis','z',"\xEF\xA8\x91"),
("\xFA\xB2",'utf8','sjis','z',"\xE5\xB5\x82"),
("\xFA\xB3",'utf8','sjis','z',"\xE5\xB5\xAD"),
("\xFA\xB4",'utf8','sjis','z',"\xE5\xB6\xB8"),
("\xFA\xB5",'utf8','sjis','z',"\xE5\xB6\xB9"),
("\xFA\xB6",'utf8','sjis','z',"\xE5\xB7\x90"),
("\xFA\xB7",'utf8','sjis','z',"\xE5\xBC\xA1"),
("\xFA\xB8",'utf8','sjis','z',"\xE5\xBC\xB4"),
("\xFA\xB9",'utf8','sjis','z',"\xE5\xBD\xA7"),
("\xFA\xBA",'utf8','sjis','z',"\xE5\xBE\xB7"),
("\xFA\xBB",'utf8','sjis','z',"\xE5\xBF\x9E"),
("\xFA\xBC",'utf8','sjis','z',"\xE6\x81\x9D"),
("\xFA\xBD",'utf8','sjis','z',"\xE6\x82\x85"),
("\xFA\xBE",'utf8','sjis','z',"\xE6\x82\x8A"),
("\xFA\xBF",'utf8','sjis','z',"\xE6\x83\x9E"),
("\xFA\xC0",'utf8','sjis','z',"\xE6\x83\x95"),
("\xFA\xC1",'utf8','sjis','z',"\xE6\x84\xA0"),
("\xFA\xC2",'utf8','sjis','z',"\xE6\x83\xB2"),
("\xFA\xC3",'utf8','sjis','z',"\xE6\x84\x91"),
("\xFA\xC4",'utf8','sjis','z',"\xE6\x84\xB7"),
("\xFA\xC5",'utf8','sjis','z',"\xE6\x84\xB0"),
("\xFA\xC6",'utf8','sjis','z',"\xE6\x86\x98"),
("\xFA\xC7",'utf8','sjis','z',"\xE6\x88\x93"),
("\xFA\xC8",'utf8','sjis','z',"\xE6\x8A\xA6"),
("\xFA\xC9",'utf8','sjis','z',"\xE6\x8F\xB5"),
("\xFA\xCA",'utf8','sjis','z',"\xE6\x91\xA0"),
("\xFA\xCB",'utf8','sjis','z',"\xE6\x92\x9D"),
("\xFA\xCC",'utf8','sjis','z',"\xE6\x93\x8E"),
("\xFA\xCD",'utf8','sjis','z',"\xE6\x95\x8E"),
("\xFA\xCE",'utf8','sjis','z',"\xE6\x98\x80"),
("\xFA\xCF",'utf8','sjis','z',"\xE6\x98\x95"),
("\xFA\xD0",'utf8','sjis','z',"\xE6\x98\xBB"),
("\xFA\xD1",'utf8','sjis','z',"\xE6\x98\x89"),
("\xFA\xD2",'utf8','sjis','z',"\xE6\x98\xAE"),
("\xFA\xD3",'utf8','sjis','z',"\xE6\x98\x9E"),
("\xFA\xD4",'utf8','sjis','z',"\xE6\x98\xA4"),
("\xFA\xD5",'utf8','sjis','z',"\xE6\x99\xA5"),
("\xFA\xD6",'utf8','sjis','z',"\xE6\x99\x97"),
("\xFA\xD7",'utf8','sjis','z',"\xE6\x99\x99"),
("\xFA\xD8",'utf8','sjis','z',"\xEF\xA8\x92"),
("\xFA\xD9",'utf8','sjis','z',"\xE6\x99\xB3"),
("\xFA\xDA",'utf8','sjis','z',"\xE6\x9A\x99"),
("\xFA\xDB",'utf8','sjis','z',"\xE6\x9A\xA0"),
("\xFA\xDC",'utf8','sjis','z',"\xE6\x9A\xB2"),
("\xFA\xDD",'utf8','sjis','z',"\xE6\x9A\xBF"),
("\xFA\xDE",'utf8','sjis','z',"\xE6\x9B\xBA"),
("\xFA\xDF",'utf8','sjis','z',"\xE6\x9C\x8E"),
("\xFA\xE0",'utf8','sjis','z',"\xEF\xA4\xA9"),
("\xFA\xE1",'utf8','sjis','z',"\xE6\x9D\xA6"),
("\xFA\xE2",'utf8','sjis','z',"\xE6\x9E\xBB"),
("\xFA\xE3",'utf8','sjis','z',"\xE6\xA1\x92"),
("\xFA\xE4",'utf8','sjis','z',"\xE6\x9F\x80"),
("\xFA\xE5",'utf8','sjis','z',"\xE6\xA0\x81"),
("\xFA\xE6",'utf8','sjis','z',"\xE6\xA1\x84"),
("\xFA\xE7",'utf8','sjis','z',"\xE6\xA3\x8F"),
("\xFA\xE8",'utf8','sjis','z',"\xEF\xA8\x93"),
("\xFA\xE9",'utf8','sjis','z',"\xE6\xA5\xA8"),
("\xFA\xEA",'utf8','sjis','z',"\xEF\xA8\x94"),
("\xFA\xEB",'utf8','sjis','z',"\xE6\xA6\x98"),
("\xFA\xEC",'utf8','sjis','z',"\xE6\xA7\xA2"),
("\xFA\xED",'utf8','sjis','z',"\xE6\xA8\xB0"),
("\xFA\xEE",'utf8','sjis','z',"\xE6\xA9\xAB"),
("\xFA\xEF",'utf8','sjis','z',"\xE6\xA9\x86"),
("\xFA\xF0",'utf8','sjis','z',"\xE6\xA9\xB3"),
("\xFA\xF1",'utf8','sjis','z',"\xE6\xA9\xBE"),
("\xFA\xF2",'utf8','sjis','z',"\xE6\xAB\xA2"),
("\xFA\xF3",'utf8','sjis','z',"\xE6\xAB\xA4"),
("\xFA\xF4",'utf8','sjis','z',"\xE6\xAF\x96"),
("\xFA\xF5",'utf8','sjis','z',"\xE6\xB0\xBF"),
("\xFA\xF6",'utf8','sjis','z',"\xE6\xB1\x9C"),
("\xFA\xF7",'utf8','sjis','z',"\xE6\xB2\x86"),
("\xFA\xF8",'utf8','sjis','z',"\xE6\xB1\xAF"),
("\xFA\xF9",'utf8','sjis','z',"\xE6\xB3\x9A"),
("\xFA\xFA",'utf8','sjis','z',"\xE6\xB4\x84"),
("\xFA\xFB",'utf8','sjis','z',"\xE6\xB6\x87"),
("\xFA\xFC",'utf8','sjis','z',"\xE6\xB5\xAF"),
("\xFB\x40",'utf8','sjis','z',"\xE6\xB6\x96"),
("\xFB\x41",'utf8','sjis','z',"\xE6\xB6\xAC"),
("\xFB\x42",'utf8','sjis','z',"\xE6\xB7\x8F"),
("\xFB\x43",'utf8','sjis','z',"\xE6\xB7\xB8"),
("\xFB\x44",'utf8','sjis','z',"\xE6\xB7\xB2"),
("\xFB\x45",'utf8','sjis','z',"\xE6\xB7\xBC"),
("\xFB\x46",'utf8','sjis','z',"\xE6\xB8\xB9"),
("\xFB\x47",'utf8','sjis','z',"\xE6\xB9\x9C"),
("\xFB\x48",'utf8','sjis','z',"\xE6\xB8\xA7"),
("\xFB\x49",'utf8','sjis','z',"\xE6\xB8\xBC"),
("\xFB\x4A",'utf8','sjis','z',"\xE6\xBA\xBF"),
("\xFB\x4B",'utf8','sjis','z',"\xE6\xBE\x88"),
("\xFB\x4C",'utf8','sjis','z',"\xE6\xBE\xB5"),
("\xFB\x4D",'utf8','sjis','z',"\xE6\xBF\xB5"),
("\xFB\x4E",'utf8','sjis','z',"\xE7\x80\x85"),
("\xFB\x4F",'utf8','sjis','z',"\xE7\x80\x87"),
("\xFB\x50",'utf8','sjis','z',"\xE7\x80\xA8"),
("\xFB\x51",'utf8','sjis','z',"\xE7\x82\x85"),
("\xFB\x52",'utf8','sjis','z',"\xE7\x82\xAB"),
("\xFB\x53",'utf8','sjis','z',"\xE7\x84\x8F"),
("\xFB\x54",'utf8','sjis','z',"\xE7\x84\x84"),
("\xFB\x55",'utf8','sjis','z',"\xE7\x85\x9C"),
("\xFB\x56",'utf8','sjis','z',"\xE7\x85\x86"),
("\xFB\x57",'utf8','sjis','z',"\xE7\x85\x87"),
("\xFB\x58",'utf8','sjis','z',"\xEF\xA8\x95"),
("\xFB\x59",'utf8','sjis','z',"\xE7\x87\x81"),
("\xFB\x5A",'utf8','sjis','z',"\xE7\x87\xBE"),
("\xFB\x5B",'utf8','sjis','z',"\xE7\x8A\xB1"),
("\xFB\x5C",'utf8','sjis','z',"\xE7\x8A\xBE"),
("\xFB\x5D",'utf8','sjis','z',"\xE7\x8C\xA4"),
("\xFB\x5E",'utf8','sjis','z',"\xEF\xA8\x96"),
("\xFB\x5F",'utf8','sjis','z',"\xE7\x8D\xB7"),
("\xFB\x60",'utf8','sjis','z',"\xE7\x8E\xBD"),
("\xFB\x61",'utf8','sjis','z',"\xE7\x8F\x89"),
("\xFB\x62",'utf8','sjis','z',"\xE7\x8F\x96"),
("\xFB\x63",'utf8','sjis','z',"\xE7\x8F\xA3"),
("\xFB\x64",'utf8','sjis','z',"\xE7\x8F\x92"),
("\xFB\x65",'utf8','sjis','z',"\xE7\x90\x87"),
("\xFB\x66",'utf8','sjis','z',"\xE7\x8F\xB5"),
("\xFB\x67",'utf8','sjis','z',"\xE7\x90\xA6"),
("\xFB\x68",'utf8','sjis','z',"\xE7\x90\xAA"),
("\xFB\x69",'utf8','sjis','z',"\xE7\x90\xA9"),
("\xFB\x6A",'utf8','sjis','z',"\xE7\x90\xAE"),
("\xFB\x6B",'utf8','sjis','z',"\xE7\x91\xA2"),
("\xFB\x6C",'utf8','sjis','z',"\xE7\x92\x89"),
("\xFB\x6D",'utf8','sjis','z',"\xE7\x92\x9F"),
("\xFB\x6E",'utf8','sjis','z',"\xE7\x94\x81"),
("\xFB\x6F",'utf8','sjis','z',"\xE7\x95\xAF"),
("\xFB\x70",'utf8','sjis','z',"\xE7\x9A\x82"),
("\xFB\x71",'utf8','sjis','z',"\xE7\x9A\x9C"),
("\xFB\x72",'utf8','sjis','z',"\xE7\x9A\x9E"),
("\xFB\x73",'utf8','sjis','z',"\xE7\x9A\x9B"),
("\xFB\x74",'utf8','sjis','z',"\xE7\x9A\xA6"),
("\xFB\x75",'utf8','sjis','z',"\xEF\xA8\x97"),
("\xFB\x76",'utf8','sjis','z',"\xE7\x9D\x86"),
("\xFB\x77",'utf8','sjis','z',"\xE5\x8A\xAF"),
("\xFB\x78",'utf8','sjis','z',"\xE7\xA0\xA1"),
("\xFB\x79",'utf8','sjis','z',"\xE7\xA1\x8E"),
("\xFB\x7A",'utf8','sjis','z',"\xE7\xA1\xA4"),
("\xFB\x7B",'utf8','sjis','z',"\xE7\xA1\xBA"),
("\xFB\x7C",'utf8','sjis','z',"\xE7\xA4\xB0"),
("\xFB\x7D",'utf8','sjis','z',"\xEF\xA8\x98"),
("\xFB\x7E",'utf8','sjis','z',"\xEF\xA8\x99"),
("\xFB\x80",'utf8','sjis','z',"\xEF\xA8\x9A"),
("\xFB\x81",'utf8','sjis','z',"\xE7\xA6\x94"),
("\xFB\x82",'utf8','sjis','z',"\xEF\xA8\x9B"),
("\xFB\x83",'utf8','sjis','z',"\xE7\xA6\x9B"),
("\xFB\x84",'utf8','sjis','z',"\xE7\xAB\x91"),
("\xFB\x85",'utf8','sjis','z',"\xE7\xAB\xA7"),
("\xFB\x86",'utf8','sjis','z',"\xEF\xA8\x9C"),
("\xFB\x87",'utf8','sjis','z',"\xE7\xAB\xAB"),
("\xFB\x88",'utf8','sjis','z',"\xE7\xAE\x9E"),
("\xFB\x89",'utf8','sjis','z',"\xEF\xA8\x9D"),
("\xFB\x8A",'utf8','sjis','z',"\xE7\xB5\x88"),
("\xFB\x8B",'utf8','sjis','z',"\xE7\xB5\x9C"),
("\xFB\x8C",'utf8','sjis','z',"\xE7\xB6\xB7"),
("\xFB\x8D",'utf8','sjis','z',"\xE7\xB6\xA0"),
("\xFB\x8E",'utf8','sjis','z',"\xE7\xB7\x96"),
("\xFB\x8F",'utf8','sjis','z',"\xE7\xB9\x92"),
("\xFB\x90",'utf8','sjis','z',"\xE7\xBD\x87"),
("\xFB\x91",'utf8','sjis','z',"\xE7\xBE\xA1"),
("\xFB\x92",'utf8','sjis','z',"\xEF\xA8\x9E"),
("\xFB\x93",'utf8','sjis','z',"\xE8\x8C\x81"),
("\xFB\x94",'utf8','sjis','z',"\xE8\x8D\xA2"),
("\xFB\x95",'utf8','sjis','z',"\xE8\x8D\xBF"),
("\xFB\x96",'utf8','sjis','z',"\xE8\x8F\x87"),
("\xFB\x97",'utf8','sjis','z',"\xE8\x8F\xB6"),
("\xFB\x98",'utf8','sjis','z',"\xE8\x91\x88"),
("\xFB\x99",'utf8','sjis','z',"\xE8\x92\xB4"),
("\xFB\x9A",'utf8','sjis','z',"\xE8\x95\x93"),
("\xFB\x9B",'utf8','sjis','z',"\xE8\x95\x99"),
("\xFB\x9C",'utf8','sjis','z',"\xE8\x95\xAB"),
("\xFB\x9D",'utf8','sjis','z',"\xEF\xA8\x9F"),
("\xFB\x9E",'utf8','sjis','z',"\xE8\x96\xB0"),
("\xFB\x9F",'utf8','sjis','z',"\xEF\xA8\xA0"),
("\xFB\xA0",'utf8','sjis','z',"\xEF\xA8\xA1"),
("\xFB\xA1",'utf8','sjis','z',"\xE8\xA0\x87"),
("\xFB\xA2",'utf8','sjis','z',"\xE8\xA3\xB5"),
("\xFB\xA3",'utf8','sjis','z',"\xE8\xA8\x92"),
("\xFB\xA4",'utf8','sjis','z',"\xE8\xA8\xB7"),
("\xFB\xA5",'utf8','sjis','z',"\xE8\xA9\xB9"),
("\xFB\xA6",'utf8','sjis','z',"\xE8\xAA\xA7"),
("\xFB\xA7",'utf8','sjis','z',"\xE8\xAA\xBE"),
("\xFB\xA8",'utf8','sjis','z',"\xE8\xAB\x9F"),
("\xFB\xA9",'utf8','sjis','z',"\xEF\xA8\xA2"),
("\xFB\xAA",'utf8','sjis','z',"\xE8\xAB\xB6"),
("\xFB\xAB",'utf8','sjis','z',"\xE8\xAD\x93"),
("\xFB\xAC",'utf8','sjis','z',"\xE8\xAD\xBF"),
("\xFB\xAD",'utf8','sjis','z',"\xE8\xB3\xB0"),
("\xFB\xAE",'utf8','sjis','z',"\xE8\xB3\xB4"),
("\xFB\xAF",'utf8','sjis','z',"\xE8\xB4\x92"),
("\xFB\xB0",'utf8','sjis','z',"\xE8\xB5\xB6"),
("\xFB\xB1",'utf8','sjis','z',"\xEF\xA8\xA3"),
("\xFB\xB2",'utf8','sjis','z',"\xE8\xBB\x8F"),
("\xFB\xB3",'utf8','sjis','z',"\xEF\xA8\xA4"),
("\xFB\xB4",'utf8','sjis','z',"\xEF\xA8\xA5"),
("\xFB\xB5",'utf8','sjis','z',"\xE9\x81\xA7"),
("\xFB\xB6",'utf8','sjis','z',"\xE9\x83\x9E"),
("\xFB\xB7",'utf8','sjis','z',"\xEF\xA8\xA6"),
("\xFB\xB8",'utf8','sjis','z',"\xE9\x84\x95"),
("\xFB\xB9",'utf8','sjis','z',"\xE9\x84\xA7"),
("\xFB\xBA",'utf8','sjis','z',"\xE9\x87\x9A"),
("\xFB\xBB",'utf8','sjis','z',"\xE9\x87\x97"),
("\xFB\xBC",'utf8','sjis','z',"\xE9\x87\x9E"),
("\xFB\xBD",'utf8','sjis','z',"\xE9\x87\xAD"),
("\xFB\xBE",'utf8','sjis','z',"\xE9\x87\xAE"),
("\xFB\xBF",'utf8','sjis','z',"\xE9\x87\xA4"),
("\xFB\xC0",'utf8','sjis','z',"\xE9\x87\xA5"),
("\xFB\xC1",'utf8','sjis','z',"\xE9\x88\x86"),
("\xFB\xC2",'utf8','sjis','z',"\xE9\x88\x90"),
("\xFB\xC3",'utf8','sjis','z',"\xE9\x88\x8A"),
("\xFB\xC4",'utf8','sjis','z',"\xE9\x88\xBA"),
("\xFB\xC5",'utf8','sjis','z',"\xE9\x89\x80"),
("\xFB\xC6",'utf8','sjis','z',"\xE9\x88\xBC"),
("\xFB\xC7",'utf8','sjis','z',"\xE9\x89\x8E"),
("\xFB\xC8",'utf8','sjis','z',"\xE9\x89\x99"),
("\xFB\xC9",'utf8','sjis','z',"\xE9\x89\x91"),
("\xFB\xCA",'utf8','sjis','z',"\xE9\x88\xB9"),
("\xFB\xCB",'utf8','sjis','z',"\xE9\x89\xA7"),
("\xFB\xCC",'utf8','sjis','z',"\xE9\x8A\xA7"),
("\xFB\xCD",'utf8','sjis','z',"\xE9\x89\xB7"),
("\xFB\xCE",'utf8','sjis','z',"\xE9\x89\xB8"),
("\xFB\xCF",'utf8','sjis','z',"\xE9\x8B\xA7"),
("\xFB\xD0",'utf8','sjis','z',"\xE9\x8B\x97"),
("\xFB\xD1",'utf8','sjis','z',"\xE9\x8B\x99"),
("\xFB\xD2",'utf8','sjis','z',"\xE9\x8B\x90"),
("\xFB\xD3",'utf8','sjis','z',"\xEF\xA8\xA7"),
("\xFB\xD4",'utf8','sjis','z',"\xE9\x8B\x95"),
("\xFB\xD5",'utf8','sjis','z',"\xE9\x8B\xA0"),
("\xFB\xD6",'utf8','sjis','z',"\xE9\x8B\x93"),
("\xFB\xD7",'utf8','sjis','z',"\xE9\x8C\xA5"),
("\xFB\xD8",'utf8','sjis','z',"\xE9\x8C\xA1"),
("\xFB\xD9",'utf8','sjis','z',"\xE9\x8B\xBB"),
("\xFB\xDA",'utf8','sjis','z',"\xEF\xA8\xA8"),
("\xFB\xDB",'utf8','sjis','z',"\xE9\x8C\x9E"),
("\xFB\xDC",'utf8','sjis','z',"\xE9\x8B\xBF"),
("\xFB\xDD",'utf8','sjis','z',"\xE9\x8C\x9D"),
("\xFB\xDE",'utf8','sjis','z',"\xE9\x8C\x82"),
("\xFB\xDF",'utf8','sjis','z',"\xE9\x8D\xB0"),
("\xFB\xE0",'utf8','sjis','z',"\xE9\x8D\x97"),
("\xFB\xE1",'utf8','sjis','z',"\xE9\x8E\xA4"),
("\xFB\xE2",'utf8','sjis','z',"\xE9\x8F\x86"),
("\xFB\xE3",'utf8','sjis','z',"\xE9\x8F\x9E"),
("\xFB\xE4",'utf8','sjis','z',"\xE9\x8F\xB8"),
("\xFB\xE5",'utf8','sjis','z',"\xE9\x90\xB1"),
("\xFB\xE6",'utf8','sjis','z',"\xE9\x91\x85"),
("\xFB\xE7",'utf8','sjis','z',"\xE9\x91\x88"),
("\xFB\xE8",'utf8','sjis','z',"\xE9\x96\x92"),
("\xFB\xE9",'utf8','sjis','z',"\xEF\xA7\x9C"),
("\xFB\xEA",'utf8','sjis','z',"\xEF\xA8\xA9"),
("\xFB\xEB",'utf8','sjis','z',"\xE9\x9A\x9D"),
("\xFB\xEC",'utf8','sjis','z',"\xE9\x9A\xAF"),
("\xFB\xED",'utf8','sjis','z',"\xE9\x9C\xB3"),
("\xFB\xEE",'utf8','sjis','z',"\xE9\x9C\xBB"),
("\xFB\xEF",'utf8','sjis','z',"\xE9\x9D\x83"),
("\xFB\xF0",'utf8','sjis','z',"\xE9\x9D\x8D"),
("\xFB\xF1",'utf8','sjis','z',"\xE9\x9D\x8F"),
("\xFB\xF2",'utf8','sjis','z',"\xE9\x9D\x91"),
("\xFB\xF3",'utf8','sjis','z',"\xE9\x9D\x95"),
("\xFB\xF4",'utf8','sjis','z',"\xE9\xA1\x97"),
("\xFB\xF5",'utf8','sjis','z',"\xE9\xA1\xA5"),
("\xFB\xF6",'utf8','sjis','z',"\xEF\xA8\xAA"),
("\xFB\xF7",'utf8','sjis','z',"\xEF\xA8\xAB"),
("\xFB\xF8",'utf8','sjis','z',"\xE9\xA4\xA7"),
("\xFB\xF9",'utf8','sjis','z',"\xEF\xA8\xAC"),
("\xFB\xFA",'utf8','sjis','z',"\xE9\xA6\x9E"),
("\xFB\xFB",'utf8','sjis','z',"\xE9\xA9\x8E"),
("\xFB\xFC",'utf8','sjis','z',"\xE9\xAB\x99"),
("\xFC\x40",'utf8','sjis','z',"\xE9\xAB\x9C"),
("\xFC\x41",'utf8','sjis','z',"\xE9\xAD\xB5"),
("\xFC\x42",'utf8','sjis','z',"\xE9\xAD\xB2"),
("\xFC\x43",'utf8','sjis','z',"\xE9\xAE\x8F"),
("\xFC\x44",'utf8','sjis','z',"\xE9\xAE\xB1"),
("\xFC\x45",'utf8','sjis','z',"\xE9\xAE\xBB"),
("\xFC\x46",'utf8','sjis','z',"\xE9\xB0\x80"),
("\xFC\x47",'utf8','sjis','z',"\xE9\xB5\xB0"),
("\xFC\x48",'utf8','sjis','z',"\xE9\xB5\xAB"),
("\xFC\x49",'utf8','sjis','z',"\xEF\xA8\xAD"),
("\xFC\x4A",'utf8','sjis','z',"\xE9\xB8\x99"),
("\xFC\x4B",'utf8','sjis','z',"\xE9\xBB\x91"),
("\xFC\x4C",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x4D",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x4E",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x4F",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x50",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x51",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x52",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x53",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x54",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x55",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x56",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x57",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x58",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x59",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x5A",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x5B",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x5C",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x5D",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x5E",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x5F",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x60",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x61",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x62",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x63",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x64",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x65",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x66",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x67",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x68",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x69",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x6A",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x6B",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x6C",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x6D",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x6E",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x6F",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x70",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x71",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x72",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x73",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x74",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x75",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x76",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x77",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x78",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x79",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x7A",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x7B",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x7C",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x7D",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x7E",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x80",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x81",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x82",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x83",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x84",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x85",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x86",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x87",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x88",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x89",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x8A",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x8B",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x8C",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x8D",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x8E",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x8F",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x90",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x91",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x92",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x93",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x94",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x95",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x96",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x97",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x98",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x99",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x9A",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x9B",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x9C",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x9D",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x9E",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\x9F",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xA0",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xA1",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xA2",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xA3",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xA4",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xA5",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xA6",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xA7",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xA8",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xA9",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xAA",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xAB",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xAC",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xAD",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xAE",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xAF",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xB0",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xB1",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xB2",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xB3",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xB4",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xB5",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xB6",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xB7",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xB8",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xB9",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xBA",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xBB",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xBC",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xBD",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xBE",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xBF",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xC0",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xC1",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xC2",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xC3",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xC4",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xC5",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xC6",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xC7",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xC8",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xC9",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xCA",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xCB",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xCC",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xCD",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xCE",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xCF",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xD0",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xD1",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xD2",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xD3",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xD4",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xD5",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xD6",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xD7",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xD8",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xD9",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xDA",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xDB",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xDC",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xDD",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xDE",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xDF",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xE0",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xE1",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xE2",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xE3",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xE4",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xE5",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xE6",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xE7",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xE8",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xE9",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xEA",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xEB",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xEC",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xED",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xEE",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xEF",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xF0",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xF1",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xF2",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xF3",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xF4",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xF5",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xF6",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xF7",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xF8",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xF9",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xFA",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xFB",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFC\xFC",'utf8','sjis','z',"\xE3\x80\x93"),
("\xFD",'utf8','sjis','z',"\xFD"),
("\xFE",'utf8','sjis','z',"\xFE"),
("\xFF",'utf8','sjis','z',"\xFF"),
);

print "1..", scalar(@todo)/5, "\n";
$tno = 1;

while (($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = splice(@todo,0,5)) {
    $got = $give;
    &jacode'convert(*got,$OUTPUT_encoding,$INPUT_encoding,$option);
    if ($got eq $want) {
        printf(    "ok $tno - give=(%s) want=(%s) got=(%s)\n", unpack('H*',$give), unpack('H*',$want), unpack('H*',$got));
    }
    else {
        printf("not ok $tno - give=(%s) want=(%s) got=(%s)\n", unpack('H*',$give), unpack('H*',$want), unpack('H*',$got));
    }
    $tno++;
}

__END__
