/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.dbd.jdbc;

import com.vizdom.ber.BerIdentifier;
import com.vizdom.ber.BerObject;
import com.vizdom.dbd.jdbc.BerDbdModule;
import com.vizdom.dbd.jdbc.CommitRequest;
import com.vizdom.dbd.jdbc.CommitResponse;
import com.vizdom.dbd.jdbc.ConnectRequest;
import com.vizdom.dbd.jdbc.ConnectResponse;
import com.vizdom.dbd.jdbc.ConnectionFuncRequest;
import com.vizdom.dbd.jdbc.ConnectionFuncResponse;
import com.vizdom.dbd.jdbc.DbdException;
import com.vizdom.dbd.jdbc.DisconnectRequest;
import com.vizdom.dbd.jdbc.DisconnectResponse;
import com.vizdom.dbd.jdbc.ErrorResponse;
import com.vizdom.dbd.jdbc.ExecuteRequest;
import com.vizdom.dbd.jdbc.ExecuteResponse;
import com.vizdom.dbd.jdbc.ExecuteResultSetResponse;
import com.vizdom.dbd.jdbc.ExecuteRowsResponse;
import com.vizdom.dbd.jdbc.FatalException;
import com.vizdom.dbd.jdbc.FetchRequest;
import com.vizdom.dbd.jdbc.FetchResponse;
import com.vizdom.dbd.jdbc.GeneratedKey;
import com.vizdom.dbd.jdbc.GetConnectionPropertyRequest;
import com.vizdom.dbd.jdbc.GetConnectionPropertyResponse;
import com.vizdom.dbd.jdbc.GetGeneratedKeysRequest;
import com.vizdom.dbd.jdbc.GetGeneratedKeysResponse;
import com.vizdom.dbd.jdbc.GetStatementPropertyRequest;
import com.vizdom.dbd.jdbc.GetStatementPropertyResponse;
import com.vizdom.dbd.jdbc.Parameter;
import com.vizdom.dbd.jdbc.PingRequest;
import com.vizdom.dbd.jdbc.PingResponse;
import com.vizdom.dbd.jdbc.PrepareRequest;
import com.vizdom.dbd.jdbc.PrepareResponse;
import com.vizdom.dbd.jdbc.RollbackRequest;
import com.vizdom.dbd.jdbc.RollbackResponse;
import com.vizdom.dbd.jdbc.SetConnectionPropertyRequest;
import com.vizdom.dbd.jdbc.SetConnectionPropertyResponse;
import com.vizdom.dbd.jdbc.SetStatementPropertyRequest;
import com.vizdom.dbd.jdbc.SetStatementPropertyResponse;
import com.vizdom.dbd.jdbc.StatementDestroyRequest;
import com.vizdom.dbd.jdbc.StatementDestroyResponse;
import com.vizdom.dbd.jdbc.StatementFinishRequest;
import com.vizdom.dbd.jdbc.StatementFinishResponse;
import com.vizdom.dbd.jdbc.StatementFuncRequest;
import com.vizdom.dbd.jdbc.StatementFuncResponse;
import com.vizdom.dbd.jdbc.StatementHolder;
import com.vizdom.util.CharacterEncoder;
import com.vizdom.util.UnreachableCodeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.Socket;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Wrapper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Connection
implements Runnable {
    private static final Logger gLog = LogManager.getLogger(Connection.class);
    private static final Integer sDbiNoNulls = new Integer(0);
    private static final Integer sDbiNullable = new Integer(1);
    private static final Integer sDbiNullableUnknown = new Integer(2);
    private static final int sLONG_READ_BUFFER_SIZE = 8192;
    private String mThreadId;
    private Socket mSocket;
    private BufferedInputStream mIn;
    private BufferedOutputStream mOut;
    private BerDbdModule mBerModule;
    private java.sql.Connection mConn;
    private boolean preExistingConnection;
    private Hashtable<Integer, StatementHolder> mStatementTable = new Hashtable();
    private int mNextHandle;
    String mUser;
    String mPassword;
    String mUrl;
    Properties mProperties;
    private boolean mSupportsGetGeneratedKeys;
    private GeneratedKey[] mGeneratedKeys;

    Connection(Socket aClient, BerDbdModule aBerModule) throws IOException {
        this.mSocket = aClient;
        this.mIn = new BufferedInputStream(this.mSocket.getInputStream());
        this.mOut = new BufferedOutputStream(this.mSocket.getOutputStream());
        this.mNextHandle = 1;
        this.mBerModule = aBerModule;
        this.preExistingConnection = false;
    }

    Connection(Socket aClient, BerDbdModule aBerModule, java.sql.Connection aJdbcConnection) throws IOException {
        this(aClient, aBerModule);
        this.mConn = aJdbcConnection;
        this.preExistingConnection = true;
    }

    @Override
    public void run() {
        this.mThreadId = "[" + Thread.currentThread().getName() + "]";
        try (CloseableThreadContext.Instance ctc = CloseableThreadContext.push((String)this.mThreadId);){
            BerObject response = null;
            boolean connected = true;
            gLog.info("Client started");
            while (connected) {
                try {
                    BerIdentifier id;
                    BerObject request = this.mBerModule.readFrom(this.mIn);
                    if (request == null) {
                        throw new FatalException("Client disconnected");
                    }
                    if (gLog.isDebugEnabled()) {
                        gLog.debug("Request: " + request);
                    }
                    if ((id = request.getIdentifier()).getTagClass() != 64) {
                        throw new FatalException("Unknown request received " + id);
                    }
                    int tagNumber = id.getTagNumber();
                    switch (tagNumber) {
                        case 12: {
                            connected = false;
                            response = this.handleRequest((DisconnectRequest)request);
                            break;
                        }
                        case 11: {
                            try {
                                response = this.handleRequest((ConnectRequest)request);
                                break;
                            }
                            catch (SQLException sql) {
                                connected = false;
                                throw sql;
                            }
                        }
                        case 26: {
                            response = this.handleRequest((PingRequest)request);
                            break;
                        }
                        case 13: {
                            response = this.handleRequest((CommitRequest)request);
                            break;
                        }
                        case 14: {
                            response = this.handleRequest((RollbackRequest)request);
                            break;
                        }
                        case 15: {
                            response = this.handleRequest((PrepareRequest)request);
                            break;
                        }
                        case 16: {
                            response = this.handleRequest((ExecuteRequest)request);
                            break;
                        }
                        case 17: {
                            response = this.handleRequest((FetchRequest)request);
                            break;
                        }
                        case 20: {
                            response = this.handleRequest((GetConnectionPropertyRequest)request);
                            break;
                        }
                        case 22: {
                            response = this.handleRequest((SetConnectionPropertyRequest)request);
                            break;
                        }
                        case 21: {
                            response = this.handleRequest((GetStatementPropertyRequest)request);
                            break;
                        }
                        case 23: {
                            response = this.handleRequest((SetStatementPropertyRequest)request);
                            break;
                        }
                        case 24: {
                            response = this.handleRequest((StatementFinishRequest)request);
                            break;
                        }
                        case 25: {
                            response = this.handleRequest((StatementDestroyRequest)request);
                            break;
                        }
                        case 29: {
                            response = this.handleRequest((ConnectionFuncRequest)request);
                            break;
                        }
                        case 32: {
                            response = this.handleRequest((StatementFuncRequest)request);
                            break;
                        }
                        case 33: {
                            response = this.handleRequest((GetGeneratedKeysRequest)request);
                            break;
                        }
                        default: {
                            throw new DbdException(6, new String[]{String.valueOf(tagNumber)});
                        }
                    }
                    if (response != null) {
                        response.writeTo(this.mOut);
                        this.mOut.flush();
                        if (gLog.isDebugEnabled()) {
                            gLog.debug("Response: " + response);
                        }
                        response = null;
                        continue;
                    }
                    throw new DbdException(7);
                }
                catch (SQLException sqlError) {
                    gLog.warn("Error", (Throwable)sqlError);
                    try {
                        this.mSendError(sqlError);
                    }
                    catch (FatalException fatal) {
                        gLog.warn("Failed to send error", (Throwable)fatal);
                    }
                }
                catch (Throwable throwable) {
                    connected = false;
                    gLog.warn("Rollback due to fatal error");
                    this.mRollback();
                    gLog.fatal("Error; ending connection", throwable);
                    try {
                        this.mSendError(new DbdException(8, new String[]{throwable.toString()}));
                    }
                    catch (FatalException fatal) {
                        gLog.warn("Failed to send error", (Throwable)fatal);
                    }
                }
            }
            this.mDoDisconnect(true);
            try {
                this.mOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mOut = null;
            try {
                this.mIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mIn = null;
            try {
                this.mSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mSocket = null;
            gLog.info("Client done");
        }
    }

    private void mRollback() {
        if (this.mConn == null) {
            return;
        }
        try {
            this.mConn.rollback();
        }
        catch (SQLException e) {
            gLog.warn("SQLException during rollback", (Throwable)e);
        }
    }

    BerObject handleRequest(ConnectRequest aRequest) throws SQLException {
        String charset = null;
        try {
            charset = aRequest.getCharacterEncoding();
            if (!charset.equals("")) {
                if (gLog.isDebugEnabled()) {
                    gLog.debug("Setting character encoding to " + charset);
                }
                CharacterEncoder.toByteArray("test string", charset);
                this.mBerModule.setCharacterEncoding(charset);
            }
            if (!this.preExistingConnection) {
                this.mUrl = aRequest.getURL(charset);
                this.mUser = aRequest.getUser(charset);
                this.mPassword = aRequest.getPassword(charset);
                this.mProperties = aRequest.getProperties(charset);
                if (gLog.isDebugEnabled()) {
                    gLog.debug("url = " + this.mUrl);
                    gLog.debug("user = " + this.mUser);
                    Enumeration<Object> keys = this.mProperties.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        gLog.debug(key + " = " + this.mProperties.get(key));
                    }
                }
                this.mConn = this.mUser == null && this.mPassword == null ? DriverManager.getConnection(this.mUrl, this.mProperties) : DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
                DatabaseMetaData dbmd = this.mConn.getMetaData();
                gLog.debug("Created database connection to " + dbmd.getDatabaseProductName() + " v" + dbmd.getDatabaseProductVersion());
                this.mSupportsGetGeneratedKeys = dbmd.supportsGetGeneratedKeys();
                if (gLog.isDebugEnabled()) {
                    gLog.debug("Driver supports getGeneratedKeys? " + this.mSupportsGetGeneratedKeys);
                }
            }
        }
        catch (UnsupportedEncodingException unsupEnc) {
            throw new DbdException(10, new String[]{charset});
        }
        return new ConnectResponse();
    }

    public void reconnect() throws SQLException {
        this.mDoDisconnect(true);
        this.mConn = this.mUser == null && this.mPassword == null ? DriverManager.getConnection(this.mUrl, this.mProperties) : DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
    }

    BerObject handleRequest(DisconnectRequest aRequest) throws SQLException {
        this.mDoDisconnect(!this.preExistingConnection);
        return new DisconnectResponse();
    }

    private void mDoDisconnect(boolean shouldCloseConnection) {
        if (this.mStatementTable.size() > 0) {
            Enumeration<StatementHolder> elements = this.mStatementTable.elements();
            while (elements.hasMoreElements()) {
                elements.nextElement().close();
            }
            if (gLog.isDebugEnabled()) {
                gLog.debug("Closed " + this.mStatementTable.size() + " Statements on disconnect");
            }
        }
        if (this.mConn != null && shouldCloseConnection) {
            try {
                gLog.debug("Closing database connection");
                this.mConn.close();
            }
            catch (Throwable t) {
                gLog.warn("Error closing connection: " + t.getMessage());
            }
        }
        this.mConn = null;
    }

    BerObject handleRequest(PingRequest aRequest) throws SQLException {
        return new PingResponse(this.mConn.isClosed() ? 0 : 1);
    }

    BerObject handleRequest(CommitRequest aRequest) throws SQLException {
        this.mConn.commit();
        return new CommitResponse();
    }

    BerObject handleRequest(RollbackRequest aRequest) throws SQLException {
        this.mConn.rollback();
        return new RollbackResponse();
    }

    BerObject handleRequest(PrepareRequest aRequest) throws SQLException {
        PreparedStatement stmt = null;
        stmt = this.mSupportsGetGeneratedKeys ? ("name".equals(aRequest.getKeyType()) ? this.mConn.prepareStatement(aRequest.getStatement(), aRequest.getColumnNames()) : ("index".equals(aRequest.getKeyType()) ? this.mConn.prepareStatement(aRequest.getStatement(), aRequest.getColumnIndexes()) : this.mConn.prepareStatement(aRequest.getStatement(), 1))) : this.mConn.prepareStatement(aRequest.getStatement());
        int stmtHandle = this.mNextHandle++;
        this.mStatementTable.put(new Integer(stmtHandle), new StatementHolder(stmt));
        if (gLog.isTraceEnabled()) {
            gLog.trace("Assigned statement handle " + stmtHandle);
        }
        return new PrepareResponse(stmtHandle);
    }

    BerObject handleRequest(ExecuteRequest aRequest) throws SQLException {
        ExecuteResponse resp;
        if (gLog.isTraceEnabled()) {
            gLog.trace("Executing statement handle " + aRequest.getHandle());
        }
        StatementHolder holder = this.mGetStatementHolder(aRequest.getHandle());
        PreparedStatement stmt = holder.getStatement();
        Parameter[] params = aRequest.getParameters();
        if (gLog.isDebugEnabled()) {
            gLog.debug("setting " + params.length + " parameters");
        }
        for (int i = 0; i < params.length; ++i) {
            try {
                if (params[i].value == null) {
                    if (gLog.isTraceEnabled()) {
                        gLog.trace("setting parameter " + (i + 1) + "; value null; type " + params[i].type);
                    }
                    stmt.setNull(i + 1, params[i].type);
                    continue;
                }
                if (gLog.isTraceEnabled()) {
                    gLog.trace("setting parameter " + (i + 1) + "; value ");
                }
                switch (params[i].type) {
                    case -4: 
                    case -3: 
                    case -2: {
                        stmt.setBytes(i + 1, params[i].value.toByteArray());
                        break;
                    }
                    case -6: 
                    case 5: {
                        stmt.setShort(i + 1, Short.parseShort(params[i].value.toString()));
                        break;
                    }
                    case 4: {
                        stmt.setInt(i + 1, Integer.parseInt(params[i].value.toString()));
                        break;
                    }
                    case -5: {
                        stmt.setLong(i + 1, Long.parseLong(params[i].value.toString()));
                        break;
                    }
                    case 7: {
                        stmt.setFloat(i + 1, new Float(params[i].value.toString()).floatValue());
                        break;
                    }
                    case 6: 
                    case 8: {
                        stmt.setDouble(i + 1, new Double(params[i].value.toString()));
                        break;
                    }
                    case 2: 
                    case 3: {
                        stmt.setBigDecimal(i + 1, new BigDecimal(params[i].value.toString()));
                        break;
                    }
                    case -7: {
                        stmt.setBoolean(i + 1, params[i].value.toString().equals("1"));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        stmt.setString(i + 1, params[i].value.toString());
                        break;
                    }
                    default: {
                        stmt.setString(i + 1, params[i].value.toString());
                    }
                }
                if (params[i].type == -2 || params[i].type == -3 || params[i].type == -4) {
                    if (!gLog.isTraceEnabled()) continue;
                    gLog.trace("(binary; length " + params[i].value.toByteArray().length + "); type " + params[i].type);
                    continue;
                }
                if (!gLog.isTraceEnabled()) continue;
                gLog.trace(params[i].value.toString() + "; type " + params[i].type);
                continue;
            }
            catch (NumberFormatException ne) {
                throw new DbdException(11, new String[]{String.valueOf(i + 1), ne.toString()});
            }
            catch (SQLException se) {
                DbdException dbd = new DbdException(11, new String[]{String.valueOf(i + 1), se.toString()});
                dbd.setNextException(se);
                throw dbd;
            }
        }
        if (stmt.execute()) {
            gLog.debug("Getting and returning a result set");
            ResultSet rs = stmt.getResultSet();
            holder.setResultSet(rs);
            ResultSetMetaData rsmd = holder.getResultSetMetaData();
            int cols = rsmd.getColumnCount();
            resp = new ExecuteResponse(new ExecuteResultSetResponse(cols));
        } else {
            ResultSet rs;
            ResultSetMetaData rsmd;
            gLog.debug("Getting and returning a row count");
            resp = new ExecuteResponse(new ExecuteRowsResponse(stmt.getUpdateCount()));
            if (this.mSupportsGetGeneratedKeys && (rsmd = (rs = stmt.getGeneratedKeys()).getMetaData()).getColumnCount() > 0) {
                this.mGeneratedKeys = new GeneratedKey[rsmd.getColumnCount()];
                while (rs.next()) {
                    for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                        this.mGeneratedKeys[i - 1] = new GeneratedKey(rsmd.getCatalogName(i), rsmd.getSchemaName(i), rsmd.getTableName(i), rsmd.getColumnName(i), rs.getString(i));
                        if (!gLog.isTraceEnabled()) continue;
                        gLog.trace("Key: " + this.mGeneratedKeys[i - 1]);
                    }
                }
            }
        }
        return resp;
    }

    BerObject handleRequest(FetchRequest aRequest) throws SQLException {
        StatementHolder holder;
        ResultSet rs;
        if (gLog.isTraceEnabled()) {
            gLog.trace("Fetching row from statement handle " + aRequest.getHandle());
        }
        if ((rs = (holder = this.mGetStatementHolder(aRequest.getHandle())).getResultSet()) == null) {
            throw new DbdException(2);
        }
        Object[] row = null;
        boolean hasData = rs.next();
        if (hasData) {
            ResultSetMetaData rsmd = holder.getResultSetMetaData();
            int cols = rsmd.getColumnCount();
            row = new Object[cols];
            int longReadLen = (Integer)holder.getProperties().get("LongReadLen");
            boolean longTruncOk = (Boolean)holder.getProperties().get("LongTruncOk");
            boolean chopBlanks = (Boolean)holder.getProperties().get("ChopBlanks");
            boolean readAll = (Boolean)holder.getProperties().get("jdbc_longreadall");
            for (int i = 0; i < cols; ++i) {
                try {
                    int type = rsmd.getColumnType(i + 1);
                    if (gLog.isTraceEnabled()) {
                        gLog.trace("getting column " + (i + 1) + "/" + rsmd.getColumnName(i + 1) + "; type " + type);
                    }
                    switch (type) {
                        case -3: 
                        case -2: {
                            row[i] = rs.getBytes(i + 1);
                            break;
                        }
                        case -4: {
                            if (longReadLen == 0) {
                                row[i] = null;
                                break;
                            }
                            row[i] = this.mReadLong(i + 1, rs.getBinaryStream(i + 1), longReadLen, longTruncOk, readAll);
                            break;
                        }
                        case 2004: {
                            if (longReadLen == 0) {
                                row[i] = null;
                                break;
                            }
                            Blob blob = rs.getBlob(i + 1);
                            if (blob == null) {
                                row[i] = null;
                                break;
                            }
                            row[i] = this.mReadLong(i + 1, blob.getBinaryStream(), longReadLen, longTruncOk, readAll);
                            break;
                        }
                        case -1: {
                            if (longReadLen == 0) {
                                row[i] = null;
                                break;
                            }
                            char[] chars = this.mReadLong(i + 1, rs.getCharacterStream(i + 1), longReadLen, longTruncOk, readAll);
                            row[i] = chars == null ? null : new String(chars);
                            break;
                        }
                        case 2005: {
                            if (longReadLen == 0) {
                                row[i] = null;
                                break;
                            }
                            Clob clob = rs.getClob(i + 1);
                            if (clob == null) {
                                row[i] = null;
                                break;
                            }
                            char[] chars = this.mReadLong(i + 1, clob.getCharacterStream(), longReadLen, longTruncOk, readAll);
                            row[i] = chars == null ? null : new String(chars);
                            break;
                        }
                        case 2003: {
                            row[i] = rs.getString(i + 1);
                            break;
                        }
                        case 1: {
                            if (chopBlanks) {
                                row[i] = this.mChopBlanks(rs.getString(i + 1));
                                break;
                            }
                        }
                        default: {
                            row[i] = rs.getString(i + 1);
                        }
                    }
                    continue;
                }
                catch (IOException ioError) {
                    throw new DbdException(9, new String[]{String.valueOf(i + 1), ioError.toString()});
                }
            }
        }
        try {
            return new FetchResponse(hasData, row, this.mBerModule.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupEnc) {
            throw new UnreachableCodeException();
        }
    }

    BerObject handleRequest(GetConnectionPropertyRequest aRequest) throws SQLException {
        String property = aRequest.getPropertyName();
        if (property.equals("AutoCommit")) {
            Object[] response = new Integer[]{new Integer(this.mConn.getAutoCommit() ? 1 : 0)};
            try {
                return new GetConnectionPropertyResponse(response, this.mBerModule.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException unsupEnc) {
                throw new UnreachableCodeException();
            }
        }
        throw new DbdException(3, new String[]{property});
    }

    BerObject handleRequest(SetConnectionPropertyRequest aRequest) throws SQLException {
        String property = aRequest.getPropertyName();
        if (property.equals("AutoCommit")) {
            boolean autoCommit = aRequest.getPropertyValue().equals("1");
            gLog.debug("Settting AutoCommit to " + autoCommit);
            this.mConn.setAutoCommit(autoCommit);
            return new SetConnectionPropertyResponse();
        }
        throw new DbdException(3, new String[]{property});
    }

    BerObject handleRequest(GetStatementPropertyRequest aRequest) throws SQLException {
        try {
            StatementHolder holder = this.mGetStatementHolder(aRequest.getHandle());
            String property = aRequest.getPropertyName();
            if (property.equals("CursorName")) {
                ResultSet rs = holder.getResultSet();
                if (rs == null) {
                    throw new DbdException(4);
                }
                Object[] cursorname = new String[1];
                try {
                    cursorname[0] = rs.getCursorName();
                }
                catch (SQLException e) {
                    cursorname[0] = null;
                    gLog.warn("getCursorName threw an exception", (Throwable)e);
                }
                return new GetStatementPropertyResponse(cursorname, this.mBerModule.getCharacterEncoding());
            }
            ResultSetMetaData rsmd = holder.getResultSetMetaData();
            if (rsmd == null) {
                throw new DbdException(5);
            }
            int colcount = rsmd.getColumnCount();
            if (property.equals("NAME")) {
                Object[] data = new String[colcount];
                for (int i = 1; i <= colcount; ++i) {
                    data[i - 1] = rsmd.getColumnName(i);
                }
                return new GetStatementPropertyResponse(data, this.mBerModule.getCharacterEncoding());
            }
            if (property.equals("TYPE")) {
                Object[] data = new Integer[colcount];
                for (int i = 1; i <= colcount; ++i) {
                    data[i - 1] = new Integer(rsmd.getColumnType(i));
                }
                return new GetStatementPropertyResponse(data, this.mBerModule.getCharacterEncoding());
            }
            if (property.equals("PRECISION")) {
                Object[] data = new Integer[colcount];
                for (int i = 1; i <= colcount; ++i) {
                    data[i - 1] = new Integer(rsmd.getPrecision(i));
                }
                return new GetStatementPropertyResponse(data, this.mBerModule.getCharacterEncoding());
            }
            if (property.equals("SCALE")) {
                Object[] data = new Integer[colcount];
                for (int i = 1; i <= colcount; ++i) {
                    try {
                        data[i - 1] = new Integer(rsmd.getScale(i));
                        continue;
                    }
                    catch (SQLException e) {
                        data[i - 1] = null;
                    }
                }
                return new GetStatementPropertyResponse(data, this.mBerModule.getCharacterEncoding());
            }
            if (property.equals("NULLABLE")) {
                Object[] data = new Integer[colcount];
                block15: for (int i = 1; i <= colcount; ++i) {
                    int nullable = rsmd.isNullable(i);
                    switch (nullable) {
                        case 0: {
                            data[i - 1] = sDbiNoNulls;
                            continue block15;
                        }
                        case 1: {
                            data[i - 1] = sDbiNullable;
                            continue block15;
                        }
                        case 2: {
                            data[i - 1] = sDbiNullableUnknown;
                            continue block15;
                        }
                        default: {
                            data[i - 1] = null;
                            gLog.warn("isNullable returned an unknown value " + nullable);
                        }
                    }
                }
                return new GetStatementPropertyResponse(data, this.mBerModule.getCharacterEncoding());
            }
            throw new DbdException(3, new String[]{property});
        }
        catch (UnsupportedEncodingException unsupEnc) {
            throw new UnreachableCodeException();
        }
    }

    BerObject handleRequest(SetStatementPropertyRequest aRequest) throws SQLException {
        StatementHolder holder = this.mGetStatementHolder(aRequest.getHandle());
        String property = aRequest.getPropertyName();
        if (property.equals("LongReadLen")) {
            holder.getProperties().put(property, new Integer(aRequest.getPropertyValue()));
            return new SetStatementPropertyResponse();
        }
        if (property.equals("LongTruncOk")) {
            holder.getProperties().put(property, new Boolean(aRequest.getPropertyValue().equals("1")));
            return new SetStatementPropertyResponse();
        }
        if (property.equals("ChopBlanks")) {
            holder.getProperties().put(property, new Boolean(aRequest.getPropertyValue().equals("1")));
            return new SetStatementPropertyResponse();
        }
        if (property.equals("jdbc_longreadall")) {
            holder.getProperties().put(property, new Boolean(aRequest.getPropertyValue().equals("1")));
            return new SetStatementPropertyResponse();
        }
        throw new DbdException(3, new String[]{property});
    }

    BerObject handleRequest(StatementFinishRequest aRequest) throws SQLException {
        StatementHolder holder = this.mGetStatementHolder(aRequest.getHandle());
        return new StatementFinishResponse();
    }

    BerObject handleRequest(StatementDestroyRequest aRequest) throws DbdException {
        int handle = aRequest.getHandle();
        StatementHolder holder = this.mStatementTable.remove(new Integer(handle));
        if (holder == null) {
            throw new DbdException(1);
        }
        if (gLog.isTraceEnabled()) {
            gLog.trace("Destroying statement " + handle);
        }
        holder.close();
        holder = null;
        return new StatementDestroyResponse();
    }

    BerObject handleRequest(ConnectionFuncRequest aRequest) throws SQLException, DbdException {
        String methodName = aRequest.getMethodName();
        if (gLog.isTraceEnabled()) {
            gLog.trace("Func method: " + methodName);
        }
        String value = this.mHandleFunc(this.mConn, aRequest.getMethodName(), aRequest.getParameters());
        if (gLog.isDebugEnabled()) {
            gLog.debug(methodName + " returned '" + value + "'");
        }
        try {
            return new ConnectionFuncResponse(value, this.mBerModule.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupEnc) {
            throw new DbdException(10, new String[]{this.mBerModule.getCharacterEncoding()});
        }
    }

    BerObject handleRequest(StatementFuncRequest aRequest) throws SQLException, DbdException {
        int dot;
        String methodName = aRequest.getMethodName();
        if (gLog.isTraceEnabled()) {
            gLog.trace("Statement func method: " + methodName);
        }
        if ((dot = methodName.lastIndexOf(".")) == -1) {
            throw new DbdException(13);
        }
        StatementHolder holder = this.mGetStatementHolder(aRequest.getHandle());
        if (holder == null) {
            throw new DbdException(1);
        }
        String objectName = methodName.substring(0, dot);
        if (gLog.isTraceEnabled()) {
            gLog.trace("Looking up object type " + objectName);
        }
        Wrapper object = null;
        if (objectName.equals("Statement") || objectName.equals("PreparedStatement")) {
            object = holder.getStatement();
        } else if (objectName.equals("ResultSet")) {
            object = holder.getResultSet();
            if (object == null) {
                throw new DbdException(2);
            }
        } else if (objectName.equals("ResultSetMetaData")) {
            object = holder.getResultSetMetaData();
            if (object == null) {
                throw new DbdException(5);
            }
        } else {
            throw new DbdException(14, new String[]{objectName});
        }
        if (gLog.isDebugEnabled()) {
            gLog.debug("Underlying object type: " + object.getClass().getName());
        }
        String value = this.mHandleFunc(object, methodName.substring(dot + 1), aRequest.getParameters());
        if (gLog.isDebugEnabled()) {
            gLog.debug(methodName + " returned '" + value + "'");
        }
        try {
            return new StatementFuncResponse(value, this.mBerModule.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupEnc) {
            throw new DbdException(10, new String[]{this.mBerModule.getCharacterEncoding()});
        }
    }

    BerObject handleRequest(GetGeneratedKeysRequest aRequest) throws DbdException {
        try {
            String table = aRequest.getTable();
            String column = aRequest.getColumn();
            String key = "";
            if (this.mGeneratedKeys == null || this.mGeneratedKeys.length == 0) {
                if (gLog.isDebugEnabled()) {
                    gLog.debug("Generated key requested, but no keys are available");
                }
            } else if (table == null && column == null) {
                key = this.mGeneratedKeys[0].value;
                if (gLog.isTraceEnabled()) {
                    gLog.trace("No specific key column or table requested");
                }
            } else if (table == null && column != null) {
                for (int i = 0; i < this.mGeneratedKeys.length; ++i) {
                    if (!column.equalsIgnoreCase(this.mGeneratedKeys[i].columnName)) continue;
                    key = this.mGeneratedKeys[i].value;
                    break;
                }
                if (gLog.isTraceEnabled()) {
                    gLog.trace("Key column '" + column + "' requested");
                }
            } else if (table != null && column == null) {
                for (int i = 0; i < this.mGeneratedKeys.length; ++i) {
                    if (!table.equalsIgnoreCase(this.mGeneratedKeys[i].table)) continue;
                    key = this.mGeneratedKeys[i].value;
                    break;
                }
                if (gLog.isTraceEnabled()) {
                    gLog.trace("Key table '" + table + "' requested");
                }
            } else if (table != null && column != null) {
                for (int i = 0; i < this.mGeneratedKeys.length; ++i) {
                    if (!column.equalsIgnoreCase(this.mGeneratedKeys[i].columnName) || !table.equalsIgnoreCase(this.mGeneratedKeys[i].table)) continue;
                    key = this.mGeneratedKeys[i].value;
                    break;
                }
                if (gLog.isTraceEnabled()) {
                    gLog.trace("Key table and column '" + table + "'.'" + column + "' requested");
                }
            }
            return new GetGeneratedKeysResponse(key, this.mBerModule.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupEnc) {
            throw new DbdException(10, new String[]{this.mBerModule.getCharacterEncoding()});
        }
    }

    private String mHandleFunc(Object anObject, String aMethodName, Parameter[] aParameterList) throws SQLException, DbdException {
        if (gLog.isDebugEnabled()) {
            gLog.debug("Method has " + aParameterList.length + " parameters");
        }
        Object[] parameterObjects = new Object[aParameterList.length];
        Class[] parameterClasses = new Class[aParameterList.length];
        try {
            for (int i = 0; i < aParameterList.length; ++i) {
                if (aParameterList[i].value == null) {
                    parameterObjects[i] = null;
                    parameterClasses[i] = this.mGetClass(aParameterList[i].type);
                    if (!gLog.isTraceEnabled()) continue;
                    gLog.trace("Parameter " + (i + 1) + ": null; class " + parameterClasses[i].getName());
                    continue;
                }
                if (gLog.isTraceEnabled()) {
                    gLog.trace("Parameter " + (i + 1) + ": ");
                }
                switch (aParameterList[i].type) {
                    case -4: 
                    case -3: 
                    case -2: {
                        parameterObjects[i] = aParameterList[i].value.toByteArray();
                        break;
                    }
                    case -6: {
                        parameterObjects[i] = new Byte(aParameterList[i].value.toString());
                        break;
                    }
                    case 5: {
                        parameterObjects[i] = new Short(aParameterList[i].value.toString());
                        break;
                    }
                    case 4: {
                        parameterObjects[i] = new Integer(aParameterList[i].value.toString());
                        break;
                    }
                    case -5: {
                        parameterObjects[i] = new Long(aParameterList[i].value.toString());
                        break;
                    }
                    case 7: {
                        parameterObjects[i] = new Float(aParameterList[i].value.toString());
                        break;
                    }
                    case 6: 
                    case 8: {
                        parameterObjects[i] = new Double(aParameterList[i].value.toString());
                        break;
                    }
                    case 2: 
                    case 3: {
                        parameterObjects[i] = new BigDecimal(aParameterList[i].value.toString());
                        break;
                    }
                    case -7: {
                        parameterObjects[i] = new Boolean(aParameterList[i].value.toString().equals("1"));
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        parameterObjects[i] = aParameterList[i].value.toString();
                        break;
                    }
                    case 91: {
                        parameterObjects[i] = Date.valueOf(aParameterList[i].value.toString());
                        break;
                    }
                    case 92: {
                        parameterObjects[i] = Time.valueOf(aParameterList[i].value.toString());
                        break;
                    }
                    case 93: {
                        parameterObjects[i] = Timestamp.valueOf(aParameterList[i].value.toString());
                        break;
                    }
                    default: {
                        parameterObjects[i] = aParameterList[i].value.toString();
                    }
                }
                parameterClasses[i] = this.mGetClass(aParameterList[i].type);
                if (aParameterList[i].type == -2 || aParameterList[i].type == -3 || aParameterList[i].type == -4) {
                    if (!gLog.isTraceEnabled()) continue;
                    gLog.trace("byte[], length " + ((byte[])parameterObjects[i]).length + "; class " + parameterClasses[i].getName());
                    continue;
                }
                if (!gLog.isTraceEnabled()) continue;
                gLog.trace(parameterObjects[i].toString() + "; class " + parameterClasses[i].getName());
            }
            try {
                Object returnValue;
                if (aParameterList.length == 0) {
                    parameterClasses = null;
                }
                if ((returnValue = this.mInvokeMethod(anObject, aMethodName, parameterClasses, parameterObjects)) == null) {
                    return null;
                }
                if (returnValue instanceof Boolean) {
                    return (Boolean)returnValue != false ? "1" : "0";
                }
                return returnValue.toString();
            }
            catch (SecurityException security) {
                throw new DbdException(15, new String[]{security.toString()});
            }
            catch (IllegalArgumentException argument) {
                throw new DbdException(15, new String[]{argument.toString()});
            }
            catch (InvocationTargetException target) {
                Throwable t = target.getTargetException();
                if (t != null) {
                    if (t instanceof SQLException) {
                        throw (SQLException)t;
                    }
                    throw new DbdException(15, new String[]{t.toString()});
                }
                throw new DbdException(15, new String[]{target.toString()});
            }
        }
        catch (Exception e) {
            gLog.debug((Object)e, (Throwable)e);
            throw new DbdException(8, new String[]{e.toString()});
        }
    }

    private Object mInvokeMethod(Object anObject, String aMethodName, Class[] parameterClasses, Object[] parameterObjects) throws IllegalArgumentException, InvocationTargetException, DbdException {
        for (Class<?> currentClass = anObject.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Method method = currentClass.getMethod(aMethodName, parameterClasses);
                gLog.trace("Invoking " + currentClass.getName() + "." + aMethodName);
                return method.invoke(anObject, parameterObjects);
            }
            catch (NoSuchMethodException noMethod) {
                gLog.trace(currentClass.getName() + "/" + noMethod.toString());
            }
            catch (SecurityException security) {
                gLog.trace(currentClass.getName() + "/" + security.toString());
            }
            catch (IllegalAccessException access) {
                gLog.trace(currentClass.getName() + "/" + access.toString());
            }
            Class<?>[] interfaces = currentClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                try {
                    Method method = interfaces[i].getMethod(aMethodName, parameterClasses);
                    gLog.trace("Invoking " + interfaces[i].getName() + "." + aMethodName);
                    return method.invoke(anObject, parameterObjects);
                }
                catch (NoSuchMethodException noMethod) {
                    gLog.trace(currentClass.getName() + "/" + noMethod.toString());
                    continue;
                }
                catch (SecurityException security) {
                    gLog.trace(currentClass.getName() + "/" + security.toString());
                    continue;
                }
                catch (IllegalAccessException access) {
                    gLog.trace(currentClass.getName() + "/" + access.toString());
                }
            }
        }
        throw new DbdException(15, new String[]{"Unable to invoke method"});
    }

    private Class mGetClass(int aJdbcType) {
        switch (aJdbcType) {
            case -4: 
            case -3: 
            case -2: {
                byte[] b = new byte[]{};
                return b.getClass();
            }
            case -6: {
                return Byte.TYPE;
            }
            case 5: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case -5: {
                return Long.TYPE;
            }
            case 7: {
                return Float.TYPE;
            }
            case 6: 
            case 8: {
                return Double.TYPE;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -7: {
                return Boolean.TYPE;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
        }
        return String.class;
    }

    private StatementHolder mGetStatementHolder(int aStatementHandle) throws DbdException {
        StatementHolder holder = this.mStatementTable.get(new Integer(aStatementHandle));
        if (holder == null) {
            throw new DbdException(1);
        }
        return holder;
    }

    private String mChopBlanks(String aString) {
        if (aString != null) {
            int last;
            for (last = aString.length() - 1; last >= 0 && aString.charAt(last) == ' '; --last) {
            }
            return aString.substring(0, last + 1);
        }
        return null;
    }

    private byte[] mReadLong(int aColumnIndex, InputStream anInputStream, int aLongReadLen, boolean aLongTruncOk, boolean readAll) throws DbdException, IOException {
        int totalread;
        if (aLongReadLen == 0) {
            return null;
        }
        if (anInputStream == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        if (readAll) {
            int read;
            while ((read = anInputStream.read(buffer, 0, buffer.length)) != -1) {
                totalread += read;
                baos.write(buffer, 0, read);
            }
        } else {
            int read;
            for (totalread = 0; totalread < aLongReadLen && (read = anInputStream.read(buffer, 0, Math.min(buffer.length, aLongReadLen - totalread))) != -1; totalread += read) {
                baos.write(buffer, 0, read);
            }
        }
        baos.close();
        if (gLog.isDebugEnabled()) {
            gLog.debug("Read " + totalread + " bytes from LONG column " + aColumnIndex + "(LongReadLen=" + aLongReadLen + ";LongTruncOk=" + aLongTruncOk + ";jdbc_longreadall=" + readAll + ")");
        }
        if (!readAll && !aLongTruncOk && anInputStream.read() != -1) {
            anInputStream.close();
            throw new DbdException(12);
        }
        anInputStream.close();
        return baos.toByteArray();
    }

    private char[] mReadLong(int aColumnIndex, Reader aReader, int aLongReadLen, boolean aLongTruncOk, boolean readAll) throws DbdException, IOException {
        int totalread;
        if (aLongReadLen == 0) {
            return null;
        }
        if (aReader == null) {
            return null;
        }
        CharArrayWriter out = new CharArrayWriter(aLongReadLen);
        char[] buffer = new char[8192];
        if (readAll) {
            int read;
            while ((read = aReader.read(buffer, 0, buffer.length)) != -1) {
                totalread += read;
                out.write(buffer, 0, read);
            }
        } else {
            int read;
            for (totalread = 0; totalread < aLongReadLen && (read = aReader.read(buffer, 0, Math.min(buffer.length, aLongReadLen - totalread))) != -1; totalread += read) {
                out.write(buffer, 0, read);
            }
        }
        out.close();
        if (gLog.isDebugEnabled()) {
            gLog.debug("Read " + totalread + " bytes from LONG column " + aColumnIndex + "(LongReadLen=" + aLongReadLen + ";LongTruncOk=" + aLongTruncOk + ";jdbc_longreadall=" + readAll + ")");
        }
        if (!readAll && !aLongTruncOk && aReader.read() != -1) {
            aReader.close();
            throw new DbdException(12);
        }
        aReader.close();
        return out.toCharArray();
    }

    private void mSendError(SQLException aSQLException) {
        try {
            ErrorResponse error = new ErrorResponse(aSQLException, this.mBerModule.getCharacterEncoding());
            if (gLog.isTraceEnabled()) {
                gLog.trace("Sending error: " + aSQLException.getMessage());
            }
            error.writeTo(this.mOut);
            this.mOut.flush();
        }
        catch (UnsupportedEncodingException unsupEnc) {
            throw new UnreachableCodeException();
        }
        catch (Exception e) {
            throw new FatalException("Failed to send error message to client: " + e.toString());
        }
    }
}

