/* book.c generated by valac 0.16.0, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-ps.h>
#include <zlib.h>
#include "jpeglib.h"
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define __g_list_free__page_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__page_unref0_ (var), NULL)))

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_PS_WRITER (ps_writer_get_type ())
#define PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PS_WRITER, PsWriter))
#define PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PS_WRITER, PsWriterClass))
#define IS_PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PS_WRITER))
#define IS_PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PS_WRITER))
#define PS_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PS_WRITER, PsWriterClass))

typedef struct _PsWriter PsWriter;
typedef struct _PsWriterClass PsWriterClass;
typedef struct _PsWriterPrivate PsWriterPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _ps_writer_unref0(var) ((var == NULL) ? NULL : (var = (ps_writer_unref (var), NULL)))

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
typedef struct _PDFWriterPrivate PDFWriterPrivate;
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _ParamSpecBook ParamSpecBook;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
typedef struct _ParamSpecPsWriter ParamSpecPsWriter;

struct _Book {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookPrivate * priv;
};

struct _BookClass {
	GTypeClass parent_class;
	void (*finalize) (Book *self);
};

struct _BookPrivate {
	GList* pages;
	gboolean needs_saving;
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _PsWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PsWriterPrivate * priv;
	cairo_surface_t* surface;
	GFileOutputStream* stream;
};

struct _PsWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PsWriter *self);
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	GList* object_offsets;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBook {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

struct _ParamSpecPsWriter {
	GParamSpec parent_instance;
};


static gpointer book_parent_class = NULL;
static gpointer pdf_writer_parent_class = NULL;
static gpointer ps_writer_parent_class = NULL;

gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define BOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK, BookPrivate))
enum  {
	BOOK_DUMMY_PROPERTY
};
static void _page_unref0_ (gpointer var);
static void _g_list_free__page_unref0_ (GList* self);
Book* book_new (void);
Book* book_construct (GType object_type);
void book_clear (Book* self);
static void book_page_changed_cb (Book* self, Page* page);
void book_set_needs_saving (Book* self, gboolean needs_saving);
GType scan_direction_get_type (void) G_GNUC_CONST;
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self);
void book_move_page (Book* self, Page* page, guint location);
void book_delete_page (Book* self, Page* page);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self, gint page_number);
guint book_get_page_index (Book* self, Page* page);
static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i);
static void book_save_multi_file (Book* self, const gchar* type, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi);
static void book_save_ps (Book* self, GFile* file, GError** error);
PsWriter* ps_writer_new (GFileOutputStream* stream);
PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream);
gpointer ps_writer_ref (gpointer instance);
void ps_writer_unref (gpointer instance);
GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ps_writer (GValue* value, gpointer v_object);
void value_take_ps_writer (GValue* value, gpointer v_object);
gpointer value_get_ps_writer (const GValue* value);
GType ps_writer_get_type (void) G_GNUC_CONST;
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
gint page_get_dpi (Page* self);
static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1);
static void book_jpeg_init_cb (struct jpeg_compress_struct* info);
static gboolean book_jpeg_empty_cb (struct jpeg_compress_struct* info);
static void book_jpeg_term_cb (struct jpeg_compress_struct* info);
static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gsize* n_written, int* result_length1);
static void _book_jpeg_init_cb_jpeg_initdestinationfunc (struct jpeg_compress_struct* cinfo);
static gboolean _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc (struct jpeg_compress_struct* cinfo);
static void _book_jpeg_term_cb_jpeg_termdestinationfunc (struct jpeg_compress_struct* cinfo);
static void book_save_pdf (Book* self, GFile* file, GError** error);
PDFWriter* pdf_writer_new (GFileOutputStream* stream);
PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream);
gpointer pdf_writer_ref (gpointer instance);
void pdf_writer_unref (gpointer instance);
GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pdf_writer (GValue* value, gpointer v_object);
void value_take_pdf_writer (GValue* value, gpointer v_object);
gpointer value_get_pdf_writer (const GValue* value);
GType pdf_writer_get_type (void) G_GNUC_CONST;
void pdf_writer_write_string (PDFWriter* self, const gchar* text);
guint pdf_writer_start_object (PDFWriter* self);
gboolean page_is_color (Page* self);
gint page_get_depth (Page* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
gboolean book_get_needs_saving (Book* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void book_finalize (Book* obj);
#define PDF_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PDF_WRITER, PDFWriterPrivate))
enum  {
	PDF_WRITER_DUMMY_PROPERTY
};
static void pdf_writer_finalize (PDFWriter* obj);
enum  {
	PS_WRITER_DUMMY_PROPERTY
};
static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1);
static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1);
static void ps_writer_finalize (PsWriter* obj);


static void _page_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
}


static void _g_list_free__page_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _page_unref0_, NULL);
	g_list_free (self);
}


Book* book_construct (GType object_type) {
	Book* self = NULL;
	self = (Book*) g_type_create_instance (object_type);
	return self;
}


Book* book_new (void) {
	return book_construct (TYPE_BOOK);
}


void book_clear (Book* self) {
	g_return_if_fail (self != NULL);
	__g_list_free__page_unref0_0 (self->priv->pages);
	self->priv->pages = NULL;
	g_signal_emit_by_name (self, "cleared");
}


static void book_page_changed_cb (Book* self, Page* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	book_set_needs_saving (self, TRUE);
}


static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
	book_page_changed_cb (self, _sender);
}


static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
	book_page_changed_cb (self, _sender);
}


static gpointer _page_ref0 (gpointer self) {
	return self ? page_ref (self) : NULL;
}


Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction) {
	Page* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ScanDirection _tmp3_;
	Page* _tmp4_;
	Page* page;
	Page* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = dpi;
	_tmp3_ = scan_direction;
	_tmp4_ = page_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	page = _tmp4_;
	g_signal_connect (page, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self);
	g_signal_connect (page, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self);
	_tmp5_ = _page_ref0 (page);
	self->priv->pages = g_list_append (self->priv->pages, _tmp5_);
	g_signal_emit_by_name (self, "page-added", page);
	book_set_needs_saving (self, TRUE);
	result = page;
	return result;
}


void book_move_page (Book* self, Page* page, guint location) {
	Page* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	self->priv->pages = g_list_remove (self->priv->pages, _tmp0_);
	_tmp1_ = page;
	_tmp2_ = _page_ref0 (_tmp1_);
	_tmp3_ = location;
	self->priv->pages = g_list_insert (self->priv->pages, _tmp2_, (gint) _tmp3_);
	g_signal_emit_by_name (self, "reordered");
	book_set_needs_saving (self, TRUE);
}


void book_delete_page (Book* self, Page* page) {
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	Page* _tmp4_;
	Page* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
	_tmp2_ = page;
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
	_tmp4_ = page;
	g_signal_emit_by_name (self, "page-removed", _tmp4_);
	_tmp5_ = page;
	self->priv->pages = g_list_remove (self->priv->pages, _tmp5_);
	book_set_needs_saving (self, TRUE);
}


guint book_get_n_pages (Book* self) {
	guint result = 0U;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->pages;
	_tmp1_ = g_list_length (_tmp0_);
	result = _tmp1_;
	return result;
}


Page* book_get_page (Book* self, gint page_number) {
	Page* result = NULL;
	gint _tmp0_;
	GList* _tmp4_;
	gint _tmp5_;
	gconstpointer _tmp6_ = NULL;
	Page* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = page_number;
	if (_tmp0_ < 0) {
		GList* _tmp1_;
		guint _tmp2_ = 0U;
		gint _tmp3_;
		_tmp1_ = self->priv->pages;
		_tmp2_ = g_list_length (_tmp1_);
		_tmp3_ = page_number;
		page_number = ((gint) _tmp2_) + _tmp3_;
	}
	_tmp4_ = self->priv->pages;
	_tmp5_ = page_number;
	_tmp6_ = g_list_nth_data (_tmp4_, (guint) _tmp5_);
	_tmp7_ = _page_ref0 ((Page*) _tmp6_);
	result = _tmp7_;
	return result;
}


guint book_get_page_index (Book* self, Page* page) {
	guint result = 0U;
	GList* _tmp0_;
	Page* _tmp1_;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (page != NULL, 0U);
	_tmp0_ = self->priv->pages;
	_tmp1_ = page;
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
	result = (guint) _tmp2_;
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i) {
	GFile* result = NULL;
	guint _tmp0_ = 0U;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* basename;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* prefix;
	gchar* _tmp7_;
	gchar* suffix;
	const gchar* _tmp8_;
	gint _tmp9_ = 0;
	gint extension_index;
	gint _tmp10_;
	const gchar* _tmp25_;
	gint _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	GFile* _tmp30_ = NULL;
	GFile* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = book_get_n_pages (self);
	if (_tmp0_ == ((guint) 1)) {
		const gchar* _tmp1_;
		GFile* _tmp2_ = NULL;
		_tmp1_ = uri;
		_tmp2_ = g_file_new_for_uri (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = uri;
	_tmp4_ = g_path_get_basename (_tmp3_);
	basename = _tmp4_;
	_tmp5_ = uri;
	_tmp6_ = g_strdup (_tmp5_);
	prefix = _tmp6_;
	_tmp7_ = g_strdup ("");
	suffix = _tmp7_;
	_tmp8_ = basename;
	_tmp9_ = string_last_index_of_char (_tmp8_, (gunichar) '.', 0);
	extension_index = _tmp9_;
	_tmp10_ = extension_index;
	if (_tmp10_ >= 0) {
		const gchar* _tmp11_;
		gint _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_ = NULL;
		_tmp11_ = basename;
		_tmp12_ = extension_index;
		_tmp13_ = basename;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = string_slice (_tmp11_, (glong) _tmp12_, (glong) _tmp15_);
		_g_free0 (suffix);
		suffix = _tmp16_;
		_tmp17_ = uri;
		_tmp18_ = uri;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = suffix;
		_tmp22_ = strlen (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = string_slice (_tmp17_, (glong) 0, (glong) (_tmp20_ - _tmp23_));
		_g_free0 (prefix);
		prefix = _tmp24_;
	}
	_tmp25_ = prefix;
	_tmp26_ = i;
	_tmp27_ = suffix;
	_tmp28_ = g_strdup_printf ("%s-%d%s", _tmp25_, _tmp26_ + 1, _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_file_new_for_uri (_tmp29_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	result = _tmp31_;
	_g_free0 (suffix);
	_g_free0 (prefix);
	_g_free0 (basename);
	return result;
}


static void book_save_multi_file (Book* self, const gchar* type, GFile* file, GError** error) {
	gint i;
	GList* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (file != NULL);
	i = 0;
	_tmp0_ = self->priv->pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp0_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			Page* _tmp1_;
			Page* page = NULL;
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
			page = _tmp1_;
			{
				Page* _tmp2_;
				const gchar* _tmp3_;
				GFile* _tmp4_;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				gint _tmp7_;
				GFile* _tmp8_ = NULL;
				GFile* _tmp9_;
				gint _tmp10_;
				_tmp2_ = page;
				_tmp3_ = type;
				_tmp4_ = file;
				_tmp5_ = g_file_get_uri (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = i;
				_tmp8_ = book_make_indexed_file (self, _tmp6_, _tmp7_);
				_tmp9_ = _tmp8_;
				page_save (_tmp2_, _tmp3_, _tmp9_, &_inner_error_);
				_g_object_unref0 (_tmp9_);
				_g_free0 (_tmp6_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_page_unref0 (page);
					return;
				}
				_tmp10_ = i;
				i = _tmp10_ + 1;
				_page_unref0 (page);
			}
		}
	}
}


static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi) {
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* context;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GdkPixbuf* _tmp4_;
	cairo_pattern_t* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (image != NULL);
	_tmp0_ = surface;
	_tmp1_ = cairo_create (_tmp0_);
	context = _tmp1_;
	_tmp2_ = dpi;
	_tmp3_ = dpi;
	cairo_scale (context, 72.0 / _tmp2_, 72.0 / _tmp3_);
	_tmp4_ = image;
	gdk_cairo_set_source_pixbuf (context, _tmp4_, (gdouble) 0, (gdouble) 0);
	_tmp5_ = cairo_get_source (context);
	cairo_pattern_set_filter (_tmp5_, CAIRO_FILTER_BEST);
	cairo_paint (context);
	_cairo_destroy0 (context);
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static void book_save_ps (Book* self, GFile* file, GError** error) {
	GFile* _tmp0_;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* stream;
	PsWriter* _tmp2_;
	PsWriter* writer;
	PsWriter* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* surface;
	GList* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
	stream = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = ps_writer_new (stream);
	writer = _tmp2_;
	_tmp3_ = writer;
	_tmp4_ = _tmp3_->surface;
	_tmp5_ = _cairo_surface_reference0 (_tmp4_);
	surface = _tmp5_;
	_tmp6_ = self->priv->pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp6_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			Page* _tmp7_;
			Page* page = NULL;
			_tmp7_ = _page_ref0 ((Page*) page_it->data);
			page = _tmp7_;
			{
				Page* _tmp8_;
				GdkPixbuf* _tmp9_ = NULL;
				GdkPixbuf* image;
				GdkPixbuf* _tmp10_;
				gint _tmp11_ = 0;
				Page* _tmp12_;
				gint _tmp13_ = 0;
				gdouble width;
				GdkPixbuf* _tmp14_;
				gint _tmp15_ = 0;
				Page* _tmp16_;
				gint _tmp17_ = 0;
				gdouble height;
				cairo_surface_t* _tmp18_;
				gdouble _tmp19_;
				gdouble _tmp20_;
				cairo_surface_t* _tmp21_;
				GdkPixbuf* _tmp22_;
				Page* _tmp23_;
				gint _tmp24_ = 0;
				cairo_surface_t* _tmp25_;
				_tmp8_ = page;
				_tmp9_ = page_get_image (_tmp8_, TRUE);
				image = _tmp9_;
				_tmp10_ = image;
				_tmp11_ = gdk_pixbuf_get_width (_tmp10_);
				_tmp12_ = page;
				_tmp13_ = page_get_dpi (_tmp12_);
				width = (_tmp11_ * 72.0) / _tmp13_;
				_tmp14_ = image;
				_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
				_tmp16_ = page;
				_tmp17_ = page_get_dpi (_tmp16_);
				height = (_tmp15_ * 72.0) / _tmp17_;
				_tmp18_ = surface;
				_tmp19_ = width;
				_tmp20_ = height;
				cairo_ps_surface_set_size (_tmp18_, _tmp19_, _tmp20_);
				_tmp21_ = surface;
				_tmp22_ = image;
				_tmp23_ = page;
				_tmp24_ = page_get_dpi (_tmp23_);
				book_save_ps_pdf_surface (self, _tmp21_, _tmp22_, (gdouble) _tmp24_);
				_tmp25_ = surface;
				cairo_surface_show_page (_tmp25_);
				_g_object_unref0 (image);
				_page_unref0 (page);
			}
		}
	}
	_cairo_surface_destroy0 (surface);
	_ps_writer_unref0 (writer);
	_g_object_unref0 (stream);
}


static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1) {
	guint8* result = NULL;
	z_stream stream = {0};
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_ = NULL;
	guint8* out_data;
	gint out_data_length1;
	gint _out_data_size_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	z_stream _tmp7_;
	guint _tmp8_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	z_stream _tmp11_;
	guint _tmp12_;
	guint n_written;
	guint _tmp13_;
	gint _tmp14_ = 0;
	guint8* _tmp15_;
	gint _tmp15__length1;
	g_return_val_if_fail (self != NULL, NULL);
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	_tmp1_ = g_new0 (guint8, _tmp0__length1);
	out_data = _tmp1_;
	out_data_length1 = _tmp0__length1;
	_out_data_size_ = out_data_length1;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	stream.next_in = _tmp2_;
	stream.avail_in = _tmp2__length1;
	_tmp3_ = out_data;
	_tmp3__length1 = out_data_length1;
	stream.next_out = _tmp3_;
	stream.avail_out = _tmp3__length1;
	while (TRUE) {
		z_stream _tmp4_;
		guint _tmp5_;
		gint _tmp6_ = 0;
		_tmp4_ = stream;
		_tmp5_ = _tmp4_.avail_in;
		if (!(_tmp5_ > ((guint) 0))) {
			break;
		}
		_tmp6_ = deflate (&stream, (gint) Z_FINISH);
		if (_tmp6_ == ((gint) Z_STREAM_ERROR)) {
			break;
		}
	}
	_tmp7_ = stream;
	_tmp8_ = _tmp7_.avail_in;
	if (_tmp8_ > ((guint) 0)) {
		guint8* _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = NULL;
		_tmp9__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		out_data = (g_free (out_data), NULL);
		deflateEnd (&stream);
		return result;
	}
	_tmp10_ = data;
	_tmp10__length1 = data_length1;
	_tmp11_ = stream;
	_tmp12_ = _tmp11_.avail_out;
	n_written = _tmp10__length1 - _tmp12_;
	_tmp13_ = n_written;
	_tmp14_ = (gint) _tmp13_;
	out_data = g_renew (guint8, out_data, (gint) _tmp13_);
	(_tmp14_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp14_ - out_data_length1)) : NULL;
	out_data_length1 = _tmp14_;
	_out_data_size_ = _tmp14_;
	_tmp15_ = out_data;
	_tmp15__length1 = out_data_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	deflateEnd (&stream);
	return result;
}


static void book_jpeg_init_cb (struct jpeg_compress_struct* info) {
	g_return_if_fail (info != NULL);
}


static gboolean book_jpeg_empty_cb (struct jpeg_compress_struct* info) {
	gboolean result = FALSE;
	g_return_val_if_fail (info != NULL, FALSE);
	result = TRUE;
	return result;
}


static void book_jpeg_term_cb (struct jpeg_compress_struct* info) {
	g_return_if_fail (info != NULL);
}


static void _book_jpeg_init_cb_jpeg_initdestinationfunc (struct jpeg_compress_struct* cinfo) {
	book_jpeg_init_cb (cinfo);
}


static gboolean _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc (struct jpeg_compress_struct* cinfo) {
	gboolean result;
	result = book_jpeg_empty_cb (cinfo);
	return result;
}


static void _book_jpeg_term_cb_jpeg_termdestinationfunc (struct jpeg_compress_struct* cinfo) {
	book_jpeg_term_cb (cinfo);
}


static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gsize* n_written, int* result_length1) {
	gsize _vala_n_written = 0UL;
	guint8* result = NULL;
	struct jpeg_compress_struct info = {0};
	struct jpeg_error_mgr jerr = {0};
	struct jpeg_destination_mgr dest_mgr = {0};
	struct jpeg_error_mgr* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	gint _tmp2_ = 0;
	GdkPixbuf* _tmp3_;
	gint _tmp4_ = 0;
	struct jpeg_compress_struct _tmp5_;
	gint _tmp6_;
	struct jpeg_compress_struct _tmp7_;
	gint _tmp8_;
	struct jpeg_compress_struct _tmp9_;
	gint _tmp10_;
	gint max_length;
	gint _tmp11_;
	guint8* _tmp12_ = NULL;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_;
	GdkPixbuf* _tmp15_;
	guint8* _tmp16_ = NULL;
	guint8* pixels;
	gint pixels_length1;
	gint _pixels_size_;
	gint _tmp28_;
	struct jpeg_destination_mgr _tmp29_;
	gint _tmp30_;
	gint _tmp31_ = 0;
	guint8* _tmp32_;
	gint _tmp32__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (image != NULL, NULL);
	memset (&info, 0, sizeof (struct jpeg_compress_struct));
	memset (&jerr, 0, sizeof (struct jpeg_error_mgr));
	memset (&dest_mgr, 0, sizeof (struct jpeg_destination_mgr));
	_tmp0_ = jpeg_std_error (&jerr);
	info.err = _tmp0_;
	jpeg_create_compress (&info);
	_tmp1_ = image;
	_tmp2_ = gdk_pixbuf_get_width (_tmp1_);
	info.image_width = _tmp2_;
	_tmp3_ = image;
	_tmp4_ = gdk_pixbuf_get_height (_tmp3_);
	info.image_height = _tmp4_;
	info.input_components = 3;
	info.in_color_space = JCS_RGB;
	jpeg_set_defaults (&info);
	_tmp5_ = info;
	_tmp6_ = _tmp5_.image_width;
	_tmp7_ = info;
	_tmp8_ = _tmp7_.image_height;
	_tmp9_ = info;
	_tmp10_ = _tmp9_.input_components;
	max_length = (_tmp6_ * _tmp8_) * _tmp10_;
	_tmp11_ = max_length;
	_tmp12_ = g_new0 (guint8, _tmp11_);
	data = _tmp12_;
	data_length1 = _tmp11_;
	_data_size_ = data_length1;
	_tmp13_ = data;
	_tmp13__length1 = data_length1;
	dest_mgr.next_output_byte = _tmp13_;
	_tmp14_ = max_length;
	dest_mgr.free_in_buffer = _tmp14_;
	dest_mgr.init_destination = _book_jpeg_init_cb_jpeg_initdestinationfunc;
	dest_mgr.empty_output_buffer = _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc;
	dest_mgr.term_destination = _book_jpeg_term_cb_jpeg_termdestinationfunc;
	info.dest = &dest_mgr;
	jpeg_start_compress (&info, TRUE);
	_tmp15_ = image;
	_tmp16_ = gdk_pixbuf_get_pixels (_tmp15_);
	pixels = _tmp16_;
	pixels_length1 = -1;
	_pixels_size_ = pixels_length1;
	{
		gint r;
		r = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				struct jpeg_compress_struct _tmp21_;
				gint _tmp22_;
				guint8* row[1] = {0};
				guint8* _tmp23_;
				gint _tmp23__length1;
				gint _tmp24_;
				GdkPixbuf* _tmp25_;
				gint _tmp26_ = 0;
				guint8* _tmp27_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = r;
					r = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = r;
				_tmp21_ = info;
				_tmp22_ = _tmp21_.image_height;
				if (!(_tmp20_ < _tmp22_)) {
					break;
				}
				_tmp23_ = pixels;
				_tmp23__length1 = pixels_length1;
				_tmp24_ = r;
				_tmp25_ = image;
				_tmp26_ = gdk_pixbuf_get_rowstride (_tmp25_);
				row[0] = ((guint8*) _tmp23_) + (_tmp24_ * _tmp26_);
				_tmp27_ = row[0];
				jpeg_write_scanlines (&info, row, 1);
			}
		}
	}
	jpeg_finish_compress (&info);
	_tmp28_ = max_length;
	_tmp29_ = dest_mgr;
	_tmp30_ = _tmp29_.free_in_buffer;
	_vala_n_written = (gsize) (_tmp28_ - _tmp30_);
	_tmp31_ = (gint) _vala_n_written;
	data = g_renew (guint8, data, (gint) _vala_n_written);
	(_tmp31_ > data_length1) ? memset (data + data_length1, 0, sizeof (guint8) * (_tmp31_ - data_length1)) : NULL;
	data_length1 = _tmp31_;
	_data_size_ = _tmp31_;
	_tmp32_ = data;
	_tmp32__length1 = data_length1;
	if (result_length1) {
		*result_length1 = _tmp32__length1;
	}
	result = _tmp32_;
	jpeg_destroy_compress (&info);
	if (n_written) {
		*n_written = _vala_n_written;
	}
	return result;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void book_save_pdf (Book* self, GFile* file, GError** error) {
	GFile* _tmp0_;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* stream;
	PDFWriter* _tmp2_;
	PDFWriter* writer;
	PDFWriter* _tmp3_;
	PDFWriter* _tmp4_;
	PDFWriter* _tmp5_;
	guint _tmp6_ = 0U;
	guint catalog_number;
	PDFWriter* _tmp7_;
	guint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	PDFWriter* _tmp11_;
	PDFWriter* _tmp12_;
	PDFWriter* _tmp13_;
	guint _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	PDFWriter* _tmp17_;
	PDFWriter* _tmp18_;
	PDFWriter* _tmp19_;
	PDFWriter* _tmp20_;
	guint _tmp21_ = 0U;
	guint pages_number;
	PDFWriter* _tmp22_;
	guint _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	PDFWriter* _tmp26_;
	PDFWriter* _tmp27_;
	PDFWriter* _tmp28_;
	PDFWriter* _tmp39_;
	PDFWriter* _tmp40_;
	guint _tmp41_ = 0U;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	PDFWriter* _tmp44_;
	PDFWriter* _tmp45_;
	PDFWriter* _tmp349_;
	PDFWriter* _tmp350_;
	guint _tmp351_ = 0U;
	guint info_number;
	PDFWriter* _tmp352_;
	guint _tmp353_;
	gchar* _tmp354_ = NULL;
	gchar* _tmp355_;
	PDFWriter* _tmp356_;
	PDFWriter* _tmp357_;
	gchar* _tmp358_ = NULL;
	gchar* _tmp359_;
	PDFWriter* _tmp360_;
	PDFWriter* _tmp361_;
	PDFWriter* _tmp362_;
	gsize _tmp363_;
	gsize xref_offset;
	PDFWriter* _tmp364_;
	PDFWriter* _tmp365_;
	PDFWriter* _tmp366_;
	GList* _tmp367_;
	guint _tmp368_ = 0U;
	gchar* _tmp369_ = NULL;
	gchar* _tmp370_;
	PDFWriter* _tmp371_;
	GList* _tmp372_;
	PDFWriter* _tmp377_;
	PDFWriter* _tmp378_;
	PDFWriter* _tmp379_;
	PDFWriter* _tmp380_;
	GList* _tmp381_;
	guint _tmp382_ = 0U;
	gchar* _tmp383_ = NULL;
	gchar* _tmp384_;
	PDFWriter* _tmp385_;
	guint _tmp386_;
	gchar* _tmp387_ = NULL;
	gchar* _tmp388_;
	PDFWriter* _tmp389_;
	guint _tmp390_;
	gchar* _tmp391_ = NULL;
	gchar* _tmp392_;
	PDFWriter* _tmp393_;
	PDFWriter* _tmp394_;
	PDFWriter* _tmp395_;
	gsize _tmp396_;
	gchar* _tmp397_ = NULL;
	gchar* _tmp398_;
	PDFWriter* _tmp399_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
	stream = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = pdf_writer_new (stream);
	writer = _tmp2_;
	_tmp3_ = writer;
	pdf_writer_write_string (_tmp3_, "%PDF-1.3\n");
	_tmp4_ = writer;
	pdf_writer_write_string (_tmp4_, "%\xe2\xe3\xcf\xd3\n");
	_tmp5_ = writer;
	_tmp6_ = pdf_writer_start_object (_tmp5_);
	catalog_number = _tmp6_;
	_tmp7_ = writer;
	_tmp8_ = catalog_number;
	_tmp9_ = g_strdup_printf ("%u 0 obj\n", _tmp8_);
	_tmp10_ = _tmp9_;
	pdf_writer_write_string (_tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = writer;
	pdf_writer_write_string (_tmp11_, "<<\n");
	_tmp12_ = writer;
	pdf_writer_write_string (_tmp12_, "/Type /Catalog\n");
	_tmp13_ = writer;
	_tmp14_ = catalog_number;
	_tmp15_ = g_strdup_printf ("/Pages %u 0 R\n", _tmp14_ + 1);
	_tmp16_ = _tmp15_;
	pdf_writer_write_string (_tmp13_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = writer;
	pdf_writer_write_string (_tmp17_, ">>\n");
	_tmp18_ = writer;
	pdf_writer_write_string (_tmp18_, "endobj\n");
	_tmp19_ = writer;
	pdf_writer_write_string (_tmp19_, "\n");
	_tmp20_ = writer;
	_tmp21_ = pdf_writer_start_object (_tmp20_);
	pages_number = _tmp21_;
	_tmp22_ = writer;
	_tmp23_ = pages_number;
	_tmp24_ = g_strdup_printf ("%u 0 obj\n", _tmp23_);
	_tmp25_ = _tmp24_;
	pdf_writer_write_string (_tmp22_, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = writer;
	pdf_writer_write_string (_tmp26_, "<<\n");
	_tmp27_ = writer;
	pdf_writer_write_string (_tmp27_, "/Type /Pages\n");
	_tmp28_ = writer;
	pdf_writer_write_string (_tmp28_, "/Kids [");
	{
		gint i;
		i = 0;
		{
			gboolean _tmp29_;
			_tmp29_ = TRUE;
			while (TRUE) {
				gboolean _tmp30_;
				gint _tmp32_;
				guint _tmp33_ = 0U;
				PDFWriter* _tmp34_;
				guint _tmp35_;
				gint _tmp36_;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_;
				_tmp30_ = _tmp29_;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp32_ = i;
				_tmp33_ = book_get_n_pages (self);
				if (!(((guint) _tmp32_) < _tmp33_)) {
					break;
				}
				_tmp34_ = writer;
				_tmp35_ = pages_number;
				_tmp36_ = i;
				_tmp37_ = g_strdup_printf (" %u 0 R", (_tmp35_ + 1) + (_tmp36_ * 3));
				_tmp38_ = _tmp37_;
				pdf_writer_write_string (_tmp34_, _tmp38_);
				_g_free0 (_tmp38_);
			}
		}
	}
	_tmp39_ = writer;
	pdf_writer_write_string (_tmp39_, " ]\n");
	_tmp40_ = writer;
	_tmp41_ = book_get_n_pages (self);
	_tmp42_ = g_strdup_printf ("/Count %u\n", _tmp41_);
	_tmp43_ = _tmp42_;
	pdf_writer_write_string (_tmp40_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = writer;
	pdf_writer_write_string (_tmp44_, ">>\n");
	_tmp45_ = writer;
	pdf_writer_write_string (_tmp45_, "endobj\n");
	{
		gint i;
		i = 0;
		{
			gboolean _tmp46_;
			_tmp46_ = TRUE;
			while (TRUE) {
				gboolean _tmp47_;
				gint _tmp49_;
				guint _tmp50_ = 0U;
				gint _tmp51_;
				Page* _tmp52_ = NULL;
				Page* page;
				Page* _tmp53_;
				GdkPixbuf* _tmp54_ = NULL;
				GdkPixbuf* image;
				GdkPixbuf* _tmp55_;
				gint _tmp56_ = 0;
				gint width;
				GdkPixbuf* _tmp57_;
				gint _tmp58_ = 0;
				gint height;
				GdkPixbuf* _tmp59_;
				guint8* _tmp60_ = NULL;
				guint8* pixels;
				gint pixels_length1;
				gint _pixels_size_;
				gint _tmp61_;
				Page* _tmp62_;
				gint _tmp63_ = 0;
				gdouble page_width;
				gint _tmp64_;
				Page* _tmp65_;
				gint _tmp66_ = 0;
				gdouble page_height;
				gint depth;
				gchar* _tmp67_;
				gchar* color_space;
				gchar* filter;
				gchar* _tmp68_ = NULL;
				gchar* width_buffer;
				gint width_buffer_length1;
				gint _width_buffer_size_;
				gchar* _tmp69_ = NULL;
				gchar* height_buffer;
				gint height_buffer_length1;
				gint _height_buffer_size_;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				Page* _tmp70_;
				gboolean _tmp71_ = FALSE;
				guint8* _tmp227_;
				gint _tmp227__length1;
				gint _tmp228_ = 0;
				guint8* _tmp229_ = NULL;
				guint8* compressed_data;
				gint compressed_data_length1;
				gint _compressed_data_size_;
				guint8* _tmp230_;
				gint _tmp230__length1;
				PDFWriter* _tmp245_;
				PDFWriter* _tmp246_;
				guint _tmp247_ = 0U;
				guint number;
				PDFWriter* _tmp248_;
				guint _tmp249_;
				gchar* _tmp250_ = NULL;
				gchar* _tmp251_;
				PDFWriter* _tmp252_;
				PDFWriter* _tmp253_;
				PDFWriter* _tmp254_;
				guint _tmp255_;
				gchar* _tmp256_ = NULL;
				gchar* _tmp257_;
				PDFWriter* _tmp258_;
				gint _tmp259_;
				guint _tmp260_;
				gchar* _tmp261_ = NULL;
				gchar* _tmp262_;
				PDFWriter* _tmp263_;
				gdouble _tmp264_;
				gchar* _tmp265_;
				gint _tmp265__length1;
				const gchar* _tmp266_ = NULL;
				gdouble _tmp267_;
				gchar* _tmp268_;
				gint _tmp268__length1;
				const gchar* _tmp269_ = NULL;
				gchar* _tmp270_ = NULL;
				gchar* _tmp271_;
				PDFWriter* _tmp272_;
				guint _tmp273_;
				gchar* _tmp274_ = NULL;
				gchar* _tmp275_;
				PDFWriter* _tmp276_;
				PDFWriter* _tmp277_;
				PDFWriter* _tmp278_;
				PDFWriter* _tmp279_;
				guint _tmp280_ = 0U;
				PDFWriter* _tmp281_;
				guint _tmp282_;
				gchar* _tmp283_ = NULL;
				gchar* _tmp284_;
				PDFWriter* _tmp285_;
				PDFWriter* _tmp286_;
				PDFWriter* _tmp287_;
				PDFWriter* _tmp288_;
				gint _tmp289_;
				gchar* _tmp290_ = NULL;
				gchar* _tmp291_;
				PDFWriter* _tmp292_;
				gint _tmp293_;
				gchar* _tmp294_ = NULL;
				gchar* _tmp295_;
				PDFWriter* _tmp296_;
				const gchar* _tmp297_;
				gchar* _tmp298_ = NULL;
				gchar* _tmp299_;
				PDFWriter* _tmp300_;
				gint _tmp301_;
				gchar* _tmp302_ = NULL;
				gchar* _tmp303_;
				PDFWriter* _tmp304_;
				guint8* _tmp305_;
				gint _tmp305__length1;
				gchar* _tmp306_ = NULL;
				gchar* _tmp307_;
				const gchar* _tmp308_;
				PDFWriter* _tmp313_;
				PDFWriter* _tmp314_;
				PDFWriter* _tmp315_;
				guint8* _tmp316_;
				gint _tmp316__length1;
				PDFWriter* _tmp317_;
				PDFWriter* _tmp318_;
				PDFWriter* _tmp319_;
				gdouble _tmp320_;
				gchar* _tmp321_;
				gint _tmp321__length1;
				const gchar* _tmp322_ = NULL;
				gdouble _tmp323_;
				gchar* _tmp324_;
				gint _tmp324__length1;
				const gchar* _tmp325_ = NULL;
				gint _tmp326_;
				gchar* _tmp327_ = NULL;
				gchar* command;
				PDFWriter* _tmp328_;
				PDFWriter* _tmp329_;
				guint _tmp330_ = 0U;
				PDFWriter* _tmp331_;
				guint _tmp332_;
				gchar* _tmp333_ = NULL;
				gchar* _tmp334_;
				PDFWriter* _tmp335_;
				PDFWriter* _tmp336_;
				const gchar* _tmp337_;
				gint _tmp338_;
				gint _tmp339_;
				gchar* _tmp340_ = NULL;
				gchar* _tmp341_;
				PDFWriter* _tmp342_;
				PDFWriter* _tmp343_;
				PDFWriter* _tmp344_;
				const gchar* _tmp345_;
				PDFWriter* _tmp346_;
				PDFWriter* _tmp347_;
				PDFWriter* _tmp348_;
				_tmp47_ = _tmp46_;
				if (!_tmp47_) {
					gint _tmp48_;
					_tmp48_ = i;
					i = _tmp48_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp49_ = i;
				_tmp50_ = book_get_n_pages (self);
				if (!(((guint) _tmp49_) < _tmp50_)) {
					break;
				}
				_tmp51_ = i;
				_tmp52_ = book_get_page (self, _tmp51_);
				page = _tmp52_;
				_tmp53_ = page;
				_tmp54_ = page_get_image (_tmp53_, TRUE);
				image = _tmp54_;
				_tmp55_ = image;
				_tmp56_ = gdk_pixbuf_get_width (_tmp55_);
				width = _tmp56_;
				_tmp57_ = image;
				_tmp58_ = gdk_pixbuf_get_height (_tmp57_);
				height = _tmp58_;
				_tmp59_ = image;
				_tmp60_ = gdk_pixbuf_get_pixels (_tmp59_);
				pixels = _tmp60_;
				pixels_length1 = -1;
				_pixels_size_ = pixels_length1;
				_tmp61_ = width;
				_tmp62_ = page;
				_tmp63_ = page_get_dpi (_tmp62_);
				page_width = (_tmp61_ * 72.0) / _tmp63_;
				_tmp64_ = height;
				_tmp65_ = page;
				_tmp66_ = page_get_dpi (_tmp65_);
				page_height = (_tmp64_ * 72.0) / _tmp66_;
				depth = 8;
				_tmp67_ = g_strdup ("DeviceRGB");
				color_space = _tmp67_;
				filter = NULL;
				_tmp68_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
				width_buffer = _tmp68_;
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
				_width_buffer_size_ = width_buffer_length1;
				_tmp69_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
				height_buffer = _tmp69_;
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
				_height_buffer_size_ = height_buffer_length1;
				_tmp70_ = page;
				_tmp71_ = page_is_color (_tmp70_);
				if (_tmp71_) {
					gchar* _tmp72_;
					gint _tmp73_;
					gint _tmp74_;
					gint data_length;
					gint _tmp75_;
					guint8* _tmp76_ = NULL;
					depth = 8;
					_tmp72_ = g_strdup ("DeviceRGB");
					_g_free0 (color_space);
					color_space = _tmp72_;
					_tmp73_ = height;
					_tmp74_ = width;
					data_length = (_tmp73_ * _tmp74_) * 3;
					_tmp75_ = data_length;
					_tmp76_ = g_new0 (guint8, _tmp75_);
					data = (g_free (data), NULL);
					data = _tmp76_;
					data_length1 = _tmp75_;
					_data_size_ = data_length1;
					{
						gint row;
						row = 0;
						{
							gboolean _tmp77_;
							_tmp77_ = TRUE;
							while (TRUE) {
								gboolean _tmp78_;
								gint _tmp80_;
								gint _tmp81_;
								gint _tmp82_;
								GdkPixbuf* _tmp83_;
								gint _tmp84_ = 0;
								gint in_offset;
								gint _tmp85_;
								gint _tmp86_;
								gint out_offset;
								_tmp78_ = _tmp77_;
								if (!_tmp78_) {
									gint _tmp79_;
									_tmp79_ = row;
									row = _tmp79_ + 1;
								}
								_tmp77_ = FALSE;
								_tmp80_ = row;
								_tmp81_ = height;
								if (!(_tmp80_ < _tmp81_)) {
									break;
								}
								_tmp82_ = row;
								_tmp83_ = image;
								_tmp84_ = gdk_pixbuf_get_rowstride (_tmp83_);
								in_offset = _tmp82_ * _tmp84_;
								_tmp85_ = row;
								_tmp86_ = width;
								out_offset = (_tmp85_ * _tmp86_) * 3;
								{
									gint x;
									x = 0;
									{
										gboolean _tmp87_;
										_tmp87_ = TRUE;
										while (TRUE) {
											gboolean _tmp88_;
											gint _tmp90_;
											gint _tmp91_;
											gint _tmp92_;
											gint _tmp93_;
											gint in_o;
											gint _tmp94_;
											gint _tmp95_;
											gint out_o;
											guint8* _tmp96_;
											gint _tmp96__length1;
											gint _tmp97_;
											guint8* _tmp98_;
											gint _tmp98__length1;
											gint _tmp99_;
											guint8 _tmp100_;
											guint8 _tmp101_;
											guint8* _tmp102_;
											gint _tmp102__length1;
											gint _tmp103_;
											guint8* _tmp104_;
											gint _tmp104__length1;
											gint _tmp105_;
											guint8 _tmp106_;
											guint8 _tmp107_;
											guint8* _tmp108_;
											gint _tmp108__length1;
											gint _tmp109_;
											guint8* _tmp110_;
											gint _tmp110__length1;
											gint _tmp111_;
											guint8 _tmp112_;
											guint8 _tmp113_;
											_tmp88_ = _tmp87_;
											if (!_tmp88_) {
												gint _tmp89_;
												_tmp89_ = x;
												x = _tmp89_ + 1;
											}
											_tmp87_ = FALSE;
											_tmp90_ = x;
											_tmp91_ = width;
											if (!(_tmp90_ < _tmp91_)) {
												break;
											}
											_tmp92_ = in_offset;
											_tmp93_ = x;
											in_o = _tmp92_ + (_tmp93_ * 3);
											_tmp94_ = out_offset;
											_tmp95_ = x;
											out_o = _tmp94_ + (_tmp95_ * 3);
											_tmp96_ = data;
											_tmp96__length1 = data_length1;
											_tmp97_ = out_o;
											_tmp98_ = pixels;
											_tmp98__length1 = pixels_length1;
											_tmp99_ = in_o;
											_tmp100_ = _tmp98_[_tmp99_];
											_tmp96_[_tmp97_] = _tmp100_;
											_tmp101_ = _tmp96_[_tmp97_];
											_tmp102_ = data;
											_tmp102__length1 = data_length1;
											_tmp103_ = out_o;
											_tmp104_ = pixels;
											_tmp104__length1 = pixels_length1;
											_tmp105_ = in_o;
											_tmp106_ = _tmp104_[_tmp105_ + 1];
											_tmp102_[_tmp103_ + 1] = _tmp106_;
											_tmp107_ = _tmp102_[_tmp103_ + 1];
											_tmp108_ = data;
											_tmp108__length1 = data_length1;
											_tmp109_ = out_o;
											_tmp110_ = pixels;
											_tmp110__length1 = pixels_length1;
											_tmp111_ = in_o;
											_tmp112_ = _tmp110_[_tmp111_ + 2];
											_tmp108_[_tmp109_ + 2] = _tmp112_;
											_tmp113_ = _tmp108_[_tmp109_ + 2];
										}
									}
								}
							}
						}
					}
				} else {
					Page* _tmp114_;
					gint _tmp115_ = 0;
					_tmp114_ = page;
					_tmp115_ = page_get_depth (_tmp114_);
					if (_tmp115_ == 2) {
						gint shift_count;
						gchar* _tmp116_;
						gint _tmp117_;
						gint _tmp118_;
						gint data_length;
						gint _tmp119_;
						guint8* _tmp120_ = NULL;
						gint offset;
						shift_count = 6;
						depth = 2;
						_tmp116_ = g_strdup ("DeviceGray");
						_g_free0 (color_space);
						color_space = _tmp116_;
						_tmp117_ = height;
						_tmp118_ = width;
						data_length = _tmp117_ * (((_tmp118_ * 2) + 7) / 8);
						_tmp119_ = data_length;
						_tmp120_ = g_new0 (guint8, _tmp119_);
						data = (g_free (data), NULL);
						data = _tmp120_;
						data_length1 = _tmp119_;
						_data_size_ = data_length1;
						offset = 0;
						{
							gint row;
							row = 0;
							{
								gboolean _tmp121_;
								_tmp121_ = TRUE;
								while (TRUE) {
									gboolean _tmp122_;
									gint _tmp124_;
									gint _tmp125_;
									gint _tmp126_;
									gint _tmp128_;
									GdkPixbuf* _tmp129_;
									gint _tmp130_ = 0;
									gint in_offset;
									_tmp122_ = _tmp121_;
									if (!_tmp122_) {
										gint _tmp123_;
										_tmp123_ = row;
										row = _tmp123_ + 1;
									}
									_tmp121_ = FALSE;
									_tmp124_ = row;
									_tmp125_ = height;
									if (!(_tmp124_ < _tmp125_)) {
										break;
									}
									_tmp126_ = shift_count;
									if (_tmp126_ != 6) {
										gint _tmp127_;
										_tmp127_ = offset;
										offset = _tmp127_ + 1;
										shift_count = 6;
									}
									_tmp128_ = row;
									_tmp129_ = image;
									_tmp130_ = gdk_pixbuf_get_rowstride (_tmp129_);
									in_offset = _tmp128_ * _tmp130_;
									{
										gint x;
										x = 0;
										{
											gboolean _tmp131_;
											_tmp131_ = TRUE;
											while (TRUE) {
												gboolean _tmp132_;
												gint _tmp134_;
												gint _tmp135_;
												gint _tmp136_;
												guint8* _tmp140_;
												gint _tmp140__length1;
												gint _tmp141_;
												gint _tmp142_;
												guint8 _tmp143_;
												guint8 p;
												guint8 _tmp144_;
												gint _tmp159_;
												_tmp132_ = _tmp131_;
												if (!_tmp132_) {
													gint _tmp133_;
													_tmp133_ = x;
													x = _tmp133_ + 1;
												}
												_tmp131_ = FALSE;
												_tmp134_ = x;
												_tmp135_ = width;
												if (!(_tmp134_ < _tmp135_)) {
													break;
												}
												_tmp136_ = shift_count;
												if (_tmp136_ == 6) {
													guint8* _tmp137_;
													gint _tmp137__length1;
													gint _tmp138_;
													guint8 _tmp139_;
													_tmp137_ = data;
													_tmp137__length1 = data_length1;
													_tmp138_ = offset;
													_tmp137_[_tmp138_] = (guint8) 0;
													_tmp139_ = _tmp137_[_tmp138_];
												}
												_tmp140_ = pixels;
												_tmp140__length1 = pixels_length1;
												_tmp141_ = in_offset;
												_tmp142_ = x;
												_tmp143_ = _tmp140_[_tmp141_ + (_tmp142_ * 3)];
												p = _tmp143_;
												_tmp144_ = p;
												if (((gint) _tmp144_) >= 192) {
													guint8* _tmp145_;
													gint _tmp145__length1;
													gint _tmp146_;
													gint _tmp147_;
													guint8 _tmp148_;
													_tmp145_ = data;
													_tmp145__length1 = data_length1;
													_tmp146_ = offset;
													_tmp147_ = shift_count;
													_tmp145_[_tmp146_] |= (guint8) (3 << _tmp147_);
													_tmp148_ = _tmp145_[_tmp146_];
												} else {
													guint8 _tmp149_;
													_tmp149_ = p;
													if (((gint) _tmp149_) >= 128) {
														guint8* _tmp150_;
														gint _tmp150__length1;
														gint _tmp151_;
														gint _tmp152_;
														guint8 _tmp153_;
														_tmp150_ = data;
														_tmp150__length1 = data_length1;
														_tmp151_ = offset;
														_tmp152_ = shift_count;
														_tmp150_[_tmp151_] |= (guint8) (2 << _tmp152_);
														_tmp153_ = _tmp150_[_tmp151_];
													} else {
														guint8 _tmp154_;
														_tmp154_ = p;
														if (((gint) _tmp154_) >= 64) {
															guint8* _tmp155_;
															gint _tmp155__length1;
															gint _tmp156_;
															gint _tmp157_;
															guint8 _tmp158_;
															_tmp155_ = data;
															_tmp155__length1 = data_length1;
															_tmp156_ = offset;
															_tmp157_ = shift_count;
															_tmp155_[_tmp156_] |= (guint8) (1 << _tmp157_);
															_tmp158_ = _tmp155_[_tmp156_];
														}
													}
												}
												_tmp159_ = shift_count;
												if (_tmp159_ == 0) {
													gint _tmp160_;
													_tmp160_ = offset;
													offset = _tmp160_ + 1;
													shift_count = 6;
												} else {
													gint _tmp161_;
													_tmp161_ = shift_count;
													shift_count = _tmp161_ - 2;
												}
											}
										}
									}
								}
							}
						}
					} else {
						Page* _tmp162_;
						gint _tmp163_ = 0;
						_tmp162_ = page;
						_tmp163_ = page_get_depth (_tmp162_);
						if (_tmp163_ == 1) {
							gint mask;
							gchar* _tmp164_;
							gint _tmp165_;
							gint _tmp166_;
							gint data_length;
							gint _tmp167_;
							guint8* _tmp168_ = NULL;
							gint offset;
							mask = 0x80;
							depth = 1;
							_tmp164_ = g_strdup ("DeviceGray");
							_g_free0 (color_space);
							color_space = _tmp164_;
							_tmp165_ = height;
							_tmp166_ = width;
							data_length = _tmp165_ * ((_tmp166_ + 7) / 8);
							_tmp167_ = data_length;
							_tmp168_ = g_new0 (guint8, _tmp167_);
							data = (g_free (data), NULL);
							data = _tmp168_;
							data_length1 = _tmp167_;
							_data_size_ = data_length1;
							offset = 0;
							{
								gint row;
								row = 0;
								{
									gboolean _tmp169_;
									_tmp169_ = TRUE;
									while (TRUE) {
										gboolean _tmp170_;
										gint _tmp172_;
										gint _tmp173_;
										gint _tmp174_;
										gint _tmp176_;
										GdkPixbuf* _tmp177_;
										gint _tmp178_ = 0;
										gint in_offset;
										_tmp170_ = _tmp169_;
										if (!_tmp170_) {
											gint _tmp171_;
											_tmp171_ = row;
											row = _tmp171_ + 1;
										}
										_tmp169_ = FALSE;
										_tmp172_ = row;
										_tmp173_ = height;
										if (!(_tmp172_ < _tmp173_)) {
											break;
										}
										_tmp174_ = mask;
										if (_tmp174_ != 0x80) {
											gint _tmp175_;
											_tmp175_ = offset;
											offset = _tmp175_ + 1;
											mask = 0x80;
										}
										_tmp176_ = row;
										_tmp177_ = image;
										_tmp178_ = gdk_pixbuf_get_rowstride (_tmp177_);
										in_offset = _tmp176_ * _tmp178_;
										{
											gint x;
											x = 0;
											{
												gboolean _tmp179_;
												_tmp179_ = TRUE;
												while (TRUE) {
													gboolean _tmp180_;
													gint _tmp182_;
													gint _tmp183_;
													gint _tmp184_;
													guint8* _tmp188_;
													gint _tmp188__length1;
													gint _tmp189_;
													gint _tmp190_;
													guint8 _tmp191_;
													gint _tmp196_;
													gint _tmp197_;
													_tmp180_ = _tmp179_;
													if (!_tmp180_) {
														gint _tmp181_;
														_tmp181_ = x;
														x = _tmp181_ + 1;
													}
													_tmp179_ = FALSE;
													_tmp182_ = x;
													_tmp183_ = width;
													if (!(_tmp182_ < _tmp183_)) {
														break;
													}
													_tmp184_ = mask;
													if (_tmp184_ == 0x80) {
														guint8* _tmp185_;
														gint _tmp185__length1;
														gint _tmp186_;
														guint8 _tmp187_;
														_tmp185_ = data;
														_tmp185__length1 = data_length1;
														_tmp186_ = offset;
														_tmp185_[_tmp186_] = (guint8) 0;
														_tmp187_ = _tmp185_[_tmp186_];
													}
													_tmp188_ = pixels;
													_tmp188__length1 = pixels_length1;
													_tmp189_ = in_offset;
													_tmp190_ = x;
													_tmp191_ = _tmp188_[_tmp189_ + (_tmp190_ * 3)];
													if (((gint) _tmp191_) != 0) {
														guint8* _tmp192_;
														gint _tmp192__length1;
														gint _tmp193_;
														gint _tmp194_;
														guint8 _tmp195_;
														_tmp192_ = data;
														_tmp192__length1 = data_length1;
														_tmp193_ = offset;
														_tmp194_ = mask;
														_tmp192_[_tmp193_] |= (guint8) _tmp194_;
														_tmp195_ = _tmp192_[_tmp193_];
													}
													_tmp196_ = mask;
													mask = _tmp196_ >> 1;
													_tmp197_ = mask;
													if (_tmp197_ == 0) {
														gint _tmp198_;
														_tmp198_ = offset;
														offset = _tmp198_ + 1;
														mask = 0x80;
													}
												}
											}
										}
									}
								}
							}
						} else {
							gchar* _tmp199_;
							gint _tmp200_;
							gint _tmp201_;
							gint data_length;
							gint _tmp202_;
							guint8* _tmp203_ = NULL;
							depth = 8;
							_tmp199_ = g_strdup ("DeviceGray");
							_g_free0 (color_space);
							color_space = _tmp199_;
							_tmp200_ = height;
							_tmp201_ = width;
							data_length = _tmp200_ * _tmp201_;
							_tmp202_ = data_length;
							_tmp203_ = g_new0 (guint8, _tmp202_);
							data = (g_free (data), NULL);
							data = _tmp203_;
							data_length1 = _tmp202_;
							_data_size_ = data_length1;
							{
								gint row;
								row = 0;
								{
									gboolean _tmp204_;
									_tmp204_ = TRUE;
									while (TRUE) {
										gboolean _tmp205_;
										gint _tmp207_;
										gint _tmp208_;
										gint _tmp209_;
										GdkPixbuf* _tmp210_;
										gint _tmp211_ = 0;
										gint in_offset;
										gint _tmp212_;
										gint _tmp213_;
										gint out_offset;
										_tmp205_ = _tmp204_;
										if (!_tmp205_) {
											gint _tmp206_;
											_tmp206_ = row;
											row = _tmp206_ + 1;
										}
										_tmp204_ = FALSE;
										_tmp207_ = row;
										_tmp208_ = height;
										if (!(_tmp207_ < _tmp208_)) {
											break;
										}
										_tmp209_ = row;
										_tmp210_ = image;
										_tmp211_ = gdk_pixbuf_get_rowstride (_tmp210_);
										in_offset = _tmp209_ * _tmp211_;
										_tmp212_ = row;
										_tmp213_ = width;
										out_offset = _tmp212_ * _tmp213_;
										{
											gint x;
											x = 0;
											{
												gboolean _tmp214_;
												_tmp214_ = TRUE;
												while (TRUE) {
													gboolean _tmp215_;
													gint _tmp217_;
													gint _tmp218_;
													guint8* _tmp219_;
													gint _tmp219__length1;
													gint _tmp220_;
													gint _tmp221_;
													guint8* _tmp222_;
													gint _tmp222__length1;
													gint _tmp223_;
													gint _tmp224_;
													guint8 _tmp225_;
													guint8 _tmp226_;
													_tmp215_ = _tmp214_;
													if (!_tmp215_) {
														gint _tmp216_;
														_tmp216_ = x;
														x = _tmp216_ + 1;
													}
													_tmp214_ = FALSE;
													_tmp217_ = x;
													_tmp218_ = width;
													if (!(_tmp217_ < _tmp218_)) {
														break;
													}
													_tmp219_ = data;
													_tmp219__length1 = data_length1;
													_tmp220_ = out_offset;
													_tmp221_ = x;
													_tmp222_ = pixels;
													_tmp222__length1 = pixels_length1;
													_tmp223_ = in_offset;
													_tmp224_ = x;
													_tmp225_ = _tmp222_[_tmp223_ + (_tmp224_ * 3)];
													_tmp219_[_tmp220_ + _tmp221_] = _tmp225_;
													_tmp226_ = _tmp219_[_tmp220_ + _tmp221_];
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp227_ = data;
				_tmp227__length1 = data_length1;
				_tmp229_ = book_compress_zlib (self, _tmp227_, _tmp227__length1, &_tmp228_);
				compressed_data = _tmp229_;
				compressed_data_length1 = _tmp228_;
				_compressed_data_size_ = compressed_data_length1;
				_tmp230_ = compressed_data;
				_tmp230__length1 = compressed_data_length1;
				if (_tmp230_ != NULL) {
					gint _tmp231_;
					const gchar* _tmp241_;
					_tmp231_ = depth;
					if (_tmp231_ > 1) {
						gsize jpeg_length = 0UL;
						GdkPixbuf* _tmp232_;
						gsize _tmp233_ = 0UL;
						gint _tmp234_ = 0;
						guint8* _tmp235_ = NULL;
						guint8* jpeg_data;
						gint jpeg_data_length1;
						gint _jpeg_data_size_;
						gsize _tmp236_;
						guint8* _tmp237_;
						gint _tmp237__length1;
						_tmp232_ = image;
						_tmp235_ = book_compress_jpeg (self, _tmp232_, &_tmp233_, &_tmp234_);
						jpeg_length = _tmp233_;
						jpeg_data = _tmp235_;
						jpeg_data_length1 = _tmp234_;
						_jpeg_data_size_ = jpeg_data_length1;
						_tmp236_ = jpeg_length;
						_tmp237_ = compressed_data;
						_tmp237__length1 = compressed_data_length1;
						if (_tmp236_ < ((gsize) _tmp237__length1)) {
							gchar* _tmp238_;
							guint8* _tmp239_;
							gint _tmp239__length1;
							guint8* _tmp240_;
							gint _tmp240__length1;
							_tmp238_ = g_strdup ("DCTDecode");
							_g_free0 (filter);
							filter = _tmp238_;
							_tmp239_ = jpeg_data;
							_tmp239__length1 = jpeg_data_length1;
							_tmp240_ = (_tmp239_ != NULL) ? _vala_array_dup1 (_tmp239_, _tmp239__length1) : ((gpointer) _tmp239_);
							_tmp240__length1 = _tmp239__length1;
							data = (g_free (data), NULL);
							data = _tmp240_;
							data_length1 = _tmp240__length1;
							_data_size_ = data_length1;
						}
						jpeg_data = (g_free (jpeg_data), NULL);
					}
					_tmp241_ = filter;
					if (_tmp241_ == NULL) {
						gchar* _tmp242_;
						guint8* _tmp243_;
						gint _tmp243__length1;
						guint8* _tmp244_;
						gint _tmp244__length1;
						_tmp242_ = g_strdup ("FlateDecode");
						_g_free0 (filter);
						filter = _tmp242_;
						_tmp243_ = compressed_data;
						_tmp243__length1 = compressed_data_length1;
						_tmp244_ = (_tmp243_ != NULL) ? _vala_array_dup2 (_tmp243_, _tmp243__length1) : ((gpointer) _tmp243_);
						_tmp244__length1 = _tmp243__length1;
						data = (g_free (data), NULL);
						data = _tmp244_;
						data_length1 = _tmp244__length1;
						_data_size_ = data_length1;
					}
				}
				_tmp245_ = writer;
				pdf_writer_write_string (_tmp245_, "\n");
				_tmp246_ = writer;
				_tmp247_ = pdf_writer_start_object (_tmp246_);
				number = _tmp247_;
				_tmp248_ = writer;
				_tmp249_ = number;
				_tmp250_ = g_strdup_printf ("%u 0 obj\n", _tmp249_);
				_tmp251_ = _tmp250_;
				pdf_writer_write_string (_tmp248_, _tmp251_);
				_g_free0 (_tmp251_);
				_tmp252_ = writer;
				pdf_writer_write_string (_tmp252_, "<<\n");
				_tmp253_ = writer;
				pdf_writer_write_string (_tmp253_, "/Type /Page\n");
				_tmp254_ = writer;
				_tmp255_ = pages_number;
				_tmp256_ = g_strdup_printf ("/Parent %u 0 R\n", _tmp255_);
				_tmp257_ = _tmp256_;
				pdf_writer_write_string (_tmp254_, _tmp257_);
				_g_free0 (_tmp257_);
				_tmp258_ = writer;
				_tmp259_ = i;
				_tmp260_ = number;
				_tmp261_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", _tmp259_, _tmp260_ + 1);
				_tmp262_ = _tmp261_;
				pdf_writer_write_string (_tmp258_, _tmp262_);
				_g_free0 (_tmp262_);
				_tmp263_ = writer;
				_tmp264_ = page_width;
				_tmp265_ = width_buffer;
				_tmp265__length1 = width_buffer_length1;
				_tmp266_ = g_ascii_formatd (_tmp265_, _tmp265__length1, "%.2f", _tmp264_);
				_tmp267_ = page_height;
				_tmp268_ = height_buffer;
				_tmp268__length1 = height_buffer_length1;
				_tmp269_ = g_ascii_formatd (_tmp268_, _tmp268__length1, "%.2f", _tmp267_);
				_tmp270_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp266_, _tmp269_);
				_tmp271_ = _tmp270_;
				pdf_writer_write_string (_tmp263_, _tmp271_);
				_g_free0 (_tmp271_);
				_tmp272_ = writer;
				_tmp273_ = number;
				_tmp274_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp273_ + 2);
				_tmp275_ = _tmp274_;
				pdf_writer_write_string (_tmp272_, _tmp275_);
				_g_free0 (_tmp275_);
				_tmp276_ = writer;
				pdf_writer_write_string (_tmp276_, ">>\n");
				_tmp277_ = writer;
				pdf_writer_write_string (_tmp277_, "endobj\n");
				_tmp278_ = writer;
				pdf_writer_write_string (_tmp278_, "\n");
				_tmp279_ = writer;
				_tmp280_ = pdf_writer_start_object (_tmp279_);
				number = _tmp280_;
				_tmp281_ = writer;
				_tmp282_ = number;
				_tmp283_ = g_strdup_printf ("%u 0 obj\n", _tmp282_);
				_tmp284_ = _tmp283_;
				pdf_writer_write_string (_tmp281_, _tmp284_);
				_g_free0 (_tmp284_);
				_tmp285_ = writer;
				pdf_writer_write_string (_tmp285_, "<<\n");
				_tmp286_ = writer;
				pdf_writer_write_string (_tmp286_, "/Type /XObject\n");
				_tmp287_ = writer;
				pdf_writer_write_string (_tmp287_, "/Subtype /Image\n");
				_tmp288_ = writer;
				_tmp289_ = width;
				_tmp290_ = g_strdup_printf ("/Width %d\n", _tmp289_);
				_tmp291_ = _tmp290_;
				pdf_writer_write_string (_tmp288_, _tmp291_);
				_g_free0 (_tmp291_);
				_tmp292_ = writer;
				_tmp293_ = height;
				_tmp294_ = g_strdup_printf ("/Height %d\n", _tmp293_);
				_tmp295_ = _tmp294_;
				pdf_writer_write_string (_tmp292_, _tmp295_);
				_g_free0 (_tmp295_);
				_tmp296_ = writer;
				_tmp297_ = color_space;
				_tmp298_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp297_);
				_tmp299_ = _tmp298_;
				pdf_writer_write_string (_tmp296_, _tmp299_);
				_g_free0 (_tmp299_);
				_tmp300_ = writer;
				_tmp301_ = depth;
				_tmp302_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp301_);
				_tmp303_ = _tmp302_;
				pdf_writer_write_string (_tmp300_, _tmp303_);
				_g_free0 (_tmp303_);
				_tmp304_ = writer;
				_tmp305_ = data;
				_tmp305__length1 = data_length1;
				_tmp306_ = g_strdup_printf ("/Length %d\n", _tmp305__length1);
				_tmp307_ = _tmp306_;
				pdf_writer_write_string (_tmp304_, _tmp307_);
				_g_free0 (_tmp307_);
				_tmp308_ = filter;
				if (_tmp308_ != NULL) {
					PDFWriter* _tmp309_;
					const gchar* _tmp310_;
					gchar* _tmp311_ = NULL;
					gchar* _tmp312_;
					_tmp309_ = writer;
					_tmp310_ = filter;
					_tmp311_ = g_strdup_printf ("/Filter /%s\n", _tmp310_);
					_tmp312_ = _tmp311_;
					pdf_writer_write_string (_tmp309_, _tmp312_);
					_g_free0 (_tmp312_);
				}
				_tmp313_ = writer;
				pdf_writer_write_string (_tmp313_, ">>\n");
				_tmp314_ = writer;
				pdf_writer_write_string (_tmp314_, "stream\n");
				_tmp315_ = writer;
				_tmp316_ = data;
				_tmp316__length1 = data_length1;
				pdf_writer_write (_tmp315_, _tmp316_, _tmp316__length1);
				_tmp317_ = writer;
				pdf_writer_write_string (_tmp317_, "\n");
				_tmp318_ = writer;
				pdf_writer_write_string (_tmp318_, "endstream\n");
				_tmp319_ = writer;
				pdf_writer_write_string (_tmp319_, "endobj\n");
				_tmp320_ = page_width;
				_tmp321_ = width_buffer;
				_tmp321__length1 = width_buffer_length1;
				_tmp322_ = g_ascii_formatd (_tmp321_, _tmp321__length1, "%f", _tmp320_);
				_tmp323_ = page_height;
				_tmp324_ = height_buffer;
				_tmp324__length1 = height_buffer_length1;
				_tmp325_ = g_ascii_formatd (_tmp324_, _tmp324__length1, "%f", _tmp323_);
				_tmp326_ = i;
				_tmp327_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp322_, _tmp325_, _tmp326_);
				command = _tmp327_;
				_tmp328_ = writer;
				pdf_writer_write_string (_tmp328_, "\n");
				_tmp329_ = writer;
				_tmp330_ = pdf_writer_start_object (_tmp329_);
				number = _tmp330_;
				_tmp331_ = writer;
				_tmp332_ = number;
				_tmp333_ = g_strdup_printf ("%u 0 obj\n", _tmp332_);
				_tmp334_ = _tmp333_;
				pdf_writer_write_string (_tmp331_, _tmp334_);
				_g_free0 (_tmp334_);
				_tmp335_ = writer;
				pdf_writer_write_string (_tmp335_, "<<\n");
				_tmp336_ = writer;
				_tmp337_ = command;
				_tmp338_ = strlen (_tmp337_);
				_tmp339_ = _tmp338_;
				_tmp340_ = g_strdup_printf ("/Length %d\n", _tmp339_ + 1);
				_tmp341_ = _tmp340_;
				pdf_writer_write_string (_tmp336_, _tmp341_);
				_g_free0 (_tmp341_);
				_tmp342_ = writer;
				pdf_writer_write_string (_tmp342_, ">>\n");
				_tmp343_ = writer;
				pdf_writer_write_string (_tmp343_, "stream\n");
				_tmp344_ = writer;
				_tmp345_ = command;
				pdf_writer_write_string (_tmp344_, _tmp345_);
				_tmp346_ = writer;
				pdf_writer_write_string (_tmp346_, "\n");
				_tmp347_ = writer;
				pdf_writer_write_string (_tmp347_, "endstream\n");
				_tmp348_ = writer;
				pdf_writer_write_string (_tmp348_, "endobj\n");
				_g_free0 (command);
				compressed_data = (g_free (compressed_data), NULL);
				data = (g_free (data), NULL);
				height_buffer = (g_free (height_buffer), NULL);
				width_buffer = (g_free (width_buffer), NULL);
				_g_free0 (filter);
				_g_free0 (color_space);
				_g_object_unref0 (image);
				_page_unref0 (page);
			}
		}
	}
	_tmp349_ = writer;
	pdf_writer_write_string (_tmp349_, "\n");
	_tmp350_ = writer;
	_tmp351_ = pdf_writer_start_object (_tmp350_);
	info_number = _tmp351_;
	_tmp352_ = writer;
	_tmp353_ = info_number;
	_tmp354_ = g_strdup_printf ("%u 0 obj\n", _tmp353_);
	_tmp355_ = _tmp354_;
	pdf_writer_write_string (_tmp352_, _tmp355_);
	_g_free0 (_tmp355_);
	_tmp356_ = writer;
	pdf_writer_write_string (_tmp356_, "<<\n");
	_tmp357_ = writer;
	_tmp358_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
	_tmp359_ = _tmp358_;
	pdf_writer_write_string (_tmp357_, _tmp359_);
	_g_free0 (_tmp359_);
	_tmp360_ = writer;
	pdf_writer_write_string (_tmp360_, ">>\n");
	_tmp361_ = writer;
	pdf_writer_write_string (_tmp361_, "endobj\n");
	_tmp362_ = writer;
	_tmp363_ = _tmp362_->offset;
	xref_offset = _tmp363_;
	_tmp364_ = writer;
	pdf_writer_write_string (_tmp364_, "xref\n");
	_tmp365_ = writer;
	_tmp366_ = writer;
	_tmp367_ = _tmp366_->object_offsets;
	_tmp368_ = g_list_length (_tmp367_);
	_tmp369_ = g_strdup_printf ("1 %zu\n", (gsize) _tmp368_);
	_tmp370_ = _tmp369_;
	pdf_writer_write_string (_tmp365_, _tmp370_);
	_g_free0 (_tmp370_);
	_tmp371_ = writer;
	_tmp372_ = _tmp371_->object_offsets;
	{
		GList* offset_collection = NULL;
		GList* offset_it = NULL;
		offset_collection = _tmp372_;
		for (offset_it = offset_collection; offset_it != NULL; offset_it = offset_it->next) {
			guint offset = 0U;
			offset = GPOINTER_TO_UINT (offset_it->data);
			{
				PDFWriter* _tmp373_;
				guint _tmp374_;
				gchar* _tmp375_ = NULL;
				gchar* _tmp376_;
				_tmp373_ = writer;
				_tmp374_ = offset;
				_tmp375_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp374_);
				_tmp376_ = _tmp375_;
				pdf_writer_write_string (_tmp373_, _tmp376_);
				_g_free0 (_tmp376_);
			}
		}
	}
	_tmp377_ = writer;
	pdf_writer_write_string (_tmp377_, "trailer\n");
	_tmp378_ = writer;
	pdf_writer_write_string (_tmp378_, "<<\n");
	_tmp379_ = writer;
	_tmp380_ = writer;
	_tmp381_ = _tmp380_->object_offsets;
	_tmp382_ = g_list_length (_tmp381_);
	_tmp383_ = g_strdup_printf ("/Size %zu\n", (gsize) _tmp382_);
	_tmp384_ = _tmp383_;
	pdf_writer_write_string (_tmp379_, _tmp384_);
	_g_free0 (_tmp384_);
	_tmp385_ = writer;
	_tmp386_ = info_number;
	_tmp387_ = g_strdup_printf ("/Info %u 0 R\n", _tmp386_);
	_tmp388_ = _tmp387_;
	pdf_writer_write_string (_tmp385_, _tmp388_);
	_g_free0 (_tmp388_);
	_tmp389_ = writer;
	_tmp390_ = catalog_number;
	_tmp391_ = g_strdup_printf ("/Root %u 0 R\n", _tmp390_);
	_tmp392_ = _tmp391_;
	pdf_writer_write_string (_tmp389_, _tmp392_);
	_g_free0 (_tmp392_);
	_tmp393_ = writer;
	pdf_writer_write_string (_tmp393_, ">>\n");
	_tmp394_ = writer;
	pdf_writer_write_string (_tmp394_, "startxref\n");
	_tmp395_ = writer;
	_tmp396_ = xref_offset;
	_tmp397_ = g_strdup_printf ("%zu\n", _tmp396_);
	_tmp398_ = _tmp397_;
	pdf_writer_write_string (_tmp395_, _tmp398_);
	_g_free0 (_tmp398_);
	_tmp399_ = writer;
	pdf_writer_write_string (_tmp399_, "%%EOF\n");
	_pdf_writer_unref0 (writer);
	_g_object_unref0 (stream);
}


void book_save (Book* self, const gchar* type, GFile* file, GError** error) {
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_strcmp0;
	_tmp1_ = type;
	_tmp2_ = _tmp0_ (_tmp1_, "jpeg");
	if (_tmp2_ == 0) {
		GFile* _tmp3_;
		_tmp3_ = file;
		book_save_multi_file (self, "jpeg", _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		GCompareFunc _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_ = 0;
		_tmp4_ = g_strcmp0;
		_tmp5_ = type;
		_tmp6_ = _tmp4_ (_tmp5_, "png");
		if (_tmp6_ == 0) {
			GFile* _tmp7_;
			_tmp7_ = file;
			book_save_multi_file (self, "png", _tmp7_, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				return;
			}
		} else {
			GCompareFunc _tmp8_;
			const gchar* _tmp9_;
			gint _tmp10_ = 0;
			_tmp8_ = g_strcmp0;
			_tmp9_ = type;
			_tmp10_ = _tmp8_ (_tmp9_, "tiff");
			if (_tmp10_ == 0) {
				GFile* _tmp11_;
				_tmp11_ = file;
				book_save_multi_file (self, "tiff", _tmp11_, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
			} else {
				GCompareFunc _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_ = 0;
				_tmp12_ = g_strcmp0;
				_tmp13_ = type;
				_tmp14_ = _tmp12_ (_tmp13_, "ps");
				if (_tmp14_ == 0) {
					GFile* _tmp15_;
					_tmp15_ = file;
					book_save_ps (self, _tmp15_, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						return;
					}
				} else {
					GCompareFunc _tmp16_;
					const gchar* _tmp17_;
					gint _tmp18_ = 0;
					_tmp16_ = g_strcmp0;
					_tmp17_ = type;
					_tmp18_ = _tmp16_ (_tmp17_, "pdf");
					if (_tmp18_ == 0) {
						GFile* _tmp19_;
						_tmp19_ = file;
						book_save_pdf (self, _tmp19_, &_inner_error_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							return;
						}
					}
				}
			}
		}
	}
}


void book_set_needs_saving (Book* self, gboolean needs_saving) {
	gboolean _tmp0_;
	gboolean needed_saving;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->needs_saving;
	needed_saving = _tmp0_;
	_tmp1_ = needs_saving;
	self->priv->needs_saving = _tmp1_;
	_tmp2_ = needed_saving;
	_tmp3_ = needs_saving;
	if (_tmp2_ != _tmp3_) {
		g_signal_emit_by_name (self, "needs-saving-changed");
	}
}


gboolean book_get_needs_saving (Book* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->needs_saving;
	result = _tmp0_;
	return result;
}


static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_page (param_values + 1), data2);
}


static void value_book_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_book_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		book_unref (value->data[0].v_pointer);
	}
}


static void value_book_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = book_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_book_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_book_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Book* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = book_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_book_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Book** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = book_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBook* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_book (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK), NULL);
	return value->data[0].v_pointer;
}


void value_set_book (GValue* value, gpointer v_object) {
	Book* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		book_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		book_unref (old);
	}
}


void value_take_book (GValue* value, gpointer v_object) {
	Book* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		book_unref (old);
	}
}


static void book_class_init (BookClass * klass) {
	book_parent_class = g_type_class_peek_parent (klass);
	BOOK_CLASS (klass)->finalize = book_finalize;
	g_type_class_add_private (klass, sizeof (BookPrivate));
	g_signal_new ("page_added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
	g_signal_new ("page_removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
	g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("needs_saving_changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void book_instance_init (Book * self) {
	self->priv = BOOK_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void book_finalize (Book* obj) {
	Book * self;
	self = BOOK (obj);
	__g_list_free__page_unref0_0 (self->priv->pages);
}


GType book_get_type (void) {
	static volatile gsize book_type_id__volatile = 0;
	if (g_once_init_enter (&book_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_book_init, value_book_free_value, value_book_copy_value, value_book_peek_pointer, "p", value_book_collect_value, "p", value_book_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType book_type_id;
		book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Book", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&book_type_id__volatile, book_type_id);
	}
	return book_type_id__volatile;
}


gpointer book_ref (gpointer instance) {
	Book* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void book_unref (gpointer instance) {
	Book* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOOK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	GFileOutputStream* _tmp1_;
	g_return_val_if_fail (stream != NULL, NULL);
	self = (PDFWriter*) g_type_create_instance (object_type);
	_tmp0_ = stream;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = _tmp1_;
	return self;
}


PDFWriter* pdf_writer_new (GFileOutputStream* stream) {
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
}


void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1) {
	gsize _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFileOutputStream* _tmp0_;
		guint8* _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = self->priv->stream;
		_tmp1_ = data;
		_tmp1__length1 = data_length1;
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("book.vala:538: Error writing PDF: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->offset;
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	self->offset = _tmp4_ + _tmp5__length1;
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


void pdf_writer_write_string (PDFWriter* self, const gchar* text) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint8* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
	_tmp3_ = (guint8*) _tmp2_;
	_tmp3__length1 = _tmp1_;
	pdf_writer_write (self, _tmp3_, _tmp1_);
	_tmp3_ = (g_free (_tmp3_), NULL);
}


guint pdf_writer_start_object (PDFWriter* self) {
	guint result = 0U;
	gsize _tmp0_;
	GList* _tmp1_;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->offset;
	self->object_offsets = g_list_append (self->object_offsets, GUINT_TO_POINTER ((guint) _tmp0_));
	_tmp1_ = self->object_offsets;
	_tmp2_ = g_list_length (_tmp1_);
	result = _tmp2_;
	return result;
}


static void value_pdf_writer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_pdf_writer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		pdf_writer_unref (value->data[0].v_pointer);
	}
}


static void value_pdf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_pdf_writer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_pdf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PDFWriter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pdf_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_pdf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PDFWriter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPDFWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_pdf_writer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
	return value->data[0].v_pointer;
}


void value_set_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pdf_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdf_writer_unref (old);
	}
}


void value_take_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdf_writer_unref (old);
	}
}


static void pdf_writer_class_init (PDFWriterClass * klass) {
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
	PDF_WRITER_CLASS (klass)->finalize = pdf_writer_finalize;
	g_type_class_add_private (klass, sizeof (PDFWriterPrivate));
}


static void pdf_writer_instance_init (PDFWriter * self) {
	self->priv = PDF_WRITER_GET_PRIVATE (self);
	self->offset = (gsize) 0;
	self->ref_count = 1;
}


static void pdf_writer_finalize (PDFWriter* obj) {
	PDFWriter * self;
	self = PDF_WRITER (obj);
	_g_list_free0 (self->object_offsets);
	_g_object_unref0 (self->priv->stream);
}


GType pdf_writer_get_type (void) {
	static volatile gsize pdf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pdf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pdf_writer_type_id;
		pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pdf_writer_type_id__volatile, pdf_writer_type_id);
	}
	return pdf_writer_type_id__volatile;
}


gpointer pdf_writer_ref (gpointer instance) {
	PDFWriter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void pdf_writer_unref (gpointer instance) {
	PDFWriter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PDF_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1) {
	cairo_status_t result;
	result = ps_writer_write_cairo_data (self, data, data_length1);
	return result;
}


PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream) {
	PsWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	GFileOutputStream* _tmp1_;
	cairo_surface_t* _tmp2_;
	g_return_val_if_fail (stream != NULL, NULL);
	self = (PsWriter*) g_type_create_instance (object_type);
	_tmp0_ = stream;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->stream);
	self->stream = _tmp1_;
	_tmp2_ = cairo_ps_surface_create_for_stream (_ps_writer_write_cairo_data_cairo_write_func_t, self, (gdouble) 0, (gdouble) 0);
	_cairo_surface_destroy0 (self->surface);
	self->surface = _tmp2_;
	return self;
}


PsWriter* ps_writer_new (GFileOutputStream* stream) {
	return ps_writer_construct (TYPE_PS_WRITER, stream);
}


static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1) {
	cairo_status_t result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		GFileOutputStream* _tmp0_;
		guint8* _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = self->stream;
		_tmp1_ = data;
		_tmp1__length1 = data_length1;
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("book.vala:574: Error writing data: %s", _tmp3_);
		result = CAIRO_STATUS_WRITE_ERROR;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = CAIRO_STATUS_SUCCESS;
	return result;
}


static void value_ps_writer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_ps_writer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		ps_writer_unref (value->data[0].v_pointer);
	}
}


static void value_ps_writer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ps_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_ps_writer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_ps_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PsWriter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ps_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_ps_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PsWriter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ps_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPsWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PS_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_ps_writer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER), NULL);
	return value->data[0].v_pointer;
}


void value_set_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ps_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ps_writer_unref (old);
	}
}


void value_take_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ps_writer_unref (old);
	}
}


static void ps_writer_class_init (PsWriterClass * klass) {
	ps_writer_parent_class = g_type_class_peek_parent (klass);
	PS_WRITER_CLASS (klass)->finalize = ps_writer_finalize;
}


static void ps_writer_instance_init (PsWriter * self) {
	self->ref_count = 1;
}


static void ps_writer_finalize (PsWriter* obj) {
	PsWriter * self;
	self = PS_WRITER (obj);
	_cairo_surface_destroy0 (self->surface);
	_g_object_unref0 (self->stream);
}


GType ps_writer_get_type (void) {
	static volatile gsize ps_writer_type_id__volatile = 0;
	if (g_once_init_enter (&ps_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ps_writer_init, value_ps_writer_free_value, value_ps_writer_copy_value, value_ps_writer_peek_pointer, "p", value_ps_writer_collect_value, "p", value_ps_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PsWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ps_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PsWriter), 0, (GInstanceInitFunc) ps_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ps_writer_type_id;
		ps_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PsWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ps_writer_type_id__volatile, ps_writer_type_id);
	}
	return ps_writer_type_id__volatile;
}


gpointer ps_writer_ref (gpointer instance) {
	PsWriter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void ps_writer_unref (gpointer instance) {
	PsWriter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PS_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



