/* presui.c
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "config.h"
#include "presui.h"
#include "SRMessages.h"
#include <glade/glade.h>
#include "srintl.h"
#include "gnopiui.h"
#include "libsrconf.h"

static GtkWidget *w_presentation;
static GtkWidget *w_presentation_add;
static GtkWidget *tv_presentation_order;
static GtkWidget *tv_pres_add_chunk;
static GtkWidget *cb_pres_add_role;
static GtkWidget *cb_pres_add_device;
static GtkWidget *cb_pres_add_event;
static GtkWidget *bt_pres_add_paste;
static GtkWidget *et_pres_add_chunks;
static GtkTreeIter current_iter;
static gboolean	 new_item_in_list;
static gboolean  new_chunk;
static gboolean  pres_changed;
static gboolean  pres_add_changed;

static gchar  *copy_paste = NULL; 
extern GSList *pres_list;
static GSList *current_item = NULL;
enum
{
    PRESENTATION_DEVICE,
    PRESENTATION_ROLE,
    PRESENTATION_EVENT,
    PRESENTATION_CHUNK,
    PRESENTATION_NO_COLUMN
};

enum
{
    PRESENTATION_ADD_LIST,
    PRESENTATION_EDITABLE,
    PRESENTATION_ADD_NO_COLUMN
};


static void
presui_presentation_add_apply_sensitivity (gboolean state)
{
    pres_add_changed = state;
}

static void
presui_presentation_add_paste_sensitivity (gboolean state)
{
    if (w_presentation_add)
    {
	gtk_widget_set_sensitive (  GTK_WIDGET (bt_pres_add_paste), 
				    state);
    }
}

static void
presui_free_slist_char_data (gpointer data,
			     gpointer user_data)
{
    g_free (data);
    data = NULL;
}

enum
{
    PRES_TAG_IDLE = 0,
    PRES_TAG_START,
    PRES_TAG_BRACKET
};

static GSList*
presui_split_chunk (const gchar *chunk)
{
    GSList 	*rv = NULL;	
    gchar 	*iter;
    gint 	tag_state = PRES_TAG_IDLE;
    gchar 	*start = NULL;    

    sru_return_val_if_fail (chunk, rv);
    
    iter = (gchar*)chunk;
    
    while (iter && *iter != '\0')
    {
	switch (tag_state)
	{
	    case PRES_TAG_IDLE:
	    {
		if (*iter == '%')
		{
		    tag_state = PRES_TAG_START;
		    start = iter;
		}
	    }
	    break;
	    case PRES_TAG_START:
	    {
		if (*iter == '[')
		{
		    tag_state = PRES_TAG_BRACKET;
		}
		if (*iter == '%')
		{
		    rv = g_slist_append (rv, g_strndup (start, iter - start + 1));
		    tag_state = PRES_TAG_IDLE;
		}
	    }
	    break;
	    case PRES_TAG_BRACKET:
	    {
		if (*iter == ']')
		{
		    tag_state = PRES_TAG_START;
		}
	    }
	}
	
	iter++;
    }
    
    return rv;
}

static gchar*
presui_get_chunk (void)
{
    GtkTreeModel 	*model; 	
    GtkTreeIter		iter;
    gboolean		valid;
    gchar		*str = NULL;
    model = gtk_tree_view_get_model ( GTK_TREE_VIEW (tv_pres_add_chunk) );
    valid = gtk_tree_model_get_iter_first ( model, &iter );
    
    while (valid)
    {
	gchar *key = NULL;
	gchar *tmp = NULL;
	if (GTK_IS_LIST_STORE (model))
	{
	    gtk_tree_model_get (model, 	&iter,
        			PRESENTATION_ADD_LIST,&key,
                    		-1);
	}
	if (strcmp (key, "%%"))
	{
	    if (str)
		tmp = g_strdup_printf ("%s%s", str, key);
	    else
		tmp = g_strdup (key);
	    g_free (str);
	    str = tmp;
	}
	g_free (key);
	valid = gtk_tree_model_iter_next ( model, &iter);
    }

    return str;
}

static void
presui_refresh_entry (void)
{
    gchar *chunk = presui_get_chunk ();
    if (chunk && strlen (chunk) > 0)
	gtk_entry_set_text (GTK_ENTRY (et_pres_add_chunks), chunk); 
    else
	gtk_entry_set_text (GTK_ENTRY (et_pres_add_chunks), "%%"); 
}

static void
presui_pres_update_list (void)
{
    GtkTreeModel 	*model; 	
    GtkTreeSelection 	*selection;
    model 	= gtk_tree_view_get_model 	( GTK_TREE_VIEW (tv_presentation_order) );
    selection 	= gtk_tree_view_get_selection 	( GTK_TREE_VIEW (tv_presentation_order) );	    

    if (GTK_IS_LIST_STORE (model))
    {
	gboolean set = TRUE;
	gchar *device = NULL;
	gchar *role   = NULL;
	gchar *event  = NULL;
	gchar *chunk  = NULL;
	device = (gchar*)gtk_entry_get_text (GTK_ENTRY 
				    	    (GTK_COMBO 
				    	    (cb_pres_add_device)->entry
				    	    ));
    	role = (gchar*)gtk_entry_get_text   (GTK_ENTRY 
				    	    (GTK_COMBO 
				    	    (cb_pres_add_role)->entry
				    	    ));
	event = (gchar*)gtk_entry_get_text  (GTK_ENTRY 
				    	    (GTK_COMBO 
				    	    (cb_pres_add_event)->entry
				    	    ));
	chunk = presui_get_chunk ();
	
	if (new_item_in_list)
	{
	    if (!presconf_item_exist(device, role, event) &&
		strlen (chunk) > 0)
	    {
		presconf_append_item_to_list (	device,
			    			role,
			    			event,
			    			chunk);
		gtk_list_store_append ( GTK_LIST_STORE (model), &current_iter);
		selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW 
						    (tv_presentation_order));
		gtk_tree_selection_select_iter (selection, 
						&current_iter);
		new_item_in_list = FALSE;
	    }
	    else
		set = FALSE;
	}
	else
	{
	    if (current_item)
	    {
		PresentationStruct *value = 
		    (PresentationStruct*)current_item->data;
		g_free (value->chunk);
		value->chunk = g_strdup (chunk);
		current_item = NULL;
	    }
	}
	
	if (set)
	{
	    gtk_list_store_set (GTK_LIST_STORE (model), 
				&current_iter, 
				PRESENTATION_DEVICE, 	device,
				PRESENTATION_ROLE, 	role,
				PRESENTATION_EVENT, 	event,
				PRESENTATION_CHUNK,	chunk,
				-1 );
	}
	g_free (chunk);
    }

}
static void
presui_pres_add_copy_clicked  (GtkWidget 	*widget,
				gpointer	data)
{
    g_free (copy_paste);
    copy_paste = presui_get_chunk ();
    presui_presentation_add_paste_sensitivity (TRUE);
}


static void
presui_pres_add_paste_clicked  (GtkWidget 	*widget,
				gpointer	data)
{
    if (copy_paste != NULL)
    {
	GSList *list = NULL;
	GtkTreeModel *model;
	GtkTreeIter iter;
	
	presui_presentation_add_apply_sensitivity (TRUE);
	
	model 	 = gtk_tree_view_get_model ( GTK_TREE_VIEW (tv_pres_add_chunk) );
	    
	gtk_list_store_clear (GTK_LIST_STORE (model));
	
	list = presui_split_chunk (copy_paste);
	    
	while (list)
	{
	    gtk_list_store_append ( GTK_LIST_STORE (model), &iter);
	    gtk_list_store_set (GTK_LIST_STORE (model), &iter, 
	    	    		PRESENTATION_ADD_LIST, 	(gchar*)list->data,
				PRESENTATION_EDITABLE,  TRUE,
				-1);
	    list = list->next;
	}
	    
	g_slist_foreach (list, presui_free_slist_char_data, NULL);
	g_slist_free (list);
	
	presui_refresh_entry ();
    }
}

static GtkTreeModel*
presui_create_add_model (void)
{
    GtkListStore *store;
      
    store = gtk_list_store_new (PRESENTATION_ADD_NO_COLUMN, 
				G_TYPE_STRING, G_TYPE_BOOLEAN);
    
    return GTK_TREE_MODEL (store);
}

static void
presui_pres_chunk_add_new_clicked (GtkWidget	*widget,
				gpointer	data)
{
    GtkTreeIter 	iter;
    GtkTreeModel 	*model; 	
    model = gtk_tree_view_get_model ( GTK_TREE_VIEW (tv_pres_add_chunk) );
    
    presui_presentation_add_apply_sensitivity (TRUE);
    
    new_chunk = TRUE;
    
    gtk_list_store_append ( GTK_LIST_STORE (model), &iter);
    gtk_list_store_set (GTK_LIST_STORE (model), &iter, 
        		PRESENTATION_ADD_LIST,  "%%",
			PRESENTATION_EDITABLE,  TRUE,
			-1);
    presui_refresh_entry ();
}


static void
presui_pres_chunk_remove_clicked (GtkWidget	*widget,
				  gpointer	data)
{
    GtkTreeIter	 iter;
    GtkTreeModel *model; 	
    GtkTreeSelection 	*selection;
    selection 	= 
	gtk_tree_view_get_selection ( GTK_TREE_VIEW (tv_pres_add_chunk) );	    
    model 	= 
	gtk_tree_view_get_model ( GTK_TREE_VIEW (tv_pres_add_chunk) );
	
    presui_presentation_add_apply_sensitivity (TRUE);
    
    if (gtk_tree_selection_get_selected (selection, NULL, &iter))
	gtk_list_store_remove ( GTK_LIST_STORE (model), &iter);
    presui_refresh_entry ();
}

static void
presui_cell_edited (GtkCellRendererText *cell,
		    const gchar		*path_string,
		    const gchar		*new_text,
		    gpointer 		data)
{
    GtkTreeModel *model = GTK_TREE_MODEL (data);
    GtkTreePath  *path = gtk_tree_path_new_from_string (path_string);
    GtkTreeIter	 iter;
    presui_presentation_add_apply_sensitivity (TRUE);
    gtk_tree_model_get_iter (model, &iter, path);
    gtk_list_store_set (GTK_LIST_STORE (model), &iter, 
        		PRESENTATION_ADD_LIST,  new_text,
			-1);
    presui_refresh_entry ();
}

static void
presui_show_chunk_in_list (const gchar *chunk)
{
    GtkTreeModel *model = NULL;
    GtkTreeIter  iter;
    GSList *list = NULL;
    model = gtk_tree_view_get_model ( GTK_TREE_VIEW (tv_pres_add_chunk) );
	    
    gtk_list_store_clear (GTK_LIST_STORE (model));
    
    list = presui_split_chunk (chunk);
	    
    while (list)
    {
        gtk_list_store_append ( GTK_LIST_STORE (model), &iter);
        gtk_list_store_set (GTK_LIST_STORE (model), &iter, 
    	    		    PRESENTATION_ADD_LIST, (gchar*)list->data,
			    PRESENTATION_EDITABLE,  TRUE,
			    -1);
	list = list->next;
    }
	    
    g_slist_foreach (list, presui_free_slist_char_data, NULL);
    g_slist_free (list);
}

static void
presui_pres_add_cb_changed (GtkWidget *widget,
			    gpointer  data)
{
    presui_presentation_add_apply_sensitivity (TRUE);
}

static void
presui_pres_chunk_move_clicked (GtkWidget *widget,
				gpointer data)
{
    GtkTreeModel	*model;
    GtkTreeSelection 	*selection;
    GtkTreeIter		iter;
    model 	= gtk_tree_view_get_model 	( GTK_TREE_VIEW (tv_pres_add_chunk) );
    selection 	= gtk_tree_view_get_selection 	( GTK_TREE_VIEW (tv_pres_add_chunk) );	    

    if (gtk_tree_selection_get_selected (selection, NULL, &iter))
    {
	gchar *cmd = (gchar*)data;
	GtkTreeIter next_iter;
	GtkTreePath *next_path;
	gboolean is_valid = FALSE;
	
	next_path = gtk_tree_model_get_path (model, &iter);
	
	if (!strcmp (cmd, "UP"))
	{
	    if (gtk_tree_path_prev (next_path))
	    {
		if (gtk_tree_model_get_iter (model, &next_iter, next_path))
		    is_valid = TRUE;
	    }
	}
	if (!strcmp (cmd, "DOWN"))
	{
	    gtk_tree_path_next (next_path);
	    if (gtk_tree_model_get_iter (model, &next_iter, next_path))
		is_valid = TRUE;
	}
	gtk_tree_path_free (next_path);
	
	if (is_valid)
	{
	    gchar *chunk1,*chunk2;
	    presui_presentation_add_apply_sensitivity (TRUE);
	    
	    gtk_tree_model_get (model, 	&iter,
				PRESENTATION_ADD_LIST,  &chunk1,
            			-1);
	    gtk_tree_model_get (model, 	&next_iter,
				PRESENTATION_ADD_LIST,  &chunk2,
            			-1);
	
	    if (chunk1 != NULL)
	    {
		gtk_list_store_set (GTK_LIST_STORE (model), &next_iter, 
		    	    	    PRESENTATION_ADD_LIST,  chunk1,
				    PRESENTATION_EDITABLE,  TRUE,
				    -1);
	    }
	    if (chunk2 != NULL)
	    {
		gtk_list_store_set (GTK_LIST_STORE (model), &iter, 
		    	    	    PRESENTATION_ADD_LIST,  chunk2,
				    PRESENTATION_EDITABLE,  TRUE,
				    -1);
	    }
	    
	    gtk_tree_selection_select_iter (selection, &next_iter);
	    presui_refresh_entry ();
	}
    }
}

static GtkTargetEntry row_targets[] = 
{
{ 
    "GTK_TREE_MODEL_ROW", 
    GTK_TARGET_SAME_APP,
    PRESENTATION_ADD_LIST 
}
};

void
presui_drop_cb 	    (GtkWidget        *widget,
		    GdkDragContext   *context,
		    gint              x,
		    gint              y,
		    GtkSelectionData *selection_data,
		    guint             info,
		    guint32           time,
		    gpointer   	      ientry)

{
    presui_presentation_add_apply_sensitivity (TRUE);
}

static void
presui_pres_add_et_activate (GtkWidget 	*widget,
			    gpointer	user_data)
{
    presui_presentation_add_apply_sensitivity (TRUE);
    presui_show_chunk_in_list ( gtk_entry_get_text ( GTK_ENTRY (widget) ));
}

static void
presui_response_presentation_add_event (GtkDialog *dialog,
					gint       response_id,
					gpointer   user_data)
{
    switch (response_id)
    {
     case GTK_RESPONSE_OK: 
        {
	    if (pres_add_changed)
    		presui_pres_update_list ();
	    gtk_widget_hide ((GtkWidget*)dialog);
	}
        break;
     case GTK_RESPONSE_APPLY:
        {
	    pres_add_changed = FALSE;
	    presui_pres_update_list ();
	    presui_presentation_add_apply_sensitivity (FALSE);
	}
        break;
     case GTK_RESPONSE_HELP:
	    gn_load_help ("gnopernicus-presentation");
	break;
     default:
	    gtk_widget_hide ((GtkWidget*)dialog);
        break;
    }
}


static gint
presui_delete_emit_response_cancel (GtkDialog *dialog,
				    GdkEventAny *event,
				    gpointer data)
{
    gtk_dialog_response (GTK_DIALOG (dialog),
			 GTK_RESPONSE_CANCEL);
    return TRUE; /* Do not destroy */
}

static void
presui_set_handler_presentation_add (GladeXML *xml)
{
    GtkTreeModel 	*model;
    GtkCellRenderer 	*cell_renderer;
    GtkTreeSelection 	*selection;
    GtkTreeViewColumn 	*column;

    w_presentation_add 	= glade_xml_get_widget (xml, "w_presentation_add");
    tv_pres_add_chunk	= glade_xml_get_widget (xml, "tv_pres_add_chunk");
    cb_pres_add_device	= glade_xml_get_widget (xml, "cb_pres_add_device");
    cb_pres_add_role	= glade_xml_get_widget (xml, "cb_pres_add_role");
    cb_pres_add_event	= glade_xml_get_widget (xml, "cb_pres_add_event");
    bt_pres_add_paste	= glade_xml_get_widget (xml, "bt_pres_add_paste");
    et_pres_add_chunks	= glade_xml_get_widget (xml, "et_pres_chunks");

    g_signal_connect (w_presentation_add, "response",
		      G_CALLBACK (presui_response_presentation_add_event), NULL);
    g_signal_connect (w_presentation_add, "delete_event",
                      G_CALLBACK (presui_delete_emit_response_cancel), NULL);

    glade_xml_signal_connect (xml,"on_et_pres_chunks_activate",		
			    GTK_SIGNAL_FUNC (presui_pres_add_et_activate));
			    
    glade_xml_signal_connect (xml,"on_bt_pres_add_copy_clicked",		
			    GTK_SIGNAL_FUNC (presui_pres_add_copy_clicked));
    glade_xml_signal_connect (xml,"on_bt_pres_add_paste_clicked",		
			    GTK_SIGNAL_FUNC (presui_pres_add_paste_clicked));
    
    glade_xml_signal_connect (xml,"on_cb_et_pres_add_device_changed",		
			    GTK_SIGNAL_FUNC (presui_pres_add_cb_changed));
    glade_xml_signal_connect (xml,"on_cb_et_pres_add_role_changed",		
			    GTK_SIGNAL_FUNC (presui_pres_add_cb_changed));
    glade_xml_signal_connect (xml,"on_cb_et_pres_add_event_changed",		
			    GTK_SIGNAL_FUNC (presui_pres_add_cb_changed));			    
			    
    glade_xml_signal_connect (xml,"on_bt_pres_chunk_add_clicked",		
			    GTK_SIGNAL_FUNC (presui_pres_chunk_add_new_clicked));
    glade_xml_signal_connect (xml,"on_bt_pres_chunk_remove_clicked",		
			    GTK_SIGNAL_FUNC (presui_pres_chunk_remove_clicked));
    glade_xml_signal_connect_data (xml,"on_bt_pres_chunk_up_clicked",		
			    GTK_SIGNAL_FUNC (presui_pres_chunk_move_clicked),(gpointer)"UP");			    
    glade_xml_signal_connect_data (xml,"on_bt_pres_chunk_down_clicked",		
			    GTK_SIGNAL_FUNC (presui_pres_chunk_move_clicked),(gpointer)"DOWN");
			    
    model = presui_create_add_model ();
    
    gtk_tree_view_enable_model_drag_source (GTK_TREE_VIEW (tv_pres_add_chunk),
					  GDK_BUTTON1_MASK,
					  row_targets,
					  G_N_ELEMENTS (row_targets),
					  GDK_ACTION_MOVE); 

    gtk_tree_view_enable_model_drag_dest (GTK_TREE_VIEW (tv_pres_add_chunk),
					row_targets,
					G_N_ELEMENTS (row_targets),
					GDK_ACTION_MOVE);

    g_signal_connect ( G_OBJECT (tv_pres_add_chunk), "drag_data_received",
			G_CALLBACK (presui_drop_cb), NULL);
    
    gtk_tree_view_set_model (GTK_TREE_VIEW (tv_pres_add_chunk), model);
    
    g_object_unref (G_OBJECT (model));

    cell_renderer = gtk_cell_renderer_text_new ();
    
    column = gtk_tree_view_column_new_with_attributes   (_("Chunk List"),
    							cell_renderer,
							"text", PRESENTATION_ADD_LIST,
							"editable",PRESENTATION_EDITABLE,
							NULL);	

    g_signal_connect ( G_OBJECT (cell_renderer), "edited",
			G_CALLBACK (presui_cell_edited), model);	
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_append_column (GTK_TREE_VIEW (tv_pres_add_chunk), column);
    
    selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW (tv_pres_add_chunk));
    gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);    
    
    presui_presentation_add_paste_sensitivity (FALSE);
}

static void
presui_presentation_add_value_add_to_widget ()
{
    GtkTreeIter 	iter;
    GtkTreeModel 	*model; 	
    GtkTreeSelection 	*selection;
    model 	= gtk_tree_view_get_model 	( GTK_TREE_VIEW (tv_presentation_order) );
    selection 	= gtk_tree_view_get_selection 	( GTK_TREE_VIEW (tv_presentation_order) );	    

    if (!new_item_in_list)
    {
	if (gtk_tree_selection_get_selected (selection, NULL, &iter))
	{
	    gchar *device	= NULL;
	    gchar *role 	= NULL;
	    gchar *event	= NULL;
	    gchar *chunk	= NULL;

	    if (GTK_IS_LIST_STORE (model))
	    {
		gtk_tree_model_get (model, 	&iter,
				    PRESENTATION_DEVICE, &device,
				    PRESENTATION_ROLE,   &role,
				    PRESENTATION_EVENT,  &event,
				    PRESENTATION_CHUNK,  &chunk,
            			    -1);
		current_iter = iter;
	    }

	    if (chunk != NULL)
	    {
		gtk_entry_set_text ( GTK_ENTRY (et_pres_add_chunks), chunk);
		presui_show_chunk_in_list (chunk);
	    }
	
	    if ((device != NULL) &&
		(role   != NULL) &&
		(event  != NULL))
	    {
		current_item = presconf_search_item (device, role, event);
/*
		gtk_widget_set_sensitive (GTK_WIDGET (cb_pres_add_device), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (cb_pres_add_role),   FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (cb_pres_add_event),  FALSE);
*/		gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (cb_pres_add_device)->entry), 
				    device);
		gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (cb_pres_add_role)->entry), 
				    role);
		gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (cb_pres_add_event)->entry), 
				    event);
	    }
	}
    }
    else
    {
	GtkTreeModel 	*model; 	
	
	model 	 = gtk_tree_view_get_model ( GTK_TREE_VIEW (tv_pres_add_chunk) );
	    
	gtk_list_store_clear (GTK_LIST_STORE (model));
	gtk_widget_set_sensitive (GTK_WIDGET (cb_pres_add_device), TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (cb_pres_add_role),   TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (cb_pres_add_event),  TRUE);
	gtk_entry_set_text ( GTK_ENTRY (et_pres_add_chunks), "");
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (cb_pres_add_device)->entry), 
			    DEFAULT_PRESENTATION_DEVICE);
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (cb_pres_add_role)->entry), 
			    DEFAULT_PRESENTATION_ROLE);
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (cb_pres_add_event)->entry), 
			    DEFAULT_PRESENTATION_EVENT);
    }
}

static gboolean 
presui_load_presentation_add ()
{
    if (!w_presentation_add)
    {
	GladeXML *xml;
	xml = gn_load_interface ("Presentation/presentation.glade2", "w_presentation_add");
	sru_return_val_if_fail (xml, FALSE);
	presui_set_handler_presentation_add (xml);	
	g_object_unref (G_OBJECT (xml));
	gtk_window_set_transient_for ( GTK_WINDOW (w_presentation_add),
					   GTK_WINDOW (w_presentation));
				    
	gtk_window_set_destroy_with_parent ( GTK_WINDOW (w_presentation_add), 
						TRUE);
    }
    else
	gtk_widget_show (w_presentation_add);
    
    presui_presentation_add_value_add_to_widget ();
    
    presui_presentation_add_apply_sensitivity (FALSE);
                
    return TRUE;
}


/******************************************************************************/
static void
presui_apply_sensitivity (gboolean state)
{
    pres_changed = state;
}

static GtkListStore*
presui_add_item_to_list (GtkListStore *store)
{
    GtkTreeIter iter;
    GSList *list = NULL;
    list = pres_list;
    while (list)
    {
	gtk_list_store_append ( GTK_LIST_STORE (store), &iter);
	gtk_list_store_set ( GTK_LIST_STORE (store), &iter, 
		    	     PRESENTATION_DEVICE, ((PresentationStruct*)list->data)->device,
			     PRESENTATION_ROLE,   ((PresentationStruct*)list->data)->role,
			     PRESENTATION_EVENT,  ((PresentationStruct*)list->data)->event,
			     PRESENTATION_CHUNK,  ((PresentationStruct*)list->data)->chunk,
		    	    -1);
	list = list->next;
    }
    return store;
}

static GtkTreeModel*
presui_create_model (void)
{
    GtkListStore *store;
      
    store = gtk_list_store_new (PRESENTATION_NO_COLUMN, 
				G_TYPE_STRING,
				G_TYPE_STRING,
				G_TYPE_STRING,
				G_TYPE_STRING);
    
    presui_add_item_to_list ( GTK_LIST_STORE (store) );
    
    return GTK_TREE_MODEL (store) ;
}

static void
presui_pres_add_clicked (GtkWidget 	*widget,
			gpointer	data)
{
    new_item_in_list = TRUE;
    presui_apply_sensitivity (TRUE);
    if (!presui_load_presentation_add ())
	sru_warning (_("We colud not load interface"));
}

static void
presui_pres_remove_clicked (GtkWidget 	*widget,
			    gpointer	data)
{
    GtkTreeIter 	iter;
    GtkTreeModel 	*model; 	
    GtkTreeSelection 	*selection;
    model 	= 
	gtk_tree_view_get_model ( GTK_TREE_VIEW (tv_presentation_order) );
    selection 	= 
	gtk_tree_view_get_selection ( GTK_TREE_VIEW (tv_presentation_order) );	    
    
    presui_apply_sensitivity (TRUE);
    
    if (gtk_tree_selection_get_selected (selection, NULL, &iter))
    {
        gchar *device	= NULL;
	gchar *role 	= NULL;
	gchar *event	= NULL;
	gchar *chunk	= NULL;

	if (GTK_IS_LIST_STORE (model))
	{
	    gtk_tree_model_get (model, 	&iter,
				PRESENTATION_DEVICE, &device,
				PRESENTATION_ROLE,   &role,
				PRESENTATION_EVENT,  &event,
				PRESENTATION_CHUNK,  &chunk,
            			-1);

	    gtk_list_store_remove ( GTK_LIST_STORE (model), &iter);
	    presconf_remove_from_list (device, role,
				      event, chunk);
	}
    }
}

static void
presui_pres_modify_clicked (GtkWidget 	*widget,
			gpointer	data)
{
    new_item_in_list = FALSE;
    presui_apply_sensitivity (TRUE);
    if (!presui_load_presentation_add ())
	sru_warning (_("We colud not load interface"));
}


static void
presui_row_activated_cb (GtkTreeView       *tree_view,
                	GtkTreePath       *path,
			GtkTreeViewColumn *column)
{
    presui_pres_modify_clicked (NULL, NULL);
}

static void
presui_response_event (GtkDialog *dialog,
			gint       response_id,
			gpointer   user_data)
{
    switch (response_id)
    {
     case GTK_RESPONSE_OK: 
        {
	    if (pres_changed)
	    {
    		presconf_save_list ();
    		presconf_unset_remove_list ();
	    }
	    current_item = NULL;
	    g_free (copy_paste);
	    copy_paste = NULL;
	    gtk_widget_hide ((GtkWidget*)dialog);
	}
        break;
     case GTK_RESPONSE_CANCEL:
        {
	    current_item = NULL;
	    g_free (copy_paste);
	    copy_paste = NULL;
	    gtk_widget_hide ((GtkWidget*)dialog);
	}
        break;
     case GTK_RESPONSE_APPLY:
        {
	    presconf_save_list ();
	    presconf_unset_remove_list ();
	    presui_apply_sensitivity (FALSE);
	}
        break;
    case GTK_RESPONSE_HELP:
	    gn_load_help ("gnopernicus-presentation");
	break;
     default:
	    gtk_widget_hide ((GtkWidget*)dialog);
        break;
    }
}



static void 
presui_set_handlers (GladeXML *xml)
{    
    GtkTreeModel 	*model;
    GtkCellRenderer 	*cell_renderer;
    GtkTreeSelection 	*selection;
    GtkTreeViewColumn 	*column;

    w_presentation 	  = glade_xml_get_widget (xml, "w_presentation");
    tv_presentation_order = glade_xml_get_widget (xml, "tv_presentation_order");

    g_signal_connect (w_presentation, "response",
		      G_CALLBACK (presui_response_event), NULL);
    g_signal_connect (w_presentation, "delete_event",
                      G_CALLBACK (presui_delete_emit_response_cancel), NULL);

    glade_xml_signal_connect (xml,"on_bt_pres_add_clicked",		
			    GTK_SIGNAL_FUNC (presui_pres_add_clicked));
    glade_xml_signal_connect (xml,"on_bt_pres_remove_clicked",		
			    GTK_SIGNAL_FUNC (presui_pres_remove_clicked));
    glade_xml_signal_connect (xml,"on_bt_pres_modify_clicked",		
			    GTK_SIGNAL_FUNC (presui_pres_modify_clicked));
			    
    model = presui_create_model ();
                
    gtk_tree_view_set_model (GTK_TREE_VIEW (tv_presentation_order), model);

    
    gtk_tree_sortable_set_sort_column_id ( GTK_TREE_SORTABLE (model), 
					    PRESENTATION_DEVICE, 
					    GTK_SORT_ASCENDING);
    
    g_signal_connect (tv_presentation_order, "row_activated", 
		      G_CALLBACK (presui_row_activated_cb), model);
	    
    g_object_unref (G_OBJECT (model));

    cell_renderer = gtk_cell_renderer_text_new ();
    
    column = gtk_tree_view_column_new_with_attributes   (_("Device"),
    							cell_renderer,
							"text", PRESENTATION_DEVICE,
							NULL);	
    gtk_tree_view_column_set_sort_column_id (column, PRESENTATION_DEVICE);
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_append_column (GTK_TREE_VIEW (tv_presentation_order), column);
    
    column = gtk_tree_view_column_new_with_attributes   (_("Role"),
    							cell_renderer,
							"text", PRESENTATION_ROLE,
							NULL);	
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_column_set_max_width (column, 70);
    gtk_tree_view_append_column (GTK_TREE_VIEW (tv_presentation_order), column);
    
    column = gtk_tree_view_column_new_with_attributes   (_("Event"),
    							cell_renderer,
							"text", PRESENTATION_EVENT,
							NULL);	
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_column_set_max_width (column, 70);
    
    gtk_tree_view_append_column (GTK_TREE_VIEW (tv_presentation_order), column);
        
    column = gtk_tree_view_column_new_with_attributes   (_("Chunk"),
    							cell_renderer,
							"text", PRESENTATION_CHUNK,
							NULL);	
    gtk_tree_view_column_set_clickable (column, TRUE);
    gtk_tree_view_column_set_resizable (column, TRUE);
    gtk_tree_view_append_column (GTK_TREE_VIEW (tv_presentation_order), column);

    selection = gtk_tree_view_get_selection ( GTK_TREE_VIEW (tv_presentation_order));
    gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);    

}


gboolean 
presui_load_presentation (GtkWidget *parent_window)
{
    presconf_preload_list ();
        
    if (!w_presentation)
    {
	GladeXML *xml;
	xml = gn_load_interface ("Presentation/presentation.glade2", "w_presentation");
	sru_return_val_if_fail (xml, FALSE);
	presui_set_handlers  (xml);
	g_object_unref (G_OBJECT (xml));
	gtk_window_set_transient_for ( GTK_WINDOW (w_presentation),
				           GTK_WINDOW (parent_window));
				    
	gtk_window_set_destroy_with_parent ( GTK_WINDOW (w_presentation), 
					    	TRUE);
    }
    else
    {
	gtk_widget_show (w_presentation);
	gtk_list_store_clear 	(GTK_LIST_STORE 
				(gtk_tree_view_get_model 
				(GTK_TREE_VIEW 
				(tv_presentation_order))));
	presui_add_item_to_list (GTK_LIST_STORE 
				(gtk_tree_view_get_model 
				(GTK_TREE_VIEW 
				(tv_presentation_order)))
				);
    }
    
    presui_apply_sensitivity (FALSE);
        
    return TRUE;
}
