/* GNOME DB components library
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_control_instance_h__)
#  define __gnome_db_control_instance_h__

#include <gnome.h>
#include <bonobo/bonobo-control.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_CONTROL_INSTANCE            (gnome_db_control_instance_get_type())
#define GNOME_DB_CONTROL_INSTANCE(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_CONTROL_INSTANCE, GnomeDbControlInstance)
#define GNOME_DB_CONTROL_INSTANCE_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_CONTROL_INSTANCE, GnomeDbControlInstanceClass)
#define GNOME_DB_IS_CONTROL_INSTANCE(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_CONTROL_INSTANCE)
#define GNOME_DB_IS_CONTROL_INSTANCE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_CONTROL_INSTANCE))

typedef struct _GnomeDbControl      GnomeDbControl;
typedef struct _GnomeDbControlClass GnomeDbControlClass;

typedef struct _GnomeDbControlInstance      GnomeDbControlInstance;
typedef struct _GnomeDbControlInstanceClass GnomeDbControlInstanceClass;

typedef struct _GnomeDbControlInstancePrivate GnomeDbControlInstancePrivate;

struct _GnomeDbControlInstance
{
  BonoboObject                   bonobo_object;
  GnomeDbControlInstancePrivate* priv;
};

struct _GnomeDbControlInstanceClass
{
  BonoboObjectClass parent_class;
  
  void              (*get_property)(GnomeDbControlInstance *control_instance, const gchar *name);
  void              (*set_property)(GnomeDbControlInstance *control_instance, const gchar *name);
  
  void              (*do_print)(GnomeDbControlInstance *control_instance);
  void              (*do_cut_clipboard)(GnomeDbControlInstance *control_instance);
  void              (*do_copy_clipboard)(GnomeDbControlInstance *control_instance);
  void              (*do_paste_clipboard)(GnomeDbControlInstance *control_instance);
};

GtkType                 gnome_db_control_instance_get_type (void);
GnomeDbControlInstance* gnome_db_control_instance_construct (GnomeDbControlInstance *control_instance,
                                                             GnomeDbControl *control,
                                                             GtkWidget *w);
GnomeDbControlInstance* gnome_db_control_instance_new       (GnomeDbControl *control, GtkWidget *w);

void           gnome_db_control_instance_set_menubar        (GnomeDbControlInstance *control_instance,
                                                             GnomeUIInfo *menus);
void           gnome_db_control_instance_set_toolbar        (GnomeDbControlInstance *control_instance,
                                                             GnomeUIInfo *toolbar);

void           gnome_db_control_instance_activate           (GnomeDbControlInstance *control_instance);
void           gnome_db_control_instance_deactivate         (GnomeDbControlInstance *control_instance);
void           gnome_db_control_instance_set_status         (GnomeDbControlInstance *control_instance,
                                                             const gchar *msg);

gpointer       gnome_db_control_instance_get_user_data      (GnomeDbControlInstance *control_instance);
void           gnome_db_control_instance_set_user_data      (GnomeDbControlInstance *control_instance,
                                                             gpointer user_data);
GtkWidget*     gnome_db_control_instance_get_widget         (GnomeDbControlInstance *control_instance);
BonoboControl* gnome_db_control_instance_get_bonobo_control (GnomeDbControlInstance *control_instance);

END_GNOME_DECLS

#endif
