/* GNOME DB library
 * Copyright (C) 1999-2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gnome_db_browser_h__
#define __gnome_db_browser_h__ 1

#include <gnome.h>
#include <gda-connection.h>
#include <gda-recordset.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_BROWSER            (gnome_db_browser_get_type())
#define GNOME_DB_BROWSER(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_BROWSER, GnomeDbBrowser)
#define GNOME_DB_BROWSER_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_BROWSER, GnomeDbBrowserClass)
#define GNOME_DB_IS_BROWSER(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_BROWSER)
#define GNOME_DB_IS_BROWSER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_BROWSER))

typedef struct _GnomeDbBrowserPrivate GnomeDbBrowserPrivate;
typedef struct _GnomeDbBrowser        GnomeDbBrowser;
typedef struct _GnomeDbBrowserClass   GnomeDbBrowserClass;

struct _GnomeDbBrowser {
	GtkVBox                vbox;
	GnomeDbBrowserPrivate* priv;
};

struct _GnomeDbBrowserClass {
	GtkVBoxClass parent_class;
	
	void (*connection_changed)(GnomeDbBrowser *browser);
};

GtkType         gnome_db_browser_get_type       (void);

GtkWidget*      gnome_db_browser_new            (Gda_Connection *cnc);
Gda_Connection* gnome_db_browser_get_connection (GnomeDbBrowser *browser);
void            gnome_db_browser_set_connection (GnomeDbBrowser *browser, Gda_Connection *cnc);

void            gnome_db_browser_refresh        (GnomeDbBrowser *browser);

END_GNOME_DECLS

#endif
