# Note that this is NOT a relocatable package
# defaults for redhat
%define name	gnome-db
%define ver	0.2.3
%define prefix     /usr
%define sysconfdir /etc

%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Summary: GNOME DB
Name: 		%name
Version:	%ver
Release: 	%rel
Copyright: 	GPL
Group: 		Applications/Databases
Source:		ftp://ftp.gnome.org/pub/GNOME/sources/%{name}/%{name}-%{ver}.tar.gz
BuildRoot: 	/var/tmp/%{name}-%{ver}-root
URL: 		http://www.gnome.org/projects/gnome-db/
DocDir: 	%{prefix}/doc

%description
Gnome DB is a frontend to the GDA architecture, being developed as part
of the GNOME project. It adds, to the already powerful GDA architecture,
a nice GUI front end for users, as well as a whole set of software
components intended to be reused in other unrelated applications.

This package contains the core components of GNOME-DB.

%package devel
Summary: GNOME DB Development
Group: 		Applications/Databases
Requires:	%name = %{PACKAGE_VERSION}

%description devel
Gnome DB is a frontend to the GDA architecture, being developed as part
of the GNOME project. It adds, to the already powerful GDA architecture,
a nice GUI front end for users, as well as a whole set of software
components intended to be reused in other unrelated applications.

This package contains libraries, header files and tools to let
you develop GNOME-DB applications.

%changelog
* Fri Aug 11 2000 Rodrigo Moya <rodrigo@linuxave.net>
- Initial spec imported from old GNOME-DB spec

%prep
%setup

%build

# libtool workaround for alphalinux
%ifarch alpha
  ARCH_FLAGS="--host=alpha-redhat-linux"
%endif

# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir}
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir}
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} \
gnomedb_helpdir=$RPM_BUILD_ROOT%{prefix}/share/gnome/help/gnome-db/C \
oafinfodir=$RPM_BUILD_ROOT%{prefix}/share/oaf \
Applicationsdir=$RPM_BUILD_ROOT%{prefix}/share/gnome/apps/Applications \
Pixmapdir=$RPM_BUILD_ROOT%{prefix}/share/pixmaps \
AppPixmapdir=$RPM_BUILD_ROOT%{prefix}/share/pixmaps/gnome-db \
AppConfigdir=$RPM_BUILD_ROOT%{sysconfdir}/gnome-db \
idldir=$RPM_BUILD_ROOT%{prefix}/share/idl \
GNOME_datadir=$RPM_BUILD_ROOT%{prefix}/share \
GNOME_sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} \
install

%clean
rm -rf $RPM_BUILD_ROOT

%post
if ! grep %{prefix}/lib /etc/ld.so.conf > /dev/null ; then
  echo "%{prefix}/lib" >> /etc/ld.so.conf
fi
/sbin/ldconfig
							  
%postun
/sbin/ldconfig
							  
%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README 
%doc %{prefix}/share/gnome/help/gnome-db/*
%{prefix}/bin/gnomedb-components
%{prefix}/bin/gnomedb-fe
%{prefix}/bin/gnomedb-mgr
%{prefix}/bin/gnomedb-monikers
%{prefix}/lib/libgnomedb.so*
%{prefix}/lib/libgnomedbcomponents.so*
%{prefix}/share/gnome/apps/Applications/gnomedb-fe.desktop
%{prefix}/share/pixmaps/*
%config %{prefix}/share/oaf/GNOME_DB_Export.oafinfo
%config %{prefix}/share/oaf/GNOME_DB_Manager.oafinfo
%config %{prefix}/share/oaf/GNOME_DB_Monikers.oafinfo
%config %{prefix}/share/oaf/GNOME_DB_Designer.oafinfo
%config %{prefix}/share/oaf/GNOME_DB_Connection.oafinfo
%config %{prefix}/share/oaf/GNOME_DB_HelpViewer.oafinfo
%config %{prefix}/share/oaf/GNOME_DB_Log.oafinfo

%files devel
%defattr(-, root, root)

%{prefix}/bin/gnomedb-config
%{prefix}/bin/gnomedb-builder
%{prefix}/lib/libgnomedb.*a
%{prefix}/lib/libgnomedbcomponents.*a
%{prefix}/include/gnome-db/*
%{prefix}/share/idl/*

