/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>


#include <libgnorba/gnorba.h>
#include "gda.h"
#include "gda-connection.h"
#include "gda-command.h"
#include "gda-error.h"
#include "gnome-db-login.h"
#include "gnome-db-login-dlg.h"


gchar* provider = 0;
gchar* database = 0;
gchar* username = 0;
gchar* password = 0;


struct poptOption options[] = {
  { "provider", 's', POPT_ARG_STRING, &provider, 0, N_("database provider"), N_("PROVIDER")},
  { "database", 'd', POPT_ARG_STRING, &database, 0, N_("database name"), N_("DATABASE")},
  { "user",     'u', POPT_ARG_STRING, &username, 0, N_("user name"), N_("USER-NAME")},
  { "password", 'p', POPT_ARG_STRING, &password, 0, N_("password"), N_("PASSWORD")},
  {0, 0, 0, 0, 0, 0, 0}
};






void
cb_error(Gda_Connection* cnc, gpointer data)
{

  static GtkWidget* error_dialog = 0;
  
  g_print("%s: %d: %s called\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);

  if (!error_dialog)
    {
      error_dialog = gnome_db_errordlg_new(cnc, _("UI Test 3 Error"));
    }
  gnome_db_errordlg_show_errors(GNOME_DB_ERRORDLG(error_dialog));
  
}

void
cb_login(GnomeDbLogin* login, gpointer data)
{
  g_print("%s: %d: %s called\n", __FILE__, __LINE__,
	  __PRETTY_FUNCTION__);
  gnome_appbar_pop(GNOME_APPBAR(GNOME_APP(data)->statusbar));
}

void
cb_cancel(GnomeDbLogin* login, gpointer data)
{
  g_print("%s: %d: %s called\n", __FILE__, __LINE__,
	  __PRETTY_FUNCTION__);
  gnome_appbar_pop(GNOME_APPBAR(GNOME_APP(data)->statusbar));
}

static void
do_login(GtkWidget* button, gpointer data)
{
  Gda_Connection* cnc;
  GnomeApp*      appl;
  static GtkWidget* login = 0;

  g_print("%s: %d: %s called\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
  cnc = gda_connection_new(gnome_CORBA_ORB());
  if (!login)
    {
      appl = GNOME_APP(data);
      login = gnome_db_logindlg_new(GNOME_DB_LOGIN(gnome_db_login_new(cnc, provider, database)),
				    "GDA UI TEST3 DB LOGIN");
      gtk_signal_connect(GTK_OBJECT(cnc),"error", GTK_SIGNAL_FUNC(cb_error), appl);
      gtk_signal_connect(GTK_OBJECT(login),"login", GTK_SIGNAL_FUNC(cb_login), appl);
      gtk_signal_connect(GTK_OBJECT(login),"cancel", GTK_SIGNAL_FUNC(cb_cancel), appl);
      gnome_dialog_close_hides(GNOME_DIALOG(login), TRUE);
    }
  gnome_appbar_push(GNOME_APPBAR(GNOME_APP(data)->statusbar), _("Logging in"));
  while (gtk_events_pending())
    gtk_main_iteration();
  gnome_db_logindlg_popup(GNOME_DB_LOGINDLG(login));
}



int
main(int argc, char* argv[])
{

  CORBA_ORB orb;
  CORBA_Environment ev;
  GtkWidget*         app;
  GtkWidget*         button;
  GtkWidget*         status_bar;
  
  CORBA_exception_init(&ev);
  
  orb = gnome_CORBA_init_with_popt_table("gda-client-test1", /* app_id */
					 "0.1",	/* app_version */
					 &argc,
					 argv,
					 options, /* options */
					 0, /* popt_flags */
					 0, /* return_ctx */
					 0, /* gnorba_flags */
					 &ev);
  app = gnome_app_new("gda-ui-test3", "GDA UI TEST 3");
  status_bar = gnome_appbar_new(TRUE, TRUE, FALSE);
  gnome_app_set_statusbar(GNOME_APP(app), status_bar);

  button = gtk_button_new_with_label("Login to Database");
  
  gtk_signal_connect(GTK_OBJECT(button),"clicked", GTK_SIGNAL_FUNC(do_login), app);
  
  gnome_app_set_contents(GNOME_APP(app), button);

  gtk_widget_show_all(app);
  gtk_main();
  return (0);
}

