/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>


#include <libgnorba/gnorba.h>
#include "gda.h"
#include "gda-connection.h"
#include "gda-command.h"
#include "gda-error.h"
#include "gda-xml.h"

gchar* provider = 0;
gchar* database = 0;
gchar* username = 0;
gchar* password = 0;


struct poptOption options[] = {
  { "provider", 's', POPT_ARG_STRING, &provider, 0, N_("database provider"), N_("PROVIDER")},
  { "database", 'd', POPT_ARG_STRING, &database, 0, N_("database name"), N_("DATABASE")},
  { "user",     'u', POPT_ARG_STRING, &username, 0, N_("user name"), N_("USER-NAME")},
  { "password", 'p', POPT_ARG_STRING, &password, 0, N_("password"), N_("PASSWORD")},
  {0, 0, 0, 0, 0, 0, 0}
};

void Exception( CORBA_Environment *ev )
{
  switch( ev->_major )
    {
    case CORBA_SYSTEM_EXCEPTION:
      fprintf( stderr, "CORBA system exception %s.\n",
	       CORBA_exception_id(ev));
      exit ( 1 );
    case CORBA_USER_EXCEPTION:
      fprintf( stderr, "CORBA user exception: %s.\n",
	       CORBA_exception_id( ev ) );
      exit ( 1 );
    default:
      break;
    }
}

int
main(int argc, char* argv[])
{

  CORBA_ORB orb;
  CORBA_Environment ev;
  Gda_Connection*    cnc;
  Gda_Recordset*     rs;
  gchar              cbfr[255];
  Gda_Field*         field;
  Gda_XmlDatabase*   xmldb;
  
  CORBA_exception_init(&ev);

  orb = gnome_CORBA_init_with_popt_table("gda-client-test14", /* app_id */
					 "0.1",	/* app_version */
					 &argc,
					 argv,
					 options, /* options */
					 0, /* popt_flags */
					 0, /* return_ctx */
					 0, /* gnorba_flags */
					 &ev);

  Exception(&ev);

  /* open connection */
  cnc = gda_connection_new(orb);
  gda_connection_set_provider(cnc, provider);
  if (gda_connection_open(cnc, database, username, password) < 0)
    {
      fprintf(stderr,"gda_connection_open failed\n");
      return -1;
    }
  
  /* create XML database representation */
  if (!(xmldb = gda_xml_database_new(gda_connection_get_dsn(cnc))))
    {
      fprintf(stderr, "gda_xml_database_new failed\n");
      gda_connection_close(cnc);
      gda_connection_free(cnc);
      return -1;
    }

  /* get list of all tables */
  rs = gda_connection_open_schema(cnc, GDA_Connection_GDCN_SCHEMA_TABLES,
                                  GDA_Connection_no_CONSTRAINT, NULL);
  if (rs != NULL)
    {
      gulong position = gda_recordset_move(rs, 1, 0);
      while (position != GDA_RECORDSET_INVALID_POSITION &&
             !gda_recordset_eof(rs))
        {
          gchar *str;
          field = gda_recordset_field_idx(rs, 2);
          if (field != NULL)
            {
              gulong reccount;
              Gda_Recordset *table;
              str = g_strdup_printf("SELECT * FROM %s", 
                                    gda_stringify_value(cbfr, sizeof(cbfr) - 1, field));
              table = gda_connection_execute(cnc, str, &reccount, 0);
              if (table != NULL)
                {
                  //if (!gda_xml_database_add_recordset(xmldb, table, str))
                  //  fprintf(stderr, "Adding table %s failed\n", str);
                  gda_recordset_close(table);
                  gda_recordset_free(table);
                }
            }
          /* move to next row */
          position = gda_recordset_move(rs, 1, 0);
        }
      /* free recordset */
      gda_recordset_close(rs);
      gda_recordset_free(rs);
      /* and finally save XML stuff to disk */
      //if (!gda_xml_database_save_to_file(xmldb, "gda_xml_test.xml"))
      //  fprintf(stderr, "gda_xml_database_save_to_file failed\n");
    }
  else fprintf(stderr, "gda_connection_open_schema failed\n");

  /* close connection */
  gda_xml_database_free(xmldb);
  gda_recordset_close(rs);
  gda_connection_close(cnc);
  return 0;
}
