# Note that this is NOT a relocatable package
# defaults for redhat
%define name	gnome-db
%define ver	0.0.91
%define prefix     /usr
%define sysconfdir /etc

%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

%define	servers	--with-postgres=yes --with-oracle=yes --with-mysql=/usr

Summary: GNOME DB
Name: 		%name
Version:	%ver
Release: 	%rel
Copyright: 	GPL
Group: 		System Environment/Libraries
Source:		ftp://ftp.gnome.org/pub/GNOME/sources/%{name}/%{name}-%{ver}.tar.gz
BuildRoot: 	/var/tmp/%{name}-%{ver}-root
URL: 		http://www.gnome.org/gnome-db/
DocDir: 	%{prefix}/doc

%description
Gnome Data Access

%package devel
Summary: GNOME DB Development
Group: 		System Environment/Libraries
Requires:	%name = %{PACKAGE_VERSION}

%description devel
Gnome Data Access (devel)

# subpackage - ODBC server
%package odbc
Summary: GNOME DB Development - ODBC server
Group: 		System Environment/Libraries
Requires:	%name = %{PACKAGE_VERSION}

%description odbc
Gnome Data Access - ODBC server

# subpackage - PostgreSQL server
%package postgres
Summary: GNOME DB Development - PostgreSQL server
Group: 		System Environment/Libraries
Requires:	%name = %{PACKAGE_VERSION}

%description postgres
Gnome Data Access - PostgreSQL server

# subpackage - Oracle server
%package oracle
Summary: GNOME DB Development - Oracle server
Group:      System Environment/Libraries
Requires:   %name = %{PACKAGE_VERSION}

%description oracle
Gnome Data Access - Oracle server

# subpackage MySQL
%package MySQL
Summary: GNOME DB Development - MySQL server
Group:      System Environment/Libraries
Requires:   %name = %{PACKAGE_VERSION}

%description MySQL
Gnome Data Access - MySQL server

%changelog
* Sun Feb 6 2000 Rodrigo Moya <rmoya@chez.com>
- Added missing executables and libraries
* Sat Jan 29 2000 Rodrigo Moya <rmoya@chez.com>
- Added Oracle and MySQL servers
* Mon Dec 20 1999 Dan Horak <horakd@volny.cz>
- Initial spec file copied from ggv

%prep
%setup

%build

# libtool workaround for alphalinux
%ifarch alpha
  ARCH_FLAGS="--host=alpha-redhat-linux"
%endif

# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir} %{servers}
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure $ARCH_FLAGS --prefix=%{prefix} --sysconfdir=%{sysconfdir} %{servers}
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} \
gnome_db_helpdir=$RPM_BUILD_ROOT%{prefix}/share/gnome/help/gnome-db/C \
gnorbadir=$RPM_BUILD_ROOT%{sysconfdir}/CORBA/servers \
Applicationsdir=$RPM_BUILD_ROOT%{prefix}/share/gnome/apps/Applications/GNOME-DB \
Pixmapdir=$RPM_BUILD_ROOT%{prefix}/share/pixmaps \
AppPixmapdir=$RPM_BUILD_ROOT%{prefix}/share/pixmaps/gnome-db \
install

%clean
rm -rf $RPM_BUILD_ROOT

%post
if ! grep %{prefix}/lib /etc/ld.so.conf > /dev/null ; then
  echo "%{prefix}/lib" >> /etc/ld.so.conf
fi
/sbin/ldconfig
							  
%postun
/sbin/ldconfig
							  
%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{prefix}/bin/gdafe
%{prefix}/bin/gda-mgr
%{prefix}/bin/rolodex
%{prefix}/lib/libgda-client.so*
%{prefix}/lib/libgdaui.so*
%{prefix}/share/gnome/apps
%{prefix}/share/pixmaps/*
%config %{sysconfdir}/CORBA/servers/*

%files devel
%defattr(-, root, root)

%doc %{prefix}/share/gnome/help/gnome-db/C
%{prefix}/bin/gda-builder
%{prefix}/bin/gda-buildclient
%{prefix}/bin/gda-buildserver
%{prefix}/bin/gda-config
%{prefix}/bin/gda-run
%{prefix}/lib/libgda-client.*
%{prefix}/lib/libgdaui.*
%{prefix}/include/gda/*
%{prefix}/share/idl/*
%{prefix}/share/gnome-db/*

%files odbc
%{prefix}/bin/gda-odbc-srv
%{prefix}/lib/libgda_odbc.so*

%files postgres
%{prefix}/bin/gda-postgres-srv
%{prefix}/lib/libgda-postgres.so*

%files oracle
%{prefix}/bin/gda-oracle-srv
%{prefix}/lib/libgda_oracle.so*

%files MySQL
%{prefix}/bin/gda-mysql-srv
%{prefix}/lib/libgda-mysql.so*
