/* GNOME-DB
 * Copyright (c) 1998 by Rodrigo Moya
 * Copyright (c) 2000 by Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_POSTGRES_CONNECTION_H__
#  define __GDA_POSTGRES_CONNECTION_H__


#include "gda-postgres-types.h"

Gda_POSTGRES_Connection *gda_postgres_connection_new (void);
void                     gda_postgres_connection_free (Gda_POSTGRES_Connection *c);
gint                     gda_postgres_connection_open (Gda_POSTGRES_Connection *c,
						       const gchar *dsn,
						       const gchar *user,
						       const gchar *password);
gint                     gda_postgres_connection_close (Gda_POSTGRES_Connection *c);
Gda_POSTGRES_Recordset  *gda_postgres_connection_open_schema (Gda_POSTGRES_Connection *cnc,
							      Gda_POSTGRES_Error *e,
							      GDA_Connection_QType t,
							      GDA_Connection_Constraint *constraints,
							      gint length);
gboolean                 gda_postgres_connection_supports    (Gda_POSTGRES_Connection* cnc,
							      GDA_Connection_Feature feature);

gchar*                   gda_postgres_connection_create_recset (Gda_POSTGRES_Connection* cnc,
                                                                GDA_RowAttributes* columns);

/*
 * Native library logging
 */
gint                     gda_postgres_connection_start_logging (Gda_POSTGRES_Connection *, gchar *);
gint                     gda_postgres_connection_stop_logging (Gda_POSTGRES_Connection *);

/*
 * Transaction support
 */
gint                     gda_postgres_connection_begin_transaction (Gda_POSTGRES_Connection *);
gint                     gda_postgres_connection_commit_transaction (Gda_POSTGRES_Connection *);
gint                     gda_postgres_connection_rollback_transaction (Gda_POSTGRES_Connection *);

/*
 * Data Types lookup 
 */
GDA_ValueType           gda_postgres_connection_get_gda_type (Gda_POSTGRES_Connection *, gulong);
Gda_POSTGRES_CType      gda_postgres_connection_get_c_type (Gda_POSTGRES_Connection *, gulong);
Gda_POSTGRES_CType      gda_postgres_connection_get_c_type_from_gda (Gda_POSTGRES_Connection *, GDA_ValueType);
gulong                  gda_postgres_connection_get_sql_type(Gda_POSTGRES_Connection *cnc, gchar *postgres_type);
gchar*                  gda_postgres_connection_get_type_name(Gda_POSTGRES_Connection *cnc, gulong); /* do not free returned value! */
#endif
