/* GNOME-DB
 * Copyright (c) 1998 by Rodrigo Moya
 * Copyright (C) 1999 Stephan Heinze
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-oracle-types.h"
#include "gda-oracle-field.h"
gchar* gda_stringify_value(gchar*, gint, Gda_ORACLE_Field*);

Gda_ORACLE_Field *
gda_oracle_field_new (void)
{
  Gda_ORACLE_Field* field;
  field = g_new0(Gda_ORACLE_Field, 1);
  return (field);
}

void
gda_oracle_field_free (Gda_ORACLE_Field *field)
{
  if (field->real_value)
    {
      g_free(field->real_value);
    }
  g_free(field);
}

void 
gda_oracle_field_dump (Gda_ORACLE_Field *field)
{
  g_print("---- field-dump - start ---- \n");
  g_print("name: %s\n", field->name);
  g_print("defined_length: %ld\n", field->defined_length);
  g_print("actual_length: %ld\n", field->actual_length);
  g_print("type: %d\n", field->value->_d ); 
  if( -2 == field->indicator )
    g_print("value is NULL");
  g_print("---- field-dump - end ---- \n");
}

void 
gda_oracle_field_sql2gdatype( Gda_ORACLE_Field* server_field, 
                              GDA_FieldAttributes* field
                            )
{
   switch (server_field->sql_type)
     {
     case SQLT_CHR : /* VARCHAR2 */
     case SQLT_STR : /* null-terminated string */
     case SQLT_VCS : /* VARCHAR */
     case SQLT_RID : /* ROWID */
     case SQLT_LNG : /* LONG */
     case SQLT_LVC : /* LONG VARCHAR */
     case SQLT_AFC : /* CHAR */
     case SQLT_AVC : /* CHARZ */
     case SQLT_LAB : /* MSLABEL */
         field->gdaType = GDA_TypeVarchar;
       break;

     case SQLT_FLT : /* FLOAT */
         field->gdaType = GDA_TypeSingle;
       break; 

     case SQLT_INT : /* 8-bit, 16-bit and 32-bit integers */
     case SQLT_UIN : /* UNSIGNED INT */
         field->gdaType = GDA_TypeInteger;
       break;

     case SQLT_DAT : /* DATE */
         field->gdaType = GDA_TypeDate;
       break;

     case SQLT_VBI : /* VARRAW */
     case SQLT_BIN : /* RAW */
     case SQLT_LBI : /* LONG RAW */
     case SQLT_LVB : /* LONG VARRAW */
         field->gdaType = GDA_TypeBinary;
       break;

     default :
         g_error("Unknown ORACLE data type in sql2gda\n");
      break;
   }
}
