/* GDA Oracle server
 * Copyright (c) 1998 by Rodrigo Moya
 * Copyright (C) 1999 Stephan Heinze
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>

#include "gda-oracle-types.h"

Gda_ORACLE_Error *
gda_oracle_error_new (void)
{
  Gda_ORACLE_Error *e = g_new0(Gda_ORACLE_Error, 1);
  return (e);
}

void
gda_oracle_error_free (Gda_ORACLE_Error *e)
{
  if (e->description)
    g_free(e->description);
  if (e->source)
    g_free(e->source);
  if (e->helpfile)
    g_free(e->helpfile);
  if (e->helpctxt)
    g_free(e->helpctxt);
  if (e->sqlstate)
    g_free(e->sqlstate);
  if (e->native)
    g_free(e->native);
  g_free(e);
}

void
gda_oracle_error_make (Gda_ORACLE_Error *error, Gda_ORACLE_Recordset *recset,
                       Gda_ORACLE_Connection *cnc, gchar *where)
{
  text err_msg[512];
  sb4 errcode;
  
  memset(err_msg,0,sizeof(err_msg));
  /* retrieve error information from ORACLE */
  OCIErrorGet((dvoid *)cnc->herr, (ub4) 1, (text *) NULL, &errcode,
              (text*) err_msg, (ub4) sizeof(err_msg), OCI_HTYPE_ERROR);
              
  g_print("Error at '%s': ", where);
  g_print("error->description = '%s'\n", err_msg);
  error->description = g_strdup(err_msg);
  error->source      = g_strdup("gda-oracle");
  error->helpfile    = 0;
  error->helpctxt    = 0;
  error->sqlstate    = g_strdup("error");
  error->native      = g_strdup("error");
  cnc->errors = g_list_append(cnc->errors, error);
}
