/* GNOME-DB
 * Copyright (c) 1998 by Rodrigo Moya
 * Copyright (C) 1999 Stephan Heinze
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_ORACLE_CONNECTION_H__
#  define __GDA_ORACLE_CONNECTION_H__

#include "gda-oracle-types.h"

Gda_ORACLE_Connection* gda_oracle_connection_new (void);
void                   gda_oracle_connection_free (Gda_ORACLE_Connection *cnc);
gint                   gda_oracle_connection_close (Gda_ORACLE_Connection *cnc);
gint                   gda_oracle_connection_open (Gda_ORACLE_Connection *cnc,
                                                   gchar *cnc_string,
                                                   gchar *username,
                                                   gchar *password);
Gda_ORACLE_Recordset*  gda_oracle_connection_open_schema (Gda_ORACLE_Connection *cnc,
							                      Gda_ORACLE_Error *e,
							                      GDA_Connection_QType t,
							                      GDA_Connection_Constraint *constraints,
							                      gint length);


/*
 * Server trace
 */
gint gda_oracle_connection_start_logging (Gda_ORACLE_Connection *cnc, gchar *file_name);
gint gda_oracle_connection_stop_logging (Gda_ORACLE_Connection *cnc);

/*
 * Transaction support
 */
gint gda_oracle_connection_begin_transaction (Gda_ORACLE_Connection *cnc);
gint gda_oracle_connection_commit_transaction (Gda_ORACLE_Connection *cnc);
gint gda_oracle_connection_rollback_transaction (Gda_ORACLE_Connection *cnc);

/*
 * ask for supported features
 */
gboolean gda_oracle_connection_supports (Gda_ORACLE_Connection *cnc,
                                         GDA_Connection_Feature feature
                                        );

#endif
