/* GDA Oracle Server
 * Copyright (C) 1999 Rodrigo Moya
 * Copyright (C) 1999 Stephan Heinze
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_ORACLE_COMMAND_H__
#  define __GDA_ORACLE_COMMAND_H__

#include "gda-oracle-types.h"

Gda_ORACLE_Command    *gda_oracle_cmd_new (void);
void                   gda_oracle_cmd_free (Gda_ORACLE_Command *);
Gda_ORACLE_Connection *gda_oracle_cmd_set_connection (Gda_ORACLE_Command *,
							                  Gda_ORACLE_Connection *);
Gda_ORACLE_Recordset  *gda_oracle_cmd_execute (Gda_ORACLE_Command *,
						               Gda_ORACLE_Error *,
						               const GDA_CmdParameterSeq *,
						               gulong );

#endif
