/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-mgr.h"

static GtkWidget* l_ProviderList = 0;
static GtkWidget* l_DsnList = 0;

/*
 * Private functions
 */
static void
fill_dsn_list (GtkCList *clist)
{
}

static void
fill_provider_list (GtkCList *clist)
{
  gchar* empty_string = "";
  gchar* row[5];
  GList* server_list;
  GList* node;

  g_return_if_fail(GTK_IS_CLIST(clist));

  gtk_clist_freeze(clist);
  server_list = gda_server_list();
  node = g_list_first(server_list);
  while (node)
    {
      gchar* type_exe = "exe";
      gchar* type_lib = "lib";

      Gda_Server* server = (Gda_Server *) node->data;
      if (server)
        {
          row[0] = GDA_SERVER_NAME(server);
          if (GDA_SERVER_GOAD_TYPE(server) == GOAD_SERVER_EXE) row[1] = type_exe;
          else if (GDA_SERVER_GOAD_TYPE(server) == GOAD_SERVER_SHLIB) row[1] = type_lib;
          else row[1] = empty_string;
          row[2] = GDA_SERVER_REPO_ID(server);
          row[3] = GDA_SERVER_COMMENT(server);
          row[4] = GDA_SERVER_LOCATION(server);

          gtk_clist_append(clist, (const gchar **) row);
        }
      node = g_list_next(node);
    }
  gda_server_free_list(server_list);
  gtk_clist_thaw(clist);
}

/*
 * Callbacks
 */
static void
view_provider_log_cb (GtkButton *button, gpointer data)
{
  GList* selected;

  g_return_if_fail(GTK_IS_CLIST(l_ProviderList));

  selected = GTK_CLIST(l_ProviderList)->selection;
  if (selected)
    {
      gchar* provider = 0;

      guint row = GPOINTER_TO_UINT(selected->data);
      gtk_clist_get_text(GTK_CLIST(l_ProviderList), row, 0, &provider);
      if (provider)
        {
          gchar* filename = g_strdup_printf("/tmp/%s-srv.log", provider);
          gda_ui_show_file(filename);
          g_free((gpointer) filename);
        }
    }
}

/*
 * Public functions
 */
void
manager_gda_init (void)
{
  const gchar* titles[] = { N_("Name"),  N_("Type"), N_("Repository ID"),
                            N_("Description"), N_("Location") };
  const gchar* dsn_titles[] = { N_("GDA Name") };
  GtkWidget*   frame;
  GtkWidget*   table;
  GtkWidget*   table2;
  GtkWidget*   scroll;
  GtkWidget*   button;
  GtkWidget*   box;

  g_return_if_fail(GTK_IS_NOTEBOOK(glb_Notebook));

  /* providers frame */
  frame = gda_ui_new_frame_widget(0);
  gtk_notebook_append_page(GTK_NOTEBOOK(glb_Notebook), frame,
                           gda_ui_new_label_widget(_("GDA Configuration")));
  table = gtk_table_new(3, 4, FALSE);
  gtk_widget_show(table);
  gtk_container_add(GTK_CONTAINER(frame), table);

  frame = gda_ui_new_frame_widget(_("Providers"));
  gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 0, 1,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   3, 3);
  table2 = gtk_table_new(1, 2, FALSE);
  gtk_widget_show(table2);
  gtk_container_add(GTK_CONTAINER(frame), table2);
  scroll = gda_ui_new_scrolled_window_widget();
  gtk_table_attach(GTK_TABLE(table2), scroll, 0, 1, 0, 1,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   3, 3);
  l_ProviderList = gda_ui_new_clist_widget(titles, sizeof(titles) / sizeof(titles[0]));
  gtk_container_add(GTK_CONTAINER(scroll), l_ProviderList);
  fill_provider_list(GTK_CLIST(l_ProviderList));

  box = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(box);
  gtk_table_attach(GTK_TABLE(table2), box, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
  button = gda_ui_new_button_widget_with_pixmap(_("Add"), GNOME_STOCK_MENU_NEW);
  gtk_box_pack_start(GTK_BOX(box), button, 0, 0, 0);

  button = gda_ui_new_button_widget_with_pixmap(_("Remove"), GNOME_STOCK_MENU_TRASH);
  gtk_box_pack_start(GTK_BOX(box), button, 0, 0, 0);

  button = gda_ui_new_button_widget_with_pixmap(_("View Log"), GNOME_STOCK_MENU_BOOK_RED);
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
                     GTK_SIGNAL_FUNC(view_provider_log_cb), 0);
  gtk_box_pack_start(GTK_BOX(box), button, 0, 0, 0);

  /* data sources frame */
  frame = gda_ui_new_frame_widget(_("Data Sources"));
  gtk_table_attach(GTK_TABLE(table), frame, 0, 1, 1, 2,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   3, 3);
  table2 = gtk_table_new(1, 2, FALSE);
  gtk_widget_show(table2);
  gtk_container_add(GTK_CONTAINER(frame), table2);
  scroll = gda_ui_new_scrolled_window_widget();
  gtk_table_attach(GTK_TABLE(table2), scroll, 0, 1, 0, 1,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   3, 3);
  l_DsnList = gda_ui_new_clist_widget(dsn_titles,
                                      sizeof(dsn_titles) / sizeof(dsn_titles[0]));
  gtk_container_add(GTK_CONTAINER(scroll), l_DsnList);
  fill_dsn_list(GTK_CLIST(l_DsnList));

  box = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(box);
  gtk_table_attach(GTK_TABLE(table2), box, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
  button = gda_ui_new_button_widget_with_pixmap(_("Add"), GNOME_STOCK_MENU_NEW);
  gtk_box_pack_start(GTK_BOX(box), button, 0, 0, 0);

  button = gda_ui_new_button_widget_with_pixmap(_("Remove"), GNOME_STOCK_MENU_TRASH);
  gtk_box_pack_start(GTK_BOX(box), button, 0, 0, 0);

}
