/* GNOME-DB - GUI front-end
 * Copyright (c) 1998-2000 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gdafe.h"

static void close_browser_cb (GtkWidget *w, gpointer data);
static void create_script_cb (GtkWidget *w, gpointer data);
static void refresh_cb (GtkWidget *w, gpointer data);

static GnomeUIInfo browsertoolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Create script"), N_("Create script from object definition"),
    create_script_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Refresh"), N_("Refresh all lists"),
    refresh_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_REFRESH, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close this window"),
    close_browser_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_END
};

/*
 * Private functions
 */
static void 
real_close (GtkWidget *view, GnomeDbBrowser *browser)
{
  g_return_if_fail(GNOME_DB_IS_BROWSER(browser));
}

/*
 * Callbacks
 */
static void
close_browser_cb (GtkWidget *w, gpointer data)
{
  GtkWidget *view = fe_get_current_view();
  if (view)
    {
      if (fe_get_view_data(view, "FE_Browser_Widget"))
        fe_destroy_view(view);
    }
}

static void
close_connection_cb (Gda_Connection *cnc, GtkWidget *view)
{
  g_return_if_fail(IS_GDA_CONNECTION(cnc));
  g_return_if_fail(GTK_IS_WIDGET(view));

  if (view && fe_get_view_data(view, "FE_Browser_Widget"))
    fe_destroy_view(view);
}

static void
create_script_cb (GtkWidget *w, gpointer data)
{
  GtkWidget *view = fe_get_current_view();
  if (view)
    {
    }
}

static void
refresh_cb (GtkWidget *w, gpointer data)
{
  GtkWidget *view = fe_get_current_view();
  if (view)
    {
      GnomeDbBrowser *browser = GNOME_DB_BROWSER(fe_get_view_data(view, "FE_Browser_Widget"));
      if (browser)
        {
          gnome_db_browser_refresh(browser);
        }
    }
}

/*
 * Public functions
 */
void
fe_open_browser (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo *cnc_info = fe_get_current_connection();
  if (cnc_info)
    {
      GtkWidget *view, *browser;
      gchar *str;
      
      str = g_strdup_printf(_("Browser: %s@%s"), gda_connection_get_user(cnc_info->cnc),
                            cnc_info->dsn);
      view = fe_new_view(str, 1, 2, browsertoolbar);
      fe_set_view_data(view, "FE_ConnectionInfo", (gpointer) cnc_info);
      g_free((gpointer) str);
      
      /* connect to Gda_Connection's close signal */
      gtk_signal_connect(GTK_OBJECT(cnc_info->cnc), "close",
                         GTK_SIGNAL_FUNC(close_connection_cb), (gpointer) view);

      browser = gnome_db_browser_new(cnc_info->cnc);
      fe_add_widget_to_view(view, 0, 1, 1, 2, browser);
      fe_set_view_data(view, "FE_Browser_Widget", (gpointer) browser);
      fe_set_view_destroy_func(view, (FE_DestroyViewFunc) real_close, (gpointer) browser);
      fe_display_view(view);
    }
  else fe_status_bar_message(_("No connection open"));
}
