/* GNOME DB
 * Copyright (C) 1998 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "gda-mysql-types.h"
#include "gda-mysql-recset.h"
#include "gda-mysql-field.h"

Gda_MYSQL_Recordset*
gda_mysql_recset_new()
{
  Gda_MYSQL_Recordset* rc = g_new0(Gda_MYSQL_Recordset, 1);
  return rc;
}

void
gda_mysql_recset_free(Gda_MYSQL_Recordset* rs)
{
  if (rs->mysql_res)
    gda_mysql_recset_close(rs);
  g_free(rs);
}


gint
gda_mysql_recset_close(Gda_MYSQL_Recordset* rs)
{
  g_return_val_if_fail(rs->mysql_res, -1);
  
  mysql_free_result(rs->mysql_res);
  rs->mysql_res = 0;
  return 0;
}



gint
gda_mysql_recset_describe(Gda_MYSQL_Recordset* recset)
{
  gint max_fieldidx;
  gint fieldidx;
  
  g_return_val_if_fail(recset, -1);
  g_return_val_if_fail(recset->mysql_res, -1);
  
  max_fieldidx = mysql_num_fields(recset->mysql_res);
  fprintf(stderr,"gda_recordset_describe: dumping field information\n");
  for (fieldidx = 0; fieldidx < max_fieldidx; fieldidx++)
    {
      MYSQL_FIELD* field;
      Gda_MYSQL_Field* server_field;
      
      field = mysql_fetch_field_direct(recset->mysql_res, fieldidx);
      fprintf(stderr,"   field %d: name   = '%s'\n", fieldidx, field->name);
      fprintf(stderr,"             table  = '%s'\n", field->table);
      fprintf(stderr,"             def    = '%s'\n", field->def);
      fprintf(stderr,"             type   = %d\n", field->type);
      fprintf(stderr,"             length = %d\n", field->length);
      fprintf(stderr,"             maxlen = %d\n", field->max_length);
      fprintf(stderr,"             flags  = 0x%08x\n", field->flags);
      fprintf(stderr,"             decimls= %d\n", field->decimals);
      server_field = gda_mysql_field_new();
      server_field->name = g_strdup(field->name);
      server_field->def = field->def ? g_strdup(field->def) : 0;
      server_field->native_type = field->type;
      server_field->decimals = field->decimals;
      server_field->flags = field->flags;
      recset->fields = g_list_append(recset->fields, server_field);
    }
  return max_fieldidx;
}

