/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gnome_db_report_h__
#define __gnome_db_report_h__ 1

#include <gnome.h>
#include <gda.h>

#include <gnome-xml/parser.h>
#include <gnome-xml/tree.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_REPORT            (gnome_db_report_get_type())
#define GNOME_DB_REPORT(obj)            GTK_CHECK_CAST(obj, gnome_db_report_get_type(), GnomeDbReport)
#define GNOME_DB_REPORT_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, gnome_db_report_get_type(), GnomeDbReportClass)
#define GNOME_DB_IS_REPORT(obj)         GTK_CHECK_TYPE(obj, gnome_db_report_get_type())
#define GNOME_DB_IS_REPORT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_REPORT))

typedef struct _GnomeDbReport      GnomeDbReport;
typedef struct _GnomeDbReportClass GnomeDbReportClass;

struct _GnomeDbReport
{
  GtkVBox   vbox;
  xmlDocPtr xmldoc;
  gchar*    file_name;
};

struct _GnomeDbReportClass
{
  GtkVBoxClass parent_class;
  
  void (*file_loaded)(GnomeDbReport *);
  void (*filename_changed)(GnomeDbReport *);
};

guint      gnome_db_report_get_type      (void);
GtkWidget* gnome_db_report_new           (void);
GtkWidget* gnome_db_report_new_from_file (const gchar *file_name);
void       gnome_db_report_clear         (GnomeDbReport *rep);

gboolean   gnome_db_report_load          (GnomeDbReport *rep, const gchar *file_name);
gboolean   gnome_db_report_save          (GnomeDbReport *rep);

#define    gnome_db_report_get_file_name(rep) ((const gchar *) GNOME_DB_REPORT(rep)->file_name))
void       gnome_db_report_set_file_name (GnomeDbReport *rep, const gchar* file_name);

END_GNOME_DECLS

#endif
