/* GNOME-DB - GUI front-end
 * Copyright (c) 1998-2000 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gdafe.h"

#define MAX_COMMAND_LIST 100

GnomeClient*  glb_SessionClient = 0;
static GList* l_LastCommands = 0;

/*
 * Public functions
 */
void
fe_add_recent_command (const gchar *sql_command)
{
  gchar *cmd;
  
  g_return_if_fail(sql_command != NULL);
  
  cmd = g_strdup(sql_command);
  if (g_list_length(l_LastCommands) < MAX_COMMAND_LIST)
    {
      l_LastCommands = g_list_prepend(l_LastCommands, (gpointer) cmd);
    }
  else
    {
      GList *node = g_list_last(l_LastCommands);
      if (node != NULL)
        {
          gchar *str = (gchar *) node->data;
          l_LastCommands = g_list_remove(l_LastCommands, node->data);
          g_free((gpointer) str);
        }
      l_LastCommands = g_list_prepend(l_LastCommands, (gpointer) cmd);
    }
}

GList *
fe_get_recent_commands (void)
{
  return (l_LastCommands);
}

void
fe_load_settings (GtkWidget *w, gpointer data)
{
  gchar *str, *name, *value;
  gpointer iterator;
  register guint cnt;
  
  /* load list of SQL commands */
  for (cnt = 0; cnt < MAX_COMMAND_LIST; cnt++)
    {
      gchar *str = g_strdup_printf("%s/Command%ld", 
                                   FE_CONFIG_SECTION_SQL_COMMANDS,
                                   cnt + 1);
      gchar *cmd = gnome_config_get_string(str);
      g_free((gpointer) str);
      if (!cmd)
        break;
      else
        {
          fe_add_recent_command(cmd);
          g_free((gpointer) cmd);
        }
    }
    
  /* load default language */
  str = gnome_config_get_string(FE_CONFIG_GENERAL_LANGUAGE);
  if (str && strlen(str) > 0)
    {
      /* FIXME: what should I do? setenv(LANG)? */
    }
    
  /* load environment variables */
  iterator = gnome_config_init_iterator(FE_CONFIG_SECTION_ENVIRONMENT);
  while ((iterator = gnome_config_iterator_next(iterator, &name, &value)))
    {
      setenv(name, value, 1);
    }
    
  /* load fonts */
  if (glb_EditorFont != 0) gdk_font_unref(glb_EditorFont);
  if (glb_GridFont != 0) gdk_font_unref(glb_GridFont);
  {
    gchar *font_str;
    
    font_str = gnome_config_get_string(FE_CONFIG_GENERAL_EDITOR_FONT);
    if (font_str != 0)
      {
        glb_EditorFont = gdk_font_load((const gchar *) font_str);
        if (glb_EditorFont == 0) fe_status_bar_message(_("Could not load editor font"));
      }
      
    font_str = gnome_config_get_string(FE_CONFIG_GENERAL_GRID_FONT);
    if (font_str != 0)
      {
        glb_GridFont = gdk_font_load((const gchar *) font_str);
        if (glb_GridFont == 0) fe_status_bar_message(_("Could not load grid font"));
      }
  }


}

void
fe_save_settings (GtkWidget *w, gpointer data)
{
  register guint cnt;
  gint x, y, width, height;
  /* save list of SQL commands */
  for (cnt = 0; cnt < MAX_COMMAND_LIST; cnt++)
    {
      gchar *cmd = g_list_nth_data(l_LastCommands, cnt);
      if (!cmd)
        break;
      else
        {
          gchar *str = g_strdup_printf("%s/Command%d", 
                                       FE_CONFIG_SECTION_SQL_COMMANDS,
                                       cnt + 1);
          gnome_config_set_string(str, cmd);
          g_free((gpointer) str);
        }
    }

  /* save UI settings */
  gdk_window_get_geometry(GTK_WIDGET(glb_App)->window, &x, &y, &width, &height, NULL);
  gnome_config_set_int(FE_CONFIG_MAIN_WINDOW_X, x);
  gnome_config_set_int(FE_CONFIG_MAIN_WINDOW_Y, y);
  gnome_config_set_int(FE_CONFIG_MAIN_WINDOW_WIDTH, width);
  gnome_config_set_int(FE_CONFIG_MAIN_WINDOW_HEIGHT, height);

  gnome_config_sync();
}

/* 
 * Session management stuff
 */
static gint
die_session_cb (GnomeClient *client, gpointer client_data)
{
  gtk_exit(0);
  return (FALSE);
}

static gint
save_yourself_cb (GnomeClient *client, 
                  gint phase, 
	          GnomeRestartStyle restart_style,
	          gint shutdown,
	          GnomeInteractStyle interact_style,
  	          gint fast, 
  	          gpointer client_data)
{
  /* fe_save_settings ignore parameters, but be polite */
  fe_save_settings(GTK_WIDGET(client), NULL);
  return (TRUE);
}

void
fe_init_gnome_session (void)
{
  glb_SessionClient = gnome_master_client();
  gtk_signal_connect(GTK_OBJECT(glb_SessionClient), "save_yourself",
		     GTK_SIGNAL_FUNC(save_yourself_cb), NULL);
  gtk_signal_connect(GTK_OBJECT(glb_SessionClient), "die",
  		     GTK_SIGNAL_FUNC(die_session_cb), NULL);
}
