/* GNOME-DB - GUI front-end
 * Copyright (c) 1998-2000 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gdafe.h"

/*
 * Public functions
 */
void
fe_show_help (GtkWidget *w, gpointer data)
{
  gchar* helpfile;
  
  helpfile = gnome_help_file_find_file("gnome-db", "gnome-db.html");

  if (helpfile)
    {
      gchar* url;

      url = g_strconcat("file:", helpfile, 0);

      gnome_help_goto(0, url);

      g_free(url);
      g_free(helpfile);
    }
  else gda_ui_show_error(_("Could not find the GNOME-DB manual!"));
}

void
fe_show_related_links (GtkWidget *w, gpointer data)
{
  GtkWidget *dialog, *label, *table, *frame, *box;
  register gint cnt;
  struct
  {
    gchar *url;
    gchar *label;
  } hrefs[] =
  {
    { "http://www.omg.org/corba/", "CORBA" },
    { "http://www.freeodbc.org/", "FreeODBC"},
    { "http://www.gnome.org/", "GNOME" },
    { "http://www.gnome.org/gw.html", "GNOME Workshop" },
    { "http://www.mysql.org/", "MySQL" },
    { "http://www.oracle.com/", "Oracle" },
    { "http://www.labs.redhat.com/orbit/", "ORBit" },
    { "http://www.postgresql.org/", "PostgreSQL" },
    { "http://www.w3.org/", "XML" },
  };
  const gchar *msg = N_("Below is a list of links to several sites related to GNOME-DB "
                        "for you to be able to find any information that may be missing "
                        "in the GNOME-DB documentation");
  gint col = 0, row = 0;
  
  dialog = gnome_dialog_new(_("Related Links"), GNOME_STOCK_BUTTON_CLOSE, NULL);
  frame = gtk_frame_new(_("Related Links"));
  gtk_widget_show(frame);
  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), frame, 0, 0, GNOME_PAD);
  
  box = gtk_vbox_new(FALSE, 1);
  gtk_widget_show(box);
  gtk_container_add(GTK_CONTAINER(frame), box);
  
  label = gda_ui_new_label_widget(msg);
  gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
  gtk_box_pack_start(GTK_BOX(box), label, 1, 1, 0);
  
  table = gtk_table_new(6, 4, TRUE);
  gtk_box_pack_start(GTK_BOX(box), table, 1, 1, 0);
  gtk_widget_show(table);
  for (cnt = 0; cnt < sizeof(hrefs) / sizeof(hrefs[0]); cnt++)
    {
      GtkWidget *link = gnome_href_new(hrefs[cnt].url, hrefs[cnt].label);
      gtk_widget_show(link);
      gtk_table_attach(GTK_TABLE(table), link, col, col + 1, row, row + 1,
                       GTK_FILL, GTK_FILL, 3, 3);
      col++;
      if (col == 4)
        {
          col = 0;
          row++;
        }
    }
  gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
}