/* GNOME-DB - GUI front-end
 * Copyright (c) 1998-2000 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gdafe.h"

static GtkWidget* l_LoginDialog = NULL;

/*
 * Callbacks
 */
static void
error_cb (Gda_Connection* cnc, gpointer data)
{
  GtkWidget *error_dialog;
  error_dialog = gnome_db_errordlg_new(cnc, _("Error Viewer"));
  gnome_db_errordlg_show_errors(GNOME_DB_ERRORDLG(error_dialog)); 
}

static void
login_cb (Gda_Connection *cnc)
{
  g_return_if_fail(cnc != NULL);
  if (cnc->is_open)
    {
      gchar *dsn;
      GnomeDbLogin *login = GNOME_DB_LOGIN(GNOME_DB_LOGINDLG(l_LoginDialog)->login);
      if (login != NULL)
        dsn = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(login->gda_dbname)->entry));
      else dsn = NULL;
      fe_open_sql_window(cnc, dsn);
      fe_status_bar_message(_("Connected to %s"), dsn);

      gnome_dialog_close(GNOME_DIALOG(l_LoginDialog));
      l_LoginDialog = NULL;
    }
}

static void
cancel_cb (GnomeDbLogin* login, gpointer data)
{
  gnome_dialog_close(GNOME_DIALOG(l_LoginDialog));
  fe_status_bar_message("");
  l_LoginDialog = NULL;
}

/*
 * Public interface
 */
FE_ConnectionInfo *
fe_get_current_connection (void)
{
  GtkWidget *current_view;
  current_view = gtk_notebook_get_nth_page(GTK_NOTEBOOK(glb_WorkArea),
                           gtk_notebook_get_current_page(GTK_NOTEBOOK(glb_WorkArea)));
  if (current_view != NULL)
    {
      gpointer info;
      if ((info = fe_get_view_data(current_view, "FE_ConnectionInfo")))
        return ((FE_ConnectionInfo *) info);
    }
  return (NULL);
}

void
fe_login (GtkWidget *w, gpointer data)
{
  Gda_Connection *cnc = gda_connection_new(glb_Orb);
  /* check if dialog box is already open */
  if (l_LoginDialog == NULL)
    {
      l_LoginDialog = gnome_db_logindlg_new(GNOME_DB_LOGIN(gnome_db_login_new(cnc,
                                                                              NULL, NULL)),
				            _("Open Connection"));
      gtk_signal_connect(GTK_OBJECT(cnc), "error", GTK_SIGNAL_FUNC(error_cb), NULL);
      gtk_signal_connect_after(GTK_OBJECT(cnc), "open", GTK_SIGNAL_FUNC(login_cb), NULL);
      gtk_signal_connect(GTK_OBJECT(l_LoginDialog), "cancel", GTK_SIGNAL_FUNC(cancel_cb), NULL);
      gnome_dialog_close_hides(GNOME_DIALOG(l_LoginDialog), TRUE);
    }
  fe_status_bar_message(_("Connecting..."));
  while (gtk_events_pending())
    gtk_main_iteration();
  gnome_db_logindlg_popup(GNOME_DB_LOGINDLG(l_LoginDialog));
}

void
gda_ui_show_errors (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo *cnc_info = fe_get_current_connection();
  if (cnc_info != NULL)
    {
      error_cb(cnc_info->cnc, NULL);
    }
}

void
fe_begin_transaction (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo *cnc_info = fe_get_current_connection();
  if (cnc_info != NULL)
    {
      if (gda_connection_begin_transaction(cnc_info->cnc) == 0)
        fe_status_bar_message(_("Transaction started"));
    }
}

void
fe_commit_transaction (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo *cnc_info = fe_get_current_connection();
  if (cnc_info != NULL)
    {
      if (gda_connection_commit_transaction(cnc_info->cnc) == 0)
        fe_status_bar_message(_("Commit executed"));
    }
}

void
fe_rollback_transaction (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo *cnc_info = fe_get_current_connection();
  if (cnc_info != NULL)
    {
      if (gda_connection_rollback_transaction(cnc_info->cnc) == 0)
        fe_status_bar_message(_("Rollback executed"));
    }
}
