/* Sample Rolodex Application
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnomerecset.h"
#include <gda/gda-recordset.h>

enum
{
  RS_EOF,
  RS_BOF,
  FIRST,
  LAST,
  MOVE,
  LAST_SIGNAL
};

static gint
gnomerecset_signals[LAST_SIGNAL] = {0,};

static void     gnome_recset_class_init    (GnomeRecsetClass* klass);
static void     gnome_recset_init          (GnomeRecset* rs);
static void     gnome_recset_changed       (GtkAdjustment* adj);
static void     gnome_recset_value_changed (GtkAdjustment* adj);

guint
gnome_recset_get_type()
{
  static guint gr_type = 0;

  if (!gr_type)
    {
      GtkTypeInfo gr_info =
      {
	"GnomeRecset",
	sizeof(GnomeRecset),
	sizeof(GnomeRecsetClass),
	(GtkClassInitFunc)gnome_recset_class_init,
	(GtkObjectInitFunc)gnome_recset_init,
	(GtkArgSetFunc)NULL,
	(GtkArgSetFunc)NULL,
      };
      gr_type = gtk_type_unique(gtk_adjustment_get_type(), &gr_info);
    }
  return gr_type;
}


static void
gnome_recset_class_init(GnomeRecsetClass* klass)
{
  GtkObjectClass*     object_class;
  GtkAdjustmentClass* adjustment_class;
  
  object_class = (GtkObjectClass*) klass;
  adjustment_class = (GtkAdjustmentClass*) klass;
  
  gnomerecset_signals[RS_EOF] = gtk_signal_new("eof",
					       GTK_RUN_LAST,
					       object_class->type,
					       GTK_SIGNAL_OFFSET(GnomeRecsetClass, eof),
					       gtk_signal_default_marshaller,
					       GTK_TYPE_NONE, 0);
  gnomerecset_signals[RS_BOF] = gtk_signal_new("bof",
					       GTK_RUN_LAST,
					       object_class->type,
					       GTK_SIGNAL_OFFSET(GnomeRecsetClass, bof),
					       gtk_signal_default_marshaller,
					       GTK_TYPE_NONE, 0);
  klass->eof = 0;
  klass->bof = 0;
#if 0
  adjustment_class->changed = gnome_recset_changed;
  adjustment_class->value_changed = gnome_recset_value_changed;
#endif
}

  

static void
gnome_recset_init(GnomeRecset* grs)
{
  grs->current_pos = 0;
  GTK_ADJUSTMENT(grs)->upper = G_MAXFLOAT;
  GTK_ADJUSTMENT(grs)->lower = 0;
  GTK_ADJUSTMENT(grs)->value = 0;
  
  gtk_signal_connect(GTK_OBJECT(grs), "value_changed",
		     GTK_SIGNAL_FUNC(gnome_recset_value_changed), NULL);
}

GtkObject*
gnome_recset_new(Gda_Recordset* rs)
{
  GnomeRecset* grs;
  grs = gtk_type_new(gnome_recset_get_type());
  grs->recset = rs;
  return GTK_OBJECT(grs);
}


gboolean
gnome_recset_eof(GnomeRecset* grs)
{
  return gda_recordset_eof(grs->recset);
}

gboolean
gnome_recset_bof(GnomeRecset* grs)
{
  return gda_recordset_bof(grs->recset);
}

static void
gnome_recset_changed(GtkAdjustment* adj)
{
  GnomeRecset* grs = GNOMERECSET(adj);

  g_print("gnome_recset_changed: adjustment->lower = %8.1f\n", adj->lower);
  g_print("gnome_recset_changed: adjustment->upper = %8.1f\n", adj->upper);
  g_print("                      grs->current_pos  = %d\n",    grs->current_pos);
}


static void
gnome_recset_value_changed(GtkAdjustment* adj)
{
  GnomeRecset* grs = GNOMERECSET(adj);
  guint        pos;
  gint         offset;
  
  if (adj->value == G_MAXFLOAT)
    offset = G_MAXINT;
  else
    offset = adj->value - grs->current_pos;
  if (offset == 0)
    return;
  
  pos = gda_recordset_move(grs->recset, (gint)offset, 0);
  
  adj->value = pos;
  if (gnome_recset_eof(grs))
    {
      adj->upper = pos;
    }
  grs->current_pos = adj->value;
}

