/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-error.h"

/*
 * gda_error_new:
 * Creates a new unitialized error object.
 *
 * Returns: the error object.
 */
Gda_Error*
gda_error_new(void)
{
  Gda_Error* error;

  error = g_new0(Gda_Error, 1);
  return error;
}


/**
 * gda_error_free:
 * @error: the error object.
 *
 * Frees the memory allocated by the error object.
 *
 */
void
gda_error_free(Gda_Error* error)
{
  g_return_if_fail(error != NULL);
  
  if (error->description)
    g_free(error->description);

  if (error->source)
    g_free(error->source);

  if (error->helpurl)
    g_free(error->helpurl);

  if (error->sqlstate)
    g_free(error->sqlstate);

  if (error->native)
    g_free(error->native);
}

/**
 * gda_error_list_free:
 * @errors: a glist holding error objects.
 *
 * Frees all error objects in the list and the list itself.
 * After this function has been called, the @errors parameter doesn't point
 * to valid storage any more.
 */
void
gda_error_list_free(GList* errors)
{
  GList* ptr = errors;

  while(ptr)
    {
      Gda_Error* error = ptr->data;
      gda_error_free(error);
      ptr = g_list_next(ptr);
    }
  g_list_free(errors);
}

 
