/* gnome-sql - GUI front-end
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* header files */
#include "gsqlfe.h"

/* global variables */
extern GList *l_last_commands;

GnomeClient *glb_SessionClient = NULL;
gint glb_mwx = 0;
gint glb_mwy = 0;
gint glb_mww = 0;
gint glb_mwh = 0;
GList *glb_recent_connections = NULL;

/* private functions */
static void
load_recent_connections (void)
{
}

static void
load_sql_commands (void)
{
  register gint cnt;
  /* just read from config files and call sql_store_command() */
  for (cnt = MAX_COMMAND_LIST; cnt > 0; cnt--)
    {
      gchar *path = g_strdup_printf("/gsqlfe/SQL/Command%d", cnt + 1);
      gchar *sql_command = gnome_config_get_string(path);
      if (sql_command != NULL)
	{
	  gchar *str = g_strdup(sql_command);
	  l_last_commands = g_list_prepend(l_last_commands, (gpointer) str);
	}
      g_free((gpointer) path);
    }
}

static void
load_ui_settings (void)
{
  /* get main window's geometry */
  glb_mwx = gnome_config_get_int("gsqlfe/MainWindow/x");
  glb_mwy = gnome_config_get_int("gsqlfe/MainWindow/y");
  glb_mww = gnome_config_get_int("gsqlfe/MainWindow/width");
  glb_mwh = gnome_config_get_int("gsqlfe/MainWindow/height");
}

static void
save_recent_connections (void)
{
}

static void
save_sql_commands (void)
{
  register gint cnt = 0;
  extern GList *l_last_commands; /* defined in sql.c */
  GList *node = g_list_first(l_last_commands);
  while (node != NULL)
    {
      gchar *path = g_strdup_printf("/gsqlfe/SQL/Command%d", cnt + 1);
      gnome_config_set_string(path, (gchar *) node->data);
      cnt++;
      node = g_list_next(node);
    }
}

static void
save_ui_settings (void)
{
  /* save main window's geometry */
  gdk_window_get_geometry(GTK_WIDGET(glb_app)->window, &glb_mwx, &glb_mwy,
			  &glb_mww, &glb_mwh, NULL);
  gnome_config_set_int("/gsqlfe/MainWindow/x", glb_mwx);
  gnome_config_set_int("/gsqlfe/MainWindow/y", glb_mwy);
  gnome_config_set_int("/gsqlfe/MainWindow/width", glb_mww);
  gnome_config_set_int("/gsqlfe/MainWindow/height", glb_mwh);
}

/* application settings */
void
app_add_recent_connection (const gchar *provider, 
                           const gchar *dbname,
                           const gchar *login)
{
  struct GSQLFE_RecentConnection *new_conn, *tmp_conn;
  GList *node = g_list_first(glb_recent_connections);
  /* first search if already present */
  while (node != NULL)
    {
      tmp_conn = (struct GSQLFE_RecentConnection *) node->data;
      if (tmp_conn != NULL)
        {
          if ((!strcmp(provider, tmp_conn->provider)) &&
              (!strcmp(dbname, tmp_conn->database)) &&
              (!strcmp(login, tmp_conn->login)))
            return;
        }
      node = g_list_next(node);
    }
  /* add it */
  if ((new_conn = (struct GSQLFE_RecentConnection *) 
                   g_malloc(sizeof(struct GSQLFE_RecentConnection))))
    {
      new_conn->provider = provider ? g_strdup(provider) : NULL;
      new_conn->database = dbname ? g_strdup(dbname) : NULL;
      new_conn->login = login ? g_strdup(login) : NULL;
      glb_recent_connections = g_list_prepend(glb_recent_connections, new_conn);
      app_save_settings(NULL, NULL);
    }
  else ui_show_error("Cannot allocate %ld bytes", sizeof(struct GSQLFE_RecentConnection));
}

void
app_edit_config_file (GtkWidget *w, gpointer data)
{
  gchar *config_file = gnome_config_get_real_path("/gsqlfe");
  if (config_file != NULL)
    {
      ui_show_file_in_window((const gchar *) config_file);
      g_free(config_file);
    }
}

void
app_load_settings (void)
{
  load_ui_settings();
  load_sql_commands();
  load_recent_connections();
}

void
app_save_settings (GtkWidget *w, gpointer data)
{
  save_ui_settings();
  save_sql_commands();
  save_recent_connections();
  /* actually update configuration files */
  gnome_config_sync();
}

/* Session management stuff */
static gint
die_session_cb (GnomeClient *client, gpointer client_data)
{
  gtk_exit(0);
  return (FALSE);
}

static gint
save_yourself_cb (GnomeClient *client, gint phase, 
	          GnomeRestartStyle restart_style,
	          gint shutdown,
	          GnomeInteractStyle interact_style,
  	          gint fast, gpointer client_data)
{
  /* app_save_settings ignore parameters, but be polite */
  app_save_settings(GTK_WIDGET(client), NULL);
  return (TRUE);
}

void
app_init_gnome_session (void)
{
  glb_SessionClient = gnome_master_client();
  gtk_signal_connect(GTK_OBJECT(glb_SessionClient), "save_yourself",
		     GTK_SIGNAL_FUNC(save_yourself_cb), NULL);
  gtk_signal_connect(GTK_OBJECT(glb_SessionClient), "die",
  		     GTK_SIGNAL_FUNC(die_session_cb), NULL);
}
