/* 
 * Copyright (C) 1999 Robert Wilhelm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <config.h>
#include <gnome.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "portab.h"
#include "position.h"
#include "pro.h"
#include "movlist.h"
#include "disk.h"
#include "pgn.h"

static void open_st(const char *fname)
{
  pgn_open(fname);
}

static void write_txt(const char *file)
{
  FILE *fp;
  char newbuf[2048]; 

  generate_notation(newbuf,sizeof(newbuf));
  
  fp = fopen(file,"w");
  if(fp == NULL) 
    {
      /*      abort();  */
      return;
    }

  if(fputs(newbuf,fp)==EOF)
    {
      /* abort(); */
    }

  fclose(fp);
}

static void
set_ok (GtkWidget *widget, gboolean *dialog_result)
{
	*dialog_result = TRUE;
	gtk_main_quit ();
}


static void filesel (const char *what,const char *filename, void func() )
{
	GtkFileSelection *fsel;
	gboolean accepted = FALSE;
	
	fsel = (GtkFileSelection *)gtk_file_selection_new (what);
	gtk_file_selection_set_filename (fsel, filename);
	
	/* Connect the signals for Ok and Cancel */
	gtk_signal_connect (GTK_OBJECT (fsel->ok_button), "clicked",
			    GTK_SIGNAL_FUNC (set_ok), &accepted);
	gtk_signal_connect (GTK_OBJECT (fsel->cancel_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
	
	/* Run the dialog */
	gtk_widget_show (GTK_WIDGET (fsel));
	gtk_grab_add (GTK_WIDGET (fsel));
	gtk_main ();

	if (accepted)
	  {
	    char *name = gtk_file_selection_get_filename (fsel);
	    func(name);
	  }
	gtk_widget_destroy (GTK_WIDGET (fsel));
}

void save_game()
{
  filesel(_("Save game as"), "noname.pgn", write_txt);
}

void load_game()
{
  filesel(_("Load game"), "noname.pgn", open_st);
}
