/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            kolab-util-camel.c
 *
 *  Thu Feb 24 15:42:23 2011
 *  Copyright  2011  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#include <config.h>

#include <glib/gi18n-lib.h>

#include <libedataserver/libedataserver.h>

#include "kolab-util-error.h"
#include "kolab-util-glib.h"
#include "kolab-util-camel.h"

/*----------------------------------------------------------------------------*/
/* Camel init/shutdown */

gboolean
kolab_util_camel_init (GError **err)
{
	static gboolean is_initialized = FALSE;

	g_return_val_if_fail (err == NULL || *err == NULL, FALSE);

	if (is_initialized == TRUE)
		return TRUE;

	/* GLib must be initialized first */
	kolab_util_glib_init ();

	/* init Camel subsystem */
	if (camel_init (e_get_user_data_dir (), TRUE) != 0) {
		g_set_error (err,
		             KOLAB_CAMEL_ERROR,
		             KOLAB_CAMEL_ERROR_GENERIC,
		             _("Failed to initialize Camel subsystem"));
		return FALSE;
	}

	/* init the CamelProvider system */
	camel_provider_init ();

	is_initialized = TRUE;

	g_debug ("%s: camel system initialized", __func__);

	return TRUE;
}

gboolean
kolab_util_camel_shutdown (GError **err)
{
	g_return_val_if_fail (err == NULL || *err == NULL, FALSE);
	return TRUE;
}

/*----------------------------------------------------------------------------*/
/* Camel helper functions */

gchar*
kolab_util_camel_get_storage_path (CamelService *service,
                                   CamelSession *session,
                                   GError **err)
{
	gchar *store_path = NULL;

	g_assert (CAMEL_IS_SERVICE (service));
	g_assert (CAMEL_IS_SESSION (session));
	g_return_val_if_fail (err == NULL || *err == NULL, NULL);

	store_path = g_strdup (camel_service_get_user_cache_dir (service));

	if (store_path == NULL) {
		/* FIXME mark this as a translatable string */
		g_set_error (err,
		             KOLAB_CAMEL_KOLAB_ERROR,
		             KOLAB_CAMEL_KOLAB_ERROR_DB,
		             _("Could not get Camel storage path"));
	}

	return store_path;
}

guint64
kolab_util_camel_imapx_folder_get_uidvalidity (CamelIMAPXFolder *folder)
{
	CamelIMAPXFolder *ifolder = NULL;
	guint64 uidvalidity = 0;

	ifolder = CAMEL_IMAPX_FOLDER (folder);

	/* TODO check whether we need to hold folder lock here */
	uidvalidity = ifolder->uidvalidity_on_server;

	return uidvalidity;
}

/*----------------------------------------------------------------------------*/
