/***************************************************************************
 *            kolab-util-folder.c
 *
 *  Mon Feb 28 17:57:21 2011
 *  Copyright  2011  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
/*----------------------------------------------------------------------------*/

#include <glib.h>

#include "kolab-util-folder.h"

/*----------------------------------------------------------------------------*/

KolabFolderContextID
kolab_util_folder_type_map_to_context_id (KolabFolderTypeID type_id)
{
	/* TODO better handling here */
	g_assert ((type_id > KOLAB_FOLDER_TYPE_INVAL) &&
	          (type_id < KOLAB_FOLDER_LAST_TYPE));

	if ((type_id >= KOLAB_FOLDER_TYPE_UNKNOWN) &&
	    (type_id <= KOLAB_FOLDER_TYPE_EMAIL_JUNKEMAIL))
		return KOLAB_FOLDER_CONTEXT_EMAIL;

	if ((type_id >= KOLAB_FOLDER_TYPE_EVENT) &&
	    (type_id <= KOLAB_FOLDER_TYPE_NOTE_DEFAULT))
		return KOLAB_FOLDER_CONTEXT_CALENDAR;

	return KOLAB_FOLDER_CONTEXT_CONTACT;
}

gboolean
kolab_util_folder_type_match_with_context_id (KolabFolderTypeID type_id,
                                              KolabFolderContextID context_id)
{
	/* TODO better handling here */
	g_assert ((type_id > KOLAB_FOLDER_TYPE_INVAL) &&
	          (type_id < KOLAB_FOLDER_LAST_TYPE));
	g_assert ((context_id > KOLAB_FOLDER_CONTEXT_INVAL) &&
	          (context_id < KOLAB_FOLDER_LAST_CONTEXT));
	
	switch (context_id) {
		case KOLAB_FOLDER_CONTEXT_EMAIL:
			if ((type_id < KOLAB_FOLDER_TYPE_UNKNOWN) ||
			    (type_id > KOLAB_FOLDER_TYPE_EMAIL_JUNKEMAIL))
				return FALSE;
			break;
		case KOLAB_FOLDER_CONTEXT_CALENDAR:
			if ((type_id < KOLAB_FOLDER_TYPE_EVENT) ||
			    (type_id > KOLAB_FOLDER_TYPE_NOTE_DEFAULT))
				return FALSE;
			break;
		case KOLAB_FOLDER_CONTEXT_CONTACT:
			if ((type_id < KOLAB_FOLDER_TYPE_CONTACT) ||
			    (type_id > KOLAB_FOLDER_TYPE_CONTACT_DEFAULT))
				return FALSE;
			break;
		default:
			/* can't happen */
			g_assert_not_reached ();
		
	}
	return TRUE;
}

/*----------------------------------------------------------------------------*/
