/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  Copyright (C) 2000 Ximian Inc.
 *
 *  Authors: Michael Zucchi <notzed@ximian.com>
 *
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file has been borrowed from the original IMAPX implementation
 * of libcamel1.2-14, which is part of the Evolution Data Server.
 * Since the IMAPX API is not a public libcamel one, yet we need to
 * derive from (and extend) it, a local copy is kept here. The verbatim
 * copies are kept in a separate branch. 
 * This version of the file might have been extended by the
 * evolution-kolab project. Diff against the version in the verbatim branch
 * to see the changeset.
 *
 * changed by: Christian Hilberg <hilberg@kernelconcepts.de>
 * Changes (c) 2010 kernel concepts
 */

#ifndef _CAMEL_IMAPX_STREAM_H
#define _CAMEL_IMAPX_STREAM_H

#include <camel/camel-stream.h>

#define CAMEL_IMAPX_STREAM(obj)         CAMEL_CHECK_CAST (obj, __KOLAB_camel_imapx_stream_get_type (), CamelIMAPXStream)
#define CAMEL_IMAPX_STREAM_CLASS(klass) CAMEL_CHECK_CLASS_CAST (klass, __KOLAB_camel_imapx_stream_get_type (), CamelIMAPXStreamClass)
#define CAMEL_IS_IMAPX_STREAM(obj)      CAMEL_CHECK_TYPE (obj, __KOLAB_camel_imapx_stream_get_type ())

typedef struct _CamelIMAPXStreamClass CamelIMAPXStreamClass;
typedef struct _CamelIMAPXStream CamelIMAPXStream;

typedef enum {
	IMAPX_TOK_PROTOCOL = -2,
	IMAPX_TOK_ERROR = -1,
	IMAPX_TOK_TOKEN = 256,
	IMAPX_TOK_STRING,
	IMAPX_TOK_INT,
	IMAPX_TOK_LITERAL,
} camel_imapx_token_t;

struct _CamelIMAPXStream {
	CamelStream parent;

	CamelStream *source;

	/*int state;*/
	guchar *buf, *ptr, *end;
	guint literal;

	guint unget;
	camel_imapx_token_t unget_tok;
	guchar *unget_token;
	guint unget_len;

	guchar *tokenbuf, *tokenptr, *tokenend;
};

struct _CamelIMAPXStreamClass {
	CamelStreamClass parent_class;
};

CamelType	 __KOLAB_camel_imapx_stream_get_type	(void);

CamelStream     *__KOLAB_camel_imapx_stream_new		(CamelStream *source);

gint		 __KOLAB_camel_imapx_stream_buffered	(CamelIMAPXStream *is);

camel_imapx_token_t __KOLAB_camel_imapx_stream_token	(CamelIMAPXStream *is, guchar **start, guint *len, CamelException *ex); /* throws IO,PARSE exception */
void		 __KOLAB_camel_imapx_stream_ungettoken	(CamelIMAPXStream *is, camel_imapx_token_t tok, guchar *token, guint len);

void		 __KOLAB_camel_imapx_stream_set_literal	(CamelIMAPXStream *is, guint literal);
gint		 __KOLAB_camel_imapx_stream_gets		(CamelIMAPXStream *is, guchar **start, guint *len);
gint		 __KOLAB_camel_imapx_stream_getl		(CamelIMAPXStream *is, guchar **start, guint *len);

/* all throw IO,PARSE exceptions */

/* gets an atom, upper-cases */
gint		 __KOLAB_camel_imapx_stream_atom		(CamelIMAPXStream *is, guchar **start, guint *len, CamelException *ex);
/* gets an atom or string */
gint		 __KOLAB_camel_imapx_stream_astring	(CamelIMAPXStream *is, guchar **start, CamelException *ex);
/* gets a NIL or a string, start==NULL if NIL */
gint		 __KOLAB_camel_imapx_stream_nstring	(CamelIMAPXStream *is, guchar **start, CamelException *ex);
/* gets a NIL or string into a stream, stream==NULL if NIL */
gint		 __KOLAB_camel_imapx_stream_nstring_stream(CamelIMAPXStream *is, CamelStream **stream, CamelException *ex);
/* gets 'text' */
gint		 __KOLAB_camel_imapx_stream_text		(CamelIMAPXStream *is, guchar **text, CamelException *ex);

/* gets a 'number' */
guint64		 __KOLAB_camel_imapx_stream_number	(CamelIMAPXStream *is, CamelException *ex);

/* skips the rest of a line, including literals, etc */
gint __KOLAB_camel_imapx_stream_skip(CamelIMAPXStream *is, CamelException *ex);

#endif /* _CAMEL_IMAPX_STREAM_H */
