/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file has been borrowed from the original IMAPX implementation
 * of libcamel1.2-14, which is part of the Evolution Data Server.
 * Since the IMAPX API is not a public libcamel one, yet we need to
 * derive from (and extend) it, a local copy is kept here. The verbatim
 * copies are kept in a separate branch. 
 * This version of the file might have been extended by the
 * evolution-kolab project. Diff against the version in the verbatim branch
 * to see the changeset.
 *
 * changed by: Christian Hilberg <hilberg@kernelconcepts.de>
 * Changes (c) 2010 kernel concepts
 */

#ifndef _CAMEL_IMAPX_SERVER_H
#define _CAMEL_IMAPX_SERVER_H

#include <camel/camel-msgport.h>
#include <camel/camel-list-utils.h>
#include <libedataserver/e-flag.h>

struct _CamelFolder;
struct _CamelException;
struct _CamelMimeMessage;
struct _CamelMessageInfo;
struct _CamelIMAPXMetaData;
struct _CamelIMAPXMetaDataSpec;

#define CAMEL_IMAPX_SERVER(obj)         CAMEL_CHECK_CAST (obj, __KOLAB_camel_imapx_server_get_type (), CamelIMAPPServer)
#define CAMEL_IMAPX_SERVER_CLASS(klass) CAMEL_CHECK_CLASS_CAST (klass, __KOLAB_camel_imapx_server_get_type (), CamelIMAPPServerClass)
#define CAMEL_IS_IMAPX_SERVER(obj)      CAMEL_CHECK_TYPE (obj, __KOLAB_camel_imapx_server_get_type ())

typedef struct _CamelIMAPXServer CamelIMAPXServer;
typedef struct _CamelIMAPXServerClass CamelIMAPXServerClass;

#define IMAPX_MODE_READ (1<<0)
#define IMAPX_MODE_WRITE (1<<1)

struct _CamelIMAPXServer {
	CamelObject cobject;

	struct _CamelStore *store;
	struct _CamelSession *session;

	/* Info about the current connection */
	struct _CamelURL *url;
	struct _CamelIMAPXStream *stream;
	struct _capability_info *cinfo;
	gboolean is_ssl_stream;
	gboolean is_process_stream;

	CamelIMAPXNamespaceList *nsl;

	/* incoming jobs */
	CamelMsgPort *port;
	CamelDList jobs;
	/* in micro seconds */
	guint job_timeout;

	gchar tagprefix;
	gint state:4;

	/* Current command/work queue.  All commands are stored in one list,
	   all the time, so they can be cleaned up in exception cases */
	GStaticRecMutex queue_lock;
	struct _CamelIMAPXCommand *literal;
	CamelDList queue;
	CamelDList active;
	CamelDList done;

	/* info on currently selected folder */
	struct _CamelFolder *select_folder;
	struct _CamelFolderChangeInfo *changes;
	struct _CamelFolder *select_pending;
	guint32 permanentflags;
	guint32 unseen;
	guint64 uidvalidity;
	guint64 highestmodseq;
	guint32 uidnext;
	guint32 exists;
	guint32 recent;
	guint32 mode;

	/* any expunges that happened from the last command, they are
	   processed after the command completes. */
	GSList *expunged;

	GThread *parser_thread;
	/* Protects the output stream between parser thread (which can disconnect from server) and other threads that issue
	   commands. Input stream does not require a lock since only parser_thread can operate on it */
	GStaticRecMutex ostream_lock;
	/* Used for canceling operations as well as signaling parser thread to disconnnect/quit */
	CamelOperation *op;
	gboolean parser_quit;

	/* Idle */
	struct _CamelIMAPXIdle *idle;
	gboolean use_idle;

	gboolean use_qresync;

	/* used for storing eflags to syncronize duplicate get_message requests */
	GHashTable *uid_eflags;

	/* used for binding the handlers for untagged responses */
	GHashTable *untagged_handlers;

	/* ANNOTATEMORE / METADATA (RFC 5464) */
	/* TODO check whether this is the right place to keep this data */
        struct _CamelIMAPXMetaData *metadata; /* for CamelIMAPXMetaData, keyed by path */
};

struct _CamelIMAPXServerClass {
	CamelObjectClass cclass;

	gchar tagprefix;
};

CamelType               __KOLAB_camel_imapx_server_get_type     (void);
CamelIMAPXServer *__KOLAB_camel_imapx_server_new(struct _CamelStore *store, struct _CamelURL *url);

gboolean __KOLAB_camel_imapx_server_connect(CamelIMAPXServer *is, CamelException *ex);
gboolean __KOLAB_imapx_connect_to_server (CamelIMAPXServer *is, CamelException *ex);

GPtrArray *__KOLAB_camel_imapx_server_list(CamelIMAPXServer *is, const gchar *top, guint32 flags, const gchar *ext, CamelException *ex);

void __KOLAB_camel_imapx_server_refresh_info(CamelIMAPXServer *is, CamelFolder *folder, struct _CamelException *ex);
void __KOLAB_camel_imapx_server_sync_changes(CamelIMAPXServer *is, CamelFolder *folder, CamelException *ex);
void __KOLAB_camel_imapx_server_expunge(CamelIMAPXServer *is, CamelFolder *folder, CamelException *ex);
void __KOLAB_camel_imapx_server_noop (CamelIMAPXServer *is, CamelFolder *folder, CamelException *ex);

CamelStream *__KOLAB_camel_imapx_server_get_message(CamelIMAPXServer *is, CamelFolder *folder, const gchar *uid, struct _CamelException *ex);
void __KOLAB_camel_imapx_server_copy_message (CamelIMAPXServer *is, CamelFolder *source, CamelFolder *dest, GPtrArray *uids, gboolean delete_originals, CamelException *ex);
void __KOLAB_camel_imapx_server_append_message(CamelIMAPXServer *is, CamelFolder *folder, struct _CamelMimeMessage *message, const struct _CamelMessageInfo *mi, CamelException *ex);
void __KOLAB_camel_imapx_server_sync_message (CamelIMAPXServer *is, CamelFolder *folder, const gchar *uid, CamelException *ex);

void __KOLAB_camel_imapx_server_manage_subscription (CamelIMAPXServer *is, const gchar *folder_name, gboolean subscribe, CamelException *ex);
void __KOLAB_camel_imapx_server_create_folder (CamelIMAPXServer *is, const gchar *folder_name, CamelException *ex);
void __KOLAB_camel_imapx_server_delete_folder (CamelIMAPXServer *is, const gchar *folder_name, CamelException *ex);
void __KOLAB_camel_imapx_server_rename_folder (CamelIMAPXServer *is, const gchar *old_name, const gchar *new_name, CamelException *ex);

/* ANNOTATEMORE / METADATA (RFC 5464) */
struct _CamelIMAPXMetaData *__KOLAB_imapx_server_get_metadata (CamelIMAPXServer *is, const struct _CamelIMAPXMetaDataSpec *spec, gboolean do_resect, CamelException *ex);
gint __KOLAB_imapx_server_get_metadata_proto (CamelIMAPXServer *is);
gboolean __KOLAB_imapx_server_set_metadata (CamelIMAPXServer *is, const struct _CamelIMAPXMetaData *md, CamelException *ex);

gboolean __KOLAB_imapx_server_logout_sync (CamelIMAPXServer *is, CamelException *ex);

#endif /* _CAMEL_IMAPX_SERVER_H */
