/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* camel-imap-folder.h : Class for a IMAP folder */

/*
 * Authors: Michael Zucchi <notzed@ximian.com>
 *
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file has been borrowed from the original IMAPX implementation
 * of libcamel1.2-14, which is part of the Evolution Data Server.
 * Since the IMAPX API is not a public libcamel one, yet we need to
 * derive from (and extend) it, a local copy is kept here. The verbatim
 * copies are kept in a separate branch. 
 * This version of the file might have been extended by the
 * evolution-kolab project. Diff against the version in the verbatim branch
 * to see the changeset.
 *
 * changed by: Christian Hilberg <hilberg@kernelconcepts.de>
 * Changes (c) 2010 kernel concepts
 */

#ifndef CAMEL_IMAPX_FOLDER_H
#define CAMEL_IMAPX_FOLDER_H 1

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus }*/

#include <camel/camel-offline-folder.h>
#include <camel/camel-folder.h>
#include <camel/camel-data-cache.h>

#define CAMEL_IMAPX_FOLDER_TYPE     (__KOLAB_camel_imapx_folder_get_type ())
#define CAMEL_IMAPX_FOLDER(obj)     (CAMEL_CHECK_CAST((obj), CAMEL_IMAPX_FOLDER_TYPE, CamelIMAPXFolder))
#define CAMEL_IMAPX_FOLDER_CLASS(k) (CAMEL_CHECK_CLASS_CAST ((k), CAMEL_IMAPX_FOLDER_TYPE, CamelIMAPXFolderClass))
#define CAMEL_IS_IMAPX_FOLDER(o)    (CAMEL_CHECK_TYPE((o), CAMEL_IMAPX_FOLDER_TYPE))

typedef struct _CamelIMAPXFolder {
	CamelOfflineFolder parent_object;

	gchar *raw_name;
	CamelDataCache *cache;
	CamelFolderSearch *search;

	guint32 exists_on_server;
	guint32 unread_on_server;
	guint64 modseq_on_server;
	guint64 uidvalidity_on_server;
	guint32 uidnext_on_server;

	/* hash table of UIDs to ignore as recent when updating folder */
	GHashTable *ignore_recent;

	GMutex *search_lock;
	GMutex *stream_lock;
} CamelIMAPXFolder;

typedef struct _CamelIMAPXFolderClass {
	CamelOfflineFolderClass parent_class;
} CamelIMAPXFolderClass;

/* Standard Camel function */
CamelType __KOLAB_camel_imapx_folder_get_type (void);

/* public methods */
CamelFolder *__KOLAB_camel_imapx_folder_new(CamelStore *parent, const gchar *path, const gchar *raw, CamelException *ex);
gchar * __KOLAB_imapx_get_filename (CamelFolder *folder, const gchar *uid, CamelException *ex);

guint64 __KOLAB_camel_imapx_folder_get_uidvalidity (CamelFolder *folder, GError **err);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* CAMEL_IMAPX_FOLDER_H */
