/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* camel-imapx-exception.h : imapx exceptions */

/*
 * Authors: Michael Zucchi <notzed@ximian.com>
 *
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file has been borrowed from the original IMAPX implementation
 * of libcamel1.2-14, which is part of the Evolution Data Server.
 * Since the IMAPX API is not a public libcamel one, yet we need to
 * derive from (and extend) it, a local copy is kept here. The verbatim
 * copies are kept in a separate branch. 
 * This version of the file might have been extended by the
 * evolution-kolab project. Diff against the version in the verbatim branch
 * to see the changeset.
 *
 * changed by: Christian Hilberg <hilberg@kernelconcepts.de>
 * Changes (c) 2010 kernel concepts
 */


/* This implements 'real' exceptions that work a bit like c++/java exceptions */

/* Still experimental code */

#ifndef __CAMEL_IMAPX_EXCEPTION_H
#define __CAMEL_IMAPX_EXCEPTION_H

#include <setjmp.h>
#include "camel/camel-exception.h"

struct _CamelExceptionEnv {
	struct _CamelExceptionEnv *parent;
	CamelException *ex;
	jmp_buf env;
};

#define CAMEL_TRY { struct _CamelExceptionEnv __env; __KOLAB_camel_exception_try(&__env); if (setjmp(__env.env) == 0)
#define CAMEL_IGNORE __KOLAB_camel_exception_done(&__env); }
#define CAMEL_CATCH(x) { CamelException *x; x=__env.ex; if (x != NULL)
#define CAMEL_DONE } __KOLAB_camel_exception_done(&__env); }
#define CAMEL_DROP() __KOLAB_camel_exception_drop(&__env)

void __KOLAB_camel_exception_setup(void);

/* internal functions, use macro's above */
void __KOLAB_camel_exception_try(struct _CamelExceptionEnv *env);
void __KOLAB_camel_exception_done(struct _CamelExceptionEnv *env);
void __KOLAB_camel_exception_drop(struct _CamelExceptionEnv *env);

/* user functions */
void __KOLAB_camel_exception_throw_ex(CamelException *ex) __attribute__ ((noreturn));
void __KOLAB_camel_exception_throw(gint id, gchar *fmt, ...) __attribute__ ((noreturn));

#endif
