/***************************************************************************
 *            camel-kolab-imapx-transport.h
 *
 *  Fri Sep  3 13:18:36 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_KOLAB_IMAPX_TRANSPORT_H_
#define _CAMEL_KOLAB_IMAPX_TRANSPORT_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>
#include <libekolabutil/camel-system-headers.h>

/*----------------------------------------------------------------------------*/

#define CAMEL_KOLAB_IMAPX_TRANSPORT_TYPE	(camel_kolab_imapx_transport_get_type ())
#define CAMEL_KOLAB_IMAPX_TRANSPORT(obj)	(CAMEL_CHECK_CAST((obj), CAMEL_KOLAB_IMAPX_TRANSPORT_TYPE, CamelKolabIMAPXTransport))
#define CAMEL_KOLAB_IMAPX_TRANSPORT_CLASS(klass) (CAMEL_CHECK_CLASS_CAST ((klass), CAMEL_KOLAB_IMAPX_TRANSPORT_TYPE, CamelKolabIMAPXTransportClass))
#define CAMEL_KOLAB_IS_IMAP_TRANSPORT(obj)	(CAMEL_CHECK_TYPE((obj), CAMEL_KOLAB_IMAPX_TRANSPORT_TYPE))

G_BEGIN_DECLS

typedef struct {
	CamelTransport parent_object;
	gboolean connected ;

} CamelKolabTransport;


typedef struct {
	CamelTransportClass parent_class;

} CamelKolabTransportClass;


/* Standard Camel function */
CamelType camel_kolab_imapx_transport_get_type (void);

G_END_DECLS

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_KOLAB_IMAPX_TRANSPORT_H_ */

/*----------------------------------------------------------------------------*/
 